/*
$VerboseHistory: os2cmds.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:44a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:44a
 * Comment:
 * Added support for editor control.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:37p
 * Comment:
 * Adding new 3.0 stuff
*/
#include "slick.sh"
/* This file contains commands which only work on OS/2 */
_str process_retrieve_id;

#if __UNIX__
   /* Actually supported by SUN only. */
   _str def_process_shell='/bin/sh -i'; /* Concurrent proccess may not use csh shell */
                                   /* for SUN OS. */
   _str def_linux1_shell='/bin/tcsh -i';  /* This LINUX shell works in process buffer.*/
   _str def_linux2_shell='/bin/ksh -i';   /* This LINUX shell works in process buffer.*/
#endif

#if __NT__ || __OS2386__
   _str def_wshell='wshell';  /* Concurrent process shell under windows. */
   _str def_ntshell;          /* Concurrent process shell for Windows NT. */
#endif

_command start()
{
   status=shell('start 'arg(1),'p')
   return(status)

}
_command concur_command(_str command="",boolean leave_active=false,boolean quiet=false,boolean uniconize=true)
{
   //command=arg(1);
   //quiet=arg(3);
   //leave_active=arg(2)!='' && arg(2);
   if ( _process_info('b') || p_window_id==HIDDEN_WINDOW_ID || p_view_id>=0) {
      orig_buf_id='';
   } else {
      orig_wid=p_window_id;
      orig_buf_id=p_buf_id
      found_tile=_find_tile('.process')
   }
   if (def_process_tab_output) {
      status=start_process_tab(false,false /* No focus changes. */,quiet,uniconize);
   } else {
      status=start_process(false,false /* No focus changes. */,quiet,uniconize);
   }
   if ( status ) {
      if ( status!=PROCESS_ALREADY_RUNNING_RC ) {
         p_window_id=orig_wid;
         p_buf_id=orig_buf_id
         return(status)
      }
      clear_message
   }
   if ( p_Noflines!=p_line ) {
      bottom
   }
   get_line line
   if ( _process_info('c') ) {
      line=expand_tabs(line,1,_process_info('c')-1,'S')
   } else {
      line=''
   }
   parse command with memory rest;
   if ( isinteger(memory) ) {
      command=rest;
   }
   replace_line(line:+command);
   insert_line('');
   if ( (!leave_active || found_tile)&& orig_buf_id!='') {
      p_window_id=orig_wid;
      p_buf_id=orig_buf_id
   } else {
      if (def_process_tab_output) {
         if (!p_isbutton_bar) {
            _TOOLBAR *ptoolbar;
            ptoolbar=_tbFind(p_active_form.p_name);
            if (!ptoolbar || !(ptoolbar->tbflags & TBFLAG_ALWAYS_ON_TOP)) {
               p_active_form._set_foreground_window(VSWID_TOP);
               /*focus_wid=_get_focus();
               _set_focus();
               if (focus_wid) {
                  focus_wid._set_focus();
               } */
            }
         }
      } else {
         _set_focus();
      }
   }
   if (!quiet) {
      message nls("Command %s queued",command)
   }
   return(0)
}
int _OnUpdate_stop_process(CMDUI &cmdui,int target_wid,_str command)
{
   if (_process_info()) {
      return(MF_ENABLED);
   }
   return(MF_GRAYED);
}
_command void stop_process() name_info(','VSARG2_EDITORCTL)
{
   _stop_process();
}
_str no_concur_proc;

static int doStartProcess(boolean OpenInCurrentWindow, boolean doSetFocus,
                          boolean quiet, boolean uniconize, _str outputTo)
{
   p_window_id=_edit_window();
   if ( pos(machine(),' 'no_concur_proc' ') ) {
      message nls('Sorry.  No concurrent process available for this operating system')
      return(1)
   }
   if (p_window_id==HIDDEN_WINDOW_ID) {
      status=start_process2(OpenInCurrentWindow,quiet,uniconize,outputTo);
   } else {
      old_buffer_name=(p_DocumentName!="")?p_DocumentName:p_buf_name;
      status=start_process2(OpenInCurrentWindow,quiet,uniconize,outputTo);
      if ( p_buf_name!=old_buffer_name ) {
         switch_buffer(old_buffer_name);
      }
   }
   //messageNwait('doSetFocus='doSetFocus);
   if (doSetFocus) {
      //messageNwait('h1');
      _set_focus();
   }
   return(status)
}
_command start_process(boolean OpenInCurrentWindow=false,
                       boolean doSetFocus=true,
                       boolean quiet=false,
                       boolean uniconize=true
                       ) name_info(','VSARG2_EDITORCTL)
{
   if (!p_mdi_child) {
      if (p_view_id<0 && p_buf_name!='.process') {
         if (p_active_form.p_modal || !def_process_tab_output) {
            return('');
         }
      }
   }
   //OpenInCurrentWindow=arg(1)!="";
   //doSetFocus=arg(2)=="";;
   //quiet=arg(3)!="";
   //uniconize=arg(4)=="";

   _str outputTo;
   outputTo = 'T';
   if (!def_process_tab_output) outputTo = 'B';

   status=doStartProcess(OpenInCurrentWindow,doSetFocus,quiet,uniconize,outputTo);
   if (doSetFocus && outputTo=='T') {
      formwid = _find_object("_tboutput_form","N");
      if (formwid && !formwid.p_isbutton_bar) {
         formwid._set_foreground_window();
      }
   }
   return(status);
}
_command start_process_window(boolean OpenInCurrentWindow=false,
                       boolean doSetFocus=true,
                       boolean quiet=false,
                       boolean uniconize=true)
{
   return(doStartProcess(OpenInCurrentWindow,doSetFocus,quiet,uniconize,'B'));
}
_command start_process_tab(boolean OpenInCurrentWindow=false,
                       boolean doSetFocus=true,
                       boolean quiet=false,
                       boolean uniconize=true)
{
   return(doStartProcess(OpenInCurrentWindow,doSetFocus,quiet,uniconize,'T'));
}
// Returns a window id.  0 if not found.
_str _find_tile(_str buf_name)
{
   if (buf_name==p_buf_name && (p_window_id!=HIDDEN_WINDOW_ID )) {
      return(p_window_id);
   }
   if (p_window_state=='N') {
      // Look for a tiled window already running process buffer.
      tile_id=p_tile_id;
      wid=window_match(buf_name,1,'xn')
      for (;;) {
         if (!wid) break;
         if (wid.p_mdi_child && wid.p_tile_id==tile_id && buf_name==wid.p_buf_name) {
            return(wid);
         }
         wid=window_match(buf_name,0,'xn')
      }
   }
   return(0);
}
static _str start_process2(boolean OpenInCurrentWindow ,boolean quiet,boolean uniconize,
                           _str location)
{
   int formwid;
   if ( machine()=='PCDOS' ) {
      message get_message(FUNCTION_NOT_SUPPORTED_IN_DOS_RC)
      return(1)
   }
   status=0;
   if (location == 'T') {
      // Show the shell output tab:
      wid = outputTabToolShowShell();

      // If existing .process exists, reuse it:
      p_window_id=wid;
      oriBufId = p_buf_id;
      for (;p_buf_name != ".process";) {
         if (p_buf_name == ".process") {
            //say( "Found existing .process" );
            //bottom();
            break;
         }
         _next_buffer( "HR" );
         if (p_buf_id == oriBufId) break;
      }
   } else {
      wid=_find_tile('.process')
   }
   if (wid) {
      p_window_id=wid;
   } else {
      insert_window='';
      if (location!='T') {
         if (!OpenInCurrentWindow && _no_child_windows()) {
            insert_window=' +i ';
         }
      }
      if ( pos('+bp',def_load_options,1,'i') ) {
         status=load_files(insert_window:+def_one_file' +bp +b .process')
      } else {
         status=load_files(insert_window:+def_one_file' +b .process')
      }
   }
   if ( ! status ) {
      if ( ! _process_info() ) {   /* have an exited .process buffer? */
         /* empty the file. */
         mark=_alloc_selection()
         if ( mark<0 ) {
            bottom
         } else {
            top;_select_line mark;bottom;_select_line mark
            _delete_selection mark
            _free_selection mark
            insert_line('');   /* Need at least one blank line for */
                               /* CONCUR_COMMAND procedure. */
         }
         p_modify=0
      } else {
         //bottom();
         if (!quiet) {
            message(get_message(PROCESS_ALREADY_RUNNING_RC));
         }
         if (uniconize) {
            if (p_window_state=='I') {
               p_window_state="N";
            }
         }
         // IF mdi child
         if (location == 'B') {
            // Remove HIDE_BUFFER flag
            p_buf_flags = THROW_AWAY_CHANGES;
         }
         return(PROCESS_ALREADY_RUNNING_RC)
      }
   } else {
      clear_message();
      // Open concurrent process in current window?
      if (OpenInCurrentWindow) {
         status=load_files('-u +t');
         if (!status) {
            select_edit_mode();
         }
      }  else {
         status=edit('-u +t');
      }
      if ( status ) {
         return(1);
      }
   }
   name('.process',0); //p_buf_name='.process';
   outputTabToolConnectProcess();
   select_edit_mode();
   set('SLKRUNS=1');

   if (!status && machine()=='OS2386') {
      exepath=editor_name('p');
      // This check is reasonably close enough
      if (!pos(substr(exepath,1,length(exepath)-1),get_env('PATH'))) {
         set('PATH='get_env('PATH')';'exepath);
      }
   }
#if __UNIX__
   replace_line('You can ignore shell warning messages.');
   insert_line('');
   insert_line('');
   if ( machine()=='SPARC' ) {
      /* Unfortunately the C shell under SUN does not work in the concurrent */
      /* process buffer. So the user is forced to define the def_process_shell */
      /* variable. */
      status=concur_shell(def_process_shell);
   } else if (machine()=='LINUX' ) {
      parse  def_linux1_shell with filename .
      if (file_match('-p 'filename,1)!='') {
         concur_shell(def_linux1_shell);
         shell_used=1;
      } else {
         parse def_linux2_shell with filename .
         if (file_match('-p 'filename,1)!='') {
            concur_shell(def_linux2_shell);
            shell_used=2;
         } else {
            concur_shell ''
         }
      }
   } else {
      status=concur_shell('');
   }
#else
   if (_win32s()==2) { // IF running under windows 95?
      status=concur_shell('');
#if 1
      for (;;) {
         if ( ! _process_info('R') ) {
            break
         }
         get_line(line);
         if (line!='' || p_Noflines>1) {
            break;
         }
      }
      _mdi._set_foreground_window();
#endif
      //_post_call(find_index('_process_focus',PROC_TYPE));
   } else if (_win32s()==1) {
      status=0;
      if (!status && get_env("TEMP")=="") {
         _message_box("TEMP environment variable must be set");
         status=1;
      }
      if (!status && !isdirectory(get_env("TEMP"))) {
         _message_box("TEMP environment variable specifies invalid directory");
         status=1;
      }
      if (!status) {
         /* Unfortunately, must run wshell to be safe since DOSKEY and other */
         /* retrieve programs screw things up. */
         mou_hour_glass(1);

         message 'Starting concurrent process...'
         orig_wid=p_window_id;
         status=concur_shell(def_wshell)
         p_window_id=orig_wid
         if (status>=0) {
            clear_message
         }
         mou_hour_glass(0);
      }
   } else if (machine()=='NT386') {
      if (def_ntshell=='') {
         status=concur_shell(get_env('COMSPEC')' /q')
      } else {
         status=concur_shell(def_ntshell)
      }
   } else if ( machine()=='NT386' || machine()=='NTMIPS' || machine()=='NTALPHA') {
      status=concur_shell(get_env('COMSPEC')' /q')
   } else {
      status=concur_shell('');
   }
#endif
   set('SLKRUNS=');
   // Remove HIDE_BUFFER flag
   p_buf_flags=THROW_AWAY_CHANGES;
   if (location == 'T') {
      p_buf_flags = THROW_AWAY_CHANGES|HIDE_BUFFER;
   }
   if ( status ) {
      quit()
      return(status)
   }
   if (process_retrieve_id=='' ) {  /* Start .process-command file. ? */
      get_view_id view_id
      activate_view HIDDEN_VIEW_ID
      load_files '+c +t'
      if ( rc ) {
         clear_message
      } else {
         process_retrieve_id=p_view_id;
         p_buf_name='.process-command'
         p_buf_flags= THROW_AWAY_CHANGES|HIDE_BUFFER;
      }
      activate_view view_id
   }
   return(0)

}
_command void exit_process()
{
   if ( _process_info() ) {
#if __UNIX__
      if ( _rsprocessbug() ) {
         return;
      }
#endif
      orig_wid=p_window_id;
      status=_open_temp_view('.process',temp_view_id,orig_view_id,'+b');
      if (!status) {
         command='exit';
         bottom();
         get_line(line);
         if ( _process_info('c') ) {
            line=expand_tabs(line,1,_process_info('c')-1,'S');
         } else {
            line='';
         }
         replace_line(line:+command);
         insert_line("");

         Noflines=p_Noflines;
         message(nls('Attempting to exit process. Hold down Ctrl+Shift+Alt to abort'));
         refresh();
         for (;;) {
            if ( ! _process_info('R') ) {
               break
            }
         }
         _delete_temp_view(temp_view_id,0);
         p_window_id=orig_wid;
         clear_message();
      }
   }

}
_command cdd() name_info(FILE_ARG',')
{
   param=arg(1)
   if ( machine()!='PCDOS') {  /* Not DOS and process running */
      /* Change directory in concurrent process buffer. */
      _process_cd(param)
   }
   status=chdir(param,1);
   if (!status) {
      call_list('_cd_');
   }
   return(status);
}
