/*
$VerboseHistory: menu.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:35a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:35a
 * Comment:
 * Added support for editor control.
 * Added support for new project commands.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
#include "slick.sh"
  #define SPACES 2

   _str old_search_string;
  static _str
     _disabled_icon_commands
     ,_disabled_ncw_commands

     /* _menu_refresh_list */

static _str _open_menu_callback(reason,var result,key);

definit()
{
   if ( arg(1)!='L' ) {
      /* Editor initialization case. */
      /* don't know where menu file is yet. */
      /* Don't know where help file is yet. */
      _help_file_spec=''
      _cur_mdi_menu=def_mdi_menu
      _disabled_icon_commands=0;
      _disabled_ncw_commands=0;
   } else {
      _disabled_icon_commands=1;
      _disabled_ncw_commands=1;
   }
   /* _update_cl_menu_refresh() */
   rc=0;
   _origMdiMenuFont='';
}
#define FILEHIST_HELP  ''
#define FILEHIST_MESSAGE 'Opens file '

// Input filename to this function must be absolute.  This requirement
// is imposed so that unnecessary disk reads (during auto restore) do
// not occur.  Calling the absolute function for floppy drives is slow.
//
void _menu_add_filehist(filename)
{
   call_list("_MenuAddFileHist_",filename);
   if (!def_max_filehist || !_mdi.p_menu_handle || !length(filename)) return;

   _menu_add_hist(filename,_mdi.p_menu_handle,0,'filehist','e','ncw',
                  FILEHIST_HELP,FILEHIST_MESSAGE:+filename);
}
// Input filename must be abosolute
static _str _reduce_filenamelen(_str filename,int len)
{
   value=filename
   for (;;){
      if (length(value)<=len) break;
      /* Remove a path */
#if __UNIX__
      //start=substr(value,1,1);
      //rest=substr(value,2);
      parse value with 2 start '/','r'
      if (length(start)) {
         start='/'start:+'/';
      } else {
         start='/';
      }
      rest=substr(value,length(start)+1);
#else
      if (substr(value,1,2)=='\\') {
         parse value with '\\' server '\' share_name '\' rest
         start='\\' server '\' share_name
         if (rest!='') {
            start=start:+FILESEP;
         }
      } else {
         start=substr(value,1,3);
         rest=substr(value,4);
      }
#endif
      // Just incase server share name is very long
      if (rest=='..' || rest=='') {   // Bug Fix
         value='';break;
      }
      for (;;) {
         parse rest with  path (FILESEP) rest
         if (rest=='') {
            rest='..';
            break;
         }
         if (path!='..') {
            rest='..':+FILESEP:+rest;
            break;
         }
      }
      value=start :+ rest
   }
   return(value)
}
static _str _make_fhist_caption(_str filename)
{
   result=_reduce_filenamelen(filename,def_max_fhlen);
   result2=strip_filename(filename,'P');
   if (length(result)<length(result2)) {
      result=result2;
   }
   return(result);
}
//
//  This function currently only supports add file history because
//  file case matching is performed and file names are place in
//  double quotes if the filename contains spaces.
//
void _menu_add_hist(_str filename,int menu_handle,typeless submenu_pos,_str dash_category,_str command,_str category,_str help_command,_str help_message)
{
   // Look for the menu files separator */
   status=_menu_find(menu_handle,dash_category,dash_mh,dash_pos,'c');
    if (isinteger(submenu_pos)) {
      _menu_get_state(menu_handle,submenu_pos,mf_flags,'p',item_text,file_mh)
    } else {
       // Find the submenu with caption matching submenu_pos
       mh=menu_handle;
       Nofitems=_menu_info(mh,'c');
       for (i=0;i<Nofitems;++i) {
         _menu_get_state(mh,i,mf_flags,'p',item_text,file_mh)
         if (!stricmp(item_text,submenu_pos)) {
            break;
         }
       }
       if (i>=Nofitems) return;
    }
   if (status) {
      /* Add the menu files separator. */
      _menu_insert(file_mh,-1,MF_ENABLED,'-','',dash_category);
      _menu_insert(file_mh,-1,MF_ENABLED,
                   '&1 ':+_make_fhist_caption(filename),  // caption
                   command' 'maybe_quote_filename(filename), // command
                   category,             // categories.
                   help_command,
                   help_message
                   );
      return;
   }
   Nofitems=_menu_info(file_mh,'c');
   for (i=dash_pos+1;;++i) {
      if (i>=Nofitems) {
         if (Nofitems-dash_pos-1>=def_max_filehist) {
            // Delete last item
            _menu_delete(file_mh,Nofitems-1);
            break;
         }
         break;
      }
      _menu_get_state(file_mh,i,flags,'p',caption,tcommand,categories,help_command,thelp_message);
      parse caption with . caption
      _menu_set_state(file_mh,i,flags,'p','&'(i-dash_pos+1)' 'caption,tcommand,categories,help_command,thelp_message);

      parse tcommand with cmd tfilename
      if (file_eq(filename,strip(tfilename,'b','"'))) {
         _menu_delete(file_mh,i);
         break;
      }
   }
   _menu_insert(file_mh,dash_pos+1,MF_ENABLED,'&1 ':+_make_fhist_caption(filename),
                command' 'maybe_quote_filename(filename),category,help_command,help_message);

}
_sr_filehist()
{
   if (arg(1)=='R' || arg(1)=='N') {
      parse arg(2) with Noffiles .;
      status=_menu_find(_mdi.p_menu_handle,'filehist',dash_mh,dash_pos,'c');
      if (!status) {
         Nofitems=_menu_info(dash_mh,'c');
         for (i=Nofitems-1; i>=dash_pos+1 ;--i) {
            _menu_delete(dash_mh,i);
         }
      }
      if (!def_max_filehist || !_mdi.p_menu_handle || !Noffiles) {
         down(Noffiles);
         return(0);
      }
      for (i=1;i<=Noffiles;++i) {
         down();
         if (i<=def_max_filehist) {
            get_line(filename);
            _menu_add_filehist(filename);
         }
      }
   } else {
      if (def_max_filehist && _mdi.p_menu_handle) {
         // Look for the menu files separator */
         status=_menu_find(_mdi.p_menu_handle,'filehist',dash_mh,dash_pos,'c');
         if (status) return(0);
         Nofitems=_menu_info(dash_mh,'c');
         for (count=0,i=Nofitems-1; i>=dash_pos+1 ;++count,--i) {
            _menu_get_state(dash_mh,i,flags,'p',caption,junk,junk,junk,help_message);
            parse help_message with . . filename;
            insert_line(filename);
         }
         up(count);
         insert_line('FILEHIST: 'count);
         down(count);
      }
   }
   return(0);
}
static void _menu_adjust_help()
{
   menu_handle=p_menu_handle;
   if (!menu_handle) return;
#if __UNIX__
   _menu_set_state(menu_handle,'help -search',MF_ENABLED,'m',
             '&Search...');
                //'&Search Help &Index');
      //_menu_set_state(menu_handle,'help',MF_ENABLED,'m','&General Help');
   status=_menu_find(menu_handle,"help -using",mh,mpos,'M');
   if (!status) {
      _menu_delete(mh,mpos);
   }
   status=_menu_find(menu_handle,"printer-setup",mh,mpos,'M');
   if (!status) {
      _menu_delete(mh,mpos);
   }
#else
   if (machine()=='OS2386') {
      _menu_set_state(menu_handle,'help -search',MF_ENABLED,'m',
                '&Search...');
                //'&Search Help &Index');
      //_menu_set_state(menu_handle,'help',MF_ENABLED,'m','&General Help');
   } else {
      status=_menu_find(menu_handle,"help -using",mh,mpos,'M');
      if (!status) {
         _menu_delete(mh,mpos);
      }
      if (_win32s()==1) {
         status=_menu_find(menu_handle,"show -modal -mdi _vchack_form",mh,mpos,'M');
         if (!status) {
            _menu_delete(mh,mpos);
         }
      }
   }
#endif
   if (!(
          machine()=='NT386' && 
          (_win32s()==2 || _win32s()==0) 
        )
      ) {
      // DemoShield not support here
      status=_menu_find(menu_handle,"demo",mh,mpos,'M');
      if (!status) {
         _menu_delete(mh,mpos);
      }
   }
   if (machine()=='OS2386' || __UNIX__) {
      status=_menu_find(menu_handle,"configure_index_file",mh,mpos,'M');
      if (!status) {
         _menu_delete(mh,mpos);
      }
      status=_menu_find(menu_handle,"help_index",mh,mpos,'M');
      if (!status) {
         _menu_delete(mh,mpos);
      }
      _menu_get_state(mh,mpos,mf_flags,"p",caption);
      if (caption=="-") {
         _menu_delete(mh,mpos);
      }
      _menu_adjust_config(menu_handle);
   }
}
static void _menu_adjust_config(int menu_handle)
{
   if (machine()=='OS2386' || __UNIX__) {
      status=_menu_find(menu_handle,"assocft",mh,mpos,'M');
      if (!status) {
         _menu_delete(mh,mpos);
      }
      status=_menu_find(menu_handle,"show -modal -mdi _vchack_form",mh,mpos,'M');
      if (!status) {
         _menu_delete(mh,mpos);
      }
   }
}
#if __UNIX__
static maybe_delete_softbench_menu(mh)
{
   if (!_softbench_running()) {
      // Find the submenu with caption matching submenu_pos
      Nofitems=_menu_info(mh,'c');
      for (i=0;i<Nofitems;++i) {
        _menu_get_state(mh,i,mf_flags,'p',item_text,file_mh)
        item_text=stranslate(item_text,'','&');
        if (!stricmp(item_text,'SBSHOW')) {
           break;
        }
      }
      if (i<Nofitems) {
         _menu_delete(mh,i);
      }
   }
}
#endif
void _load_mdi_menu()
{
   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_MENUS)) {
      return;
   }
   if (_cur_mdi_menu!='') {
      index=find_index(_cur_mdi_menu,oi2type(OI_MENU));
      if (!index) {
         _message_box(nls("MDI menu '%s' not found",_cur_mdi_menu))
      } else {
         menu_handle=_mdi._menu_load(index);
#if __UNIX__
         maybe_delete_softbench_menu(menu_handle);
#endif
         if (menu_handle<0) {
            _message_box(nls("Unable to load MDI menu.  ")get_message(menu_handle))
         } else {
            old_menu_handle=_mdi.p_menu_handle;
            _mdi._menu_set(menu_handle);
            if (old_menu_handle) {
               status=_menu_destroy(old_menu_handle);
            }
            if (machine()=='OS2386') {
               _origMdiMenuFont=_default_font(CFG_MENU);
            }
         }
      }
      _mdi._menu_adjust_help();
   }
}
#if 0
/* Could switch to different menu when different window is active. */
_str _on_activate_menu()
{
}
#endif

_str Nofclipboards

// Desc:  Find the first separator starting from the
//        specified position.  If found, return the
//        position of the separator.
// Retn:  0 for separator found, 1 for not found.
static int findFirstSeparator(int menu_handle, int startpos,
                              int & foundpos)
{
   int itempos, mf_flags, total;
   _str caption, command;
   itempos = startpos;
   total = _menu_info(menu_handle);
   while (itempos < total) {
      int mf_flags;
      _str caption, command;
      _menu_get_state(menu_handle,itempos,mf_flags,"P",caption,command);
      if (caption == "-") {
         foundpos = itempos;
         return(0);
      }
      itempos++;
   }
   return(1);
}

// Desc:  Initialize the tools in the project menu.
static void initProjectTools(int menu_handle,_str extension)
{
   // Locate the project sub menu:
   int status;
   int project_menu_handle, itempos;
   if (_menu_find(menu_handle, "project-close", project_menu_handle,
              itempos, "M")) {
      return;
   }

   // Locate the positions of the first and last tool in
   // current menu:
   //
   // We assume that the project tools stays between the
   // first and second separators.  If we can't find both the
   // separators, we do nothing.
   int startPos, endPos;
   if (findFirstSeparator(project_menu_handle, 0, startPos)) {
      return;
   }
   startPos = startPos + 1;
   if (findFirstSeparator(project_menu_handle, startPos, endPos)) {
      return;
   }
   endPos = endPos - 1;
   //say("first="startPos" endPos="endPos);

   // Get the tool list from the project code;
   _str toolNameList[];
   _str toolCaptionList[];
   _str toolMenuCmdList[];
   _str toolCmdList[];
   projectToolGetList(toolNameList,toolCaptionList,
                      toolMenuCmdList,toolCmdList,extension);
   // Delete all old menu items:
   for (menupos=endPos; menupos>=startPos; menupos--) {
      //say("deleting "menupos);
      _menu_delete(project_menu_handle,menupos);
   }

   // Insert new tools into the menu:
   menupos = startPos;
   for (i=0; i<toolCaptionList._length(); ++i) {
      //say("inserting "menupos" "toolCaptionList[i]" "toolMenuCmdList[i]);
      _str helpMessage;
      helpMessage = "Runs " :+ toolNameList[i] :+" for the current project";
      int mf_flags;
      mf_flags = (toolCmdList[i]=="")?MF_GRAYED:MF_ENABLED;
      _menu_insert(project_menu_handle,
                   menupos,
                   mf_flags,       // flags
                   toolCaptionList[i],  // tool name
                   toolMenuCmdList[i],   // command
                   "ncw",    // category
                   "help project menu",  // help command
                   helpMessage       // help message
                   );
      menupos++;
   }
}

void _on_init_menu()
{
   //say('_on_init_menu');
   old_wid=p_window_id
   p_window_id=_mdi._edit_window()
   menu_handle=_mdi.p_menu_handle;
   no_child_windows=_no_child_windows()
   // Initialize the project tools in the project menu:
   initProjectTools(menu_handle,_no_child_windows()?"":_mdi.p_child.p_extension);
   call_list('-init-menu-',menu_handle,no_child_windows);
   
   /*status=_menu_get_state(menu_handle,'project-build',mf_flags,'M');
   if (!status) {
      say('build='(mf_flags&MF_GRAYED)' e='(mf_flags&MF_ENABLED));
   }
   */
   p_window_id=old_wid
}
static  _str gtoolMenuCmdList[];
static _str gtoolCmdList[];
int _OnUpdateProjectCommand(CMDUI &cmdui,int target_wid,_str command)
{
   if (cmdui.menu_handle) {
       /*say('xxx');
      return(MF_ENABLED);
      if (command=='project-build') {
         say('update 'command);
         status=_menu_get_state(cmdui.menu_handle,'project-build',mf_flags,'M');
         if (!status) {
            say('update='(mf_flags&MF_GRAYED)' e='(mf_flags&MF_ENABLED));
         }
         return(MF_ENABLED);
      }  */
      return(0);
   }
   command=translate(command,'_','-');
   parse command with cmdname name;
   if (name!="") {
      if (cmdname:!='project_usertool') {
         // Not sure whats going on here
         return(MF_ENABLED);
      }
      cmdname=command;
   } 
   for (i=0; i<gtoolMenuCmdList._length(); ++i) {
      //say("inserting "menupos" "toolCaptionList[i]" "toolMenuCmdList[i]);
      
      if (translate(gtoolMenuCmdList[i],'_','-')==command) {
         //if (debug && gtoolCmdList[i]!="") say('enable');
         return((gtoolCmdList[i]=="")?MF_GRAYED:MF_ENABLED);
      }
   }
   return(MF_GRAYED);
}
static int gRequireFlags;
void _OnUpdateInit(CMDUI &cmdui,int target_wid)
{
#if 1
   if (cmdui.button_wid /*|| !cmdui.inMenuBar*/) {
      _str toolNameList[];
      _str toolCaptionList[];
      projectToolGetList(toolNameList,toolCaptionList,
                         gtoolMenuCmdList,gtoolCmdList,_no_child_windows()?"":_mdi.p_child.p_extension);
      /*for (i=0; i<toolCaptionList._length(); ++i) {
         say('n='toolNameList[i]' c='toolCaptionList[i]' mc='toolMenuCmdList[i]' cm='toolCmdList[i]);
      } */
   }
#endif

   gRequireFlags=0;
   if (target_wid && target_wid._isEditorCtl()) {
      orig_wid=p_window_id;
      p_window_id=target_wid;

      gRequireFlags|=VSARG2_REQUIRES_MDI_EDITORCTL;
      if (select_active2()) {
         gRequireFlags|=VSARG2_REQUIRES_AB_SELECTION;
      }
      if (_modename_eq(p_mode_name,"Fileman")) {
         gRequireFlags|=VSARG2_REQUIRES_FILEMAN_MODE;
      }
      if (_istagging_supported() ) {
         gRequireFlags|=VSARG2_REQUIRES_TAGGING;
      }
      p_window_id=orig_wid;
   }
   int seltype=_select_type();
   if ( seltype:=='BLOCK') {
      gRequireFlags|=VSARG2_REQUIRES_BLOCK_SELECTION;
   }
   if ( seltype ) {
      gRequireFlags|=VSARG2_REQUIRES_SELECTION;
   }
   if ( _HaveClipboard() ) {
      gRequireFlags|=VSARG2_REQUIRES_CLIPBOARD;
   }
   if (_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_WINDOW) {
      gRequireFlags|=VSARG2_REQUIRES_MDI;
   }
}
int _OnUpdate(CMDUI &cmdui,int target_wid,_str command) 
{
   parse command with cmdname .;  // strip arguments
   index=find_index('_OnUpdate_'cmdname,PROC_TYPE);
   if (index_callable(index)) {
      if (target_wid) {
         p_window_id=target_wid;
         status=call_index(cmdui,target_wid,command,index);
      } else {
         status=call_index(cmdui,target_wid,command,index);
      }
      return(status);
   }
   index=find_index(cmdname,COMMAND_TYPE);
   flags=0;
   if (index) {
      parse name_info(index) with ',' flags;
      if (!isinteger(flags)) flags=0;
   }
   req_flags=flags&VSARG2_REQUIRES;
   if (cmdui.button_wid) {
      tempCmdLine = stranslate(command,"","%%");
      if(pos("(%f)|(%l)|(%w)",tempCmdLine,1,"RI")) {
         req_flags|=VSARG2_REQUIRES_MDI_EDITORCTL;
      }
   }
   if (target_wid && target_wid.p_object==OI_TEXT_BOX && (flags & VSARG2_TEXT_BOX)) {
      if (flags & VSARG2_REQUIRES_AB_SELECTION) {
         target_wid._get_sel(start_sel,end_sel);
         if (start_sel==end_sel) {
            return(MF_GRAYED);
         }
      }
      if ((flags & VSARG2_REQUIRES_CLIPBOARD) && 
          !(gRequireFlags& VSARG2_REQUIRES_CLIPBOARD)) {
         return(MF_GRAYED);
      }
      if (target_wid.p_ReadOnly && !(flags & VSARG2_READ_ONLY)) {
         return(MF_GRAYED);
      }
      // Could check for requires selection here
      return(MF_ENABLED);
   }
   // IF everything that is required isn't there
   if ((req_flags & gRequireFlags)!=req_flags){ 
      return(MF_GRAYED);
   }
   // IF an editor control is required
   if (((req_flags & VSARG2_REQUIRES_MDI_EDITORCTL) && 
         ( (target_wid.p_window_state=='I' && !(flags & VSARG2_ICON)) || 
           (target_wid._isEditorCtl() && target_wid._QReadOnly() && !(flags & VSARG2_READ_ONLY)) 
         )
        )
       ) {
      return(MF_GRAYED);
   }
   // IF any required flags were specified
   if (req_flags) {
      return(MF_ENABLED);
   }
   return(0);
}
_str _Noficons()
{
   if (_no_child_windows()) {
      return(0);
   }
   Noficons=0
   first_window_id=p_window_id
   for (;;) {
      _next_window 'hr'
      if ( ! (p_window_flags & HIDE_WINDOW_OVERLAP) && p_window_state=='I' ) {
         Noficons=Noficons+1
      }
      if ( p_window_id:==first_window_id ) {
         return(Noficons)
      }
   }

}
/*
   Warning:  If there are no edit windows, this function will
   still return 1 for the number of buffers.  Use _no_child_windows
   to check whether there are no child edit windows.
*/
int _Nofbuffers(int maxcount=MAXINT)
{
   orig_wid= p_window_id;
   p_window_id= _mdi.p_child;
   Nofbuffers=1   /* Always count active buffer.  Might be hidden buffer. */
   first_buf_id=p_buf_id
   for (buf_info=buf_match('',1,'v');;) {
      if (rc) {
         return(Nofbuffers)
      }
      parse buf_info with buf_id modify buf_flags buf_name;
      if (buf_id!=first_buf_id) {
         ++Nofbuffers;
         if (Nofbuffers>=maxcount) {
            return(Nofbuffers);
         }
      }
      buf_info=buf_match('',0,'v')
   }
   p_window_id=orig_wid;
}

_str maybe_find_file(var file_spec,file_no_path)
{
  if ( file_spec=='' ) {
    file_spec=slick_path_search(file_no_path)
    if ( file_spec=='' ) {
      _message_box(nls("File '%s' not found",file_no_path)". ")
      return(1)
    }
    file_spec=maybe_quote_filename(absolute(file_spec))
  }
  return(0)
}

_command void open_menu() name_info(MENU_ARG','VSARG2_EDITORCTL)
{
   was_recording=_macro();
   result=arg(1);
   if(result==''){
      result=_list_matches2(
                     'Open Menu',   // title
                     SL_VIEWID|SL_COMBO|SL_SELECTPREFIXMATCH|SL_DEFAULTCALLBACK|SL_MATCHCASE,        // flags
                     '&Open,&New,&Delete,&Show',                   // buttons
                     'open menu dialog box',   // help_item
                     '',       // font
                     _open_menu_callback, //callback
                     'open_menu',       // retrieve_name
                     MENU_ARG); // completion
      if (result=='') {
         return;
      }
   }
   _macro('m',was_recording);
   _macro_delete_line();
   parse result with option menu
   if (lowcase(option)=='-show') {
      _macro_call('mou_show_menu',menu);
      show(menu);
      return;
   }
   _macro_call('show','-desktop _menu_editor_form',result);
   result=show('-desktop _menu_editor_form',result);
}
static _str _open_menu_callback(reason,var result,key)
{
   if (reason==SL_ONDEFAULT) {  // Enter key
      // Make sure that valid id characters are used.
      result=_sellist._lbget_seltext();
      if (result=='') {
         result=_sellistcombo.p_text;
      }
      if (!isid_valid(result)) {
         _message_box(nls('Invalid identifier'))
         return('');
      }
      result='-new 'result
      return(1);
   }
   if (reason==SL_ONINIT) {
      _sellist._lbtop();
      status=_sellist._lbsearch("*");
      if (!status) {
         _sellist._lbdelete_item();
         _sellist._lbtop();
      }
   }
   if (reason==SL_ONSELECT) {
      text=strip(_sellistcombo.p_text);
      if (name_eq(translate(_MDIMENU,'_','-'),text)) {
         b5.p_enabled=0;
      } else {
         b5.p_enabled=1;
      }
   }
   if (reason!=SL_ONUSERBUTTON) {
      return('');
   }
   switch (key) {
   case 4:  // New
      result='-new';
      return(1);
#if 0
      result=_sellistcombo.p_text;
      if (result!='' && !isid_valid(result)) {
         _message_box(nls('Invalid identifier'))
         return('');
      }
      result='-new 'result;
      return(1);
#endif
   case 5:  // Delete
      menuname=strip(_sellistcombo.p_text);
      // Don't want cursor y to change. _lbsearch changes cursor y
      _sellist.save_pos(p);
      status=_sellist._lbsearch(menuname);
      if (status) {
         _message_box(nls('Menu not found'));
         return('');
      }
      result=_message_box(nls("Delete menu '%s'.  Are you sure? ",menuname),'',MB_ICONQUESTION|MB_YESNOCANCEL)
      if (result!=IDYES) {
         return('');
      }
      linenum=_sellist.p_line;
      _sellist.restore_pos(p);
      _sellist.p_line=linenum
      _sellist._lbdelete_item();
      _macro('m',_macro('s'));
      _macro_append('index=find_index('_quote(menuname)',oi2type(OI_MENU));');
      _macro_append('if (index) delete_name(index);');
      _macro_append('_config_modify|=CFGMODIFY_SYSRESOURCE|CFGMODIFY_RESOURCE;');
      index=find_index(menuname,oi2type(OI_MENU));
      if (index) {
         _set_object_modify(index);
         _config_modify|=CFGMODIFY_DELRESOURCE;
         delete_name(index);
      }
      return('');
   case 6:  // Show
      result=strip(_sellistcombo.p_text);
      _sellist.save_pos(p);
      status=_sellist._lbsearch(result);
      if (status) {
         _message_box(nls('Menu not found'));
         return('');
      }
      _sellist.restore_pos(p);
      result='-show 'result;
      return(1);
   }
   return('');
}
void _menu_mdi_update()
{
   if (_cur_mdi_menu=="") {
      return;
   }
   //messageNwait('_menu_mdi_update');
   orig_view_id=_create_temp_view(temp_view_id);
   if (orig_view_id=='') return;
   _sr_filehist();
   _srg_project();

   index=find_index(_cur_mdi_menu,oi2type(OI_MENU));
   if (index) {
      menu_handle=_mdi._menu_load(index);
      if (menu_handle<0) {
         _message_box(nls("Unable to load MDI menu.  ")get_message(menu_handle))
         activate_view orig_view_id
         return;
      }
      old_menu_handle=_mdi.p_menu_handle;
      //_mdi._menu_set(0);
      //if (old_menu_handle) _menu_destroy(old_menu_handle);
#if __UNIX__
      maybe_delete_softbench_menu(menu_handle);
#endif
      _mdi._menu_set(menu_handle);
      _mdi._menu_adjust_help();
      if (old_menu_handle) _menu_destroy(old_menu_handle);
      top();up();
      for (;;) {
         if (down()) break;
         get_line(line);
         orig_line=line;linenumber=p_line;
         parse line with rtype line;
         name='_sr_'strip(lowcase(rtype),'',':');
         index=find_index(name,PROC_TYPE);
         if ( !index_callable(index) ) {
            name='_srg_'strip(lowcase(rtype),'',':');
            index=find_index(name,PROC_TYPE);
         }
         if ( index_callable(index) ) {
            status=call_index('R',line,index)
            if ( status ) {
               _delete_temp_view();
               activate_view(orig_view_id);
               return;
            }
            activate_view(temp_view_id);
         } else {
            /* Skip over lines that can't be processed. */
            parse line with count .;
            /*if (!isinteger(count) || count<0) {
               _message_box('orig_line='orig_line' linenumber='linenumber);
               _showbuf(p_view_id);

            } */
            down(count);
         }
      }

      menu_mdi_bind_all();
   }
   _delete_temp_view();
   activate_view orig_view_id
}

void _menu_unbind(menu_handle,menu_index,command_index,keyname)
{
   if (name_type(command_index)&EVENTTAB_TYPE) {
      menu_mdi_bind_all();
      return;
   }
   /* messageNwait('keyname='keyname'>') */
   _menu_bind(menu_handle,menu_index,command_index,keyname,'U');
   // Look for a different binding of this key
   keyname=''
   // messageNwait('command='name_name(command_index))
   key_index=find_key_binding(command_index,keyname,'',_default_keys,
                           p_mode_eventtab);
   if (key_index) {
      //messageNwait('got here keyname='keyname'>');
      _menu_bind(menu_handle,menu_index,name_name(command_index),keyname,'B');
      //if (_issysmenu_key(index2event(key_index))) _update_sysmenu_bindings();
   }
}
static int find_key_binding(index,var key_binding_list,prefix_keys,
                     _root_keys,_mode_keys)
{
  key_index= -1
  for (;;) {
     list_bindings key_index,name_index_found,keys_used,
                   _root_keys,_mode_keys,index
     if ( key_index<0 ) return(0);
     key_name=_key_for_display(index2event(key_index))
     if ( name_type(name_index_found)&EVENTTAB_TYPE ) {
        status=find_key_binding(index,key_binding_list,prefix_keys " "key_name,
                                 name_index_found,name_index_found)
        if (status) return(status);
     } else {
        if ( key_binding_list!='' ) { key_binding_list=key_binding_list:+',' }
        key_binding_list=strip(key_binding_list:+prefix_keys " "key_name)
        return(key_index);
     }
  }
}
static int _menu_find_caption(int menu_index,_str menu_text)
{
   child=menu_index.p_child;
   if (child) {
      firstchild=child;
      for (;;) {
         item_text=stranslate(child.p_caption,'','&');
         if (!stricmp(item_text,menu_text)) {
            return(child);
         }
         child=child.p_next;
         if (child==firstchild) {
            break;
         }
      }
   }
   return(0);
}
_command void config()
{
   if (p_window_id==HIDDEN_WINDOW_ID) {
      p_window_id=_mdi;
   }
   _macro_delete_line();
   // Find the submenu with caption matching submenu_pos
   menu_handle=find_index("_mdi_menu",oi2type(OI_MENU));
   tools_index=_menu_find_caption(menu_handle,"Tools");
   if (tools_index) {
      config_index=_menu_find_caption(tools_index,"Configuration");
      if (config_index) {
         // Put the menu right on the current mouse pointer location:
         int new_x, new_y;
         mou_get_xy(new_x, new_y);
         x = new_x - 20; y = new_y - 10;

         menu_handle=p_active_form._menu_load(config_index,'P');
         _menu_adjust_config(menu_handle);
         _GetOuterMostWindow(mdi_x,mdi_y,mdi_width,mdi_height);
         //mdi_x=_mdi.p_x;mdi_y=_mdi.p_y;
         //mdi_width=_mdi.p_width;mdi_height=_mdi.p_height;
#if 1
         x=mdi_x + (mdi_width intdiv 2);
         y=mdi_y + (mdi_height intdiv 2);
         //x=x-100 intdiv _twips_per_pixel_x();
         y=y-2000 intdiv _twips_per_pixel_y();
         if (x<mdi_x) x=mdi_x;
         if (y<mdi_y) y=mdi_y;
         //_lxy2dxy(SM_TWIP,x,y);
         flags=VPM_CENTERALIGN|VPM_LEFTBUTTON;
#else
         flags=VPM_LEFTBUTTON;
#endif 

         if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_CONFIGURABLE_VCPP_SETUP)) {
             status=_menu_find(menu_handle, "show -modal -mdi _vchack_form", found_mh, found_mp,'M');
             if (!status) {
                _menu_delete(found_mh,found_mp);
             }
         }
         _menu_show(menu_handle,flags,x,y)
         _menu_destroy(menu_handle);
      }
   }
}
