/*
$VerboseHistory: listbox.e$
*/
//
//  This code to handle the list box can be
//  ellagantly and drastically reduced once the macro langauge
//  can call static functions by address.
//
#include 'slick.sh'
//
//    User level 2 inheritance for LIST BOX p_multi_select!=MS_EDIT_WINDOW
//
defeventtab _ul2_listbox
   // The p_value property is set to 0 if only the
   // current line is selected.  p_value is set to -1
   // more than the current line could be selected.
   // p_value is also set to a non-zero pivot point
   // when the user used the
#define MORE_THAN_CLINE_SELECTED  -1

_ul2_listbox.' '()
{
   switch (p_multi_select) {
   case MS_NONE:
      if (!_lbisline_selected()) {
         _lbselect_line();
      }
      break;
   case MS_SIMPLE_LIST:
      if (_lbisline_selected()) {
         _lbdeselect_line();
      } else {
         _lbselect_line();
      }
      break;
   case MS_EXTENDED:
      _lbdeselect_all();
      _lbselect_line();
      break;
   }
   call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'')
}
//
//  Define this keys first,  If they get blown away latter (like c-a), don't worry about it
//  Try to use keys based on users emulation.
_ul2_listbox.c_a-c_z()
{
   switch (name_on_key(last_event())) {
   case 'cursor-up':
      call_event(defeventtab  _ul2_listbox,UP,'E');
      return('');
   case 'cursor-down':
      call_event(defeventtab  _ul2_listbox,DOWN,'E');
      return('');
   case 'page-up':
      call_event(defeventtab  _ul2_listbox,PGUP,'E')
      return('');
   case 'page-down':
      call_event(defeventtab  _ul2_listbox,PGDN,'E')
      return('')
   case 'top-of-buffer':
      call_event(defeventtab  _ul2_listbox,C_HOME,'E')
      return('');
   case 'bottom-of-buffer':
      call_event(defeventtab  _ul2_listbox,C_HOME,'E')
      return('');
   }
}
_ul2_listbox.c_a()
{
   switch (p_multi_select) {
   case MS_SIMPLE_LIST:
   case MS_EXTENDED:
      _lbselect_all();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      break;
   }
}
#if 0
_ul2_listbox.on_create2()
{
   if (p_edit) {
      insert_line(' 'p_name);
   }
}
#endif
_ul2_listbox.tab()
{
  call_event(_get_form(p_window_id),TAB);
}
_ul2_listbox.s_tab()
{
   call_event(_get_form(p_window_id),S_TAB);
}
_str _lbisline_selected()
{
   get_line(line);
   return(substr(line,1,1)=='>')
}
//
// Returns selected list box text (no picture info) or null string
// if line is not selected and p_multi_select==MS_NONE
//
_str _lbget_seltext()
{
   if (!_lbisline_selected()) {
      return('');
   }
   get_line(line);
   if (p_cb) {
      if (p_picture) {
         parse line with ':' text;
      } else {
         text=substr(line,2);
      }
   } else {
      if (p_picture) {
         parse line with ':' text;
      } else {
         text=substr(line,2);
      }
   }
   return(text)
}
#define PICTURE_PREFIX_LEN 14
#define BMINDENT_WIDTH 6

_lbdelete_item()
{
   if (_lbisline_selected()) {
      --p_Nofselected;
   }
   return(_delete_line());
}
void _lbset_item(text)
{
   if (arg(2)!='') {
      replace_line(' 'substr(arg(2),1,BMINDENT_WIDTH)' 'substr(arg(3),1,5)':'text);
   } else {
      replace_line(' 'text);
   }
}
_str _lbup()
{
   switch (p_multi_select) {
   case MS_NONE:
      if (_lbisline_selected()) {
         _lbdeselect_line();
      }
      break;
#if 0
   case MS_EXTENDED:
      _lbdeselect_all();
      break;
#endif
   }
   return(up());
}
_str _lbdown()
{
   switch (p_multi_select) {
   case MS_NONE:
      if (_lbisline_selected()) {
         _lbdeselect_line();
      }
      break;
#if 0
   case MS_EXTENDED:
      _lbdeselect_all();
      break;
#endif
   }
   return(down());
}

void _lbtop()
{
   switch (p_multi_select) {
   case MS_NONE:
      if (_lbisline_selected()) {
         _lbdeselect_line();
      }
      break;
#if 0
   case MS_EXTENDED:
      _lbdeselect_all();
      break;
#endif
   }
   top();
}
void _lbbottom()
{
   switch (p_multi_select) {
   case MS_NONE:
      if (_lbisline_selected()) {
         _lbdeselect_line();
      }
      break;
#if 0
   case MS_EXTENDED:
      _lbdeselect_all()
      break;
#endif
   }
   p_line=p_Noflines;
}
void _lbadd_item(text)
{
   switch (p_multi_select) {
   case MS_NONE:
      if (_lbisline_selected()) {
         _lbdeselect_line();
      }
      break;
#if 0
   case MS_EXTENDED:
      _lbdeselect_all();
      break;
#endif
   }
   if (arg(2)!='') {
      //  bitmap_indent (twips)  bitmap_index
      insert_line(' 'substr(arg(2),1,BMINDENT_WIDTH)' 'substr(arg(3),1,5)':'text);
   } else {
      insert_line(' 'text);
   }
   _begin_line();
}
_lbsort()
{
   mark=_alloc_selection();
   if (mark<0) {
      return(TOO_MANY_SELECTIONS_RC);
   }
   if (p_picture) {
      start_col=PICTURE_PREFIX_LEN;
   } else {
      start_col=2;
   }
   // Remember what line we are on by placing a C in
   // column 1
   get_line(cur_line);
   replace_line('C'substr(cur_line,2));
   if (arg(2)!='') {
      goto_point(arg(2));
   } else {
      top();
      if (_on_line0()) {
         _free_selection(mark);
         return(0)
      }
   }
   start_point=point();
   p_col=start_col;_select_block(mark);
   if (arg(3)!=''){
      goto_point(arg(3));
   } else {
      bottom();
   }
   end_point=point();
   p_col=MAX_LINE;_select_block(mark);
   //old_mark=_duplicate_selection('')
   status=_sort_selection((arg(1)!='')?arg(1):'i',mark);
   goto_point start_point;_deselect(mark);_select_line(mark);
   goto_point end_point;_select_line(mark);_delete_selection(mark);
   _free_selection(mark);
   top();
   search('^C','re@');
   replace_line(cur_line);
   return(status);
}
void _lbclear()
{
   mark=_alloc_selection();
   if (mark<0) {
       top();
       while (p_Noflines) {
          _delete_line();
       }
       if (p_object==OI_LIST_BOX) {
          p_Nofselected=0;
       }
   } else {
      top
      if (!_on_line0()) {
         _select_line(mark);
         bottom;p_col=1;
         _select_line(mark);
         _delete_selection(mark);
      }
      _free_selection(mark)
      if (p_object==OI_LIST_BOX) {
         p_Nofselected=0;
      }
   }
}
void _lbget_item(var item,var indent,var pic_index)
{
   get_line(line);
   if (p_picture) {
      parse substr(line,2) with indent pic_index ':' item;
      pic_index=strip(pic_index);
   } else {
      indent=0;pic_index=0;
      item=text=substr(line,2);
   }
}
//
// Returns list box text (no picture info) regardless whether text
// is selected.
//
_str _lbget_text()
{
   get_line(line);
   if (p_picture) {
      parse line with ':' text
   } else {
      text=substr(line,2);
   }
   return(text);
}
void _lbselect_line()
{
   if (_lbisline_selected()) return;
   get_line(line);
   replace_line('>':+substr(line,2));
   ++p_Nofselected;
}
void _lbdeselect_line()
{
   if (!_lbisline_selected()) return;
   get_line(line);
   replace_line(' ':+substr(line,2));
   --p_Nofselected;
}
void _lbselect_all()
{
   save_pos(p);
   top();
   search('^ ','r@','>');
   restore_pos(p);
   p_value=MORE_THAN_CLINE_SELECTED;
   p_Nofselected=p_Noflines;
}
void _lbinvert()
{
   save_pos(p)
   top();up();
   for (;;) {
      down();
      if (rc) break;
      get_line(line);
      if (substr(line,1,1)=='>') {
         replace_line(' ':+substr(line,2));
      } else {
         replace_line('>':+substr(line,2));
      }
   }
   restore_pos(p);
   p_value=MORE_THAN_CLINE_SELECTED;
   p_Nofselected=p_Noflines-p_Nofselected;
}
void _lbdeselect_all()
{
   if(p_Nofselected>1 || (p_Nofselected==1 && !_lbisline_selected()) || p_value){
      save_pos(p);
      top();
      search('^>','r@',' ');
      restore_pos(p);
      p_value=0;
   } else if (_lbisline_selected()) {
      _lbdeselect_line();
   }
   p_Nofselected=0;
}
_ul2_listbox.s_up()
{
   if (p_scroll_left_edge>=0) p_scroll_left_edge= -1;
   if ( point()<=0) {
      return('');
   }
   switch (p_multi_select) {
   case MS_NONE:
      _lbdeselect_line();
      up();_lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      break;
   case MS_SIMPLE_LIST:
      up();
      break;
   case MS_EXTENDED:
      if (p_value>0) {
         up();
         select_to_cursor(1);
         call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
         return('');
      }
      _lbdeselect_all();
      p_value=(int)point()+1;
      _lbselect_line();
      up();
      _lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      break;
   }
}
_ul2_listbox.s_down()
{
   if (p_scroll_left_edge>=0) p_scroll_left_edge= -1;
   switch (p_multi_select) {
   case MS_NONE:
      was_selected=_lbisline_selected();
      _lbdeselect_line();
      status=down();_lbselect_line();
      if(!status || !was_selected) {
         call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      }
      break;
   case MS_SIMPLE_LIST:
      down();
      break;
   case MS_EXTENDED:
      if (p_value>0) {
         down();
         select_to_cursor(1);
         call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
         return('')
      }
      _lbdeselect_all();
      p_value=(int)point()+1;
      _lbselect_line();
      down();
      _lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
   }
}
_ul2_listbox.up()
{
   if (p_scroll_left_edge>=0) p_scroll_left_edge= -1;
   if ( point()<=0) {
      return('');
   }
   switch (p_multi_select) {
   case MS_NONE:
      if (!_lbisline_selected() && !_on_line0()) {
         _lbselect_line();
         call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
         return('');
      }
      _lbdeselect_line();
      up();_lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      break;
   case MS_SIMPLE_LIST:
      up();
      break;
   case MS_EXTENDED:
      if (p_Nofselected==0 && !_lbisline_selected() && !_on_line0()) {
         _lbselect_line();
         call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
         return('');
      }
      _lbdeselect_all();
      up();
      _lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      break;
   }
}
_ul2_listbox.down()
{
   if (p_scroll_left_edge>=0) p_scroll_left_edge= -1;
   switch (p_multi_select) {
   case MS_NONE:
      if (!_lbisline_selected() && !_on_line0()) {
         _lbselect_line();
         call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
         return('');
      }
      was_selected=_lbisline_selected();
      _lbdeselect_line();
      status=down();_lbselect_line();
      if(!status || !was_selected) {
         call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      }
      break;
   case MS_SIMPLE_LIST:
      down();
      break;
   case MS_EXTENDED:
      if (p_Nofselected==0 && !_lbisline_selected() && !_on_line0()) {
         _lbselect_line();
         call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
         return('');
      }
      _lbdeselect_all();
      down();
      _lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
   }
}
_ul2_listbox.pgup()
{
   if (p_scroll_left_edge>=0) p_scroll_left_edge= -1;
   if ( point()<=0) {
      return('');
   }
   switch (p_multi_select) {
   case MS_NONE:
      _lbdeselect_line();
      page_up();_lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      break;
   case MS_SIMPLE_LIST:
      page_up();
      break;
   case MS_EXTENDED:
      _lbdeselect_all();
      page_up();
      _lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
   }
}
_ul2_listbox.pgdn()
{
   if (p_scroll_left_edge>=0) p_scroll_left_edge= -1;
   switch (p_multi_select) {
   case MS_NONE:
      _lbdeselect_line();
      page_down();_lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      break;
   case MS_SIMPLE_LIST:
      page_down();
      break;
   case MS_EXTENDED:
      _lbdeselect_all();
      page_down();
      _lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
   }
}
_ul2_listbox.c_pgup,"s-c-pgup"()
{
   if (p_scroll_left_edge>=0) p_scroll_left_edge= -1;
   if ( point()<=0) {
      return('');
   }
   switch (p_multi_select) {
   case MS_NONE:
      _lbdeselect_line();
      top_of_window();_lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      break;
   case MS_SIMPLE_LIST:
      top_of_window();
      break;
   case MS_EXTENDED:
      if (last_event():==name2event("s-c-pgup")) {
         if (p_value>0) {
            top_of_window();
            select_to_cursor(1);
            call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
            return('');
         }
         _lbdeselect_all();
         p_value=(int)point()+1;
         top_of_window();
         select_to_cursor(1);
         call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
         return('')
      }
      _lbdeselect_all();
      top_of_window();
      _lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
   }
}
_ul2_listbox.c_pgdn,"s-c-pgdn"()
{
   if (p_scroll_left_edge>=0) p_scroll_left_edge= -1;
   switch (p_multi_select) {
   case MS_NONE:
      _lbdeselect_line();
      bottom_of_window();_lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      break;
   case MS_SIMPLE_LIST:
      bottom_of_window();
      break;
   case MS_EXTENDED:
      if (last_event():==name2event("s-c-pgdn")) {
         if (p_value>0) {
            bottom_of_window();
            select_to_cursor(1);
            call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
            return('')
         }
         _lbdeselect_all();
         p_value=(int)point()+1;
         bottom_of_window();
         select_to_cursor(1)
         call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
         return('');
      }
      _lbdeselect_all();
      bottom_of_window();
      _lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
   }
}
_ul2_listbox.s_pgup()
{
   if (p_scroll_left_edge>=0) p_scroll_left_edge= -1;
   if ( point()<=0) {
      return('')
   }
   switch (p_multi_select) {
   case MS_NONE:
      _lbdeselect_line();
      page_up();_lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      break;
   case MS_SIMPLE_LIST:
      page_up();
      break;
   case MS_EXTENDED:
      if (p_value>0) {
         page_up();
         select_to_cursor(1);
         call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
         return('');
      }
      _lbdeselect_all();
      p_value=(int)point()+1;
      page_up();
      select_to_cursor(1);
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
   }
}
_ul2_listbox.s_pgdn()
{
   if (p_scroll_left_edge>=0) p_scroll_left_edge= -1;
   switch (p_multi_select) {
   case MS_NONE:
      _lbdeselect_line();
      page_down();_lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      break;
   case MS_SIMPLE_LIST:
      page_down();
      break;
   case MS_EXTENDED:
      if (p_value>0) {
         page_down();
         select_to_cursor(1);
         call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
         return('')
      }
      _lbdeselect_all();
      p_value=(int)point()+1;
      page_down();
      select_to_cursor(1);
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
   }
}
def on_vsb_page_down=_sb_page_down
def on_vsb_page_up=_sb_page_up
def on_vsb_top=top_of_buffer
def on_vsb_bottom=bottom_of_buffer
def on_vsb_line_down=fast_scroll
def on_vsb_line_up=fast_scroll
def on_vsb_thumb_pos=_vsb_thumb_pos
def on_vsb_thumb_track=_vsb_thumb_pos
def on_sb_end_scroll=fast_scroll
def on_hsb_line_down=fast_scroll
def on_hsb_line_up=fast_scroll
def on_hsb_top=scroll_begin_line
def on_hsb_bottom=scroll_end_line
def on_hsb_page_down=_sb_page_right
def on_hsb_page_up=_sb_page_left
def on_hsb_thumb_pos=_hsb_thumb_pos
def on_hsb_thumb_track=_hsb_thumb_pos
_ul2_listbox.home,c_home()
{
   if (p_scroll_left_edge>=0) p_scroll_left_edge= -1;
   switch (p_multi_select) {
   case MS_NONE:
      _lbdeselect_line();
      top();_lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      break;
   case MS_SIMPLE_LIST:
      top();
      break;
   case MS_EXTENDED:
      _lbdeselect_all();
      top();
      _lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
   }
}
_ul2_listbox.end,c_end()
{
   if (p_scroll_left_edge>=0) p_scroll_left_edge= -1;
   switch (p_multi_select) {
   case MS_NONE:
      _lbdeselect_line();
      p_line=p_Noflines;_lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      break;
   case MS_SIMPLE_LIST:
      p_line=p_Noflines;
      break;
   case MS_EXTENDED:
      _lbdeselect_all();
      p_line=p_Noflines;
      _lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
   }
}
_ul2_listbox.s_home,"s-c-home"()
{
   if (p_scroll_left_edge>=0) p_scroll_left_edge= -1;
   switch (p_multi_select) {
   case MS_NONE:
      _lbdeselect_line();
      top();_lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      break;
   case MS_SIMPLE_LIST:
      top();
      break;
   case MS_EXTENDED:
      if (p_value>0) {
         top();
         select_to_cursor(1);
         call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
         return('');
      }
      _lbdeselect_all();
      p_value=(int)point()+1;
      top();
      select_to_cursor(1);
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
   }
}
_ul2_listbox.s_end,"s-c-end"()
{
   if (p_scroll_left_edge>=0) p_scroll_left_edge= -1;
   switch (p_multi_select) {
   case MS_NONE:
      _lbdeselect_line();
      p_line=p_Noflines;_lbselect_line();
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      break;
   case MS_SIMPLE_LIST:
      p_line=p_Noflines;
      break;
   case MS_EXTENDED:
      if (p_value>0) {
         p_line=p_Noflines;
         select_to_cursor(1);
         call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
         return('');
      }
      _lbdeselect_all();
      p_value=(int)point()+1;
      p_line=p_Noflines;
      select_to_cursor(1)
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
   }
}
//name_info(','VSARG2_READ_ONLY)
_ul2_listbox.lbutton_down,"s-lbutton_down","c-lbutton-down"()
{
   switch (p_multi_select) {
   case MS_NONE:
      linenum=p_line;
      nochange_event=_lbisline_selected();
      _lbdeselect_line();
      if (p_scroll_left_edge>=0) {
         nochange_event=0;
         parse _scroll_page() with line_pos down_count;
         goto_point(line_pos);
         down(down_count);
         set_scroll_pos p_scroll_left_edge,0
         p_scroll_left_edge= -1;
      }
      if (_on_line0()) return('');
      if (mou_last_y()>p_font_height*p_char_height) {
         scroll_down();
      }
      p_cursor_y=mou_last_y();
      p_cursor_x=p_left_edge+p_windent_x;
      _lbselect_line();
      _lbmou_click2(2,'');
      if (p_line!=linenum || !nochange_event || !_lbisline_selected()) {
         call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      }
      break;
   case MS_SIMPLE_LIST:
      if (p_scroll_left_edge>=0) {
         parse _scroll_page() with line_pos down_count;
         goto_point(line_pos);
         down(down_count);
         set_scroll_pos(p_scroll_left_edge,0);
         p_scroll_left_edge= -1;
      }
      if (_on_line0()) return('');
      if (mou_last_y()>p_font_height*p_char_height) {
         scroll_down();
      }
      p_cursor_y=mou_last_y();
      p_cursor_x=p_left_edge+p_windent_x;
      if (_lbisline_selected()) {
         _lbdeselect_line();
      } else {
         _lbselect_line();
      }
      p_value=MORE_THAN_CLINE_SELECTED;
      _lbmou_click2(0,'');
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      break;
   case MS_EXTENDED:
      switch (last_event()) {
      case name2event("c-lbutton-down"):
         if (p_scroll_left_edge>=0) {
            parse _scroll_page() with line_pos down_count;
            goto_point(line_pos);
            down(down_count);
            set_scroll_pos(p_scroll_left_edge,0);
            p_scroll_left_edge= -1;
         }
         if (_on_line0()) return('');
         if (mou_last_y()>p_font_height*p_char_height) {
            scroll_down();
         }
         p_cursor_y=mou_last_y();
         p_cursor_x=p_left_edge+p_windent_x;
         line_selected=_lbisline_selected();
         if (line_selected) {
            _lbdeselect_line();
         } else {
            _lbselect_line();
         }
         p_value=MORE_THAN_CLINE_SELECTED;
         _lbmou_click2(0,!line_selected);
         call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
         return('');
      case name2event("s-lbutton-down"):
         if (_on_line0()) return('');
         start_point=point();
         if (p_value>0) {
            start_point=p_value-1;
         }
         _lbdeselect_all();
         if (p_scroll_left_edge>=0) {
            parse _scroll_page() with line_pos down_count;
            goto_point(line_pos);
            down(down_count);
            set_scroll_pos(p_scroll_left_edge,0);
            p_scroll_left_edge= -1;
         }
         if (mou_last_y()>p_font_height*p_char_height) {
            scroll_down();
         }
         p_cursor_y=mou_last_y();
         p_cursor_x=p_left_edge+p_windent_x;
         end_point=point();
         save_pos(p);
         p_value=start_point+1;
         if (start_point>end_point) {
            temp=start_point;start_point=end_point;end_point=temp;
         }
         goto_point(start_point);
         for (;;) {
            _lbselect_line();
            if (point()>=end_point) {
               break;
            }
            if(down()) break;
         }
         restore_pos(p);
         _lbmou_click2(1,'');
         call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
         return('');
      }
      if (_on_line0()) return('');
      _lbdeselect_all();
      if (p_scroll_left_edge>=0) {
         parse _scroll_page() with line_pos down_count;
         goto_point(line_pos);
         down(down_count);
         set_scroll_pos(p_scroll_left_edge,0);
         p_scroll_left_edge= -1;
      }
      if (mou_last_y()>p_font_height*p_char_height) {
         scroll_down();
      }
      p_cursor_y=mou_last_y();
      p_cursor_x=p_left_edge+p_windent_x;
      _lbselect_line();
      _lbmou_click2(1,'');
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
   }
}
static void set_scroll_directions(var past_bottom,
     var past_top,var new_y)
{
   new_y=mou_last_y();
   past_bottom=0;past_top=0;
   if ( mou_last_y()>=p_client_height ) {
      past_bottom=1;
      new_y=p_client_height;
   }
   if ( mou_last_y()<p_windent_y ) {
      past_top=1;
      new_y=0;
   }
}
static void select_to_cursor2(do_select,new_y,_str specific_value)
{
   if (do_select==2) {
      linenum=p_line;
      was_selected=_lbisline_selected();
      _lbdeselect_line();
      p_cursor_y=new_y;
      _lbselect_line();
#if 0
      if ((linenum!=p_line || !was_selected) && p_multi_select!=MS_NONE) {
         call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
      }
#endif
      return;
   }
   p_cursor_y=new_y;
   if (!do_select) return;
   select_to_cursor(do_select);
}
static void select_to_cursor(do_select/*,specific_value*/)
{
   specific_value=arg(2);
   if (!do_select) return;
   pivot_point=p_value-1;
   cursor_point=point();
   save_pos(p);

   // Deselect lines outside of selection area
   start_point=pivot_point;end_point=cursor_point;
   if (start_point>end_point) {
      temp=start_point;start_point=end_point;end_point=temp;
   }
   if (specific_value=='') {
      // Deselect lines before start_point
      goto_point(start_point);
      for (;;) {
         if (point()<=0) break;
         up();
         if (!_lbisline_selected()) break;
         _lbdeselect_line();
      }
      // Deselect lines after end point
      goto_point(end_point);
      for (;;) {
         down();
         if (rc) break;
         if (!_lbisline_selected()) break;
         _lbdeselect_line();
      }
   }

   // Select lines while move in the direction of the pivot point.
   goto_point(cursor_point);
   if (cursor_point>=pivot_point) {
      //message 'cursor_point='cursor_point' pivot_point='pivot_point
      for (;;) {
         if(specific_value=='') {
            if (_lbisline_selected()) break;
            _lbselect_line();
         } else if (specific_value) {
            _lbselect_line();
         } else {
            _lbdeselect_line();
         }
         if (point()<=pivot_point) break;
         if (point()<=0) break;
         up();
      }

   } else {
      for (;;) {
         if(specific_value=='') {
            if (_lbisline_selected()) break;
            _lbselect_line();
         } else if (specific_value) {
            _lbselect_line();
         } else {
            _lbdeselect_line();
         }
         if (point()>=pivot_point) break;
         down();
         if (rc) break;
      }
   }
   restore_pos(p);
}
static _lbselect_specific(_str specific_value,int default_value)
{
   if (specific_value=='') specific_value=default_value;
   if (specific_value) {
      _lbselect_line();
   } else {
      _lbdeselect_line();
   }
}
static _str lbmou_in_window()
{
   return mou_last_y()>=p_windent_y && mou_last_y()<p_client_height;
}
static void _lbmou_click2(int do_select,_str specific_value)
{
   mou_mode(1);
   mou_release();mou_capture();
   old_y=p_cursor_y;
   for (;;) {
       event=get_event();
       if ( event:==MOUSE_MOVE ) {
          if ( lbmou_in_window() ) {
             if (!p_value) {
                new_y=mou_last_y();
                if (new_y==old_y) {
                   continue;
                }
                if (do_select==2) {
                   _lbdeselect_line();
                }
                p_cursor_y=new_y;
                p_value=(int)point()+1;
             }
             select_to_cursor2(do_select,mou_last_y(),specific_value);
          } else {
             if (!p_value) {
                p_value=(int)point()+1;
             }
             done=selectNscroll(do_select,specific_value);
             if ( done ) {
                break;
             }
          }
       } else {
          break;
       }
   }
   mou_mode(0);
   mou_release();
}
static _str selectNscroll(int do_select,_str specific_value)
{
   // Mapping coordinates under UNIX is VERY VERY slow.
   // Here were reduce the number of calls a lot by getting the mouse
   // coordinates relative the screen and mapping top left corner of
   // client window.
   mx=mou_last_x('D');my=mou_last_y('D');
   wx=wy=0;_map_xy(p_window_id,0,wx,wy);
   mx-=wx;my-=wy;
   /* we are outside the window. */
   /* Determine which side of window we are outside. */

   set_scroll_directions(past_bottom,past_top,new_y);
   select_to_cursor2(do_select,new_y,specific_value);
   pivot_point=p_value -1;

   init_delay=def_init_delay;
   max_skip=1;
   count=DEF_CHG_COUNT;
   _set_scroll_speed(init_delay,max_skip,count,mx,my);
   skip_count=0;
   if ( machine()=='NT386' || machine()=='NTMIPS' ) {
      max_skip=2;
   }
   _set_timer(init_delay);
   for (;;) {
      event=ON_TIMER;
      ++skip_count;
      no_skip=skip_count>=max_skip;  //  || test_event('r'):!='')
      if ( no_skip ) {
         event=get_event();
         skip_count=0;
      }
      if (event:==ON_TIMER) {
         --count;
         if ( count<=0 ) {
            count=DEF_CHG_COUNT;
            max_skip=max_skip+DEF_INC_MAX_SKIP_BY;
            if ( max_skip>DEF_MAX_SKIP ) {
               max_skip=DEF_MAX_SKIP;
            }
         }
      } else if ( event:==MOUSE_MOVE ) {
         // Mapping coordinates under UNIX is VERY VERY slow.
         // Here were reduce the number of calls a lot.
         mx=mou_last_x('D');my=mou_last_y('D');
         mx-=wx;my-=wy;
         if ( lbmou_in_window() ) {
            select_to_cursor2(do_select,mou_last_y(),specific_value);
            _kill_timer();
            return(0)
         }
         set_scroll_directions(past_bottom,past_top,new_y);
         select_to_cursor2(do_select,new_y,specific_value);
         _set_scroll_speed(init_delay,max_skip,count,mx,my);
         _set_timer(init_delay);
      } else {
         _kill_timer();
         return(1);
      }
      switch (do_select) {
      case 2:
         if ( past_bottom ) {
            _lbdeselect_line();
            down();
            _lbselect_line();
         }
         if ( past_top ) {
            if (point()>0) {
               _lbdeselect_line();
               up();
               _lbselect_line();
            }
         }
         break;
      case 1:
         if ( past_bottom ) {
            if (point()>=pivot_point) {
               down();
               _lbselect_specific(specific_value,1);
            } else {
               _lbselect_specific(specific_value,0);
               down();
            }
         }
         if ( past_top ) {
            if (point()>0) {
               if (point()<=pivot_point) {
                  up();
                  _lbselect_specific(specific_value,1);
               } else {
                  _lbselect_specific(specific_value,0);
                  up();
               }
            }
         }
         break;
      default:
         if ( past_bottom ) {
            down();
         }
         if ( past_top ) {
            if (point()>0) {
               up();
            }
         }
      }
   }
}
_str _lbsearch(text)
{
   last_data='';
   options=arg(2);
   if (options=='') options='i';
   if (!pos('r',options,1,'i')) {
      text=_escape_re_chars(text)'$';
      options=options'r';
   }
   return(_lbi_search(last_data,text,options));
}
_str _lbbeginline_re()
{
   if (p_picture) {
      return(LB_PICTURE_RE'\c');
   } else {
      return(LB_RE'\c');
   }
}

_str _lbsearch2(text)
{
   options=arg(2);
   switch (p_multi_select) {
   case MS_NONE:
      if (_lbisline_selected()) {
         _lbdeselect_line();
      }
      break;
#if 0
   case MS_EXTENDED:
      _lbdeselect_all();
      break;
#endif
   }

   if (p_scroll_left_edge>=0) {
      // parse _scroll_page() with line_pos down_count
      // goto_point line_pos
      // down down_count
      // set_scroll_pos p_scroll_left_edge,0
      p_scroll_left_edge= -1;
   }
   case_sense='i'
   if (options!='') {
      case_sense=options;
   }
   status=search(text,'@'case_sense);
   if (status) {
      return(status);
   }
   for (;;) {
      if (p_picture) {
         get_line(line);
         // For now, tab expansion not supported
         i=pos(':',line,1,'i');
         if (!i) break;
         if (p_col>i) break;
      } else {
         if (p_col>1) break;
      }
      status=repeat_search();
      if (status) break;
   }
   if (status) {
      return(status);
   }
   _post_paint();
   if (p_cursor_y!=0) {
      line_to_top();
   }
#if 0
   cursor_y=p_cursor_y;
   p_cursor_y=0;old_line=p_line;p_cursor_y=cursor_y;
   status=search(retext:+arg(4),options);
   if (status && last_status && add_char) {
      return(status);
   }
   cursor_y=p_cursor_y;
   p_cursor_y=0;new_line=p_line;p_cursor_y=cursor_y;
   if (old_line!=new_line) {
      line_to_top();
   }
#endif
   return(status);
}

_str _lbi_search(var last_data,text)
{
   switch (p_multi_select) {
   case MS_NONE:
      if (_lbisline_selected()) {
         _lbdeselect_line();
      }
      break;
#if 0
   case MS_EXTENDED:
      _lbdeselect_all();
      break;
#endif
   }
   return(_lbi_search2(last_data,text,arg(3),arg(4)));
}
static _str _lbi_search2(var last_data,text)
{
   add_char=0;
   sub_char=0;
   parse last_data with last_status last_text;
   if (p_scroll_left_edge>=0) {
      // parse _scroll_page() with line_pos down_count
      // goto_point line_pos
      // down down_count
      // set_scroll_pos p_scroll_left_edge,0
      p_scroll_left_edge= -1;
   }
   case_sense='i';
   if (arg(3)!='') {
      case_sense=arg(3);
   }
   if (last_text!='') {
      if (last_status) {
         prefix_not_found=substr(text,1,length(last_text)):==last_text &&
               length(last_text)<=length(text);
         if (last_status && prefix_not_found) {
            return(STRING_NOT_FOUND_RC);
         }
      }
      add_char=substr(text,1,length(last_text)):==last_text &&
               length(last_text)+1==length(text);
      if (!add_char && length(last_text)-1==length(text) &&
           substr(last_text,1,length(text))==text && text:!='') {
         status=0;
         // Go back up the list until find mismatch or top line
         ignore_case=pos('i',case_sense,1,'i');
         for (;;) {
            status=up();
            if (status) {
               down();
               break;
            }
            line=_lbget_text();
            if (ignore_case) {
               if (stricmp(substr(line,1,length(text)),text)) {
                  down();
                  line_to_top();
                  break;
               }
            } else if(substr(line,1,length(text))!=text){
               down();
               line_to_top();
               break;
            }
         }
         last_data=status' 'text
         return(status);
      }
   } else {
      last_status=0;
   }
   //  IF the list box has a picture, use regular expression to match
   //  text
   if (p_picture) {
      retext=LB_PICTURE_RE:+_escape_re_chars(text)
   } else {
      retext=LB_RE:+_escape_re_chars(text)
   }
   if (pos('[rRuUbB]',case_sense,1,'ri')) {
      if (p_picture) {
         retext=LB_PICTURE_RE:+text;
      } else {
         retext=LB_RE:+text;
      }
   } else {
      if (p_picture) {
         retext=LB_PICTURE_RE:+_escape_re_chars(text);
      } else {
         retext=LB_RE:+_escape_re_chars(text);
      }
   }
   options='@r'case_sense;
   save_pos(orig_pos);
   if (!add_char) {
      top();
   }
   status=search(retext:+arg(4),options);
   if (status) {
      if (last_status && add_char) {
         save_pos(pos2);
         if (orig_pos!=pos2) {
            _post_paint();
         }
         return(status);
      }
      if (!last_status && add_char) {
      } else {
         text='';
      }
   }
   if (p_cursor_y!=0 && p_Noflines*p_font_height>p_client_height) {
      line_to_top();
   }
   save_pos(pos2);
   if (orig_pos!=pos2) {
      _post_paint();
   }
   last_data=status' 'text;
#if 0
   cursor_y=p_cursor_y;
   p_cursor_y=0;old_line=p_line;p_cursor_y=cursor_y;
   status=search(retext:+arg(4),options);
   if (status && last_status && add_char) {
      return(status);
   }
   cursor_y=p_cursor_y;
   p_cursor_y=0;new_line=p_line;p_cursor_y=cursor_y;
   if (old_line!=new_line) {
      line_to_top();
   }
   last_data=status' 'text;
#endif
   return(status);
}
_lbfind_selected(find_first)
{
   if (find_first) {
      top();
      return(search('^>','r@'));
   }
   restore_search('^>',RE_SEARCH|NO_MESSAGE_SEARCH,'['p_word_chars']');
   return(repeat_search());
}
