/*
$VerboseHistory: guifind.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:20a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:20a
 * Comment:
 * Windows: Fixed problem where buffers with UNC names would not
 * get searched during a multi-file search or replace.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 02:32p
 * Comment:
 * Adding new 3.0 stuff
*/
/*
  Clark :
     * Added an if statement to the end of _findok.lbutton_up
     * Added if statements _mfinvert.lbutton_up and _mfclear.lbutton_up
     * Appended _command list_search to end of the file(hope the view stuff is ok)
     * Added _findmark.lbutton_up event handler for disabling list all occurences
       checkbox.
     * Forward/Backward and "Place Cursor at End" don't make sense when
       find all occurences is on.
     * Moved the number selected indicator into _mfhook.
       NOTE: Command Line Syntax: list-search <then use same syntax as find>
       EX  : list-search /^_command :w\((:w\,*)\)/?@$/RI-
         (I thought that this was the best way to make sure that you
          could enter flags form the command line)
*/

#include 'slick.sh'
  _command_button _findok
  _combo_box _findstring
  _check_box _findcase
  _check_box _findword
  _check_box _findre
  _check_box _findwrap
  _check_box _findmark
  _radio_button _findforward
  _radio_button _findbackward
/*
_find_form and _replace_form
    _findstring.p_user=1     Indicates that retrieve list has been done
    _mffiles.p_user=p_text   Save/restore text in _mffiles text box
    _mfmore.p_user=1         Indicates that buffer list has been filled.
    _replacestring.p_user=1  Indicates that retrieve list has been done
    _mfinvert.p_user         Form parent
    _mffiles.p_cb_list_box.p_user Indicates that filespec list has been done
-----------------------------------------------------------------


*/

typeless old_search_flags;
_str
   old_search_string,old_word_re,old_replace_string,old_go

int def_mfsearch_init_flags;

_command int gui_find() name_info(','VSARG2_EDITORCTL)
{
   was_recording=_macro();
   result=show('-modal -reinit _find_form',arg(1),p_window_id);
   _macro('m',was_recording);
   if (result=='') {
      _macro_delete_line();
      return(COMMAND_CANCELLED_RC);
   }
   _exit_scroll();
   if (_param3=='' && _param4=='' && !_param5) {
      return(l(_param1,_param2));
   } else {
      _macro_delete_line();
      if (substr(_param4,1,1)=='@' && _macro()) {
         _message_box(nls("Sorry, can't generate macro code for this operation."));
      } else {
         _macro_call('_mffind',_param1,_param2,_param3,_param4,_param5)
      }
      return(_mffind(_param1,_param2,_param3,_param4,_param5));
   }
}
_command gui_replace() name_info(','VSARG2_EDITORCTL)
{
   _macro_delete_line()
   maybe_do_begin_selection=0;
   if(_isEditorCtl() && select_active2() && (def_mfsearch_init_flags&MFSEARCH_INIT_SELECTION)) {
      maybe_do_begin_selection=1;
      //begin_select();
   }
   result=show('-modal -reinit _replace_form',arg(1),p_window_id)
   if (result=='') {
      return(COMMAND_CANCELLED_RC);
   }
   _exit_scroll();
   _macro('m',_macro('s'))
   if (_param4=='' && _param5=='') {
      search("",_param3);
      save_search(junk,flags,junk);
      if (maybe_do_begin_selection && !(flags &MARK_SEARCH)) {
         begin_select();
      }
      _macro_call('gui_replace2',_param1,_param2,_param3)
      return(gui_replace2(_param1,_param2,_param3))
   } else {
      if (substr(_param5,1,1)=='@' && _macro()) {
         _message_box(nls("Sorry, can't generate macro code for this operation."));
      } else {
         _macro_call('_mfreplace',_param1,_param2,_param3,_param4,_param5)
      }
      return(_mfreplace(_param1,_param2,_param3,_param4,_param5));
   }
}

#define COLOR2CHECKBOXTAB "OKNSCPL1234FA"
static _str gcolortab[]={
   "Other",
   "Keyword",
   "Number",
   "String",
   "Comment",
   "Preprocessing",
   "Line Number",
   "Symbol 1",
   "Symbol 2",
   "Symbol 3",
   "Symbol 4",
   "Function",
   "Attribute",
};

defeventtab _ccsearch_form
void ctlok.lbutton_up()
{
   IncludeChars="";
   ExcludeChars="";
   for (i=1;i<=gcolortab._length();++i) {
      wid=_find_control('check'i);
      if (wid.p_value==0) {
         ExcludeChars=ExcludeChars:+substr(COLOR2CHECKBOXTAB,i,1);
      } else if (wid.p_value==1) {
         IncludeChars=IncludeChars:+substr(COLOR2CHECKBOXTAB,i,1);
      }
   }
   if (IncludeChars=="" && ExcludeChars=="") {
      _param1="";
      p_active_form._delete_window(1);
      return;
   }
   if (IncludeChars!='') {
      IncludeChars='C'IncludeChars;
   } 
   if (ExcludeChars!='') {
      ExcludeChars='X'ExcludeChars;
   }
   _param1=IncludeChars',':+ExcludeChars',';
   p_active_form._delete_window(1);
}
void ctlok.on_create()
{
   parse arg(1) with IncludeChars','ExcludeChars',';
   for (i=2;i<=length(IncludeChars);++i) {
      j=pos(substr(IncludeChars,i,1,'I'),COLOR2CHECKBOXTAB);
      if (j) {
         wid=_find_control('check'j);
         if (wid) {
            wid.p_value=1;
         }
      }
   }
   for (i=2;i<=length(ExcludeChars);++i) {
      j=pos(substr(ExcludeChars,i,1,'I'),COLOR2CHECKBOXTAB);
      if (j) {
         wid=_find_control('check'j);
         if (wid) {
            wid.p_value=0;
         }
      }
   }

}
defeventtab _find_form
void _find_form.'F1'()
{
   help('Find Dialog Box');
}
void ctlnocolor.lbutton_up()
{
   ctlcoloroptions.p_text="";
   _findstring._set_focus();
}
void ctlcoloroptions.on_change()
{
   if (ctlcolor.p_enabled) {
      ctlnocolor.p_enabled=(p_text!="");
   } else {
      ctlnocolor.p_enabled=false;
      ctlcolorlabel.p_caption='';
      return;
   }
   parse p_text with IncludeChars','ExcludeChars',';
   result="";
   for (i=2;i<=length(IncludeChars);++i) {
      j=pos(substr(IncludeChars,i,1),COLOR2CHECKBOXTAB,1,'I');
      //messageNwait("i="i" j="j);
      if (j) {
         if (result=='') {
            result=gcolortab[j-1];
         } else {
            result=result:+', 'gcolortab[j-1];
         }
      }
   }
   for (i=2;i<=length(ExcludeChars);++i) {
      j=pos(substr(ExcludeChars,i,1),COLOR2CHECKBOXTAB,1,'I');
      if (j) {
         if (result=='') {
            result='not 'gcolortab[j-1];
         } else {
            result=result:+', not 'gcolortab[j-1];
         }
      }
   }
   ctlcolorlabel.p_caption=result;
}
void ctlcolor.lbutton_up()
{
   result=show('-modal _ccsearch_form',ctlcoloroptions.p_text);
   if (result!='') {
      ctlcoloroptions.p_text=_param1;
      _findstring._set_focus();
   }
}
#if 0
// I don't think it makes sense to have a save settings button
// because typically this dialog box shows that last search
_findsave_settings.lbutton_up()
{
   flags=0;
   flag_names='';
   if(!_findcase.p_value) {
      flags|=def_re_search;
      if (flag_names!='') flag_names=flag_names:+'|';
      flag_names=flag_names:+'IGNORECASE_SEARCH';
   }
   //if(_findword.p_value) flags|= WORD_SEARCH;
   if(_findre.p_value) {
      flags|=def_re_search;
      if (flag_names!='') flag_names=flag_names:+'|';
      if ( def_re_search==UNIXRE_SEARCH ) {
         flag_names=flag_names:+'UNIXRE_SEARCH';
      } else if ( def_re_search==BRIEFRE_SEARCH ) {
         flag_names=flag_names:+'BRIEFRE_SEARCH';
      } else {
         flag_names=flag_names:+'RE_SEARCH';
      }
   }
   if(_findwrap.p_value) {
      flags|=WRAP_SEARCH;
      if (flag_names!='') flag_names=flag_names:+'|';
      flag_names=flag_names:+'WRAP_SEARCH';
   }
   //if(_findmark.p_value) flags|=MARK_SEARCH;
   //messageNwait('flags='(flags & IGNORECASE_SEARCH))
   _default_option('s',flags)
   _config_modify|=CFGMODIFY_OPTION;
   save_config();
   _macro('m',_macro('s'))
   _macro_append('_config_modify|=CFGMODIFY_OPTION;')
   _macro_call('_default_options',flag_names)
}
#endif
_findlist_all.lbutton_up()
{
   _findforward.p_enabled=_findbackward.p_enabled=_findcursorend.p_enabled=
        _findwrap.p_enabled=!_findlist_all.p_value;
   wid=_mfparent();
   if (_findlist_all.p_value) {
      _findmark.p_enabled=0;
   } else if (!(wid.p_view_id<0 && !wid.select_active())) {
      _findmark.p_enabled=1;
   }
}

_findstring.on_create()
{
   wid=_mfparent(arg(2));
   if (!wid._isEditorCtl() ||
       (p_active_form.p_name=='_replace_form' && wid._QReadOnly())
       ) {
      _mfmore.call_event(_mfmore,LBUTTON_UP);
   } else {
      ctlnocolor.p_enabled=ctlcolor.p_enabled=(wid.p_view_id<0 && wid.p_lexer_name!="");
   }
   // If parent window is not an MDI child window
   if (!wid.p_mdi_child) {
      _mfmore.p_visible=0;
      if(_find_control('_findlist_all') ){
         p_active_form.p_height=_findlist_all.p_y+p_active_form._top_height()+p_active_form._bottom_height();
         _findlist_all.p_visible=0;
      }
   }

   ctlnocolor.p_enabled=ctlcolor.p_enabled=(wid._isEditorCtl() && wid.p_lexer_name!="");
   //if (!widcolor.p_enabled) {
   //ctlcoloroptions.call_event(ctlcoloroptions,on_change);
#if 0
   if ((def_mfsearch_init_flags&MFSEARCH_INIT_HISTORY)/* &&
       !(def_mfsearch_init_flags&(MFSEARCH_INIT_CURWORD|MFSEARCH_INIT_SELECTION))*/) {
      _retrieve_prev_form();
   }
#endif
   _retrieve_prev_form();
   if (_findstring.p_text:=='') {
      replacestring_wid=_find_control('_replacestring');
      if (def_mfsearch_init_flags&MFSEARCH_INIT_HISTORY) {
         _findstring.p_text=old_search_string;
      }
      if (replacestring_wid) {
         replacestring_wid.p_text=old_replace_string;
      }
      if (_findstring.p_text!='') {
         flags=old_search_flags;
      } else {
         flags=_default_option('s')
      }
      if (flags & REVERSE_SEARCH) {
         _findbackward.p_value=1;
      } else {
         _findforward.p_value=1;
      }
      if (_findstring.p_text:=='') {
         _findstring.p_text=old_search_string;
      }
      _findcase.p_value= (int)!(flags & IGNORECASE_SEARCH);
      _findword.p_value=flags & WORD_SEARCH;
      _findre.p_value=flags & (RE_SEARCH|UNIXRE_SEARCH|BRIEFRE_SEARCH);
      _findwrap.p_value=flags & WRAP_SEARCH;
      _findmark.p_value=flags & MARK_SEARCH;
   }
   if ((def_mfsearch_init_flags&MFSEARCH_INIT_CURWORD)
      && wid._isEditorCtl()) {
      word=wid.cur_word(junk,'',1);
      _findstring.p_text=word;
   }
   if (def_mfsearch_init_flags&MFSEARCH_INIT_SELECTION) {
      if (wid._isEditorCtl() && wid.select_active2()) {
         mark_locked=0;
         if (_select_type('','S')=='C') {
            mark_locked=1;
            _select_type('','S','E');
         }
         wid.filter_init();
         wid.filter_get_string(str);
         wid.filter_restore_pos();
         //4:29pm 9/5/1996 Dan & Clark added to fix only search & replace on
         //first line after init with selectio
         _findstring.p_text=str;
         if (mark_locked) {
            _select_type('','S','C');
         }
      }
   }
   wid.refresh();
   wid=_mfparent();
   if (wid.p_view_id<0 && !wid.select_active()) {
      _findmark.p_enabled=0;
   }
   search_options=arg(1)
   if (pos('-',search_options)) {
      _findbackward.p_value=1;
   }else if (def_keys=='brief-keys') {
      //In brief, if we aren't searching back, we are always searching forward.
      _findforward.p_value=1;
   }
   if (pos('[rubRUB]',search_options,1,'r')) {
      _findre.p_value=1;
   }
   if (lowcase(p_active_form.p_caption)!='replace') {
      // Make sure the _no_child_windows is in here so that can't list
      // all occurrences when there are no MDI children.
      _findlist_all.p_enabled=!(_findmark.p_enabled&&_findmark.p_value)&& wid._isEditorCtl() && wid.p_mdi_child;
   }
}
_findstring.on_drop_down(reason)
{
   if (p_user=='') {
      p_cb_list_box._retrieve_list();
      p_user=1; // Indicate that retrieve list has been done
   }
}
_finddir.lbutton_up()
{
   result=show('-modal '_stdform('_cd_form'),'Choose Directory',1,1,1);
   if( result=='' ) {
      return('');
   }
   _mfcurdir.p_caption='CurDir is 'getcwd();
   result=strip_options(result,dummy);
   line=_mffiles.p_text;
   if( line!='' ) {
      lastch=substr(strip(line,'T'),length(line),1);
      if( lastch==FILESEP ) {
         #if __UNIX__
         line=strip(line,'T'):+'* ':+result;
         #else
         line=strip(line,'T'):+'*.* ':+result;
         #endif
      } else {
         line=strip(line,'T'):+' ':+result;
      }
   } else {
      line=result;
   }
   _mffiles.p_text=line;
   _mffiles._end_line();
   _mffiles._set_focus();
}
_findok.lbutton_up()
{
   status=_mfget_result(_param3,_param4,
          (_mfproject_files.p_value&& _mfproject_files.p_enabled &&pos('<<',_mfmore.p_caption)));
   if (status) return('');
   wid=_mfparent();
   if (wid.p_view_id>=0 || (wid.p_window_flags & HIDE_WINDOW_OVERLAP)) {
      if (_param3=='' && _param4=='') {
         _message_box('No files selected')
         p_window_id=_control _mffiles;_set_focus
         _set_sel(1,length(p_text)+1)
         return('');
      }
   }
   _save_form_response();

   mfflags=0;
   // IF we are doing a list all occurrences search
   if ((_findlist_all.p_value)&&(_findlist_all.p_enabled)) {
      mfflags=MFFIND_CURBUFFERONLY;
   // IF we are doing a multi-file search
   } else if(_param3!='' || _param4!='') {
      if (ctllistfilesonly.p_value) {
         mfflags|=MFFIND_FILESONLY;
      }
      if (ctlappend.p_value) {
         mfflags|=MFFIND_APPEND;
      }
      if (ctlmdichild.p_value) {
         mfflags|=MFFIND_MDICHILD;
      }
      if (ctlglobal.p_value) {
         mfflags|=MFFIND_GLOBAL;
      } else if (ctlsingle.p_value) {
         mfflags|=MFFIND_SINGLE;
      }
   }
   _param5=mfflags;

   if (_findcase.p_value) {
      search_options= '';
   } else {
      search_options='I';
   }
   if (_findword.p_value) {
      search_options=search_options'W'
   }
   if (_findre.p_value) {
      if (def_re_search==UNIXRE_SEARCH) {
         search_options=search_options'U'
      } else if (def_re_search==BRIEFRE_SEARCH) {
         search_options=search_options'B'
      } else {
         search_options=search_options'R'
      }
   }
   if (_findwrap.p_value && !_param5) {
      search_options=search_options'P';
   }
   if (_findmark.p_value && !_param5) {
      search_options=search_options'M';
   }
   if (_findbackward.p_value && !_param5) {
      search_options=search_options'-';
   }
   if (_findcursorend.p_value && !_param5) {
      search_options=search_options'>';
   }
   if (ctlcolor.p_enabled) {
      search_options=search_options:+ctlcoloroptions.p_text;
   }
   _param2=search_options;
   _param1= _findstring.p_text;
   p_active_form._delete_window(1);
}


defeventtab _replace_form
void _findcase.lbutton_up()
{
   if (_findcase.p_value) {
      ctlpreservecase.p_value=0;
   }
}
void ctlpreservecase.lbutton_up()
{
   if (ctlpreservecase.p_value) {
      _findcase.p_value=0;
   }
}
void _replace_form.'F1'()
{
   help('Replace Dialog Box');
}
/*
  The purpose of this button is to provide encapsulated clipboard
  inheritance for the multiple file/buffer controls.  The multiple
  file/buffers controls call the function below when events of interest
  occur.
*/
_mffiles.on_destroy()
{
   // Need this for UNIX only.  List box of combobox does not get 
   // reinitialized.
   p_cb_list_box.p_user="";
}
_mffiles.on_drop_down(reason)
{
   if (p_cb_list_box.p_user=='') {
      p_cb_list_box._retrieve_list();
      p_cb_list_box.p_user=1; // Indicate that retrieve list has been done
   }
}
_mfhook.lbutton_up(reason,info)
{
   if (reason==CHANGE_SELECTED) {
      _mfnofselected.p_caption=_mfbuflist.p_Nofselected' of '_mfbuflist.p_Noflines' selected'
      if (info) {
         widcolor=_find_control('ctlcolor');
         if (widcolor) {
            ctlnocolor.p_enabled=widcolor.p_enabled=true;
            ctlcoloroptions.call_event(ctlcoloroptions,ON_CHANGE);
         }
         // Some files or bufers have been selected
         if (_findmark.p_enabled) _findmark.p_enabled=0;
         if (_findwrap.p_enabled) _findwrap.p_enabled=0;
         if (_findforward.p_enabled) _findforward.p_enabled=0;
         if (_findbackward.p_enabled) _findbackward.p_enabled=0;
         if (lowcase(p_active_form.p_caption)!='replace') {
            _nocheck _control _findlist_all;
            if (_findlist_all.p_enabled) _findlist_all.p_enabled=0;
         }
      } else {
         // No files or buffers are selected
         widcolor=_find_control('ctlcolor');
         if (widcolor) {
            wid=_mfparent();
            ctlnocolor.p_enabled=widcolor.p_enabled=(wid.p_view_id<0 && wid.p_lexer_name!="");
            //if (!widcolor.p_enabled) {
               ctlcoloroptions.call_event(ctlcoloroptions,on_change);
            //}
         }

         if (lowcase(p_active_form.p_caption)!='replace') {
            _nocheck _control _findlist_all
            if (!_findlist_all.p_enabled) _findlist_all.p_enabled=1;
            if (!_findmark.p_enabled) {
              wid=_mfparent();
              if (!_findlist_all.p_value && wid.p_view_id<0 && wid.select_active()) {
                 _findmark.p_enabled=1;
              }
            }
            if (!_findwrap.p_enabled) _findwrap.p_enabled=!_findlist_all.p_value;
            if (!_findforward.p_enabled) _findforward.p_enabled=!_findlist_all.p_value;
            if (!_findbackward.p_enabled) _findbackward.p_enabled=!_findlist_all.p_value;
         } else {
            if (!_findmark.p_enabled) {
               wid=_mfparent();
              if (wid.p_view_id<0 && wid.select_active()) {
                 _findmark.p_enabled=1;
              }
            }
            if (!_findwrap.p_enabled) _findwrap.p_enabled=1;
            if (!_findforward.p_enabled) _findforward.p_enabled=1;
            if (!_findbackward.p_enabled) _findbackward.p_enabled=1;
         }
      }
      if (p_active_form.p_name=='_find_form') {
         _nocheck _control ctlmdichild,ctlappend,ctllistfilesonly;
         _nocheck _control ctlprompted,ctlsingle,ctlglobal;
         ctlprompted.p_enabled=ctlsingle.p_enabled=ctlglobal.p_enabled=
         ctlmdichild.p_enabled=ctlappend.p_enabled=ctllistfilesonly.p_enabled=info;
      }
   }
}
static boolean _mfhave_input()
{
   return((_mffiles.p_text!='' || _mfbuflist.p_Nofselected ||
         (_mfproject_files.p_enabled && _mfproject_files.p_value)) &&
         pos('<<',_mfmore.p_caption));
}
_mffiles.on_change(reason)
{
   // If the mult file stuff is not visible
   if (pos('>',_mfmore.p_caption)) {
      if (p_text=='') return('');
      p_user=p_text;
      p_text='';
      return('');
   }
   p_user=p_text;
   _mfhook.call_event(CHANGE_SELECTED,_mfhave_input(),_mfhook,LBUTTON_UP,'')
}

_mffiles.on_drop_down(reason)
{
   if (p_cb_list_box.p_user=='') {
      p_cb_list_box._retrieve_list();
      p_cb_list_box.p_user=1; // Indicate that retrieve list has been done
   }
}

_finddir.lbutton_up()
{
   result=show('-modal '_stdform('_cd_form'),'Choose Directory',1,1,1);
   if( result=='' ) {
      return('');
   }
   _mfcurdir.p_caption='CurDir is 'getcwd();
   result=strip_options(result,dummy);
   line=_mffiles.p_text;
   if( line!='' ) {
      lastch=substr(strip(line,'T'),length(line),1);
      if( lastch==FILESEP ) {
         #if __UNIX__
         line=strip(line,'T'):+'* ':+result;
         #else
         line=strip(line,'T'):+'*.* ':+result;
         #endif
      } else {
         line=strip(line,'T'):+' ':+result;
      }
   } else {
      line=result;
   }
   _mffiles.p_text=line;
   _mffiles._end_line();
   _mffiles._set_focus();
}

_mfbuflist.on_change(reason)
{
   if (reason==CHANGE_SELECTED) {
      _mfhook.call_event(CHANGE_SELECTED,_mfhave_input(),_mfhook,LBUTTON_UP,'')
   }
}

// Class code for operating on multiple files or buffers
_mfmore.on_create()
{
   if (pos('>',_mfmore.p_caption)) {
      _dmless('h');
   }
   _mfbuflist.call_event(_mfbuflist,LBUTTON_UP);
   _findproject_fileswid=(_control _mfproject_files);
   _mfset_prjfiles_state(_findproject_fileswid);
}
_mfproject_files.lbutton_up()
{
   _mfhook.call_event(CHANGE_SELECTED,_mfhave_input(),_mfhook,LBUTTON_UP,'');
}
static void _mfset_prjfiles_state(wid)
{
   orig_view_id=p_view_id;
   if (_project_name!='') {
      //11:45am 8/18/1997
      //Dan changed for makefile support
#if 0
      //status=_ini_get_section(_project_name, "FILES", temp_view_id);
      status=GetProjectFiles(_project_name, temp_view_id);
      if (status) {
         if (status!=STRING_NOT_FOUND_RC) {
            _message_box(nls("Could not open project file %s.\n\n%s",_project_name,get_message(status)));
         }
         wid.p_enabled=0;
         wid.p_value=0;
      } else {
         p_view_id=temp_view_id;
         if (!p_Noflines) {
            wid.p_enabled=0;
            wid.p_value=0;
         }
         p_view_id=orig_view_id;
         _delete_temp_view(temp_view_id);
      }
#else
      status=_ini_get_value(_project_name,"ASSOCIATION",'makefile',result,'');
      if (status || result=='') {
         status=GetProjectFiles(_project_name, temp_view_id);
         if (status) {
            if (status!=STRING_NOT_FOUND_RC) {
               _message_box(nls("Could not open project file %s.\n\n%s",_project_name,get_message(status)));
            }
            wid.p_enabled=0;
            wid.p_value=0;
         } else {
            p_view_id=temp_view_id;
            if (!p_Noflines) {
               wid.p_enabled=0;
               wid.p_value=0;
            }
            p_view_id=orig_view_id;
            _delete_temp_view(temp_view_id);
         }
      }
#endif
   }else{
      wid.p_enabled=0;
      wid.p_value=0;
   }
}

/*
   Stores and returns form parent.
*/
_mfparent()
{
   if (arg()) {
      _mfinvert.p_user=arg(1);
   }
   return(_mfinvert.p_user);
}
_mfmore.lbutton_up()
{
   if (p_user=='') {
      p_user=1;
      // Fill the buffer list
      p_window_id=_control _mfbuflist;
      name=buf_match('',1)
      for (;;) {
         if (rc) break;
         if (name!='' && name!='.process' ){
            _lbadd_item(name);
         }
         name=buf_match('',0)
      }
      p_window_id=_control _mfmore;
   }
   if (p_active_form.p_name=='_find_form') {
      if (pos('>',p_caption)) {
         _nocheck _control ctlmdichild;
         y=ctlmdichild.p_y+ctlmdichild.p_height+50;
         new_height=y+p_active_form._top_height()+p_active_form._bottom_height();
         if (p_active_form.p_height!=new_height) {
            p_active_form.p_height=new_height;
            // This forced update seems to fix a paint bug under OS/2
            p_active_form.refresh('w');
         }
      }
      _dmmoreless('h');
   } else {
      _dmmoreless('h');
   }
   // This forced update seems to fix a paint bug under OS/2
   p_active_form.refresh('w');
   if (pos('<',p_caption)) {
      _mfcurdir.p_caption='CurDir is 'getcwd();
      _mfcurdir.p_visible=1;
      p_window_id=_control _mffiles;
      _mffiles.p_text=_mffiles.p_user;
      _set_sel(1,length(p_text)+1)
   } else {
      _mfcurdir.p_visible=0;
      _mffiles.p_user=_mffiles.p_text;
      _mffiles.p_text='';
      _mfhook.call_event(CHANGE_SELECTED,_mfhave_input(),_mfhook,LBUTTON_UP,'')
   }
   _set_focus();
}
_mfclear.lbutton_up()
{
   _mfbuflist._lbdeselect_all();
   _mfhook.call_event(CHANGE_SELECTED,_mfhave_input(),_mfhook,LBUTTON_UP,'')
   //_findlist_all.p_enabled=(_mfbuflist.p_Nofselected==0&&_mffiles.p_text=='')?1:0;
}
_mfinvert.lbutton_up()
{
   _mfbuflist._lbinvert();
   _mfhook.call_event(CHANGE_SELECTED,_mfhave_input(),_mfhook,LBUTTON_UP,'')
   //_findlist_all.p_enabled=(_mfbuflist.p_Nofselected==0&&_mffiles.p_text=='')?1:0;
}
/*
   Status is returned.  If non-zero, an error message box was displayed.
   IF status is zero, result is set to the result
   IF status is zero and result=='' then the user has not selected anything.

   WARNING: IF this function returns valid results, the buffer list is
            destroyed.  Make sure you call this function after you have
            verified all other dialog box values so you can close the
            dialog box.
*/
_str _mfget_result(var files,var atbuflist,... /* include_project_files */)
{
   if (!_mfhave_input()) {
      files="";
      atbuflist="";
      return(0);
   }
   // Check the files
   include_project_files=0;
   if (arg()>=3) {
      include_project_files=arg(3);
   }

   orig_wid=p_window_id;
   result=_unix_expansion(_mffiles.p_text);
   if (result!='' && (_mfsubdir.p_value) && (_mfsubdir.p_enabled)) {
      result= '+t 'result
   }
   tree_option=''
   line=result;
   Noffiles=0;
   one_file_found=0;
   first_file_not_found='';
   for (;;) {
      word = parse_file(line);
      if (word=='') break;
      ch=substr(word,1,1);
      if (ch=='-' || ch=='+') {
         option=upcase(substr(word,2));
         switch (option) {
         case 'T':
            tree_option='+t'
            break;
         default:
            _message_box('Invalid switch')
            _mferror()
            return(1)
         }
      } else {
         ++Noffiles;
         if (file_match('-pd 'tree_option' 'word,1)!='') {
             one_file_found=1;
         } else if (!iswildcard(word)) {
            _message_box(nls('File "%s" not found',word))
            _mferror()
            return(1)
         } else {
            if (Noffiles==1) {
               first_file_not_found=word;
            }
         }
      }
   }
   if (!one_file_found && first_file_not_found!='') {
      _message_box(nls('File "%s" not found',first_file_not_found))
      _mferror()
      return(1)
   }
   files=result;
   if (include_project_files) {
      _mfbuflist.add_project_files();
   }
   atbuflist=_mfbuflist._lbmulti_select_result();

   return(0);
}

static void add_project_files()
{
   if (_project_name=='') {
      return;
   }
   orig_view_id=p_view_id;
   //11:45am 8/18/1997
   //Dan changed for makefile support
   //status=_ini_get_section(_project_name,"FILES",temp_view_id);
   status=GetProjectFiles(_project_name,temp_view_id);
   if (status) {
      p_view_id=orig_view_id;
      return;
   }
   p_view_id=temp_view_id;
   mark_id=_alloc_selection();
   top();_select_line(mark_id);
   bottom();_select_line(mark_id);
   _shift_selection_right(mark_id);
   _deselect(mark_id);
   p_col=1;p_line=1;
   p_line=0;
   while (!down()) {
      get_line(line);
      replace_line('>'substr(line,2));
   }
   top();_select_line(mark_id);
   bottom();_select_line(mark_id);
   p_view_id=orig_view_id;
   bottom();
   _copy_to_cursor(mark_id);
   _free_selection(mark_id);
   _delete_temp_view(temp_view_id);
}

static void _mferror()
{
   p_window_id=_mffiles;_set_sel(1,length(p_text)+1);_set_focus();
   if (pos('>',_mfmore.p_caption)) {
      _mfmore.call_event(_mfmore,LBUTTON_UP);
   }
   //_mfmore._dmmore('h');
}
_replaceall.lbutton_up()
{
   _replaceok.call_event('*',_replaceok,LBUTTON_UP,'');
}
_replaceok.lbutton_up()
{
   status=_mfget_result(_param4,_param5,(_mfproject_files.p_value&&pos('<<',_mfmore.p_caption)));
   if (status) return('');
   wid=_form_parent();
   if (wid.p_view_id>=0 || (wid.p_window_flags & HIDE_WINDOW_OVERLAP)||
       (wid.p_ReadOnly)) {
      if (_param4=='' && _param5=='') {
         if(wid._QReadOnly()){
            _message_box("No files selected\n\nRead only files can't be modified")
         } else {
            _message_box('No files selected')
         }
         p_window_id=_control _mffiles;
         _set_sel(1,length(p_text)+1);_set_focus();
         return('');
      }
   }
   _save_form_response();
   if (_findcase.p_value) {
      search_options= 'E';
   } else {
      search_options='I';
      if (_find_control('ctlpreservecase') && ctlpreservecase.p_value) {
         search_options=search_options:+'V';
      }
   }
   if (_findword.p_value) {
      search_options=search_options'W'
   }
   if (_findre.p_value) {
      if (def_re_search==UNIXRE_SEARCH) {
         search_options=search_options'U'
      } else if (def_re_search==BRIEFRE_SEARCH) {
         search_options=search_options'B'
      } else {
         search_options=search_options'R'
      }
   }
   if (_findwrap.p_value && _findwrap.p_enabled) {
      search_options=search_options'P'
   }
   if (_findmark.p_value && _findmark.p_enabled) {
      search_options=search_options'M'
   }
   if (_findbackward.p_value) {
      search_options=search_options'-'
   }
   if (_findcursorend.p_value) {
      search_options=search_options'>'
   }
   if (ctlcolor.p_enabled) {
      search_options=search_options:+ctlcoloroptions.p_text;
   }
   search_options=search_options:+arg(1)
   _param1= _findstring.p_text;
   _param2= _replacestring.p_text;
   _param3= search_options
   p_active_form._delete_window(1);
}

_replacestring.on_drop_down(reason)
{
   if (p_user=='') {
      p_cb_list_box._retrieve_list();
      p_user=1; // Indicate that retrieve list has been done
   }
}
_str gui_replace2(_str search_string,_str replace_string,_str options)
{
   _mffindNoMore(1);
   edit_wid=p_window_id;
   status=qreplace_init(search_string,replace_string,options,
             old_mark,    // Handle to original marked area
             mark,        // Handle to mark used for select_match purposes
             search_mark, // Handle to mark for original cursor pos
             wrap_mark,   // Handle to mark. Area to search in when reach end.
             searched_in_wrap_mark,
             search_flags, // flags equivalent of options
             go,
             leave_selected
             )
   if (status) {
      _Nofchanges=0;
      // If a critical message box was not display
      if (!(arg() >= 4 && arg(4) == 1)) { // arg(4)==1 means suppress STRING_NOT_FOUND_RC messages
         if (status==STRING_NOT_FOUND_RC) {
            message(get_message(status));
         }
      }
      return(status);
   }
   old_go=go;
   if (go) {
      _show_selection old_mark
      Nofchanges=1;
      searchrc=search_replace(replace_string,'R');
      if (!searchrc || (search_flags&WRAP_SEARCH)) {
         if( !searchrc && !(search_flags & REVERSE_SEARCH) ) {
            goto_point match_length('S')
         }
         if( !searchrc ) {
            wrap_option=(searched_in_wrap_mark==1)?'m':'';
            searchrc=search(search_string,wrap_option'@':+options'*',replace_string,add_Nofchanges)
            Nofchanges+=add_Nofchanges
         }
         if (!searched_in_wrap_mark &&
             _select_type(wrap_mark)!='' && (search_flags & WRAP_SEARCH)) {
            searched_in_wrap_mark=1;
            if (search_flags & REVERSE_SEARCH) {
               _end_select wrap_mark
            } else {
               _begin_select wrap_mark
            }
            temp=wrap_mark;wrap_mark=old_mark;old_mark=temp;
            _show_selection(old_mark);
            searchrc=search(search_string,'m@'options'*',replace_string,add_Nofchanges)
            Nofchanges+=add_Nofchanges
         }
      }
      if ( def_restore_cursor ) { _begin_select search_mark }
      return(qreplace_done2(old_mark,wrap_mark,search_mark,mark,
                            searched_in_wrap_mark,Nofchanges,edit_wid)
             )
   }
   old_show_cursor=_default_option('C');
   _default_option('C',0);


   int tbsstabid=0;
   tbformid = _find_object("_tbproject_form","N")
   if (tbformid) {
      tbsstabid = tbformid._find_control("_proj_toolbar_sstab");
      if (tbsstabid.p_ActiveTab == PROJTOOLTAB_PROCS && 
          !tbsstabid.p_ActiveEnabled) {
         tbsstabid.p_ActiveEnabled = TRUE;
      } else {
         tbsstabid=0;
      }
   }

   result=show('-reinit -modal -nocenter _qreplace_form',search_string,replace_string,options,
             old_mark,    // Handle to original marked area
             mark,        // Handle to mark used for select_match purposes
             search_mark, // Handle to mark for original cursor pos
             wrap_mark,   // Handle to mark. Area to search in when reach end.
             searched_in_wrap_mark,
             search_flags, // flags equivalent of options
             leave_selected,
             p_window_id
             );
   if (tbsstabid) {
      tbsstabid.p_ActiveEnabled = FALSE;
   }
   _default_option('C',old_show_cursor)
   if (result=='') {
      return(COMMAND_CANCELLED_RC);
   }
   old_go=result;
   return(0);
}

/*
  _qryes.p_user=old_mark' 'wrap_mark' 'search_mark' 'mark' 'options' 'search_flags' 'searched_in_wrap_mark' 'leave_selected
   _qrno.p_user=search_string
   _qrlast.p_user=replace_string
   _qrquit.p_user=0;               //Nofchanges
   _qrgo.p_user=form_parent

*/
 static _str gSaveSearch_search_string;
 static int gSaveSearch_flags;
 static int gSaveSearch_word_re;
 static int gSaveSearch_ReservedMore;
defeventtab _qreplace_form

_qryes.on_create()
{
   search_string=arg(1);
   replace_string=arg(2)
   options=arg(3);
   old_mark=arg(4);     // Handle to original marked area
   mark=arg(5);         // Handle to mark used for select_match purposes
   search_mark=arg(6);  // Handle to mark for original cursor pos
   wrap_mark=arg(7);    // Handle to mark. Area to search in when reach end.
   searched_in_wrap_mark=arg(8);
   search_flags=arg(9); // flags equivalent of options
   leave_selected=arg(10)
   frmparent=arg(11);
   _qrgo.p_user=frmparent;

   _qryes.p_user=old_mark' 'wrap_mark' 'search_mark' 'mark' 'options' 'search_flags' 'searched_in_wrap_mark' 'leave_selected
   _qrno.p_user=search_string
   _qrlast.p_user=replace_string
   _qrquit.p_user=0;               //Nofchanges
   _qrfound.p_caption=_qrgo.p_user.get_text(match_length(''),match_length('s'))

   _search_form_xy(p_active_form,_qrgo.p_user)
   qreplace_liney();
   save_search(gSaveSearch_search_string,gSaveSearch_flags,gSaveSearch_word_re,gSaveSearch_ReservedMore);
}
static qreplace_liney()
{
   wid=_qrgo.p_user;
   _SearchViewMatch(p_active_form,wid);
}
void _SearchViewMatch(int form_wid,int buf_wid)
{
   form_wid._get_window(form_x,form_y,form_width,form_height);
   _lxy2dxy(form_wid.p_xyscale_mode,form_x,form_y);
   _map_xy(0,buf_wid,form_x,form_y,SM_PIXEL);

   line_height=buf_wid._text_height();
   if (buf_wid.p_cursor_y+line_height>form_y) {
      buf_wid.set_scroll_pos(buf_wid.p_left_edge,buf_wid._text_height()*2);
   }
}
_qryes.on_destroy()
{
   parse _qryes.p_user with old_mark wrap_mark search_mark mark options search_flags searched_in_wrap_mark leave_selected
   _show_selection old_mark
   if (searched_in_wrap_mark) {
      temp=wrap_mark;wrap_mark=old_mark;old_mark=temp;
   }
   _free_selection wrap_mark
   _free_selection search_mark
   _show_selection old_mark
   _free_selection mark
   _Nofchanges=_qrquit.p_user;

}
static qreplace_done(searchrc,go)
{
   _Nofchanges=Nofchanges=_qrquit.p_user
   p_active_form._delete_window(go);
   if (searchrc==COMMAND_CANCELLED_RC || searchrc==STRING_NOT_FOUND_RC || searchrc==0) {
      qreplace_Nofchanges(searchrc,Nofchanges)
   } else {
      _message_box(get_message(searchrc));
   }
}
static _str qreplace_done2(old_mark,wrap_mark,search_mark,mark,searched_in_wrap_mark,Nofchanges,edit_wid)
{
   _show_selection old_mark
   if (searched_in_wrap_mark) {
      temp=wrap_mark;wrap_mark=old_mark;old_mark=temp;
   }
   _free_selection wrap_mark
   _free_selection search_mark
   orig_wid=p_window_id;
   p_window_id=edit_wid;
   _show_selection old_mark
   p_window_id=orig_wid;
   _free_selection(mark);
   _Nofchanges=Nofchanges;
   qreplace_Nofchanges(0,Nofchanges);
   return(0);
}
_qrquit.lbutton_up()
{
   restore_search(gSaveSearch_search_string,gSaveSearch_flags,gSaveSearch_word_re,gSaveSearch_ReservedMore);

   parse _qryes.p_user with old_mark wrap_mark search_mark mark options search_flags searched_in_wrap_mark leave_selected
   if (leave_selected) {
      temp=old_mark;old_mark=mark;mark=temp;
   }
   _qryes.p_user=old_mark' 'wrap_mark' 'search_mark' 'mark' 'options' 'search_flags' 'searched_in_wrap_mark' 'leave_selected
   qreplace_done(COMMAND_CANCELLED_RC,'');
}
_qryes.lbutton_up()
{
   restore_search(gSaveSearch_search_string,gSaveSearch_flags,gSaveSearch_word_re,gSaveSearch_ReservedMore);
   // Zap check variables. close if no child windows active, restore search
   qreplace_resume(wid,search_string,replace_string,options,search_flags,searched_in_wrap_mark,search_mark,old_mark,mark);
   // Check if the text at the cursor
   ++ _qrquit.p_user;
   _show_selection old_mark
   orig_wid=p_window_id;
   p_window_id=wid;
   searchrc=search_replace(replace_string,'R');
   if (searchrc==STRING_NOT_FOUND_RC){
      save_pos(p);
      if(qreplace_wrap(orig_wid)) {
         searchrc=repeat_search('m');
         if (searchrc) restore_pos(p);
      }
   }
   if (!searchrc) {
      _show_selection mark
      _select_match
      orig_wid._qrfound.p_caption=get_text(match_length(''),match_length('s'))
   }
   p_window_id=orig_wid;
   if (searchrc) {
      qreplace_done(searchrc,0);

      save_search(gSaveSearch_search_string,gSaveSearch_flags,gSaveSearch_word_re,gSaveSearch_ReservedMore);
      return('');
   }
   qreplace_liney();

   save_search(gSaveSearch_search_string,gSaveSearch_flags,gSaveSearch_word_re,gSaveSearch_ReservedMore);
}
_qrno.lbutton_up()
{
   restore_search(gSaveSearch_search_string,gSaveSearch_flags,gSaveSearch_word_re,gSaveSearch_ReservedMore);
   // Zap check variables. close if no child windows active, restore search
   qreplace_resume(wid,search_string,replace_string,options,search_flags,searched_in_wrap_mark,search_mark,old_mark,mark);
   // Check if the text at the cursor
   _show_selection old_mark
   orig_wid=p_window_id;
   p_window_id=wid;

   searchrc=repeat_search();
   if (searchrc==STRING_NOT_FOUND_RC){
      save_pos(p);
      if(qreplace_wrap(orig_wid)) {
         searchrc=repeat_search('m');
         if (searchrc) restore_pos(p);
      }
   }
   if (!searchrc) {
      _show_selection mark
      _select_match
      orig_wid._qrfound.p_caption=get_text(match_length(''),match_length('s'))
   }
   p_window_id=orig_wid;
   if (searchrc) {
      qreplace_done(searchrc,0);
      save_search(gSaveSearch_search_string,gSaveSearch_flags,gSaveSearch_word_re,gSaveSearch_ReservedMore);
      return('');
   }
   qreplace_liney();
   save_search(gSaveSearch_search_string,gSaveSearch_flags,gSaveSearch_word_re,gSaveSearch_ReservedMore);
}

_qrlast.lbutton_up()
{
   restore_search(gSaveSearch_search_string,gSaveSearch_flags,gSaveSearch_word_re,gSaveSearch_ReservedMore);
   // Zap check variables. close if no child windows active, restore search
   qreplace_resume(wid,search_string,replace_string,options,search_flags,searched_in_wrap_mark,search_mark,old_mark,mark);
   // Check if the text at the cursor
   ++ _qrquit.p_user;
   _show_selection old_mark
   orig_wid=p_window_id;
   p_window_id=wid;
   searchrc=search_replace(replace_string);
   p_window_id=orig_wid;
   qreplace_done(COMMAND_CANCELLED_RC,0);
   save_search(gSaveSearch_search_string,gSaveSearch_flags,gSaveSearch_word_re,gSaveSearch_ReservedMore);
}
_qrgo.lbutton_up()
{
   restore_search(gSaveSearch_search_string,gSaveSearch_flags,gSaveSearch_word_re,gSaveSearch_ReservedMore);
   // Zap check variables. close if no child windows active, restore search
   qreplace_resume(wid,search_string,replace_string,options,search_flags,searched_in_wrap_mark,search_mark,old_mark,mark);
   // Check if the text at the cursor
   ++ _qrquit.p_user;
   _show_selection old_mark
   orig_wid=p_window_id;
   p_window_id=wid;
   searchrc=search_replace(replace_string,'R');
   if (searchrc) {
      if (qreplace_wrap(orig_wid)) {
         parse orig_wid._qryes.p_user with . . . . . . searched_in_wrap_mark .
      } else {
         p_window_id=orig_wid;
         if ( def_restore_cursor ) wid._begin_select(search_mark);
         qreplace_done(searchrc,1);
         save_search(gSaveSearch_search_string,gSaveSearch_flags,gSaveSearch_word_re,gSaveSearch_ReservedMore);
         return('');
      }
   }
   if (! (search_flags & REVERSE_SEARCH) && !searchrc) {
      goto_point match_length('S')
   }
   wrap_option=(searched_in_wrap_mark==1)?'m':'';
   add_Nofchanges2=0;
   searchrc=search(search_string,wrap_option'@':+options'*',replace_string,add_Nofchanges1)
   if (qreplace_wrap(orig_wid)) {
      searchrc=search(search_string,'m@'options'*',replace_string,add_Nofchanges2)
   }
   p_window_id=orig_wid;
   _qrquit.p_user+=add_Nofchanges1+add_Nofchanges2;
   if ( def_restore_cursor ) wid._begin_select(search_mark);
   qreplace_done(searchrc,1);
   save_search(gSaveSearch_search_string,gSaveSearch_flags,gSaveSearch_word_re,gSaveSearch_ReservedMore);
}
static qreplace_wrap(orig_wid)
{
   parse orig_wid._qryes.p_user with old_mark wrap_mark search_mark mark options search_flags searched_in_wrap_mark leave_selected
   if (!searched_in_wrap_mark &&
       _select_type(wrap_mark)!='' && (search_flags & WRAP_SEARCH)) {
      searched_in_wrap_mark=1;
      if (search_flags & REVERSE_SEARCH) {
         _end_select wrap_mark
      } else {
         _begin_select wrap_mark
      }
      clear_message
      temp=wrap_mark;wrap_mark=old_mark;old_mark=temp;
      _show_selection old_mark
      orig_wid._qryes.p_user=old_mark' 'wrap_mark' 'search_mark' 'mark' 'options' 'search_flags' 'searched_in_wrap_mark' 'leave_selected
      return(1);
   }
   return(0);
}
static qreplace_resume(var wid,var search_string,var replace_string,var options,var search_flags,var searched_in_wrap_mark,var search_mark,var old_mark,var mark)
{
   parse _qryes.p_user with old_mark wrap_mark search_mark mark options search_flags searched_in_wrap_mark leave_selected
   search_string=_qrno.p_user;
   replace_string=_qrlast.p_user;
   wid=_qrgo.p_user;
}

static _str qreplace_init(search_string,replace_string,options,
             var old_mark,    // Handle to original marked area
             var mark,        // Handle to mark used for select_match purposes
             var search_mark, // Handle to mark for original cursor pos
             var wrap_mark,   // Handle to mark. Area to search in when reach end.
             var searched_in_wrap_mark,
             var flags,  // flags equivalent of options
             var go,
             var leave_selected
                 )
{
   search_mark=arg(4)
   old_mark=_duplicate_selection('')
   mark=_duplicate_selection()
   if ( mark<0 ) {
      _message_box(get_message(mark));
      if ( search_mark!='' ) {
         _free_selection search_mark
      }
      return(mark);
   }
   if ( isinteger(options) ) { /* Flags given? */
      go=options&GO_SEARCH
      options=make_search_options(options,1);
   } else {
      parse options with a 'w=','i'
      go=pos('*',a)
   }
   // Set the word characters
   restore_search old_search_string,0,'['p_word_chars']'
   search '',options
   // Translate flags to word_re
   save_search junk,flags,word_re
   old_search_flags=flags
   old_word_re=word_re
   old_search_string=search_string
   old_replace_string=replace_string
   search_mark=_alloc_selection()
   if ( search_mark<0 ) {
      _message_box(get_message(search_mark))
      _free_selection mark
      return(search_mark);
   }
   _select_char search_mark     /* Save cursor position */
   wrap_mark=_alloc_selection();
   if (wrap_mark<0) {
      _message_box(get_message(wrap_mark));
      _free_selection mark
      _free_selection search_mark
      return(wrap_mark);
   }

   if ( (flags & MARK_SEARCH) && (_cursor_move_deselects() || _cursor_move_extendssel())) {
      if( _select_type('','S')=='C' ) select_it(_select_type(),'');  /* lock the mark. */
      if ( flags&REVERSE_SEARCH ) {
         _end_select;_end_line
      } else {
         _begin_select;_begin_line
      }
      if (flags & WRAP_SEARCH) flags&=~ WRAP_SEARCH;
   }
   searched_in_wrap_mark=0;
   if ((flags & (MARK_SEARCH|WRAP_SEARCH))==(MARK_SEARCH|WRAP_SEARCH) &&
       select_active() && _select_type()=='BLOCK') {
      // Can't handle wrap searching within block marks that well
      // Must start at begin or end of block
      if (flags & REVERSE_SEARCH) {
         _end_select();
      } else {
         _begin_select();
      }
      searched_in_wrap_mark=2;
   }
   if ( search_string:=='' ) {
      searchrc=STRING_NOT_FOUND_RC
   } else {
      searchrc=search(search_string,'@'options)
   }
   if (search_string:!='' && (flags & WRAP_SEARCH) && !searched_in_wrap_mark) {
      save_pos(p);
      if ((flags & MARK_SEARCH) && select_active()) {
         style='CHAR';
         if (_select_type()=='BLOCK') {
            style='BLOCK';
         }
         // Is this an inclusive mark?
         if (flags & REVERSE_SEARCH) {
            if (searchrc) {
               _begin_select();if (_select_type()=='LINE') _begin_line();
            } else {
               // Place cursor at first character string found
               status2=goto_point(match_length('s')+match_length(''));
               if (status2) {
                  // Must be binary file and found string at end of file.
                  // can't seek past end of file
                  clear_message;bottom();
               }
            }
            // Select text from after string to bottom of file
            select_it(style,wrap_mark)
            _end_select;
            if (_select_type()=='LINE') {
               _end_line;p_col+=2;
            } else if (_select_type()=='CHAR' && _select_type('','i')) {
               // This is an inclusive character mark
               ++p_col;
            }
            select_it(style,wrap_mark)
         } else {
            if (searchrc) {
               _end_select;
               if (_select_type()=='LINE') {
                  _end_line;p_col+=2;
               } else if (_select_type()=='CHAR' && _select_type('','i')) {
                  // This is an inclusive character mark
                  ++p_col;
               }
            } else {
               // Place cursor at start of string found
               goto_point(match_length('s'));
            }
            // Select text from start of string to top of file
            select_it(style,wrap_mark)
            _begin_select();if (_select_type()=='LINE') _begin_line();
            select_it(style,wrap_mark)
         }
      } else {
         if (flags & REVERSE_SEARCH) {
            if (searchrc) {
               top();
            } else {
               // Place cursor at first character string found
               status2=goto_point(match_length('s')+match_length(''));
               if (status2) {
                  // Must be binary file and found string at end of file.
                  // can't seek past end of file
                  clear_message;bottom();
               }
            }
            // Select text from after string to bottom of file
            _select_char(wrap_mark);bottom;_select_char(wrap_mark);
         } else {
            if (searchrc) {
               bottom();
            } else {
               // Place cursor at start of string found
               goto_point(match_length('s'));
            }
            // Select text from start of string to top of file
            _select_char(wrap_mark);top();_select_char(wrap_mark);
         }
      }
      restore_pos(p);
   }
   if ( searchrc<0 ) {
      // messageNwait('h1 got here type='_select_type(wrap_mark))
      if (!searched_in_wrap_mark &&
          _select_type(wrap_mark)!='' && (flags & WRAP_SEARCH)) {
         save_pos(p);
         searched_in_wrap_mark=1;
         if (flags & REVERSE_SEARCH) {
            _end_select wrap_mark
         } else {
            _begin_select wrap_mark
         }
         clear_message
         temp=wrap_mark;wrap_mark=old_mark;old_mark=temp;
         _show_selection old_mark
         wrap_option='m';
         wrap_flag=MARK_SEARCH;
         searchrc=search(search_string,'@m'options)
         if (searchrc) {
            restore_pos(p);
         }
      }
   }
   if (searchrc) {
      if (searched_in_wrap_mark==1) {
         temp=wrap_mark;wrap_mark=old_mark;old_mark=temp;
      }
      _free_selection wrap_mark
      _free_selection search_mark
      _show_selection old_mark
      _free_selection mark
      return(searchrc);
   }
   orig_mark_flag=(old_search_flags & MARK_SEARCH);
   leave_selected=!(orig_mark_flag && select_active()) && def_persistent_select=='D' && def_leave_selected;
   _show_selection mark
   _select_match
   return(searchrc);
}



void _search_form_xy(form_wid,buf_wid)
{
   // Save the buffer (x,y), width, and height for manipulation
   buf_x= buf_wid.p_x;
   buf_y= buf_wid.p_y;
   _map_xy(buf_wid.p_xyparent,0,buf_x,buf_y,buf_wid.p_xyscale_mode);

   _lxy2dxy(buf_wid.p_xyscale_mode,buf_x,buf_y);

   caption_height=buf_wid._top_height()

   buf_width=buf_wid.p_width
   buf_height=buf_wid.p_height
   _lxy2dxy(buf_wid.p_xyscale_mode,buf_width,buf_height);

   form_width=form_wid.p_width;
   form_height=form_wid.p_height;
   _lxy2dxy(form_wid.p_xyscale_mode,form_width,form_height);

   // Get the height of one line in the buffer window
   buf_line_height=buf_wid._text_height()
   junk=0;
   _lxy2dxy(buf_wid.p_scale_mode,junk,buf_line_height);
   buf_line_height=buf_line_height*10;

   if (buf_line_height<buf_height intdiv 2) {
      buf_line_height=buf_height intdiv 2;
   }

   // Center the form within the buffer window
   x= (buf_x+(buf_width intdiv 2))-(form_width intdiv 2);
   y= buf_y+(buf_line_height)+caption_height;
   if(y+form_height>=_screen_height()) {
      // Compute the midpoint of the buffer window in screen coords
      buf_midpt_x= buf_x+(buf_width intdiv 2);
      buf_midpt_y= buf_y+(buf_height intdiv 2);

      // Compute the midpoint of the screen
      screen_midpt_x= (_screen_width() intdiv 2);
      screen_midpt_y= (_screen_height() intdiv 2);

      topflag= (buf_midpt_y<screen_midpt_y);
      leftflag=(buf_midpt_x<screen_midpt_x);
      if( leftflag ) {
         x= buf_x+buf_width;
      } else {
         x= buf_x-form_width;
      }
      if( topflag ) {
         y=buf_y;
      } else {
         y= buf_y-form_height;
      }
      // Put final (x,y) coordinates back into scale mode of form
      _dxy2lxy(form_wid.p_xyscale_mode,x,y)
      form_wid.p_x=x;
      form_wid.p_y=y;
      form_wid._show_entire_form();
   } else {
      // Put final (x,y) coordinates back into scale mode of form
      _dxy2lxy(form_wid.p_xyscale_mode,x,y);
      form_wid.p_x=x;
      form_wid.p_y=y;
      form_wid._show_entire_form();
   }
}
_command list_search() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   _macro_delete_line()
   if ( arg(1)=='' ) {
      _message_box('Syntax: list-search /s[/[E][I][R][W]]  E=Exact case I=Ignore case R=R-E W=Word');
      command_put('list-search /');
      return(1)
   }

   if (arg()>=2) {
      search_string=arg(1);
      search_flags=arg(2);
      if (pos(1,search_flags)) {
         parse search_flags with beg '1' en;
         search_flags=beg:+en;
      }
   }else{
      parse arg(1) with 1 delim +1 search_string (delim) search_flags;
   }
   _macro_call('list_search',search_string,search_flags);
   return(_mffind(search_string,search_flags,"","",MFFIND_CURBUFFERONLY));
}
/*
     This function is for MicroEdge only.  If you want to insert your own regular
     expressions or untranslated text into a text box or combo box, use the 
     "ctlinsert" command.
*/
_command void regexinsert()
{
   parse arg(1) with re rep;
   if (rep=='') {
      if (def_re_search==UNIXRE_SEARCH) {
         switch (re) {
         case '?':
            re='.';
            break;
         case '{%\c}':
            re='(%\c)';
            break;
         case ':%\c':
            re='{%\c,}';
            break;
         case '(%\c)':
            re='(?:%\c)';
            break;
         default:
            if (substr(re,1,2)=='\g') {
               re='\'((int)substr(re,3)+1);
            } else if (substr(re,1,1)==':') {
               re='\'re;
            }
         }
      } else if (def_re_search!=RE_SEARCH) {  // BRIEFRE_SEARCH
         switch (re) {
         case '[^%\c]':
            re='[~%\c]';
            break;
         case '^':
            re='<';
            break;
         case '*':
            re='@';
            break;
         case ':%\c,':
            re='\:%\c,';
            break;
         case '(%\c)':
            re='\(%\c)';
            break;
         default:
            if (substr(re,1,2)=='\g') {
               re='\'((int)substr(re,3));
            } else if (substr(re,1,1)==':') {
               re='\'re;
            }
         }
      } /*else {
         if (re=='not') {
            re='[^%\c]';
         }
      }*/
   } else {
      if (def_re_search!=RE_SEARCH) {
         if (substr(re,1,1)=='#') {
            re='\'((int)substr(re,2)+1);
         }
      }
   }
   parse re with b4 '%\c' after
   wid=p_prev;
   if (wid) {
      wid._set_focus();
      wid.keyin(b4);
      wid._get_sel(start_pos);
      wid.keyin(after);
      wid._set_sel(start_pos);
      rewid=_find_control('_findre');
      if (!rewid) {
         rewid=_find_control('ctlre');
      }
      if (rewid) {
         rewid.p_value=1;
      }
   }
}
