/*
$VerboseHistory: fontcfg.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:16a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:15a
 * Comment:
 * Added support for editor control.
 * Change message box to display question mark icon.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:33p
 * Updated in \vault\vsship30\
 * Last Modified: 10/09/1997 02:25p
 * Comment:
 * Adding new 3.0 stuff
*/
#include "slick.sh"

#define DEFAULT_FONT_PLACE 'Window-Text='CFG_WINDOW_TEXT

                           //' Message-Line='CFG_MESSAGE:+\
#define COMMON_FONT_PLACES ('Command-Line='CFG_CMDLINE:+\
                           ' Status-Text='CFG_STATUS:+\
                           ' Window-Text='CFG_WINDOW_TEXT:+\
                           ' Function-Help='CFG_FUNCTION_HELP:+\
                           ' Selection-List=sellist')
#if __UNIX__
  #define FONT_PLACES (COMMON_FONT_PLACES:+\
                      ' Menu='CFG_MENU:+\
                      ' Dialog='CFG_DIALOG:+\
                      ' Mdi-Child-Icon='CFG_MDICHILDICON:+\
                      ' Mdi-Child-Title='CFG_MDICHILDTITLE)
#else
  #define FONT_PLACES (COMMON_FONT_PLACES:+\
                      ' Menu='CFG_MENU)
#endif

#define CHANGING_ELEMENT_LIST _ctl_element_list.p_user

// These are also defined in font.e
#define CHANGING_SCRIPT_LIST  ctlScript.p_cb_list_box.p_user
#define CHANGING_NAME_LIST    _font_name_list.p_cb_list_box.p_user
#define CHANGING_SIZE_LIST    _font_size_list.p_user

typedef struct {
   _str id;   // This is a string because of 'sellist'
   _str info;
} settings_t;

static settings_t _settings:[];
static settings_t _orig_settings:[];

_control _font_name_list;
_control _font_size_list;

defeventtab _font_config_form;
_ctl_element_list.on_create()
{
   _macro('m',_macro('s'));

   // Disallow ON_CHANGE events to _ctl_element_list
   CHANGING_ELEMENT_LIST=0;
   // arg(1) and arg(2) are passed to the on_create() event of _font_form._font_name_list
   default_element_id=arg(3);
   if( default_element_id=='' ) {
      _ctl_element_list._retrieve_value();
      element_name=p_text;
      if( element_name=='' ) {
         default_element_id=CFG_WINDOW_TEXT;
      } else {
         default_element_id= eq_name2value(translate(element_name,'-',' '),FONT_PLACES);
      }
   }
   FillInElementList(FONT_PLACES,default_element_id);

   // Save all the original element settings
   list=FONT_PLACES;
   for( ;; ) {
      parse list with name '=' id list;
      if( id=='' ) break;
      name=strip(translate(name,' ','-'));
      _settings:[name].id=id;
      if( id=='sellist' ) {
         info= (_dbcs()?def_jsellist_font:def_sellist_font);
         parse info with font_name ',' font_size ',' font_style ',' charset',';
         if (charset=='') {
            charset=VSCHARSET_DEFAULT;
            info=font_name ',' font_size ',' font_style ',' charset',';
         }
         _settings:[name].info=info;
      } else {
         _settings:[name].info=_default_font(id);
      }
   }
   //say('xx info='_settings:['Selection List'].info);
   _orig_settings=_settings;

   // Re-allow ON_CHANGE events to _ctl_element_list
   CHANGING_ELEMENT_LIST=1;
   
   call_event(_ctl_element_list,ON_CHANGE);

}

_ctl_element_list.on_destroy()
{
   // Save the last element we were working on
   _append_retrieve(_ctl_element_list,_ctl_element_list.p_text);
   
   // Empty the _settings hash table so it doesn't get stored in the state file.
   _settings._makeempty();
}

void _font_config_form.on_load()
{
   // Do this after the on_create()'s because the list will be filled in now
   CHANGING_ELEMENT_LIST=1;
   _ctl_element_list.call_event(_ctl_element_list,ON_CHANGE);
   if (ctlfixedfonts.p_value==1 &&
       _font_name_list.p_text!="" &&
       _font_name_list.p_text!=_font_name_list.p_cb_list_box._lbget_text()) {
      ctlfixedfonts.p_value=0;
      charsetName=ctlScript.p_text;
      ctlfixedfonts.call_event(ctlfixedfonts,LBUTTON_UP);
      if (ctlScript.p_cb_list_box._lbsearch(charsetName)) {
          ctlScript.p_text="Default";
      } else {
         ctlScript.p_text=charsetName;
      }
   }
}

// Bad font name
static void _fn_bad_setting(_str msg)
{
   p_window_id=_font_name_list;
   _set_sel(1,length(p_text)+1);_set_focus();
   _post_call(find_index('popup_message',COMMAND_TYPE),msg);
   return;
}

// Bad font size
static void _fs_bad_setting(_str msg)
{
   p_window_id=_font_size_list;
   _set_sel(1,length(p_text)+1);_set_focus();
   _post_call(find_index('popup_message',COMMAND_TYPE),msg);
   return;
}

_ctl_element_list.on_got_focus()
{
   name=strip(_ctl_element_list.p_text);
   
   #if 1
   // Wholesaled from _font_get_result() in font.e
   flags = 0;

   font_name=_font_name_list.p_text;
   font_size=_font_size_list.p_text;
   if (!isinteger(font_size)) {
      parse font_size with width 'x','i' height
      if (!isinteger(width) || !isinteger(height)) {
         _post_call(_fs_bad_setting,'Invalid font size');
         result='';
      }
      if (lowcase(font_name)!='terminal') {
         _post_call(_fs_bad_setting,'Currently we only allow the size for the Terminal font to be selected in pixel width X pixel height form');
         result='';
      }
   } else if (font_size > 400) {
      _post_call(_fs_bad_setting,'Invalid font size');
      result='';
   }
   if(_font_name_list.p_cb_list_box._lbsearch(font_name)){
      p_window_id=_font_name_list;
      _post_call(_fn_bad_setting,'Invalid font name');
      result='';
   }else{
      if (_sample_text.p_font_bold == 1) {
         flags |= 0x01
      }
      if (_sample_text.p_font_italic == 1) {
         flags |= 0x02
      }
      if (_sample_text.p_font_strike_thru == 1) {
         flags |= 0x04
      }
      if (_sample_text.p_font_underline == 1) {
         flags |= 0x08
      }
      result=_sample_text.p_font_name','_font_size_list.p_text','flags','_sample_text.p_font_charset',';
   }
   #else
   result=_font_get_result(1);
   #endif
   
   if( result!='' ) {
      _settings:[name].info=result;   /* Save this so we don't lose
                                       * the settings when user picks
                                       * another element.
                                       */
   }
}

_ctl_ok.lbutton_up()
{
   /* If they only set a single font, then the ON_GOT_FOCUS event
    * on _ctl_element_list would not have occurred, so save the
    * current settings for the current element.
    */
   name=_ctl_element_list.p_text;
   if( name!='' ) {
      name=strip(name);
      result=_font_get_result();
      if( result=='' ) return('');
      _settings:[name].info=result;
   }
   
   // Now do all the macro recording
   _macro('m',_macro('s'));
   for( i._makeempty();; ) {
      _settings._nextel(i);
      if( i._isempty() ) break;
      if( _settings:[i].id=='sellist' ) {
         if( _dbcs() ) {
            _macro_append("def_jsellist_font="_quote(_settings:[i].info)";");
         } else {
            _macro_append("def_sellist_font="_quote(_settings:[i].info)";");
         }
      } else if( _settings:[i].id==CFG_DIALOG ) {
         _macro_call('_ConfigEnvVar','VSLICKDIALOGFONT',_settings:[i].info);
      } else {
         _macro_append("_default_font("_settings:[i].id","_quote(_settings:[i].info)");");
      }
   }
   for( i._makeempty();; ) {
      _settings._nextel(i);
      if( i._isempty() ) break;
      
      font_id=_settings:[i].id;
      result=_settings:[i].info;
      orig_result=_orig_settings:[i].info;
      
      if (font_id==CFG_DIALOG) {
         if( result==orig_result ) continue;
         _ConfigEnvVar('VSLICKDIALOGFONT',result);
      }
      switch (font_id) {
      case CFG_MDICHILDICON:
      case CFG_MDICHILDTITLE:
         if( result==orig_result ) continue;
         _message_box('Existing child edit windows are not updated.');
         break;
      case CFG_DIALOG:
         _message_box('You must exit and restart Visual SlickEdit for Dialog font changes to appear.');
         continue;
      }
      
      parse result with font_name','font_size','font_flags','charset',';
      parse orig_result with ofont_name','ofont_size','ofont_flags','ocharset',';
      if( font_name==ofont_name && font_size==ofont_size && font_flags==ofont_flags && charset==ocharset) continue;
      
      if (font_id=='sellist') {
         if (_dbcs()) {
            def_jsellist_font=result;
         } else {
            def_sellist_font=result;
         }
         _config_modify|=CFGMODIFY_DEFVAR;
         continue;
      }
      
      status=0;
      if (font_id==CFG_WINDOW_TEXT) {
         status = _message_box('Do You Wish to Change the Window Text Font in all Windows?',
                      '',
                      MB_YESNO|MB_ICONQUESTION);
      }
      _config_modify|=CFGMODIFY_OPTION;
      if (font_id==CFG_WINDOW_TEXT && (status == IDNO)) {
         _default_font(CFG_WINDOW_TEXT, font_name','font_size','font_flags','charset)
         wid=_mdi.p_child;
         p_redraw=0;
         wid.p_font_name=font_name;//I've added these changes to immediately update the current window
         wid.p_font_size=font_size;
         wid.p_font_bold      = font_flags & F_BOLD;
         wid.p_font_italic    = font_flags & F_ITALIC;
         wid.p_font_underline = font_flags & F_UNDERLINE;
         wid.p_font_strike_thru = font_flags & F_STRIKE_THRU;
         wid.p_font_charset=charset;
         p_redraw=1;
         continue;
      }
      if (font_id==CFG_WINDOW_TEXT && (status == IDYES)) {
         setall_wfonts(font_name, font_size, font_flags,charset);
         continue;
      }
      _default_font(font_id,result)
   }
   
   p_active_form._delete_window(0);
}

_ctl_element_list.on_change()
{
   if( CHANGING_ELEMENT_LIST ) {
      disable_fixedfonts=0;
      show_fixedfonts=0;
      font_options='';
      font_id=_settings:[p_text].id;
      font=_settings:[p_text].info;
      if( font_id==CFG_WINDOW_TEXT ) {
         show_fixedfonts=1;
      }
      // Disable fixed fonts option?
      if( disable_fixedfonts ) {
         ctlfixedfonts.p_enabled=0;
      }

      // Show only fixed fonts?
      if( show_fixedfonts ) {
         font_options=font_options'f';
         ctlfixedfonts.p_value=1;
      } else {
         ctlfixedfonts.p_value=0;
      }
      parse font with font_name ',' font_size ',' font_style ',' charset',';
      
      // Disallow ON_CHANGE events on _font_name_list and _font_size_list
      CHANGING_NAME_LIST=CHANGING_SIZE_LIST=0;
      CHANGING_SCRIPT_LIST=0;
      
      // Set the font in _font_name_list.p_text
      _font_name_list.p_text=font_name;
      
      // Set the size in _font_size_list.p_text
      _font_size_list.p_text=font_size;
      ctlScript.p_text=_CharSet2Name(charset);
      _sample_text.p_font_charset=charset;
      
      // Set the style
      _bold.p_value=0;
      _italic.p_value=0;
      _strikethrough.p_value=0;
      _underline.p_value=0;
      if( isinteger(font_style) ) {
         if( font_style&F_BOLD ) {
            _bold.p_value=1;
         }
         if( font_style&F_ITALIC ) {
            _italic.p_value=1;
         }
         if( font_style&F_STRIKE_THRU ) {
            _strikethrough.p_value=1;
         }
         if( font_style&F_UNDERLINE ) {
            _underline.p_value=1;
         }
      }

      /* Call this no matter what because it causes the font list
       * to be refreshed.
       */
      _font_name_list.p_user=font_options;
      ctlfixedfonts.call_event(ctlfixedfonts,LBUTTON_UP);
      
      // Select font_name in the list box
      _font_name_list.p_cb_list_box._set_focus();
      _font_name_list.p_cb_list_box._lbdeselect_all();
      _font_name_list.p_cb_list_box._lbsearch(font_name);
      _font_name_list.p_cb_list_box._lbselect_line();
      
      // Re-allow ON_CHANGE events on _font_name_list and _font_size_list
      CHANGING_NAME_LIST=CHANGING_SIZE_LIST=1;
      CHANGING_SCRIPT_LIST=1;
      
      /* Call the ON_CHANGE event for _font_name_list so the list of sizes
       * and sample text are updated.
       */
      _font_name_list.call_event('',_font_name_list,ON_CHANGE,'W');

      charsetName=_CharSet2Name(charset);
      if (ctlScript.p_cb_list_box._lbsearch(ctlScript.p_text)==0) {
         ctlScript.p_text=charsetName;
      }
      
      // Select the font name in the text box of _font_name_list
      p_window_id=_font_name_list;
      _set_sel(1,length(p_text)+1);_set_focus();
   }
}

void setall_wfonts(font_name, font_size, font_flags)
{
   charset=arg(4);
   if (!isinteger(charset)) {
      charset=VSCHARSET_DEFAULT;
   }
   /*
     Loop to change font in all edit windows.  Could not use
     pre-exixting function because it automatically deleted the current
     window.
   */
   _macro('m',_macro('s'))   //Had to add this to get it to work consistently
   _macro_call('setall_wfonts',font_name, font_size, font_flags);
   last=_last_window_id();
   for (i=1;i<=last;++i) {
      if( _iswindow_valid(i) ) {
         if ((i.p_object==OI_EDITOR) ||
             ((i.p_mdi_child) &&
             (i.p_view_id < 0) &&
             !(i.p_window_flags&HIDE_WINDOW_OVERLAP))
            ) {
            i.p_redraw=0;
            i.p_font_name      = font_name;
            i.p_font_size      = font_size;
            i.p_font_bold      = font_flags & F_BOLD;
            i.p_font_italic    = font_flags & F_ITALIC;
            i.p_font_underline = font_flags & F_UNDERLINE;
            i.p_font_strike_thru = font_flags & F_STRIKE_THRU;
            i.p_font_charset=charset;
            i.p_redraw=1;
         }
      }
   }
   _default_font(CFG_WINDOW_TEXT, font_name','font_size','font_flags','charset);
}

static FillInElementList(_str element_list,_str default_element_id)
{
   list=element_list;
   for( ;; ) {
      parse list with name '=' junk list;
      if( name=='' ) break;
      if( machine()!='NT386' || name!='Menu' ) {
         if (name=='Status-Text') {
            if ((_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_CONFIGURABLE_STATUS_FONT)) {
               _ctl_element_list.p_cb_list_box._lbadd_item(translate(name,' ','-'));
            }
         } else if (name=='Command-Line') {
            if ((_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_CONFIGURABLE_CMDLINE_FONT)) {
               _ctl_element_list.p_cb_list_box._lbadd_item(translate(name,' ','-'));
            }
         } else {
            _ctl_element_list.p_cb_list_box._lbadd_item(translate(name,' ','-'));
         }
      }
   }

   if( default_element_id=='' ) {
      default_element_id=CFG_WINDOW_TEXT;
   }
   default_element=translate(eq_value2name(default_element_id,FONT_PLACES),' ','-');
   _ctl_element_list.p_text=default_element;
   if( _ctl_element_list.p_text=='' ) {
      parse DEFAULT_FONT_PLACE with default_element '=' .;
      _ctl_element_list.p_text=translate(default_element,' ','-');
   }
}


