/*
$VerboseHistory: font.e$
*/
#include 'slick.sh'

_control _bold;
_control _italic;
_control _strikethrough;
_control _underline;
_control _font_name_list;
_control _font_size_list;
_control _ok;
_control _cancel;
_control _sample_text;



#define FONT_SIZE_LIST '8 9 10 11 12 14 16 18 20 22 24 26 28 36 48 72'
/*List of font sizes for scalable fonts*/


#define CHANGING_SCRIPT_LIST  ctlScript.p_cb_list_box.p_user
#define CHANGING_NAME_LIST    _font_name_list.p_cb_list_box.p_user
#define CHANGING_SIZE_LIST    _font_size_list.p_user

/*

   _font_name_list.p_user    Contains _insert_font_list options.
                             Not necessarily the original options.

*/
defeventtab _font_form;
ctlfixedfonts.lbutton_up()
{
   options=_font_name_list.p_user;
   parse options with before 'f' after;
   options=before:+after;
   if (p_value) {
      options=options'f';
   }
   _font_name_list.p_user=options;
   FillInFontNameList(_font_name_list.p_text);
}

void update_sample_text()
{
   _sample_text.p_redraw=0;
   _sample_text.p_font_name = _font_name_list.p_cb_list_box._lbget_text();
   if (isinteger(_font_size_list.p_text)) {
      _sample_text.p_font_size = _font_size_list.p_text
   }
   _sample_text.p_font_bold = _bold.p_value!=0;
   _sample_text.p_font_italic = _italic.p_value!=0;
   _sample_text.p_font_strike_thru = _strikethrough.p_value!=0;
   _sample_text.p_font_underline = _underline.p_value!=0;

   _sample_text.p_font_charset=_CharSetName2Id(ctlScript.p_text);
   charset=_sample_text.p_font_charset;
   if (charset==VSCHARSET_DEFAULT) {
      charset=_GetFontCharSet(_sample_text.p_font_name,_sample_text.p_font_size,_font_name_list.p_user);
   }

   _sample_text.p_caption=_CharSet2SampleText(charset);
   _sample_text.p_redraw=0;
}

/* Function to find item in list, select it, and put it in text box.*/
static prepare_cb_and_list(item,setting_size)
{
   p_cb_list_box.p_line = 1;
   status = p_cb_list_box._lbsearch(item);
   if(status){//item was never found
      if (setting_size) {
         p_text=item;
         return('');
      }
      p_cb_list_box.p_line = 1;
      if(arg(1) == ''){
         p_text = p_cb_list_box._lbget_text();
      }else{
         p_text = item;
      }
      p_cb_list_box._lbselect_line();
      return('');
   }
   p_text = p_cb_list_box._lbget_text();
   p_cb_list_box._lbselect_line();
   return(0);
}

static void put_in_sizes(_str font_name)
{

   /*Handle Font Size List*/
   list = FONT_SIZE_LIST;

   _font_size_list.p_cb_list_box._lbclear();

   old_size = _font_size_list.p_text;

   special_case_terminal= (lowcase(font_name)=='terminal');
   if (_isscalable_font(font_name, _font_name_list.p_user)) {
       for (;;) {
          parse list with ls list;
          if (ls == '') {
             break;
          }
          _font_size_list.p_cb_list_box._lbadd_item(ls);
          _font_size_list.p_cb_list_box.p_line = 1;
          _font_size_list.p_cb_list_box._lbsort('-n');
       }
   }else{
       old_wid = p_window_id;
       p_window_id = _font_size_list.p_cb_list_box;
       _insert_font_list(_font_name_list.p_user, font_name);
       _lbsort('-n');
       top();
       _lbdeselect_line();
       _remove_duplicates();
       p_window_id = old_wid;
   }
    if (special_case_terminal) {
       orig_wid=p_window_id;
       p_window_id=_font_size_list.p_cb_list_box;
       orig_view_id=_create_temp_view(temp_view_id);
       _insert_font_list(orig_wid._font_name_list.p_user'x', font_name);
       _lbsort();
       _remove_duplicates();
       top();
       search('^ #{:i}( @)x( @){:i}','@ir',' #0x#1');
       Noflines=p_Noflines;
       input_buf_id=p_buf_id;
       activate_view orig_view_id;
       _lbbottom();
       if (Noflines>=1) {
          _buf_transfer(input_buf_id,1,Noflines);
          _delete_temp_view(temp_view_id);
          p_line=1;
       }
       p_window_id=orig_wid;
    }

   old_wid = p_window_id;
   p_window_id = _font_size_list.p_cb_list_box
   if(_lbsearch(old_size)){
      p_line = 1;
   } else {
      _lbselect_line();
   }
   p_window_id = old_wid;
   /* Handle Font Size List*/
}
static _str _CharSetName2Id(_str name)
{
   switch (name) {
   case "Western":
      return(VSCHARSET_ANSI);
   case "Default":
      return(VSCHARSET_DEFAULT);
   case "Symbol":
      return(VSCHARSET_SYMBOL);
   case "Shiftjis":
      return(VSCHARSET_SHIFTJIS);
   case "Hangeul":
      return(VSCHARSET_HANGEUL);
   case "Gb2312":
      return(VSCHARSET_GB2312);
   case "Chinesebig5":
      return(VSCHARSET_CHINESEBIG5);
   case "OEM/DOS":
      return(VSCHARSET_OEM);
   case "Johab":
      return(VSCHARSET_JOHAB);
   case "Hebrew":
      return(VSCHARSET_HEBREW);
   case "Arabic":
      return(VSCHARSET_ARABIC);
   case "Greek":
      return(VSCHARSET_GREEK);
   case "Turkish":
      return(VSCHARSET_TURKISH);
   case "Thai":
      return(VSCHARSET_THAI);
   case "Central European":
      return(VSCHARSET_EASTEUROPE);
   case "Cyrillic":
      return(VSCHARSET_RUSSIAN);
   case "Mac":
      return(VSCHARSET_MAC);
   case "Baltic":
      return(VSCHARSET_BALTIC);
   default:
      return(name);
   }
}
_str _CharSet2Name(int charset)
{
   switch (charset) {
   case VSCHARSET_ANSI:
      return("Western");
   case VSCHARSET_DEFAULT:
      return("Default");
   case VSCHARSET_SYMBOL:
      return("Symbol");
   case VSCHARSET_SHIFTJIS:
      return("Shiftjis");
   case VSCHARSET_HANGEUL:
      return("Hangeul");
   case VSCHARSET_GB2312:
      return("Gb2312");
   case VSCHARSET_CHINESEBIG5:
      return("Chinesebig5");
   case VSCHARSET_OEM:
      return("OEM/DOS");
   case VSCHARSET_JOHAB:
      return("Johab");
   case VSCHARSET_HEBREW:
      return("Hebrew");
   case VSCHARSET_ARABIC:
      return("Arabic");
   case VSCHARSET_GREEK:
      return("Greek");
   case VSCHARSET_TURKISH:
      return("Turkish");
   case VSCHARSET_THAI:
      return("Thai");
   case VSCHARSET_EASTEUROPE:
      return("Central European");
   case VSCHARSET_RUSSIAN:
      return("Cyrillic");
   case VSCHARSET_MAC:
      return("Mac");
   case VSCHARSET_BALTIC:
      return("Baltic");
   default:
      return(charset);
   }
}
static _str _CharSet2SampleText(int charset)
{
   switch (charset) {
   case VSCHARSET_SHIFTJIS:
      return("AaA@F");
   case VSCHARSET_GREEK:
      return("AaBbAB");
   case VSCHARSET_TURKISH:
      return("AaBb");
   case VSCHARSET_EASTEUROPE:
      return("AaBb");
   case VSCHARSET_RUSSIAN:  // Cyrillic
      return("AaBb");
   case VSCHARSET_SYMBOL:
      return("Symbol");
   case VSCHARSET_ARABIC:
      return("AaBb");
   case VSCHARSET_HEBREW:
      return("AaBb");
   case VSCHARSET_HANGEUL:
   case VSCHARSET_GB2312:
   case VSCHARSET_CHINESEBIG5:
   case VSCHARSET_OEM:
   case VSCHARSET_JOHAB:
   case VSCHARSET_THAI:

   case VSCHARSET_MAC:    // Uses default
   case VSCHARSET_BALTIC: // Uses default
   case VSCHARSET_ANSI:   // Western. Uses default
   case VSCHARSET_DEFAULT:
   }
   return("AaBbYyZz");
}
static void put_in_charsets(_str font_name)
{
#if !__UNIX__
   if (substr(machine(),1,2)!='NT' || _win32s()==1) {
      return;
   }
   ctlScriptLabel.p_visible=true;
   ctlScript.p_visible=true;

   ctlScript.p_cb_list_box._lbclear();

   old_charset = _font_size_list.p_text;

   old_wid = p_window_id;
   p_window_id = ctlScript.p_cb_list_box;
   _insert_font_list(_font_name_list.p_user'C', font_name);
   // Convert charset numbers to names
   top();up();
   for (;;) {
      if (down()) {
         break;
      }
      get_line(line);
      name=_CharSet2Name((int)strip(line));
      replace_line(' 'name);
   }
   _lbsort();
   top();up();
   _lbadd_item("Default");
   _lbdeselect_line();
   _remove_duplicates();
   p_window_id = old_wid;

   old_wid = p_window_id;
   p_window_id = ctlScript.p_cb_list_box
   if(_lbsearch(old_charset)){
      p_line = 1;
   } else {
      _lbselect_line();
   }
   p_window_id = old_wid;
   /* Handle Font Size List*/
#endif
}


_font_name_list.on_create(_str show_font_options="",_str _font_string="")
{
   //messageNwait("_font_name_list.on_create: h1");

   //changing_name_list =  changing_size_list = 0;
   if(_font_string != ''){
      parse _font_string with font_name ',' size ',' font_flags ',' charset ',' .;
   }else{
      font_name = '';
      size = 10;
      font_flags = 0;
      charset=VSCHARSET_DEFAULT;
   }
   if (charset=="") {
      charset=VSCHARSET_DEFAULT;
   }
   if(size == ''){
      size = 10
   }
   if (font_flags == '') {
      font_flags = 0
   }
   if (pos('d',show_font_options,1,'i')) {
      ctlfixedfonts.p_enabled=0;
      parse show_font_options with before 'i' after;
      show_font_options=before:+after;
   }
   if (pos('f',show_font_options,1,'i') ) {
      ctlfixedfonts.p_value=1;
   }

   _font_name_list.p_user=show_font_options;

   CHANGING_NAME_LIST=CHANGING_SIZE_LIST=0;
   CHANGING_SCRIPT_LIST=0;


   if (pos('p',_font_name_list.p_user,1,'i')) {
      _sample_text.p_font_printer=1;
   } else {
      _sample_text.p_font_printer=0;
   }

   //_param1 is the font name with no quotes    - Defaults to courier
   //size is the font size                      - Defaults to 10
   //font_flags is truth(bold)                  - Defaults to 0 (no)

   FillInFontNameList(font_name);


   _font_name_list.prepare_cb_and_list(font_name,0);
   put_in_sizes(font_name);
   _font_size_list.prepare_cb_and_list(size,1);
   put_in_charsets(font_name);

   isbold = font_flags & F_BOLD;
   isitalic = font_flags & F_ITALIC;
   isstrikethrough = font_flags & F_STRIKE_THRU;
   isunderline = font_flags & F_UNDERLINE;

   _bold.p_value = isbold
   _italic.p_value = isitalic
   _underline.p_value = isunderline;
   _strikethrough.p_value = isstrikethrough;

   if (isbold) _sample_text.p_font_bold=1;
   if (isitalic) _sample_text.p_font_italic=1;
   if (isunderline) _sample_text.p_font_underline=1;
   if(isstrikethrough) _sample_text.p_font_strike_thru = 1;

   _sample_text.p_font_name = _font_name_list.p_cb_list_box._lbget_text();//Change font name so that frame mathces _font_name_list.p_text
   _sample_text.p_font_size = size;
   _sample_text.p_font_charset=charset;
   if (charset==VSCHARSET_DEFAULT) {
      charset=_GetFontCharSet(_sample_text.p_font_name,_sample_text.p_font_size,_font_name_list.p_user);
   }
   _sample_text.p_caption=_CharSet2SampleText(charset);
   ctlScript.p_text=_CharSet2Name(_sample_text.p_font_charset);
   CHANGING_NAME_LIST = CHANGING_SIZE_LIST = 1;//Allow events to combo boxes
   CHANGING_SCRIPT_LIST=1;
   //changing_name_list = changing_size_list = 1;//Allow events to combo boxes
   /* messageNwait('_font_name_list.p_cb_list_box.p='_font_name_list.p_cb_list_box.p_pic_point_scale) */
   _macro('m',_macro('s'));

   if (ctlfixedfonts.p_value==1 &&
       _font_name_list.p_text!="" &&
       _font_name_list.p_text!=_font_name_list.p_cb_list_box._lbget_text()) {
      ctlfixedfonts.p_value=0;
      ctlfixedfonts.call_event(ctlfixedfonts,LBUTTON_UP);
   }
}

static FillInFontNameList(_str &font_name)
{
   _font_name_list.p_cb_list_box.p_redraw=0;
   _font_name_list.p_cb_list_box.p_picture=0;
   first_time=!_font_name_list.p_cb_list_box.p_Noflines;
   _font_name_list.p_cb_list_box._lbclear();
   /*Handle Font Name List*/
   p_window_id=_font_name_list.p_cb_list_box;
   _font_name_list.p_cb_list_box._insert_font_list(_font_name_list.p_user); //Put names of fonts in list box

   //messageNwait("FillInFontNameList: _font_name_list="_font_name_list" _font_name_list.p_user="_font_name_list.p_user" N="_font_name_list.p_cb_list_box.p_Noflines);
   //messageNwait('_font_name_list.p_user='_font_name_list.p_user);
   if (machine()=='OS2386') {
      // Kerned outline fonts are not supported.
      orig_wid=p_window_id;
      p_window_id=_font_name_list.p_cb_list_box;
      top();up();
      // Need VS to support funky fonts.  For now if initial font is KERNED.
      // Assume the caller is setting font for something that supports this font.
      status=_lbsearch(font_name);
      if (status) {
         top();up();
         for (;;) {
            if (down()) break;
            get_line(line);
            flags=_font_type(strip(line));
            if (flags & KERNING_FONTTYPE) {
               if (_delete_line()) break;
               up();
            }
         }
      }
      p_window_id=orig_wid;
   }
   if (font_name == '') {
      _font_name_list.p_cb_list_box._lbsort();
      _font_name_list.p_cb_list_box.p_line = 1;
      font_name = _font_name_list.p_cb_list_box._lbget_text();
      _font_name_list.p_text = font_name;
   } else {
      //Sort the list box
      _font_name_list.p_cb_list_box._lbsort();
   }
   _font_name_list.p_cb_list_box._remove_duplicates();
   old_line = _font_name_list.p_cb_list_box.p_line;
   orig_wid=p_window_id
   p_window_id=_font_name_list.p_cb_list_box
   top();up();
   for (;;) {
      if(down()) break;
      name = _lbget_text();
#if __UNIX__
      picture=0;
      _lbset_item(name);
#else
      if (machine()=='OS2386') {
         ft=0;
      } else {
         ft=_font_type(name,_font_name_list.p_user)
      }
      if (ft & TRUETYPE_FONTTYPE) {
         picture = _pic_tt;
      }else if(ft & DEVICE_FONTTYPE){
         picture = _pic_printer;
      } else {
         picture=0;
      }
      _lbset_item(name, 60, picture);
#endif
   }
   p_after_pic_indent_x=80;
   p_line = old_line;
   //messageNwait('h1 p_auto_size='_font_name_list.p_auto_size);
   //_font_name_list.p_auto_size=0;
#if __UNIX__
   p_picture = 0;
#else
   p_picture = _pic_tt;
#endif
   _font_name_list.p_cb_list_box.p_redraw=1;
   p_window_id=orig_wid;
   /*End Handle Font Name List*/
   if (first_time) {
      _font_name_list.p_auto_size=1;
   }


   // Select the font name in the combo box text box in
   // the list box.
#if 0
   p_cb_list_box.p_line = 1;
   status = p_cb_list_box._lbsearch(item);
   if(status){//item was never found
      p_text=item;
      return('');
   }
   p_text = p_cb_list_box._lbget_text();
   p_cb_list_box._lbselect_line();
   return(0);
#endif
   _font_name_list.prepare_cb_and_list(font_name,1);
}

ctlScript.on_change(reason)
{
   if (CHANGING_SCRIPT_LIST) {
      _sample_text.p_font_charset=charset=_CharSetName2Id(p_text);
      if (charset==VSCHARSET_DEFAULT) {
         charset=_GetFontCharSet(_sample_text.p_font_name,_sample_text.p_font_size,_font_name_list.p_user);
      }
      _sample_text.p_caption=_CharSet2SampleText(charset);
   }
}
_font_name_list.on_change(reason)
{
   if (CHANGING_NAME_LIST) {
      font_name=p_text;
      lbtext=p_cb_list_box._lbget_text()
      if (lowcase(font_name)!=lowcase(lbtext)) {
         return('');
      }
      p_cb_list_box._lbselect_line();
      _sample_text.p_font_name = font_name;
      _sample_text.p_font_bold = _bold.p_value!=0;
      _sample_text.p_font_italic = _italic.p_value!=0;
      _sample_text.p_font_underline = _underline.p_value!=0;
      _sample_text.p_font_strike_thru = _strikethrough.p_value!=0;
      put_in_sizes(p_text);
      put_in_charsets(p_text);
      _sample_text.p_font_size = _font_size_list.p_text;
      charset=_sample_text.p_font_charset;
      if(ctlScript.p_cb_list_box._lbsearch(_CharSet2Name(_sample_text.p_font_charset))){
         charset=VSCHARSET_DEFAULT;
      }
      if (charset!=_sample_text.p_font_charset) {
         _sample_text.p_font_charset=charset;
      }
      if (charset==VSCHARSET_DEFAULT) {
         ctlScript.p_text="Default";
         charset=_GetFontCharSet(_sample_text.p_font_name,_sample_text.p_font_size,_font_name_list.p_user);
      }
      _sample_text.p_caption=_CharSet2SampleText(charset);
      linenum=_font_size_list.p_cb_list_box.p_line;
      _font_size_list.p_cb_list_box.top();
      _font_size_list.p_cb_list_box.p_line=linenum;
   }
}

bigint _font_size_valid(font_size)
{
   if (isinteger(font_size)) return(1);
   parse font_size with width 'x','i' height
   if (!isinteger(width) || !isinteger(height)) {
      return(0);
   }
   return(1);
}
_font_size_list.on_lost_focus()
{
   if (_font_size_valid(p_text)) {
      _sample_text.p_font_size = p_text;
      /*
         For now, assume this character set is available in this size
         
         if (_GetFontCharSet(_sample_text.p_font_name,_sample_text.p_font_size,_font_name_list.p_user)==VSCHARSET_SHIFTJIS) {
            _sample_text.p_caption=JAPANESE_SAMPLE_TEXT;
         } else {
            _sample_text.p_caption="AaBbYyZz";
         } 
      */
   } else {
      _beep();
   }
}

_font_size_list.on_change(reason)
{
   if (!CHANGING_SIZE_LIST) {
      return('');
   }

   lbtext=p_cb_list_box._lbget_text()
   if (lbtext:!=p_text){
      if(_isscalable_font(_font_name_list.p_text,_font_name_list.p_user)) {
         if (isinteger(p_text)) {
            _sample_text.p_font_size=p_text;
            /*if (_GetFontCharSet(_sample_text.p_font_name,_sample_text.p_font_size,_font_name_list.p_user)==VSCHARSET_SHIFTJIS) {
               _sample_text.p_caption=JAPANESE_SAMPLE_TEXT;
            } else {
               _sample_text.p_caption="AaBbYyZz";
            } */
         }
      }
      return('')
   }
   p_cb_list_box._lbselect_line();
   new_size=p_cb_list_box._lbget_text()
   _sample_text.p_font_size = new_size;
   /*if (_GetFontCharSet(_sample_text.p_font_name,_sample_text.p_font_size,_font_name_list.p_user)==VSCHARSET_SHIFTJIS) {
      _sample_text.p_caption=JAPANESE_SAMPLE_TEXT;
   } else {
      _sample_text.p_caption="AaBbYyZz";
   } */
}


_italic.lbutton_up()
{
     _sample_text.p_font_italic = p_value!=0;
}

_underline.lbutton_up()
{
    _sample_text.p_font_underline = p_value!=0;
}

_bold.lbutton_up()
{
   _sample_text.p_font_bold = p_value!=0;
}

_strikethrough.lbutton_up()
{
    _sample_text.p_font_strike_thru = p_value!=0;
}


_ok.lbutton_up()
{
   result = _font_get_result();
   if (result=='') {
      return('');
   }
   _macro('m',_macro('s'))
   p_active_form._delete_window(result);
}

_str _font_get_result()
{
   flags = 0;

   font_name=_font_name_list.p_text;
   font_size=_font_size_list.p_text;
   if (!isinteger(font_size)) {
      parse font_size with width 'x','i' height
      if (!isinteger(width) || !isinteger(height)) {
         p_window_id=_font_size_list;
         _message_box(nls('Invalid font size'));
         _set_sel(1,length(p_text)+1);_set_focus();
         return('');
      }
      if (lowcase(font_name)!='terminal') {
         p_window_id=_font_size_list;
         _message_box(nls('Currently we only allow the size for the Terminal font to be selected in pixel width X pixel height form'));
         _set_sel(1,length(p_text)+1);_set_focus();
         return('');
      }
   } else if (font_size > 400) {
      p_window_id=_font_size_list;
      _message_box(nls('Invalid font size'));
      _set_sel(1,length(p_text)+1);_set_focus();
      return('');
   }
   if(_font_name_list.p_cb_list_box._lbsearch(font_name)){
      p_window_id=_font_name_list;
      _message_box(nls('Invalid font name'));
      _set_sel(1,length(p_text)+1);_set_focus();
      return('');
   }
   if (_sample_text.p_font_bold == 1) {
      flags |= 0x01
   }
   if (_sample_text.p_font_italic == 1) {
      flags |= 0x02
   }
   if (_sample_text.p_font_strike_thru == 1) {
      flags |= 0x04
   }
   if (_sample_text.p_font_underline == 1) {
      flags |= 0x08
   }

   return(_sample_text.p_font_name','_font_size_list.p_text','flags','_CharSetName2Id(ctlScript.p_text)',');
}

