/*
$VerboseHistory: files.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:41a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:40a
 * Comment:
 * Added support for editor control.
 * Change message box to display question mark icon.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:33p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
#include "slick.sh"
no_code_swapping;  /* Just in case there is an I/O error reading */
                   /* the slick.sta file, this will ensure user */
                   /* safe exit and save of files.  */
_str def_preplace,def_winpos_override="0 100 100 500 500";

_command find_buffer() name_info(BUFFER_ARG','VSARG2_READ_ONLY|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   old_buffer_name=p_buf_name
   if ( arg(1)=='' ) {
     _prev_view;buf_name=p_buf_name;_next_view
   }
   buffer_name=prompt(arg(1),'',make_buf_match(buf_name))
   parse buffer_name with name'<'path'>'
   if ( path!='' ) {
      buffer_name=path:+name
   }
   try=absolute(strip(buffer_name))
   if ( try=='' ) {
      return(1);
   }
   status=edit('+b 'try)
   if ( status ) {
     clear_message
     status=edit('+b 'buffer_name)
   }
   return(status)

}
static _str edit_count;
static _str gfirst_info;
_command e,edit(...) name_info(FILE_ARG'*,'VSARG2_CMDLINE|VSARG2_REQUIRES_MDI)
{
   /* if arg(4) is 1, We are doing a find-proc, or find-tag, so do not restore
      position*/
   a2_flags=arg(2);
   if (!isinteger(a2_flags)) a2_flags=0;
   key_or_cmdline=_executed_from_key_or_cmdline(name_name(last_index('','C')));
   key_or_cmdline=key_or_cmdline || (isnumber(arg(2)) && (arg(2) & 1));
   a2_flags|=key_or_cmdline;
   edit_count=0;
   int NextWindow_wid=_mdi.p_child;
   p_window_id=_mdi._edit_window()
   old_buffer_name=(p_DocumentName!="")?p_DocumentName:p_buf_name;
   if (_executed_from_key_or_cmdline(name_name(last_index('','C')))) {
      restorepos_flag=EDIT_RESTOREPOS;
   } else if (isinteger(arg(2))){
      restorepos_flag=arg(2)&EDIT_RESTOREPOS;
   } else {
      restorepos_flag=0;
   }
   n='e'
   if ( def_prompt ) {
      n='edit'
   }
   last_index(find_index(n,COMMAND_TYPE),'C')

   filename=prompt(arg(1));

   mou_hour_glass(1);
   status=edit2(filename,a2_flags|restorepos_flag,arg(3))
   mou_hour_glass(0);
   switch_buffer(old_buffer_name)
   if (!_no_child_windows() && !(a2_flags&EDIT_NOSETFOCUS)) {
      final_wid=p_window_id;
      if (final_wid!=HIDDEN_WINDOW_ID  &&
          NextWindow_wid!=HIDDEN_WINDOW_ID &&
           (_iswindow_valid(NextWindow_wid) && NextWindow_wid.p_mdi_child) &&
          final_wid!=NextWindow_wid) {
         if (_default_option(VSOPTION_NEXTWINDOWSTYLE)==1) {
            final_wid._MDIReorder(NextWindow_wid);
         } else if (_default_option(VSOPTION_NEXTWINDOWSTYLE)==0) {
            NextWindow_wid._MDIReorder(final_wid);
         }
      }

      _set_focus();
   }
   if (_isEditorCtl()) {
      _exit_scroll();
   }
   return(status)
}

/*
  Function Name:set_first_window

  Parameters:
      filename- the name of the file about to be opened (needed so we know if
                    it has a window)
      auto_create_firstw_arg
                  - just arg(3) from edit2().  If this
                    value:!="0" and no mdi children exist,
                    a window is created.  Pass "" for
                    this argument.  Auto restore is the
                    only macro which passes 0 for this
                    argument.  It is likely that this option
                    will not be supported in future
                    versions of VSE.

  Description:
      checks if the filename has a window already and sets the first_window
      variable to whatever size the window should be.  If def_winpos_override
      is on, it is set to it's values, otherwise '' is used (so system
      will decide where window goes)

  Returns:
      the proper value for the first_window variable in edit(2)

*/
static _str set_first_window(filename,auto_create_firstw_arg)
{
   /* only necessary for an older version, but if you get one of these,
      something is wrong anyway, so might as well return ''
   */
   if (filename=='' || iswildcard(filename)) {
      return('');
   }

   if (filename=='+t') { //need to alter window for temp buffers
      filename='';
   }
   filename=maybe_quote_filename(filename);
   first_window='';
   //format 0|1 xpos ypos winwidth winheight
   parse def_winpos_override with on xpos ypos winwidth winheight
   if (on) {  //override is on
      if (def_one_file!='' && auto_create_firstw_arg) {
         if (_no_child_windows()) {
            if (!_default_option('f')) {  //maximize first window
               first_window='+i:'xpos' 'ypos' 'winwidth' 'winheight' N '     //startx starty width height state
            } else {
               first_window='+i:'xpos' 'ypos' 'winwidth' 'winheight' M '
            }
         } else {
            //BUG if there's already a window existing, don't want to use the +i
            if (filename=="" ||
                !window_match(absolute(filename),1,'xan')) {
               first_window='+i:'xpos' 'ypos' 'winwidth' 'winheight' ':+p_window_state
            }
         }
      } else {
         if ( _no_child_windows() && auto_create_firstw_arg) {
            first_window='+i '
         }
      }
   } else {
      if ( _no_child_windows() && auto_create_firstw_arg) {
        first_window='+i '
     }
   }
   return(first_window);

}
static _str edit2()
{
  filename=arg(1);

  a2_flags=arg(2);

  options=''
  new_file_status=0;first_info=''
  first_window=''

  ExplicitWindowSizeGiven=false;
  line=def_one_file' 'filename;
  command='';
  for (;;) {
    if ( line=='' ) {
      break
    }

//    line=strip(line,'L')
//    if substr(line,1,1)='-' then
//       line=substr(line,3)
//
//    endif
    word=parse_file(line)
//   if isinteger(word) then   /* Could have a number be a line number. */
//      word='-#'word
//   endif
    word_nq=strip(word,'B','"');

    if ( substr(word_nq,1,1)=='+' || substr(word_nq,1,1)=='-' ) {
       letter=upcase(substr(word_nq,2,1))
       if ( letter=='T' || letter=='V' || letter=='B' ) {
          if ( letter=='B' ) {
             param=line;
             line='';
             parse buf_match(param,1,'vhx') with . . old_buf_flags .;
          } else {
             param=parse_file(line)
          }
          old_buf_id=p_buf_id;
          block_was_read(0);

          first_window="";
          if (!ExplicitWindowSizeGiven) {
             //the +t tells first window to go ahead and resize the new window
             first_window=set_first_window('+t',arg(3));
          }

          //status=window_edit(def_load_options " "first_window" "options" "word_nq " "param,a2_flags)
          status=window_edit(def_load_options " "options" "first_window" "word_nq " "param,a2_flags);
          first_window='';
          status=edit_status(status,new_file_status,first_info,a2_flags,'')
          if ( status ) {
             return(status)
          }
          if (letter=='T'){
             if (p_buf_id!=old_buf_id) {
                p_buf_flags=PROMPT_REPLACE_BFLAG;
             }
             select_edit_mode();
             call_list('_buffer_add_',p_buf_id,p_buf_name,p_buf_flags);
          } else if (letter=='B') {
             if (isinteger(old_buf_flags) && (old_buf_flags& HIDE_BUFFER)) {
                call_list('_buffer_add_',p_buf_id,p_buf_name,p_buf_flags);
             }
          }
          if (command!='') {
             execute(command,'');
          }
       } else if ( letter=='*' ) {
          /* Execute the command on all files that file. */
          command=substr(word_nq,3)
       } else if ( letter=='#' ) {
          execute(substr(word_nq,3),'')   /* Execute the command now. */
       } else if (letter=='I'){
          options=options " "word_nq
          if (substr(word_nq,3,1)==':') {
             /* Add the y,width,height,state options. */
             parse line with y width height state line
             options=options' 'y' 'width' 'height' 'state;
             ExplicitWindowSizeGiven=true;
          }
       } else {
         options=options " "word_nq
       }
       continue
    }
    if ( substr(word_nq,1,1)=='@' ) {   /* List of files? *///ch1
       old_gfirst_info=gfirst_info;
       gfirst_info='';
       status=for_list(word_nq,'e 'options' %l',0)//ch2
       if ( status ) {
          return(status)
       }
       if ( new_file_status ) {
          message get_message(new_file_status)
       }
       first_info=gfirst_info;
       gfirst_info=old_gfirst_info;
    } else {
       list_view_id='';
       if ( iswildcard(word) ) {
         orig_view_id=_create_temp_view(list_view_id);
         if (orig_view_id=='') return(NOT_ENOUGH_MEMORY_RC);
         status=insert_file_list('-v +p 'word);
         if (!status) {
            top();
            name=_lbget_text();
         }
         activate_view(orig_view_id);
         if ( status ) {
            _delete_temp_view(list_view_id);
            message get_message(status)
            return(status)
         }
       } else {
         name=word
       }
       for (;;) {
          if ( name=='' ) break;    /* This should not happen */
          //block_was_read(0);
#if 0
          info=_get_file_info(maybe_quote_filename(name));
          //messageNwait('info='info);
          if (def_one_file!='') {
             parse info with x y width height state .
             if (info!=''&&p_window_state!='M' && state!='M') {
                options=options' +i:'x' 'y' 'width' 'height' 'state
             } else {
                info='';
             }
          }
#else
          info='';
#endif
          block_was_read(0);
          // Code for preloading when filesize
          //parse def_max_loadall with on size;
          //if (pos('\+l(??|?|)', def_load_options, 1, 'RI') && !pos('(\+|-)l', options, 1, 'IR')) {

          /*TempNoLoad="";
          if (on && isinteger(size) && size > 0 &&
              _filesize(name) > size * 1024) {
             TempNoLoad='-L ';
          } */
          //messageNwait(build_load_options(name) " "first_window" "options);

          first_window="";
          if (!ExplicitWindowSizeGiven) {
             //the +t tells first window to go ahead and resize the new window
             first_window=set_first_window('+t',arg(3));
          }

          //status=window_edit(build_load_options(name) " "first_window" "options" "maybe_quote_filename(name),a2_flags)
          status=window_edit(build_load_options(name) " "/*TempNoLoad:+*/options" "first_window" "maybe_quote_filename(name),a2_flags)
          //Put switchbuf here
          first_window='';
          edit_status(status,new_file_status,first_info, a2_flags, info)
          if (!status && edit_count<def_max_filehist && !(a2_flags &EDIT_NOADDHIST)) {
             ++edit_count;
             _menu_add_filehist(absolute(name));
          }
          block_was_read(1);call read_ahead()
          if ( status && status!=NEW_FILE_RC ) {
             if (list_view_id!='') _delete_temp_view(list_view_id);
             return(status)
          }
          if (command!='') {
             execute(command,'');
          }
          if ( ! iswildcard(word) ) {
             break
          }
          get_view_id(orig_view_id);
          activate_view(list_view_id);
          if (down()) {
             activate_view(orig_view_id);
             break;
          }
          name=_lbget_text();
          activate_view(orig_view_id);
       }
       if (list_view_id!='') _delete_temp_view(list_view_id);
    }
  }
  if ( first_info!='' && def_start_on_first ) {
     if (gfirst_info=='') {
        gfirst_info=first_info;
     }
     _suspend
     if ( ! rc ) {
        parse first_info with first_buf_id first_wid
        p_window_id=first_wid;
        load_files '+bi 'first_buf_id  /* Could cause run-time error. */
                                       /* If user quit file with -#quit */
        rc=1;_resume
     }
     if ( rc!=1 ) {
        clear_message
        if ( new_file_status ) {
           message get_message(new_file_status)
        }
     }
  }
  return(new_file_status)

}
static _str edit_status(status,var new_file_status,var first_info, a2_flags, window_info)
{
   if ( first_info=='' ) {
      first_info=p_buf_id' 'p_window_id
   }
   if ( status ) {
      if ( status!=NEW_FILE_RC ) { return(status) }
      new_file_status=NEW_FILE_RC
   }
   if (!(a2_flags & EDIT_NOUNICONIZE) && p_window_state=='I') p_window_state='N';
   // IF in read only mode AND we just loaded this file
   if ( p_readonly_mode && block_was_read()>1 ) {
      read_only_status=block_was_read()
      command='read-only-mode'
      if ( read_only_status==3 ) {
         message nls('Warning:  You have read only access to this file')
      } else {
         message nls('Warning:  Another process has read access')
      }
      select_edit_mode();
      call_list('_buffer_add_',p_buf_id,p_buf_name,p_buf_flags);
      if (a2_flags & EDIT_RESTOREPOS) {
         _restore_filepos(p_buf_name);
         parse window_info with  x y width height state icon_x icon_y
         if (window_info!='' && def_one_file!='') {
            if (state=='I') {
               p_window_state='N'
            }else{
               p_window_state=state
            }
            _move_window(x,y,width,height,'N'/*,icon_x,icon_y*/)
         }
      }
      if ( index_callable(find_index(command,COMMAND_TYPE)) ) {
         execute(command,"");
      }
   } else if ( _modename_eq(p_mode_name,'Fundamental')) {
      // IF we just loaded this file OR a new file was created
      if (block_was_read() || status==NEW_FILE_RC) {
          select_edit_mode();
          call_list('_buffer_add_',p_buf_id,p_buf_name,p_buf_flags);
          if (!status && (a2_flags & EDIT_RESTOREPOS)) {
             _restore_filepos(p_buf_name);
             parse window_info with x y width height state icon_x icon_y;
             if (window_info!='' && def_one_file!='') {
                if (state=='I') {
                   p_window_state='N'
                }else{
                   p_window_state=state
                }
                _move_window(x,y,width,height,'N'/*,icon_x,icon_y*/)
             }
          }
      }
   }
   return(0)
}
_command save_as() name_info(','VSARG2_READ_ONLY|VSARG2_NOEXIT_SCROLL|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   _macro_delete_line()
   status=0;
   line=arg(1)
   sv_flags=arg(2);
   if (line=='') {
      status=get_string(line,nls('Save as:')' ','-.save-as',p_buf_name)
      if ( status || line=='' ) {
         return COMMAND_CANCELLED_RC
      }
   }
   _macro_call('save_as',line);
   preserve_old_name=0;
   read_only='';
   save_options='';
   for (temp=line;;) {
      parse temp with option temp
      option=upcase(option);
      if(option=='-N') {
         parse line with . line
         preserve_old_name=1;
      } else if (option=='-R') {
         parse line with . line
         read_only='-R ';
      } else {
         ch=substr(option,1,1);
         if (ch=='-' || ch=='+') {
            parse line with . line
            save_options=save_options:+option' ';
         } else {
            break;
         }
      }
   }
   if (preserve_old_name || _process_info('b') || file_eq(p_buf_name,absolute(line))) {
      // Preserve old name
      status=save(read_only:+save_options:+line,sv_flags);
   } else {
      if (buf_match(absolute(line),1,'X')!='') {
         _message_box(nls("You already have a buffer with name '%s'.",line))
         return(1);
      }
#if 1
      /* 
         This code path allows changing file formats to
         update the EOL characters.
      */   
      filename=line;
      old_buf_name=p_buf_name;
      //old_modify=p_modify;
      //old_buf_flags=p_buf_flags;
      name_file(filename);select_edit_mode();
      status=save(read_only:+save_options,sv_flags);
      if ( status ) {
         //call_list('_buffer_renamed_',p_buf_id,p_buf_name,old_buf_name,old_buf_flags);
         name_file(old_buf_name);select_edit_mode();
         //p_buf_name=old_buf_name;
         //p_modify=old_modify;
         //p_buf_flags=old_buf_flags;
      }
#else
      filename=line;
      status=save(read_only:+save_options' 'filename,sv_flags);
      if (!status && !file_eq(p_buf_name,absolute(strip(filename,'','"')))) {
         name(line);
         p_buf_flags&= ~PROMPT_REPLACE_BFLAG
         p_modify=0;
         if (read_only=='') {
            p_readonly_mode=0;
            p_readonly_set_by_user=false;
         }
      }

#endif
   }
   if (!status) {
      _menu_add_filehist(p_buf_name);
   }
   //cursor_data();
   return(status)
}
_str  _executed_from_key_or_cmdline(cmdname)
{
   executed_from_key=name_name(last_index()):==translate(cmdname,'-','_')
   executed_from_cmdline=last_index('','w')
   return(executed_from_key || executed_from_cmdline)
}
_command save() name_info(','VSARG2_ICON|VSARG2_NOEXIT_SCROLL|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   if (p_view_id>=0) {
      p_window_id=_mdi.p_child;
   }
   if (!p_mdi_child && !p_AllowSave) {
      _beep();
      return(1);
   }
   flags=arg(2);
   if (!isinteger(flags)) flags=SV_RETRYSAVE;
   preplace=!(flags&SV_OVERWRITE) && def_preplace;
   filename=strip_options(arg(1),options);
   if ( filename=='') {
     filename=p_buf_name;
     if ( filename=='' || !_HaveValidOuputFileName(filename) ||
          (p_readonly_mode && !_isdiffed(p_buf_id)
            && file_eq(absolute(filename),p_buf_name))
          ) {
        // IF called when application loses focus (save files on lost focus)
        if (flags & SV_POSTMSGBOX) {
           // Don't need to save these files
           return(0);
        }
        // IF no dialogs allowed
        if ((flags & SV_RETURNSTATUS) ) {
           if (filename=='' || !_HaveValidOuputFileName(filename)) {
              return(ERROR_WRITING_FILE_RC);
           }
        } else {
           // When save_all is called in one file per window mode need to set
           // the focus
           _set_focus();
           if (p_readonly_mode && filename!="") {
              _message_box(nls("File %s is read only",filename),filename);
           }
           return(gui_save_as())
        }
     }
   }
   if ( machine() != "OS2386" && index_callable(find_index("delphiIsRunning",PROC_TYPE)) ) {
      if ( delphiIsRunning() && delphiIsBufInDelphi(p_buf_name) ) {
         //sticky_message( "delphi file="p_buf_name );
         delphiSaveBuffer( p_buf_name );
         return( 0 );
      }
   }
   afilename=absolute(filename)
   /* IF name of buffer has been changed or new file  OR  saving to  */
   /* different file AND destination file already exists AND prompt on replace */
   /* and called from a key/command line/or option given. */
   if ( preplace && (p_buf_flags&PROMPT_REPLACE_BFLAG || !file_eq(strip(afilename,'','"'),p_buf_name)) &&
         file_match('-p 'maybe_quote_filename(filename),1)!=''
      ) {
      status=overwrite_existing(filename,'Save',flags)
      if ( status ) {
         return(status)
      }
   }
   /*
      IF user wants prompting on save AND
         buffer was not renamed AND
         save name matches buffer name AND
         This is not a new file AND
         file exists on disk AND
         file is newer than buffer
   */
   if (preplace &&
       !(p_buf_flags&PROMPT_REPLACE_BFLAG) &&
       file_eq(strip(afilename,'','"'),p_buf_name) &&
       p_file_date!="" &&
       file_match('-p 'maybe_quote_filename(filename),1)!='' &&
       p_file_date<_file_date(filename,'B')) {
      status=overwrite_newer(filename,'Save',flags);
      if ( status ) {
         return(status)
      }
   }
   update_format_line('1')
   message nls('Saving %s',filename)
   if (!_HaveValidOuputFileName(afilename)) {
     message(nls('Invalid filename'));
     return(1)
   }
   if ( _process_info('B') && ! file_eq(afilename,p_buf_name)) {
     message(nls('Use the (File, Save As) menu item to save a process buffer'));
     return(1)
   }
   filename=maybe_quote_filename(filename)
   nobackup="";
   if ((flags & SV_POSTMSGBOX)) flags&=~SV_RETRYSAVE
   for (;;) {
      tempoptions=options:+nobackup;
      save_read_only=0;
#if __UNIX__
      /* On UNIX, allow user to specify -r or +r to save as read only. */
      parse tempoptions with tempoptions '(-|\+)r','ir' +0 options2
      ch=lowcase(substr(options2,1,2))
      if ( ch=='-r' || ch=='+r' ) {
         tempoptions=tempoptions:+substr(options2,3)
         save_read_only=1
         /* Owner does not have write access. */
         status=_chmod('u+w 'filename)
         //status=_chmod('u+w 'p_buf_name);
         if ( status && status!=FILE_NOT_FOUND_RC) {
            if (flags & SV_RETURNSTATUS) {
               return(status);
            }
            _sv_message_box(flags,nls("Failed to change file permissions.  Check that you have access to the owner or group of this file."))
            return(status);
         }
      }
#endif
      mou_hour_glass(1);
      status= save_file(filename,build_save_options(filename) " "tempoptions)
      mou_hour_glass(0);
#if __UNIX__
      if ( save_read_only ) {
         status2=_chmod('u-w 'filename);
         if ( ! status && status2 ) {
            status=status2;
            message(get_message(status));
         }
      }
#endif
      clear_message
      if (flags & SV_RETURNSTATUS) {
         return(status);
      }
      if ( status==0 ) {
         if ( file_eq(afilename,p_buf_name) ) {
            p_buf_flags=p_buf_flags&~PROMPT_REPLACE_BFLAG
         }
      }
      nobackup="";
      retry=_save_status(status,p_buf_name,filename,flags);
      if (!retry) break;
      if (retry&1) { //Save file as read only. UNIX only
         nobackup=" +r";
      }
      if (retry & 2) {
         nobackup=nobackup:+" +o";
      }
      // local backup directory might have been changed.
   }
   return(status)
}
int _save_status(status,buf_name)
{
   sv_flags=arg(4);
   filename=arg(3);  //Alternate filename
   if (!isinteger(sv_flags)) sv_flags=0;
   post_msgbox=(sv_flags & SV_POSTMSGBOX);
   retrysave=(sv_flags & SV_RETRYSAVE);
   if (!status || status==COMMAND_CANCELLED_RC) {
      return(0);
   }
   // save_all command is called when VS does not have focus.  Under windows 3.x
   // this command can not set the focus.  Here we set the focus if there
   // is an error during the save_all command
   if (!post_msgbox) {
      _set_focus();
   }
   if (filename=="") {
      filename=buf_name;
      msg=nls("Unable to save %s to %s\n",buf_name,filename);
   } else {
      msg=nls("Unable to save %s\n",buf_name);
   }
   if (status==ACCESS_DENIED_RC) {
#if __UNIX__
      if (retrysave) {
         attrs=file_list_field(filename,DIR_ATTR_COL,DIR_ATTR_WIDTH);
         if (attrs=='') return(0);
         // IF there are no write permissions on this file.
         if (!pos("w","")) {
            flags=1;  // Save as read only
            status=show("-modal _retrysave_form",msg:+ get_message(status),flags);
            if (!isinteger(status)) return(0);
            return(status);
         }
      }
#endif
      backup_msg="Backup directory could not be created.\n";
      if (pos(' +d ',def_save_options,1,'i')) {
         dir=get_env('VSLICKBACKUP');
         if (dir=='') {
#if __UNIX__
            dir=get_env('HOME');
            if (last_char(dir)!=FILESEP) dir=dir:+FILESEP;
            dir=dir:+'.vslick/backup';
#else
            dir='/vslick/backup';
#endif
         }
         if (last_char(dir)==FILESEP) {
            dir=substr(dir,1,length(dir)-1);
         }
         backup_msg='';
         if (file_match('-p 'dir,1)=='') {
            backup_msg="Backup directory '"dir"' could not be created.\n"
         }
      }
      msg2="\n\n":+
      "Possible causes:\n\n":+
      backup_msg:+
#if __UNIX__
      "Permissions on this file are read only.\n":+
      "Another program has a lock on this file.\n":+
#else
      "Another program has this file open.\n":+
#endif
      "\nSee help on \"Backup options\"."
      _sv_message_box(sv_flags,msg:+ get_message(status):+msg2);
      return(0);
   }
   if (retrysave) {
      if(status==FAILED_TO_BACKUP_FILE_RC) {
         flags=2;
         // UNIX always uses a local backup directory "$HOME/.vslick"
#if !__UNIX__
         if (pos(' [\+|\-]d '," "def_save_options" ",1,'RI')) {
            flags=2|4;
         }
#endif
         status=show("-modal _retrysave_form",msg:+ get_message(status),flags);
         if (!isinteger(status)) return(0);
         return(status);
      }
      if(status==FAILED_TO_BACKUP_FILE_ACCESS_DENIED_RC) {
         status=show("-modal _retrysave_form",msg:+ get_message(status),2);
         if (!isinteger(status)) return(0);
         return(status);
      }
   }
   _sv_message_box(sv_flags,msg:+ get_message(status));
   return(0);
}

_str overwrite_existing(filename,title)
{
   sv_flags=arg(3);
   post_msgbox=isinteger(sv_flags) && (sv_flags & SV_POSTMSGBOX);
   orig_wid=p_window_id;_set_focus();
   if (post_msgbox) {
      _beep();_beep();
      message(nls("File '%s' already exists.  Can't replace during application switch focus",filename));
      return(COMMAND_CANCELLED_RC);
   }
   status=_message_box(nls("File '%s' already exists.",filename)"\n\n":+
             nls("Replace existing file?"),
             title,
             MB_YESNOCANCEL|MB_DEFBUTTON2|MB_ICONQUESTION
             )
   p_window_id=orig_wid;
   if (status!=IDYES) {
      return(COMMAND_CANCELLED_RC);
   }
   return(0)
}
static int overwrite_newer(filename,title)
{
   sv_flags=arg(3);
   post_msgbox=isinteger(sv_flags) && (sv_flags & SV_POSTMSGBOX);
   orig_wid=p_window_id;_set_focus();
   if (post_msgbox) {
      _beep();_beep();
      message(nls("File '%s' is a new version.  Can't replace during application switch focus",filename));
      return(COMMAND_CANCELLED_RC);
   }
   status=_message_box(nls("File '%s' is a new version.",filename)"\n\n":+
             nls("Replace existing newer file?"),
             title,
             MB_YESNOCANCEL|MB_DEFBUTTON2|MB_ICONQUESTION
             )
   p_window_id=orig_wid;
   if (status!=IDYES) {
      return(COMMAND_CANCELLED_RC);
   }
   return(0)
}
/*
   Under windows it is not safe to display a sychronous dialog box of any kind
   during the WM_ACTIVATEAPP lost focus message.  Windows NT and Chicago have
   not problem with this.
*/
void _sv_message_box(sv_flags,msg)
{
   post_msgbox=isinteger(sv_flags) && (sv_flags & SV_POSTMSGBOX);
   Nofargs=arg();
   if (post_msgbox) {
      _beep();_beep();
      _post_call(find_index('popup_message',COMMAND_TYPE),msg)
      return;
   }
   _message_box(msg);
}

/*
   ctlbackupdir.p_user    Original value of VSLICKBACKUP environment variable.

*/
defeventtab _retrysave_form
void ctlok.on_create()
{
   msg=arg(1);
   flags=arg(2);
   if (!isinteger(flags)) flags=1|2|4;
#if __UNIX__
   flags&=~4;
#endif
   if (msg!="") {
      ctllabel1.p_caption=msg;
   }
   if (!(flags&1)) {
#if __UNIX__
      ctlreadonly.p_enabled=0;
#else
      ctlreadonly.p_visible=0;
#endif
   }
   if (!(flags&2)) {
      ctlnobackup.p_enabled=0;
   }
   if (!(flags&4)) {
#if __UNIX__
      ctlconfigbackupdir.p_visible=ctlbackupdir.p_visible=ctlbackupdirlab.p_visible=0;
#else
      ctlconfigbackupdir.p_enabled=ctlbackupdir.p_enabled=ctlbackupdirlab.p_enabled=0;
#endif
   } else {
      backupdir=get_env("VSLICKBACKUP");
      ctlbackupdir.p_user=backupdir;
      if (backupdir=="") {
         backupdir="c:\\vslick\\backup";
      }
      ctlbackupdir.p_text=backupdir;
   }
   ctlreadonly.call_event(ctlreadonly,lbutton_up);
}
void ctlreadonly.lbutton_up()
{
   if (ctlreadonly.p_value ||
       ctlnobackup.p_value ||
      (ctlconfigbackupdir.p_value && ctlbackupdir.p_text!=ctlbackupdir.p_user)) {
      ctlok.p_enabled=1;
   } else {
      ctlok.p_enabled=0;
   }
   ctlbackupdir.p_enabled=ctlbackupdirlab.p_enabled=ctlconfigbackupdir.p_value!=0;
}
void ctlok.lbutton_up()
{
   flags=0;
   if (ctlreadonly.p_value) {
      flags|=1;
   }
   if (ctlnobackup.p_value) {
      flags|=2;
   }
   if (ctlconfigbackupdir.p_value) {
      flags|=4;
      new_value=ctlbackupdir.p_text;
      status=_ConfigEnvVar("VSLICKBACKUP",new_value)
      if (status) {
         return;
      }
   }
   p_active_form._delete_window(flags);
}
int _ini_config_value(_str filenopath,_str section, _str name, _str value)
{
#if __UNIX__
   filename=_config_path():+filenopath;
#else
   get_env(_SLICKCONFIG);
   if (rc) {
      filename=editor_name("P"):+filenopath;
   } else {
      filename=_config_path():+filenopath;
   }
#endif
   global_filename=slick_path_search(filenopath);
   if (global_filename!="" && file_match("-p "maybe_quote_filename(filename),1)=="" &&
       !file_eq(global_filename,filename)) {
       // Make copy of global configuration file.
       copy_file(global_filename,filename);
   }
   status=_ini_set_value(filename,section,name,value);
   if (status) {
      _message_box(nls("Unable to update file %s.",filename)"  "get_message(status));
      return(status);
   }
   return(0);
}
int _ConfigEnvVar(_str envvar_name,new_value)
{
   status=_ini_config_value(_INI_FILE,"Environment",envvar_name,new_value);
   if (status) return(status);
   if (new_value._isempty()) {
      set_env(envvar_name);
   } else {
      set_env(envvar_name,new_value);
   }
   return(status);
}

_command int name(_str newName="",boolean doAbsolute=true) name_info(','VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL)
{
  arg1=prompt(arg(1),'',p_buf_name)
  status= name_file(strip(arg1,'B','"'),doAbsolute);
  p_modify=1;
  p_buf_flags=p_buf_flags|PROMPT_REPLACE_BFLAG;

  select_edit_mode();
  return(status)

}
_command void docname() name_info(','VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL)
{
   newDocumentName=arg(1);
   if (p_DocumentName:==newDocumentName) {
      return;
   }
   call_list('_document_renamed_',p_buf_id,p_DocumentName,newDocumentName,p_buf_flags);
   p_DocumentName=newDocumentName;
}
_command file() name_info(','VSARG2_REQUIRES_MDI_EDITORCTL|VSARG2_READ_ONLY|VSARG2_ICON)
{
   _in_quit=true;
   status=save(arg(1),arg(2))
   if ( status==0 ) {
     status=quit()
   }
   _in_quit=false;
   return(status)
}
_command close_buffer(...) name_info(','VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   noquit_hidden=arg(2);
   key_or_cmdline=_executed_from_key_or_cmdline(name_name(last_index('','C')))
   old_buffer_name=(p_DocumentName!="")?p_DocumentName:p_buf_name;
   buf_id=p_buf_id;
   status=_window_quit('',(key_or_cmdline)?key_or_cmdline:arg(1),noquit_hidden)
   if (buf_id!=p_buf_id) {
      switch_buffer(old_buffer_name, 'Q');
   }
   return(status)
}
_command q,quit() name_info(','VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   _in_quit=true;

   noquit_hidden=arg(2);
   if (noquit_hidden && !p_mdi_child) {
      if (_process_info('b')) {
         exit_process();
      }
      _in_quit=false;
      return(0);
   }
   //bufid=p_buf_id;
   //Dan added because extra support was needed for prroject toolbar stuff
   buf_name=p_buf_name;
   do_restore_filepos=_executed_from_key_or_cmdline(name_name(last_index('','C'))) || arg(1)!='';
   if (def_one_file!='') {
      status=close_window('',do_restore_filepos,noquit_hidden);
   } else {
      status=close_buffer(do_restore_filepos,noquit_hidden);
   }
#if 0
   if (bufid!=p_buf_id) {
      switch_buffer('', 'Q');
      //Dan added extra support for project toolbar
      //switch_buffer(buf_name, 'Q');
      //switch_buffer(p_buf_name, '');
   }
#endif
   _in_quit=false;
   return(status);
}
_command dde()
{
   params=arg(1)
   multi=0;
   activate_mdi=0;
   do_refresh=0;
   cur_dir='';
   mdi_restore=1;
   for (;;) {
      params=strip(params,'L');
      if (substr(params,1,1)!='-') break;
      parse params with option params
      option=lowcase(option)
      switch (option) {
      case '-multi':
         multi=1;
         break;
      case '-mdi':
         activate_mdi=1;
         break;
      case '-r':
      case '-refresh':
         do_refresh=1;
         break;
      case '-cd':
         cur_dir=parse_file(params);
         break;
      }
   }
   if (activate_mdi){
      // If there is a modal dialog box up
      if (!_mdi.p_enabled) return(1);
      p_window_id=_mdi.p_child;
      if (mdi_restore && _mdi.p_window_state=='I') {
         _mdi.p_window_state='R';
         //_mdi.p_window_state='N';
      }
   }
   if (cur_dir!='') {
      orig_dir=getcwd();
      cur_dir=strip(cur_dir,'B','"');
      chdir(cur_dir,1);
   }
   //status=0;
   //messageNwait('params='params);
   if (!multi) {
      parse params with cmd qfilename;
      cmd=params;
      qfilename=parse_file(cmd);
      boolean done=false;
      if ((qfilename=='e' || qfilename=='edit')) {
         qfilename=parse_file(cmd);
         if (qfilename=="-#") {
            qfilename=parse_file(cmd);
            if (lowcase(qfilename)=="+fn" || lowcase(qfilename)=="-fn") {
               params="e -# "cmd;
            } else {
               filename=strip(qfilename,'B','"');
               if (file_eq(get_extension(filename),'vpj')) {
                  status=project_open(qfilename);
                  done=true;
               }
            }
         }
      }
      if (!done) {
         status=execute(params,"");
      }
   } else {
      status=0;
      for (;;) {
         parse params with command ';' params
         if (command=='') break;
         status=execute(command,"");
      }
   }
   if (cur_dir!='') {
      chdir(orig_dir,1);
   }
   if (do_refresh) {
      //messageNwait('b4 refresh buf_name='p_buf_name);
      refresh;
      //messageNwait('after refresh buf_name='p_buf_name);
   }
   return(status);

}
_command void dderefresh()
{
   refresh();
}
static _str in_actapp_files=0;
int def_actapp=1;
definit()
{
   in_actapp_files=0;
}

void call_list(prefix_name,...)
{
   get_view_id(orig_view_id);
   idx_list='';
   index=name_match(prefix_name,1,PROC_TYPE)
   for (;;) {
      if ( ! index ) { break }
      if ( index_callable(index) ) {
         if( (length(idx_list)+length(index))>MAX_LINE ) {
            break;
         }
         idx_list=idx_list:+' ':+index;
         //call_index(arg(2),arg(3),arg(4),arg(5),index)
      }
      index=name_match(prefix_name,0,PROC_TYPE)
   }
   while( idx_list!='' ) {
      parse idx_list with index idx_list;
      switch (arg()) {
      case 1:
         call_index(index);
         break;
      case 2:
         call_index(arg(2),index);
         break;
      case 3:
         call_index(arg(2),arg(3),index);
         break;
      case 4:
         call_index(arg(2),arg(3),arg(4),index);
         break;
      case 5:
         call_index(arg(2),arg(3),arg(4),arg(5),index);
         break;
      }
   }
   activate_view(orig_view_id);
}

_command void auto_reload() name_info(','VSARG2_CMDLINE)
{
   _on_activate_app(1);
}
void _on_activate_app()
{
   // IF application got focus
   if (arg(1)) {
      _tbSetRefreshBy(VSTBREFRESHBY_APPLICATION_GOT_FOCUS);
   }
   call_list('_actapp_',arg(1));
}
static void _start_undo_step()
{
   for (i=1;i<_last_window_id();++i) {
      if (_iswindow_valid(i) && i.p_view_id<0) {
         i._undo('s');
      }
   }
}
_str def_vcpp_save;
static int InRecursion=0;
void _actapp_files()
{
   if (!def_actapp) {
      return;
   }
   if (in_actapp_files) {
      return;
   }
   in_actapp_files=1;
   _str VCPPSaveFilesArg;VCPPSaveFilesArg='N';
   parse def_vcpp_save with VCPPSaveFilesArg Hunt .;
   if (!arg(1)) {
      // Must close open BSC file in case users build in VC++
      tag_close_bsc();
      if ( machine() != "OS2386" && index_callable(find_index("delphiIsRunning",PROC_TYPE)) ) {
         if ( delphiIsRunning() ) {
            //dprint( "VSE: Deactivated..." );
            //sticky_message( "VSE: Deactivated..." );
            delphi1AppDeactivate();
            delphiAppDeactivate();
         }
      }
      if (def_actapp&ACTAPP_SAVEALLONLOSTFOCUS) {
         _start_undo_step();
         _mdi.p_child.save_all(SV_POSTMSGBOX);
      }
      if (def_hidetoolbars) {
         _tbVisible(0);
      }
      if (upcase(substr(machine(),1,2))=='NT') {
         //This code is out here in case the user save the file in Visual SlickEdit
         //and it is not actually modified
         //VCPPSaveFiles(VCPPSaveFilesArg);
         if (Hunt=='Y') {
            HuntForVCPPMessageBox();
         }
      }
      in_actapp_files=0;
      return;
   }
   int dpRunning;
   dpRunning = 0;
   if ( machine() != "OS2386" && index_callable(find_index("delphiIsRunning",PROC_TYPE)) ) {
      if ( delphiIsRunning() ) {
         //dprint( "VSE: Activated..." );
         //sticky_message( "VSE: Activated..." );
         delphi1AppActivate();
         delphiAppActivate();
         dpRunning = 1;
      }
   }
   if (def_hidetoolbars) {
      _tbVisible(1);
   }
   if (!(def_actapp&ACTAPP_AUTORELOADON)) {
      in_actapp_files=0;
      return;
   }
   if (def_actapp&ACTAPP_AUTOREADONLY) {
      _mdi.p_child.for_each_buffer('maybe_set_readonly');
   }
   get_view_id(view_id);
   activate_view HIDDEN_VIEW_ID
   _safe_hidden_window();
   first_buf_id=p_buf_id;
   int ori_def_actapp;
   ori_def_actapp = def_actapp;
   if ( dpRunning ) def_actapp = def_actapp | ACTAPP_WARNONLYIFBUFFERMODIFIED;
   for (;;) {
      noption='N';
      if ((!(p_buf_flags & HIDE_BUFFER) || p_AllowSave) && p_file_date!='') {
         bfiledate=_file_date(p_buf_name,'B');
         if (bfiledate!='' && p_file_date:!=bfiledate) {
            options=''
            if (p_buf_width==1) {
               options='+LW'
            } else if (p_buf_width) {
               options='+'p_buf_width
            }
            doc_name=p_DocumentName;
            if (doc_name=="") {
               doc_name=p_buf_name;
            }
            buf_name=p_buf_name;buf_id=p_buf_id;
            modify=p_modify;
            save_pos(p,'L');
            oldp_line_numbers_len=p_line_numbers_len;
            activate_view(view_id);_set_focus();

            //disabled_wid_list=_enable_non_modal_forms(0,_mdi);
            result=IDYES;
            // IF no reload prompt
            if (def_actapp&ACTAPP_NORELOADPROMPT) {
            } else {
               // IF user wants to be warned only if buffer is modified
               if (( def_actapp & ACTAPP_WARNONLYIFBUFFERMODIFIED)) {
                  if (modify) {
                     result=_message_box(nls("Another application has modified the file\n\n '%s'\n\nwhich you have modified.  Do you want to reload it?\n\nThe command \"set-var def_sbwarn_reload_modify 0\" will avoid this message box.",doc_name),'',MB_YESNOCANCEL|MB_ICONQUESTION);
                  }
               } else {
                  result=_message_box(nls("Another application has modified '%s'.  Do you want to reload it?",doc_name),'',MB_YESNOCANCEL|MB_ICONQUESTION);
               }
            }
            //_enable_non_modal_forms(1,0,disabled_wid_list);
            activate_view(view_id);

            if (result==IDYES) {
               /* Make a view&buffer windows list which contains window and position info. */
               /* for all windows. */
               temp_view_id=_list_bwindow_pos(buf_id);
               activate_view(HIDDEN_VIEW_ID);
               // Use def_load_options for network,spill, and undo options. */
               status=load_files(def_load_options:+' +q +d +r +l ':+options' ':+maybe_quote_filename(buf_name));
               if (status) {
                  if (status==NEW_FILE_RC) {
                     status=FILE_NOT_FOUND_RC;
                     _delete_buffer();
                  }
                  activate_view(view_id);_set_focus();
                  _message_box(nls("Unable to reload %s",doc_name)"\n\n"get_message(status));
                  p_file_date=bfiledate;
               } else {
                  p_line_numbers_len=oldp_line_numbers_len;
                  restore_pos(p);
                  // Need to do an add buffer here so the debugging
                  // information is updated.
                  // load_files with +r options calls the delete buffer
                  // callback.  Here we readd this buffer.
                  call_list('_buffer_add_',p_buf_id,p_buf_name,p_buf_flags);
                  _set_bwindow_pos(temp_view_id)
                  noption='';
               }
               if (temp_view_id) {
                  _delete_temp_view(temp_view_id);
               }
            } else {
               activate_view(HIDDEN_VIEW_ID);
               p_file_date=bfiledate;
            }
            activate_view(HIDDEN_VIEW_ID);
         }
      }
      _next_buffer noption'RH'
      if (p_buf_id==first_buf_id) {
         break;
      }
   }
   if ( dpRunning ) def_actapp = ori_def_actapp;
   in_actapp_files=0;
   if (upcase(substr(machine(),1,2))=='NT') {
      //This calls the code to force VC++ to save the files
      if (VCPPSaveFilesArg!='N'){
         if ((_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_CONFIGURABLE_VCPP_SETUP)) {
            callable=index_callable(find_index('VCPPIsUp',PROC_TYPE));
            int isup=0;
            if (!InRecursion && callable) {
               isup=VCPPIsUp(def_vcpp_version);
            }
            if (isup) {
               InRecursion=1;
               index=find_index('VCPPSaveFiles',PROC_TYPE);
               if (index) {
                  _post_call(index,VCPPSaveFilesArg"\1"def_vcpp_version);
                  _post_call(_actapp_files);
               }
            }else{
               InRecursion=0;
            }
         }
      }
   }
   activate_view(view_id);
}
void _set_bwindow_pos(temp_view_id)
{
   if (temp_view_id=='') return;
   get_view_id view_id
   activate_view(temp_view_id);
   top();up();
   for (;;) {
      down();
      if (rc) return;
      get_line line
      parse line with wid p
      wid.restore_pos(p);
   }
   activate_view view_id
}
/*
   Caller should initialize p for predictable results.
*/
int _list_bwindow_pos(buf_id)
{
   orig_view_id=_create_temp_view(temp_view_id);
   if (orig_view_id=='') return(0);
   last=_last_window_id()
   for (i=1;i<=last;++i) {
      if (_iswindow_valid(i) && i.p_mdi_child && i.p_view_id<0  &&
           i.p_buf_id==buf_id && !(i.p_window_flags & HIDE_WINDOW_OVERLAP)
         ) {
         /* messageNwait('found one i='i); */
         /* Found a window which is displaying this buffer. */
         i.save_pos(p,'L');
         insert_line(i' 'p);
      }
   }
   activate_view(orig_view_id);
   return(temp_view_id);
}
void _save_all_filepos() {
   RestoreSelDisp=!(def_restore_flags &RF_NOSELDISP);
   RestoreLineModify=(def_restore_flags &RF_LINEMODIFY);
   if (!RestoreLineModify && !RestoreSelDisp) return;
   activate_view(HIDDEN_VIEW_ID);
   _safe_hidden_window();
   first_buf_id=p_buf_id;
   for (;;) {
      if(!p_modify && (RestoreSelDisp|| RestoreLineModify) && _need_to_save2()) {
         _add_filepos_info(p_buf_name);
      }
      _next_buffer('NHR');
      if (p_buf_id==first_buf_id) {
         break;
      }
   }
}
int _add_filepos_info(_str filename)
{
   if (strip_filename(filename,'p')=='filepos.slk') {
      return(0);
   }
   if (def_max_filepos<1) {
      return(0);
   }
   if (def_max_filepos>5000) {
      def_max_filepos=5000;
   }
   // Don't want to do file_match because could be looking on floppy which is slow
   // This means we can get garbage filenames
   if (filename=='' /*|| file_match('-p 'filename,1)==''*/) {
      return(1);
   }
   linenum='.'_QROffset();col=p_col;
   _get_window(win_x,win_y,win_width,win_height,'N',iconx,icony)
   win_state=p_window_state;
   hex_mode=p_hex_mode;file_date=p_file_date;

   RestoreSelDisp=!(def_restore_flags &RF_NOSELDISP);
   RestoreLineModify=(def_restore_flags &RF_LINEMODIFY);
   SaveLineflags=(p_NofSelDispBitmaps && RestoreSelDisp) ||RestoreLineModify;

   status=_activate_filepos_file(orig_view_id);
   if (status) {
      return(1);
   }
   top();
   // Check if this file needs to be converted
   if (!down()) {
      get_line(line);
      parse line with . . . . . . . . . . SelDispTempNum .;
      if (SelDispTempNum=="") {
         // Convert this file
         i=1;
         for (;;++i) {
            get_line(line);
            parse line with t1 t2 t3 t4 t5 t6 t7 t8 t9 t10;
            replace_line(t1' 't2' 't3' 't4' 't5' 't6' 't7' 't8' 't9' 't10' '(i));
            down();
            if (down()) break;
         }
      }
   }
   if (p_Noflines>def_max_filepos*2) {
      while (p_Noflines>def_max_filepos*2) {
         _lbclear();
      }
   } else {
      if (p_Noflines<def_max_filepos*2) {
         Noflines=p_Noflines/2;
         top();up();
         while (p_Noflines<def_max_filepos*2) {
             insert_line("");
             ++Noflines;
             insert_line(". . . . . . . . . . "Noflines);
         }
      }
   }
   top();
   status=search('^'_escape_re_chars(filename)'$','r@'_fpos_case);
   if (status) {
      top();
   }
   _delete_line();
   get_line(line);
   _delete_line();
   parse line with . . . . . . . . . . SelDispTempNum .;
   if (!isinteger(SelDispTempNum)) {
      SelDispTempNum=1;
   }
   if (SelDispTempNum<0) SelDispTempNum= -SelDispTempNum;
   bottom();
   insert_line(filename);
   if (SaveLineflags) {
      typeless view_id;
      get_view_id(view_id);
      path=_config_path():+"SelDisp":+FILESEP;
      //messageNwait("_add_filepos_info: filename="path:+SelDispTempNum);
      activate_view(orig_view_id);
      status=_SaveSelDisp(path:+SelDispTempNum,file_date);
      //messageNwait("status="status" !isdirectory(path)="(!isdirectory(path))" path="path);
      if (status && !isdirectory(path)) {
         //messageNwait("path="path);
         status=make_path(path);
         if (!status) {
            status=_SaveSelDisp(path:+SelDispTempNum,file_date);
         }
      }
      activate_view(view_id);
      //messageNwait('status='status);
      // IF we did not write the selective display code
      if (status) {
         SelDispTempNum=-SelDispTempNum;
      }
   } else {
      SelDispTempNum=-SelDispTempNum;
   }
   infoline=linenum' 'col' 'win_x' 'win_y' 'win_width' 'win_height' 'win_state' 'iconx' 'icony' 'hex_mode' 'SelDispTempNum;
   insert_line(infoline);
   if (status) {
      parse line with . . . . . . . . . . SelDispTempNum .;
   }
   p_view_id=orig_view_id;
   return(0);
}

int _restore_filepos(filename)
{
   RestoreSelDispOnly=arg(2)!="";
   if (strip_filename(filename,'p')=='filepos.slk') {
      return(0);
   }
   if (def_max_filepos<1) {
      return(0);
   }
   save_pos(p);
   status=_activate_filepos_file(orig_view_id);
   if (status) {
      return(status);
   }
   top();
   status=search('^'_escape_re_chars(filename)'$','@r'_fpos_case);
   if (status) {
      p_view_id=orig_view_id;
      return(status);
   }
   down();
   get_line(line);
   parse line with seekpos col win_x win_y win_height win_width win_state . . hex_mode SelDispTempNum .;
   p_view_id=orig_view_id;
   //messageNwait("_restore_filepos: SelDispTempNum="SelDispTempNum);
   if (isinteger(SelDispTempNum) && SelDispTempNum>0) {
      RestoreSelDisp=!(def_restore_flags &RF_NOSELDISP);
      RestoreLineModify=(def_restore_flags &RF_LINEMODIFY);
      RestoreLineflags=RestoreSelDisp ||RestoreLineModify;
      if(RestoreLineflags) {
         path=_config_path():+"SelDisp":+FILESEP;
         status=_RestoreSelDisp(path:+SelDispTempNum,p_file_date,RestoreSelDisp,RestoreLineModify);
         //messageNwait("restore status=":+status);
         if (RestoreSelDispOnly) restore_pos(p);
      }
   }
   if (!RestoreSelDispOnly) {
      scroll_style=_scroll_style();
      _scroll_style('C 0');
      _GoToROffset(substr(seekpos,2));
      _scroll_style(scroll_style);
      p_col=col;
      if (isinteger(hex_mode) && hex_mode && !p_hex_mode) {
         hex();
      }
   }
   return(0);
}
static _str _get_file_info(filename)
{
   status=_activate_filepos_file(orig_view_id);
   if (status) {
      return('');
   }
   top();
   ss='^'_escape_re_chars(absolute(filename))
   status=search(ss'$', '@r'_fpos_case);
   if (status) {
      p_view_id=orig_view_id;
      return('');
   }
   down();
   get_line(info_line);
   parse info_line with . . info
   p_view_id=orig_view_id;
   if (info!='') {
      return(info);
   }
   return('');
}
_exit_filepos()
{
   get_view_id orig_view_id
   activate_view(HIDDEN_VIEW_ID);
   filepos_file=_config_path():+'filepos.slk';
   status=find_view(filepos_file)
   if ( !status && p_modify) {
      _save_file('+o');
   }
   activate_view(orig_view_id);
}

static int _activate_filepos_file(var orig_view_id)
{
   get_view_id orig_view_id
   activate_view HIDDEN_VIEW_ID
   filepos_file=_config_path():+'filepos.slk';
   status=find_view(filepos_file)
   if ( status ) {
      _create_config_path();
      /* Create buffer in hidden window group called .bookmark */
      status=load_files('+l +q +c 'maybe_quote_filename(filepos_file));
      if ( status ) {
         if (status==NEW_FILE_RC) {
            _delete_line();
         } else {
            activate_view(orig_view_id);
            return(1);
         }
      }
      p_buf_flags= THROW_AWAY_CHANGES|HIDE_BUFFER|KEEP_ON_QUIT;
   }
   return(0);
}
int _filesize(filename)
{
   s=file_list_field(filename, DIR_SIZE_COL, DIR_SIZE_WIDTH);
   if (s=='') {
      return(0);
   }
   return(s);
}
#if 0
defeventtab _saveas_form
void ctlexpandtabs.lbutton_up()
{
   if (p_value) {
      ctltabify.p_value=0;
   }
}
void ctltabify.lbutton_up()
{
   if (p_value) {
      ctlexpandtabs.p_value=0;
   }
}
#endif
