/*
$VerboseHistory: ex.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:08:53a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 08:52a
 * Comment:
 * Added support for editor control.
 * Fixed problem where multi-file searching confused a
 * normal VI search.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:32p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:37p
 * Comment:
 * Adding new 3.0 stuff
*/

#include "slick.sh"
#include "ex.sh"

_str old_search_string;
_str old_replace_string;
typeless old_search_flags;
_str old_word_re;


/* By default this command handles ':' pressed */
_command ex_mode (...) name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( length(key):==1 ) {
         keyin(key);
      }
      return(0);
   }

   _macro_delete_line();

   stay_in_ex=(arg(1)!='' && arg(1));   // This is set by the 'Q' command
   report_threshold=__ex_set_report();
   if ( ! isinteger(report_threshold) ) {
      report_threshold=REPORT_DEFAULT;
   }
   prmpt=': ';
   if ( stay_in_ex ) {
      if ( ! __ex_set_prompt() ) {
         prmpt='';
      }
   }
   Noflines=p_noflines;   // Use this after we are finished for the REPORT option
   orig_buf_id=p_buf_id;  // Save this in case a command (ie TAG) takes out of the current buffer
   for (;;) {
      status=get_string(line,prmpt,'exarg*:'(FILE_CASE_MATCH|AUTO_DIR_MATCH));
      if ( status ) {
         if ( ! stay_in_ex ) {
            // User aborted
            status=0;
            break;
         } else {
            clear_message();   // Clear the "Command cancelled" message
         }
      } else if ( upcase(strip(line))=='VI' ) {
         break;
      }
      _macro_call('ex_parse_and_execute',line);
      status=ex_parse_and_execute(line);
      if ( !stay_in_ex ) break;
   }
   if ( !status && orig_buf_id==p_buf_id ) {   // We don't want to clear a more important message!
      diff=p_noflines-Noflines;
      if ( diff>0 ) {
         if ( diff>=report_threshold ) {
            vi_message(diff' more lines');
         }
      } else if ( diff<0 ) {
         if ( -diff>=report_threshold ) {
            vi_message(-diff' fewer lines');
         }
      }
   }
   
   return(status);
}


/* By default this handles 'Q' pressed */
_command ex_ex_mode () name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   _macro('m',_macro());

   return(ex_mode('1'));
}


/* By default this command handles '/' pressed */
_command ex_search_mode (...) name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   _macro_delete_line();

   arg1=arg(1);
   if ( arg1=='-' ) {
      prmpt='?';
   } else {
      prmpt='/ ';
   }

   status=0;
   if( arg(2)!='' ) {
      line=arg(2);
   } else {
   status=get_string(line,prmpt);
   }
   if ( status ) {
      // User aborted
      return(status);
   }

   _macro_call('ex_search_mode',arg1,line);

   start=1;   // Start parsing at beginning of line
   if ( arg1=='-' ) {
      line='?'line;
   } else {
      line='/'line;
   }
   status=ex_parse_search(line,start,search_re,search_options);
   search_options=search_options:+'@';
   if ( status ) {
      vi_message('Error parsing search string');
      return(1);
   }
   old_context=vi_get_prev_context();
   vi_set_prev_context();
   if ( arg1=='-' ) {
      if ( ! pos('-',search_options) ) {
         search_options=search_options:+'-';
      }
   }

   if( _default_option('S') & WRAP_SEARCH ) {
      search_options=search_options:+'P';   // We need to do this for ex-repeat-search
   }

   if( search_re:=='' ) {
      status=ex_repeat_search(arg1,'1');   // The second argument tells ex-repeat-search that it was called from ex-search-mode
   } else {
      p=point();col=p_col;
      status=vi_search(search_re,search_options);
      if( status && (old_search_flags&WRAP_SEARCH) ) {
         save_pos(p);
         if( arg1=='-' ) {
            bottom();
         } else {
            top()
         }
         status=vi_search(search_re,search_options);
         if( status ) {
            restore_pos(p);
         }
      } else if ( ! status && p==point() && col==p_col ) {   // In same place?
         status=ex_repeat_search();
      }
   }
   if ( status ) {
      vi_set_prev_context(old_context);   // Set the previous context back on error
      if ( status==STRING_NOT_FOUND_RC ) {
         msg='Pattern not found';
      } else {
         msg=get_message(status);
      }
      vi_message(msg);
      return(1);
   }
   if (!(/*pos('M',upcase(old_search_flags)) && */select_active()) && def_persistent_select=='D' && def_leave_selected) {
      _select_match();
   }
   
   return(0);
}


/* By default this handles '?' pressed */
_command ex_reverse_search_mode () name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   if ( command_state() ) {
      key=last_event();
      if ( key:=='?' ) {
         maybe_list_matches();
      } else if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   _macro('m',_macro());

   return(ex_search_mode('-'));
}


/* By default this handles 'n' pressed */
_command ex_repeat_search () name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   _macro_delete_line();
   _macro_call('ex_repeat_search',arg(1),arg(2));

   save_search_flags=old_search_flags;
   if( old_search_flags&REVERSE_SEARCH ) {
      // if 'N' OR '/'
      if( (arg(1)=='-' && arg(2)=='') || (arg(1)=='' && arg(2)!='') ) {
         old_search_flags=old_search_flags&(~REVERSE_SEARCH);
      }
   } else {
      // if 'N' OR '?'
      if( arg(1)=='-' ) {
         old_search_flags=old_search_flags|REVERSE_SEARCH;
      }
   }
   old_context=vi_get_prev_context();
   vi_set_prev_context();
   _mffindNoMore(1);
   status=execute('find-next',"");

   // Only set the old_search_flags back if we did NOT use '/' or '?'
   if( arg(2)=='' ) {
      old_search_flags=save_search_flags;
   }

   if( status ) {
      vi_set_prev_context(old_context);   // Set the previous context on error
   }

   return(status);
}


/* By default this handles 'N' pressed */
_command ex_reverse_repeat_search () name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   _macro('m',_macro());

   return(ex_repeat_search('-'));
}


#if USE_OLD_LINE_FLAGS
   #define GLOBAL_MARK_CODE ''   /* Two ESC's (ascii code=27) */
#endif

/* This function flags a line for commands like GLOBAL */
static int ex_flag_line(...)
{
   unflag=(upcase(arg(1))=='U');
   status=0;
#if USE_OLD_LINE_FLAGS
   old_modify_flag=p_modify;
   get_line(line);
#endif
   if( unflag ) {
#if USE_OLD_LINE_FLAGS
      if( substr(line,length(line)-length(GLOBAL_MARK_CODE)+1)==GLOBAL_MARK_CODE ) {
         replace_line(substr(line,1,length(line)-length(GLOBAL_MARK_CODE)));
      }
#else
      _lineflags(0,VIMARK_LF);
#endif
   } else {
      // Flag it
#if USE_OLD_LINE_FLAGS
      if( (length(line)+length(GLOBAL_MARK_CODE)+1)>MAX_LINE ) {
         messageNwait('This line is too long to process.  Type any key');
         status=1;
      } else {
         replace_line(line:+GLOBAL_MARK_CODE);
      }
#else
      _lineflags(VIMARK_LF);
#endif
   }
#if USE_OLD_LINE_FLAGS
   p_modify=old_modify_flag;
#endif

   return(status);
}


/* This function finds a flagged line for commands like GLOBAL */
static int ex_find_flagged_line()
{
#if USE_OLD_LINE_FLAGS
   options='r@';   // '@'=quiet
   _begin_line();
   status=search('^?@'GLOBAL_MARK_CODE'$',options);
   return(status);
#else
   linenum=p_line;
   for(;;) {
      flags=_lineflags();
      if( flags&VIMARK_LF ) {
         return(0);
      }
      status=down();
      if( status ) {
         p_line=linenum;
         return(status);
      }
   }
#endif
}


int ex_client_height()
{
   _get_max_window(x,y,width,height);
   height=height intdiv p_font_height;
   
   return(height);
}


void ex_msg_ro()
{
   popup_message(nls('This command is not allowed in Read Only mode.'));
}

void ex_msg_editctl()
{
   popup_message(nls('This command is not allowed in an Edit Control.'));
}


/* This function parses out the address, command, and parameter parts of
 * an ex command and then executes the command
 */
typeless ex_parse_and_execute(line,...)
{
   delay_feedback=(arg(2)!='' && arg(2));   // This is important for any command that displays a list of modified lines
   len=length(line);
   start=1;
   begin_addr='';
   end_addr='';
   params='';
   variant_form_used=0;   // Indicates whether to use the variant form of the command parsed
   // Parse out the address
   status=ex_parse_address_range(line,start,begin_addr,end_addr);
   if ( status ) {
      return(status);
   }
   status=ex_parse_command(line,start,cmd);
   if ( status ) {
      return(status);
   }
   if ( cmd!='' ) {
      orig_cmd=upcase(strip(cmd));   // Save this so we can check against the list of unsupported commands
      cmd=ex_match(cmd,1);   // Find the first ex command name that matches
      ex_match('',2);   // Reset ex command matching
      if ( cmd=='' ) {
         if ( pos(' 'orig_cmd' ',EX_NOT_SUPPORTED_CMDS) ) {
            vi_message('"'orig_cmd'": Command not supported');
         } else {
            vi_message('Unknown command');
         }
         return(1);
      } else if ( p_readonly_mode && ! pos(' 'cmd' ',EX_READONLY_CMDS) ) {
         ex_msg_ro();
         return(1);
      }
   }
   use_variant_form=0;
   if ( substr(line,start,1)=='!' && pos(' 'cmd' ',EX_VARIANT_CMDS) ) {   // Use the variant form of the command?
      use_variant_form=1;   // Use the variant form of the command
      start=start+1;   // Set up to read after the '!'
   }
   params=strip(substr(line,start));
   //messageNwait(begin_addr'|'end_addr'|'cmd'|'params);
   if ( cmd=='' && params=='' ) {
      // We simply have an address (line number)
      execute(end_addr,"");   // Execute the ending address as you would on the SlickEdit command line
      return(0);
   } else {
      // It is a valid ex command
      if ( cmd:=='!' ) {
         proc_name='__ex_shell_execute';
      } else if ( cmd:=='=' ) {
         proc_name='__ex_show_address';
      } else if( cmd:=='<' ) {
         proc_name='__ex_shift_text_left';
      } else if( cmd:=='>' ) {
         proc_name='__ex_shift_text_right';
      } else if( cmd:=='&' ) {
         proc_name='ex_repeat_last_substitute';
      } else {
         proc_name='__ex_':+lowcase(cmd);
      }
      idx=find_index(proc_name,PROC_TYPE|COMMAND_TYPE);
      if ( ! idx ) {
         vi_message('Can''t find procedure: 'proc_name);
         return(1);
      }
      if ( begin_addr!='' || end_addr!='' ) {   // Was there an address before the command name?
         if ( ! pos(' 'cmd' ',EX_ADDR_CMDS) ) {
            // It is not a valid address command
            vi_message('No address allowed on this command');
            return(1);
         }
      }
   }
   /* We call the command index with all the possible arguments
    * even though it might not use all of them
    */
   last_index(idx);   // Set this so commands like GLOBAL don't recurse
   return(call_index(params,begin_addr,end_addr,use_variant_form,delay_feedback,idx));
}


/* This function parses out the address range of an ex command */
static int ex_parse_address_range(line,int &start,int &begin_addr,int &end_addr)
{
   delim='';
   // Check for the '%' abbreviation
   if ( substr(strip(substr(line,start,1),'L'),1,1)=='%' ) {
      // '%' is an abbreviation for '1,$'
      begin_addr=1;
      end_addr=p_Noflines;
      start=start+1;
   } else {
      a=ex_parse_and_eval_address(line,start,msg);
      if ( (a<0 || a>p_Noflines) && a!='' ) {
         // Error
         if ( a<0 ) {
            vi_message(msg);
         } else {   // a>p_Noflines
            vi_message('Not that many lines in buffer');
         }
         return(1);
      }
      begin_addr=a;
      ch=substr(line,start,1);
      if ( ch!=',' && ch!=';' ) {
         // There is no ending address
         end_addr=begin_addr;
         return(0);
      } else {   // ch=',' or ch=';'
         delim=ch;
         if ( begin_addr=='' ) {
            begin_addr=ex_get_curlineno();   // Default address
         }
      }
      if ( delim==';' ) {
         // Force the beginning address to set the current line before evaluating the second address
         p_line=begin_addr;
      }
      start=start+1;   // Start looking for the ending address after the ',' or ';'
      a=ex_parse_and_eval_address(line,start,msg);
      if ( (a<0 || a>p_Noflines) && a!='' ) {
         // Error
         if ( a<0 ) {
            vi_message(msg);
         } else {   // a>p_Noflines
            vi_message('Not that many lines in buffer');
         }
         return(1);
      }
      end_addr=a;
      if ( end_addr=='' ) {
         end_addr=ex_get_curlineno();   // Default address
      }
   }
   
   return(0);
}


/* Some notes:  -implicit addresses are defined by the following symbols:
 *                 * '.' = current line number
 *                 * '$' = last line number in buffer
 *                 * '/' = line number resulting from forward search
 *                 * '?' = line number resulting from backward search
 *
 *              -an implied addition is when two addresses (either
 *               implicit or not) are separated by a space or tab;
 *               the two addresses are added together
 */
static _str ex_parse_and_eval_address(line,int &start,_str &msg)
{
   parse_only=(arg(4)!='' && arg(4)); /* If this is non-zero, then do not
                                       * evaluate implicit addresses
                                       */
   running_sum=0;
   pending_adder=0;   // The pending result of successive +'s and -'s
   maybe_implied_add=0;   // An implied addition is two addresses separated by spaces or tabs
   last_op='';
   implicit_used=0;   // Keeps track of whether an implicit address was used (i.e. '.','$')
   msg='Badly formed address';   // This is the default error message
   // Check to see if we need an implicit address to start us off
   if ( pos(substr(strip(substr(line,start),'L'),1,1),'+-') ) {
      // Put in the implicit current line number ('.')
      running_sum=ex_get_curlineno();
      implicit_used=1;
   } else if ( substr(line,start)=='' ) {
      // An empty address
      return('');
   }
   len=length(line);
   i=start;
   for (;;) {
      if ( i>len ) break;
      ch=substr(line,i,1);
      if ( ch=='+' || ch=='-' ) {
         if ( ch=='+' ) {
            pending_adder=pending_adder+1;
         } else { // ch='-'
            pending_adder=pending_adder-1;
         }
         maybe_implied_add=0;   /* There can only be an implied addition when
                                 * a space appears before an address
                                 */
         ++i;
      } else if ( pos(ch,"0123456789.$/?'`") ) {
         if ( !isdigit(ch) ) {
            if ( implicit_used ) {
               // Error - can't use more than one implicit address!
               return(-1);
            } else {
               implicit_used=1;
            }
         }
         if ( pending_adder ) {
            if ( maybe_implied_add ) {
               running_sum=running_sum+pending_adder;
            } else if ( last_op=='+' ) {
               running_sum=running_sum+(pending_adder-1);
            } else if ( last_op=='-' ) {
               running_sum=running_sum+(pending_adder+1);
            } else {
               // Error
               return(-1);
            }
         }
         // Now find the rest of the number OR expand the the implicit address
         if ( isdigit(ch) ) {
            num=ch;
            ++i;
            for (;;) {
               if ( i>len ) break;
               ch=substr(line,i,1);
               if ( isdigit(ch) ) {
                  num=num:+ch;
               } else {
                  break;
               }
               ++i;
            }
         } else if ( ch=='/' || ch=='?' ) {
            // Find the end of the search command
            delim=ch;   // Save the search delimiter
            ex_parse_search(line,i,search_re,search_options);
            if ( substr(line,i,1)==delim && i<=len ) {
               // We found an implicit address
               implicit_used=1;
            }
            //messageNwait('search_re='search_re'  search_options='search_options);
            if ( !parse_only ) {   // Evaluate the search address?
               // Do the search
               save_pos(p);
               #if 1   // HERE - 5/30/95 - added to enable wrapping on search
               if( _default_option('S') & WRAP_SEARCH ) {
                  search_options=search_options:+'P';   // We need to do this for EX-REPEAT-SEARCH
               }

               arg1='';
               if( delim=='?' ) {
                  arg1='-';
               }
               _end_line();   // The real vi will not find the first match on the current line
               if( search_re:=='' ) {
                  status=ex_repeat_search(arg1,'1');   // arg(2)='1' so the search direction is reset
               } else {
                  status=vi_search(search_re,search_options);
                  if( status && (old_search_flags&WRAP_SEARCH) ) {
                     save_pos(q);
                     if( arg1=='-' ) {
                        bottom();
                     } else {
                        top()
                     }
                     status=vi_search(search_re,search_options);
                     if( status ) {
                        restore_pos(q);
                     }
                  }
               }
               #else
               status=vi_search(search_re,search_options);
               #endif
               if ( status ) {
                  restore_pos(p);
                  msg='Pattern not found';
                  return(-1);
               }
               num=p_line;   // The resulting line number from the search
               restore_pos(p);   // Go back to where we started
            } else {
               num=0;   // Dummy value
            }
            if ( i<=len ) {
               ++i;   // Set up to read the next character
            }
         } else if ( ch=="'" || ch=="`" ) {
            linemarkflag= (ch=="'")?('1'):('');
            // Mark address
            ++i;
            if ( i>len ) {
               // Error - mark without a name
               msg="Marks are ' and ` and a-z";
               return(-1);
            }
            mark_name=substr(line,i,1);
            if( mark_name=="'" || mark_name=="`" ) {
               if( (mark_name=="'" && linemarkflag=='') ||
                   (mark_name=="`" && linemarkflag!='')
                 ) {
                  // Mark name of "'" or "`" doesn't jibe
                  msg="Invalid mark name";
                  return(-1);
               }
               mark_name='';
            }
            if( _dbcsIsLeadByte(mark_name) ) {
               mark_name=substr(line,i,2);
               ++i;   // Only increment by 1 so i=i+1 below gets it right
            }
            ++i;   // Increment past the mark name
            if ( !parse_only ) {   // Evaluate the mark address?
               buf_id=p_buf_id;   // Save this in case the mark is in another buffer
               save_pos(p);
               old_prev_context=vi_get_prev_context();   // Save this so we can restore it
               status=vi_goto_mark(mark_name,linemarkflag);
               vi_set_prev_context(old_prev_context);   // Restore the old previous context
               if ( status || buf_id!=p_buf_id ) {
                  if ( p_buf_id!=buf_id ) {
                     _undo();   // Put the cursor back where it was
                     load_files('-bp +bi 'buf_id);
                  }
                  msg='Undefined mark referenced';
                  return(-1);   // Error
               }
               num=p_line;   // The resulting line number from the vi-goto-mark
               restore_pos(p);
            } else {
               num=0;   // Dummy value
            }
         } else {
            if ( !parse_only ) {   // Evaluate the '.' or '$' address?
               if ( ch=='.' ) {
                  num=ex_get_curlineno();
               } else {   // ch='$'
                  num=p_noflines;
               }
            } else {
               num=0;   // Dummy value
            }
            ++i;
         }
         if ( pending_adder || maybe_implied_add ) {
            /* Now perform the operation:  (running_sum) last_op (num) */
            /*                                                         */
            /*                                            OR           */
            /*                                                         */
            /*                             (running_sum)   +     (num) */
            if ( maybe_implied_add ) {
               running_sum=running_sum+num;
            } else if ( last_op=='+' ) {
               running_sum=running_sum+num;
            } else if ( last_op=='-' ) {
               running_sum=running_sum-num;
            }
            // Reset these after the operation is done
            pending_adder=0;
            maybe_implied_add=0;
         } else {
            // No pending operation
            if ( last_op=='' ) {
               if ( !running_sum ) {
                  running_sum=num;
               } else {
                  running_sum=running_sum+num;
               }
            } else {
               // Error
               return(-1);
            }
         }
      } else if ( ch:==' ' || ch:==\t ) {
         if ( running_sum ) {
            // Maybe an implied addition
            maybe_implied_add=1;
         }
         ++i;
      } else {
         // We have reached the end of the address
         break;
      }
      last_ch=ch;
      if ( ch!='' ) {
         last_op=ch;
      }
   }
   if ( parse_only ) {
      running_sum=substr(line,start,i-start);
   } else {
      if ( pending_adder ) {
         // We had a string of +'s and -'s to add
         running_sum=running_sum+pending_adder;
      }
      if ( substr(line,start,i-start)=='' ) {
         running_sum='';   // Implicit current line number
      }
   }
   start=i;
   
   return(running_sum);
}



/* This function parses out the command part of an ex command */
static int ex_parse_command(line,int &start,_str &cmd)
{
   i=start;
   len=length(line);
   cmd='';
   for (;;) {
      if ( i>len ) {
         break;
      }
      ch=substr(line,i,1);
      if ( ch:==' ' && cmd=='' ) {
         ++i;
         continue;
      } else if ( ch:=='=' || ch:=='!' || ch:=='<' || ch:=='>' || ch:=='&' ) {
         if ( cmd=='' ) {
            cmd=ch;
            ++i;
         }
         break;
      } else if ( !isalpha(ch) ) {
         break;
      }
      cmd=cmd:+ch;
      ++i;
   }
   start=i;
   
   return(0);
}


/* This function parses out the regular expression and assigns the search
 * options according to the delimiter ( '/'=forward , '?'=backward )
 */
static int ex_parse_search(line,int &start,_str &search_re,_str &search_options)
{
   // Find the end of the search command
   search_expr='';   // At the end of the loop, this will hold the entire search expression
   len=length(line);
   i=start;
   delim=substr(line,i,1);
   if ( ! pos(delim,'/?') ) {   /* Is this a valid delimiter? */
      return(1);
   }
   ++i;
   for (;;) {
      if ( i>len ) break;
      ch=substr(line,i,1);
      if( _dbcsIsLeadByte(ch) ) {
         ch=substr(line,i,2);
         ++i;   // Only increment by 1 so that the final increment will get it right
      }
      search_expr=search_expr:+ch;
      if ( ch==delim ) {
         break;
      } else if ( ch=='\' ) {
         ch=substr(line,i+1,1);
         if( _dbcsIsLeadByte(ch) ) {
            ch=substr(line,i+1,2);
            ++i;   // Only increment by 1 so that the final increment will get it right
         }
         search_expr=search_expr:+ch;   // Get the skipped over char
         i+=2;   // Skip over the escaped character
      } else {
         ++i;
      }
   }
   start=i;
   // Set up the regular expression and search options
   search_options='';
   if( ch==delim && i<=len ) {
      // There was an ending delimiter
      search_re=substr(search_expr,1,length(search_expr)-1);   // Get the regular expression inside the delimiters
      search_options=strip(substr(line,start+1));   // Options are everything after the last delim
      if( last_char(search_options)==delim ) {
         search_options=substr(search_options,1,length(search_options)-1);
      }
   } else if( i>len ) {
      // There was no ending delimiter, so the whole thing is the regular expression
      search_re=search_expr;
   }
   // Set up the search options
   if( !pos('(r|u|b)',search_options,1,'r') ) {
      search_options=search_options:+_vi_search_type();   // Default regular expression type
   }
   if( !pos('(i|e)',search_options,1,'r') ) {
      search_options=search_options:+_search_case();   // Default case-sensitivity
   }
   if ( delim=='?' ) {
      // Reverse search
      search_options=search_options:+'-';
   }
   
   return(0);
}


/* This function is a match function for an ex command */
_str ex_match(name,find_first)
{
   if ( find_first ) {
      _ex_match_pos=1;
      if ( find_first==2 ) {
         return('');
      }
   }
   name=upcase(strip(name));
   p=pos('{ 'name'[~ \t]@ }',EX_CMDS,_ex_match_pos,'er');
   if ( p ) {
      _ex_match_pos=p+pos('0')-1;   // Next match occurs at the trailing space
      return(strip(substr(EX_CMDS,pos('S0'),pos('0'))));
   }
   
   return('');
}


/* This function is a match function for ex command arguments */
_str exarg_match(name,find_first)
{
   _cmdline.get_command(line,start);
   parse line with ex '[~a-zA-Z]','r' a;
   if( a!='' && a==name ) {
      if( ex_match(ex,1)=='EDIT' ) {
         return(f_match(a,find_first));
      }
   }

   /* If we got here then it means expansion was attempted on the ex
    * command itself.  We don't want that to happen more than once.
    */
   if( find_first ) {
      return(name);
   } else {
      return('');
   }
}


/* This function returns the current line number within vi */
int ex_get_curlineno()
{
   return(p_line);
}


/* This function converts '#' and '%' to prev-buffer and current-buffer respectively */
static _str ex_process_shellcmd(_str cmd)
{
   if( cmd=='' ) {
      return('');
   }
   newcmd='';
   i=1;
   len=length(cmd);
   while( i<=len ) {
      ch=substr(cmd,i,1);
      if( ch=='\' ) {
         newcmd=newcmd:+substr(cmd,i,2);
         i+=2;   // Skip over the escaped char
         continue;
      } else if( ch=='#' ) {
         // Check for previous buffer name
         thisbufid=p_buf_id;
         _prev_buffer();
         if( p_buf_id==thisbufid || !_Nofbuffers() ) {
            // There is no previous buffer
            vi_message('No filename to substitute for #');
            return('');
         }
         bufname=p_buf_name;
         _next_buffer();   // Switch back
         newcmd=newcmd:+bufname;
      } else if( ch=='%' ) {
         // Current buffer name
         if( _no_child_windows() ) {
            // There is no current buffer
            vi_message('No filename to substitute for %');
            return('');
         }
         bufname=p_buf_name;
         newcmd=newcmd:+bufname;
      } else {
         newcmd=newcmd:+substr(cmd,i,1);
      }
      ++i;
   }

   return(newcmd);
}


/* This function executes a command in a shell */
/* Note:  If an address is given for this command, then the line(s)
 *        specified by the address are replaced with the output from
 *        'params'.  Otherwise, 'params' is run inside a shell.
 *
 * !
 */
_str __ex_shell_execute(...)
{
   params=arg(1);
   a1=arg(2);
   a2=arg(3);
   /* arg(4) not used */
   /* arg(5) not used */
   status=0;
   if ( params=='' ) {
      vi_message("Incomplete shell escape command - use 'shell' to get a shell");
      return(1);
   }

   status=0;
   // Set up the range of lines to be replaced by the output of the shell
   if ( !isinteger(a1) && !isinteger(a2) ) {
      // Do NOT replace lines in the current buffer with output from the shell
      #if 1
      if( params=='!' ) {
         // User typed !!, so repeat the last :!command
         _cmdline._reset_retrieve();
         line='';
         prmpt=': ';
         ss='@'length(prmpt)prmpt;
         for(;;) {
            params=_cmdline.retrieve_skip('',ss:+line);
            if( params=='' ) break;
            params=substr(params,length(ss)+1);
            i=pos('!',params);
            if( i ) {
               params=substr(params,i+1);
               if( params=='!' ) continue;   // We found another !!
               break;
            }
         }
         if( params=='' ) {
            vi_message("No previous shell command to substitute for '!'");
            return(1);
         }
      }
      params=ex_process_shellcmd(params);   // Process for '#' and '%'
      if( params=='' ) {
         /* An error occurred processing command - no message because
          * ex_process_shellcmd took care of that.
          */
         return(1);
      }
      #endif
      status=shell('0 'params,'W')
   } else {
      #if 1
      if( p_readonly_mode ) {
         ex_msg_ro();
         return('');
      }
      if( params=='!' ) {
         /* User typed <address>!!, so repeat the last :!command and
          * substitute the addressed lines with the result.
          */
         line='';
         prmpt=': ';
         ss='@'length(prmpt)prmpt;
         for(;;) {
            params=_cmdline.retrieve_skip('',ss:+line);
            if( params=='' ) break;
            params=substr(params,length(ss)+1);
            i=pos('!',params);
            if( i ) {
               params=substr(params,i+1);
               if( params=='!' ) continue;   // We found another !!
               break;
            }
         }
         if( params=='' ) {
            vi_message("No previous shell command to substitute for '!'");
            return(1);
         }
      }

      params=ex_process_shellcmd(params);   // Process for '#' and '%'
      if( params=='' ) {
         /* An error occurred processing command - no message because
          * ex_process_shellcmd took care of that.
          */
         return(1);
      }
      #endif

      if ( ! isinteger(a1) ) {
         a1=ex_get_curlineno();
      }
      if ( ! isinteger(a2) ) {
         a2=ex_get_curlineno();
      }

      // Now mark the lines which will be used as input to the filter AND replaced with the output from the filter
      old_mark=_duplicate_selection('');
      mark=_alloc_selection();
      if ( mark<0 ) {
         vi_message(get_message(mark));
         return(mark);
      }
      p_line=a1;
      _select_line(mark,'P');
      p_line=a2;
      _select_line(mark,'P');
      _begin_select(mark);
      mark2=_duplicate_selection(mark);   // Make a duplicate so we can cut it to the clipboard later

      /* Now make a temporary file to hold the input to the shell and copy the marked lines into it */
      temp_in=mktemp();
      if( temp_in=='' ) {
         _free_selection(mark);
         _free_selection(mark2);
         vi_message('Unable to make temp file');
         return(1);
      }
      temp_in=absolute(temp_in);   // Do this in case the working directory changes

      orig_buf_id=p_buf_id;   // 11/24/1997 - Need this so can restore in the case of an editor control

      status=load_files('+t 'temp_in);
      if( status ) {
         _free_selection(mark);
         _free_selection(mark2);
         return(status);
      }
      _delete_line();
      _copy_to_cursor(mark2);
      _free_selection(mark2);
      status=save('+o');
      _delete_buffer();

      p_buf_id=orig_buf_id;   // 11/24/1997 - Need this so can restore in the case of an editor control

      if( status ) {
         _free_selection(mark);
         return(status);
      }

      // Now make a temporary file to hold the output from the shell
      start=(int)substr(strip_filename(temp_in,'EP'),7)+1;
      temp_out=mktemp(start);
      if ( temp_out=='' ) {
         _free_selection(mark);
         vi_message('Unable to make temp file');
         return(status);
      }
      temp_out=absolute(temp_out);   // Do this in case the working directory changes

      shell(params' <'temp_in' >'temp_out,'Q');
      if ( file_match(temp_out,'1')!=temp_out ) {
         _free_selection(mark);
         vi_message('Error opening results of shell command');
         return(1);
      } else {
         // Success
         _show_selection(mark);
         old_line=p_line;
         vi_cut('','');
         _show_selection(old_mark);
         _free_selection(mark);
         old_line_insert=def_line_insert;
         if( p_line!=old_line ) {
            // The end of the mark was at the bottom of the buffer, so insert AFTER
            def_line_insert='A';
         } else {
            def_line_insert='B';
         }
         get(temp_out);
         if( def_line_insert=='A' ) {
            down();   // Must move down so we are back where we started
         }
         def_line_insert=old_line_insert;   // Quick, change it back

         // Now delete the temp files
         status=delete_file(temp_in);
         if ( status ) {
            vi_message('Error deleting temp file: 'temp_in);
            return(status);
         }
         status=delete_file(temp_out);
         if ( status ) {
            vi_message('Error deleting temp file: 'temp_out);
            return(status);
         }
      }
   }
   
   return(status);
}


/* This function displays evaluated address without changing current line */
/* Note:  If no address is given, then the number of lines is displayed ($) */
/* = */
int __ex_show_address()
{
   params=arg(1);
   a1=arg(2);
   a2=arg(3);
   /* arg(4) not used */
   /* arg(5) not used */
   if ( params!='' ) {
      vi_message('Extra characters');
      return(1);
   }
   if ( ! isinteger(a1) && ! isinteger(a2) ) {
      vi_message(p_noflines);   // Display the number of lines when no address is given
   } else {
      if ( ! isinteger(a2) ) {
         a2=ex_get_curlineno();
      }
      vi_message(a2);   // Display the evaluated address
   }
   
   return(0);
}


/* This function assigns a value to an alias name so that in vi insert-mode,
 * when that alias name is entered, the alias name is automatically replaced
 * with the value assigned.
 *
 * Example:  ":abbr rainbow yellow green blue red" maps the alias name "rainbow"
             to the value "yellow green blue red".
 */
int __ex_abbreviate()
{
   params=arg(1);
   /* arg(2) not used */
   /* arg(3) not used */
   /* arg(4) not used */
   /* arg(5) not used */
   
   parse params with alias_name val;
   status=0;
   if ( alias_name=='' ) {
      match_idx=find_index('alias-match',PROC_TYPE);
      if ( ! match_idx ) {
         vi_message('Procedure not found: alias_match');
         return(1);
      }
      // We pass a match argument to list matches
      list_matches('','alias:'TERMINATE_MATCH,'Aliases');   // Throw away the result
   } else {
      if ( val=='' ) {
         vi_message('No right hand side');
         return(1);
      }
      status=alias(alias_name' 'val);
   }
   
   return(status);
}


/* This function copies addressed text after a destination line number */
int __ex_copy(...)
{
   params=arg(1);
   a1=arg(2);
   a2=arg(3);
   /* arg(4) not used */
   delay_feedback=(arg(5)!='' && arg(5));   // This is useful if we are inside GLOBAL
   move_lines=(arg(6)!='' && arg(6));   // Non-zero means move the lines, otherwise copy them
   
   start=1;
   dest=ex_parse_and_eval_address(params,start,msg);
   if ( dest=='' ) {
      vi_message('Copy requires a trailing address');
      return(1);
   }
   params=upcase(strip(substr(params,start)));   // What comes after the destination address
   if ( params!='' ) {
      params=upcase(ex_match(params,EX_ARG));   // Find the matching command
      if ( params!='LIST' && params!='PRINT' ) {;
         vi_message('Extra characters');
         return(1);
      }
   }
   if ( ! isinteger(a1) ) {
      a1=ex_get_curlineno();
   }
   if ( ! isinteger(a2) ) {
      a2=ex_get_curlineno();
   }
   mark=_alloc_selection();
   if ( mark<0 ) {
      vi_message(get_message(mark));
      return(mark);
   }
   p_line=a1;
   _select_line(mark,'P');
   p_line=a2;
   _select_line(mark,'P');
   p_line=dest;
   if ( move_lines ) {
      //_move_to_cursor(mark);
      smart_paste(mark,'M');
   } else {
      //_copy_to_cursor(mark);
      smart_paste(mark,'C');
   }
   _end_select(mark);
   vi_begin_text();   // Put cursor on first non-blank character
   _free_selection(mark);   // Can free this because it was never shown
   status=0;
   if ( (params=='PRINT' || params=='LIST' || __ex_set_autoprint()) ) {
      if ( params=='LIST' ) {
         status=__ex_print('','','','',delay_feedback,'1');   // List last line showing the end of the line
      } else {
         status=__ex_print('','','','',delay_feedback);   // Just list the last line
      }
   }
   
   return(status);
}


/* This function changes the current working directory */
int __ex_cd()
{
   params=arg(1)
   /* arg(2) not used */
   /* arg(3) not used */
   /* arg(4) not used */
   
   if ( params=='' ) {
#if __UNIX__
      dir=get_env('HOME');
      if ( dir=='' ) {
         vi_message('Environment variable HOME not set');
         return(1);
      }
#else
      dir=getcwd();
#endif
   } else {
      dir=strip(params);
   }
   if ( isdirectory(dir) ) {
      status=cd(dir);
      if ( status ) {
         vi_message(get_message(status));
         return(status);
      }
   } else {
      vi_message('"'dir'" is not a valid directory');
      return(1);
   }
   vi_message('Current directory is 'getcwd());
   
   return(0);
}


/* This function deletes the addressed lines */
int __ex_delete()
{
   params=strip(arg(1));   // This can be a count relative to the ending address
   a1=arg(2);
   a2=arg(3);
   /* arg(4) not used */
   
   if ( !isinteger(a1) && !isinteger(a2) ) {
      a1=ex_get_curlineno();
      a2=a1;
   } else {
      if ( !isinteger(a1) ) {
         a1=ex_get_curlineno();
      }
      if ( !isinteger(a2) ) {
         a2=ex_get_curlineno();
      }
   }
   if ( params!='' ) {
      if ( isinteger(params) ) {
         if ( params<=0 ) {
            vi_message('Positive count required');
            return(1);
         } else {
            // Make the beginning address the last address in the command prefix
            a1=a2;
            a2=a1+params-1;
            if ( a2>p_noflines ) {   // Is the count out of range
               a2=p_noflines;
            }
         }
      } else {
         vi_message('Extra characters');
         return(1);
      }
   }
   mark=_alloc_selection();
   if ( mark<0 ) {
      vi_message(get_message(mark));
      return(mark);
   }
   p_line=a1;
   _select_line(mark,'P');
   p_line=a2;
   _select_line(mark,'P');
   old_mark=_duplicate_selection('');
   _show_selection(mark);

   vi_cut('','','0');
   _show_selection(old_mark);

   return(0);
}


/* This function edits a file */
/* Note: '#' expands out to the name of the previous file */
int __ex_edit()
{
   if( !p_mdi_child ) {
      ex_msg_editctl();
      return(1);
   }

   params=strip(arg(1),'L');   // This is of the form: [+command] file
   /* arg(2) not used */
   /* arg(3) not used */
   use_variant_form=(arg(4)!='' && arg(4));
   
   cmd='';   // Default command
   if ( substr(params,1,1)=='+' ) {
      // We might have an ex command
      params=strip(substr(params,2));   // Take what is after the '+'
      /* This is a test to see whether the command appears in between
       * double-quotes (") and is an improvement over the real vi
       * because it allows for spaces in the command
       */
      if ( substr(params,1,1)=='"' ) {
         parse params with '"' cmd '"' params;
      } else {
         parse params with cmd params;
      }
      cmd=strip(cmd);
      params=strip(params);
   }
   oldparams=params;
   params=ex_process_shellcmd(params);   // Process for '#' and '%'
   if( params=='' && oldparams!='' ) {
      /* An error occurred processing command - no message because
       * ex_process_shellcmd took care of that.
       */
      return(1);
   }
   if ( params=='' ) {
      return(__ex_rewind('','','',use_variant_form));
   }
   status=edit(params);
   if ( status ) {
      vi_message(get_message(status));
      return(status);
   }
   if ( cmd!='' ) {
      // There was a command to execute on the file opened
      status=ex_parse_and_execute(cmd);
   } else {
      msg='"'p_buf_name'" ';
      Noflines=p_noflines;
      if ( Noflines==1 ) {
         msg=msg:+Noflines' line';
      } else {
         msg=msg:+Noflines' lines';
      }
      vi_message(msg);
   }
   
   return(status);
}


/* By default this handles 'C-^' pressed */
_command ex_prev_edit () name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   if( !p_mdi_child ) {
      ex_msg_editctl();
      return(1);
   }

   status=ex_parse_and_execute('e #');
      
   return(status);
}


/* This function changes the name of the current file OR displays the
 * the current filename if no arguments are given
 */
int __ex_file()
{
   params=arg(1);
   /* arg(2) not used */
   /* arg(3) not used */
   /* arg(4) not used */
   
   if ( params!='' ) {
      status=name(params);
      if ( status ) {
         return(status);
      }
   }
   info='"'p_buf_name'" ';
   if ( p_modify ) {
      info=info:+'[Modified] ';
   }
   info=info:+'line 'p_line' of 'p_noflines;
   vi_message(info);
   
   return(0);
}


/* This command does a per-line pattern match */
typeless __ex_global(...)
{
   //messageNwait(name_name(last_index())'  'name_name(prev_index()));
   if ( p_buf_width ) {
      vi_message('GLOBAL not allowed in a binary file');
      return(1);
   } else if ( prev_index()==last_index() ) {
      last_index(0);
      prev_index(0);
      // Some lines might still be flagged - unflag them
      linenum=p_line;
      top();
      for (;;) {
         _begin_line();
         flag_status=ex_find_flagged_line();
         if ( flag_status ) {
            break;
         }
         ex_flag_line('U');
      }
      p_line=linenum;
      vi_message('Global within global not allowed');
      return(1);
   }
   this_idx=last_index();   /* Save this so we don't recurse */
   params=arg(1);
   a1=arg(2);
   a2=arg(3);
   if ( !isinteger(a1) && !isinteger(a2) ) {
      a1=1;
      a2=p_Noflines;
   } else {
      if ( !isinteger(a1) ) {
         a1=p_line;
      }
      if ( !isinteger(a2) ) {
         a2=p_line;
      }
   }
   // Set up the step for the loop
   if ( a1>a2 ) {
      step= -1;
   } else {
      step=1;
   }
   use_variant_form=(arg(4)!='' && arg(4));

   _ex_print_view_id='';   // Clear it
   //messageNwait('use_variant_form='use_variant_form);
   if ( params=='' ) {
      if ( old_search_string:=='' ) {
         vi_message('No previous regular expression');
         return(1);
      }
   }
   parse arg(1) with  1 delim +1 search_string (delim) cmd;
   if ( search_string:!='' ) {
      old_search_string=search_string;
   }
   search_flags=_vi_search_type():+'m':+_search_case();
   //messageNwait('old_search_string='old_search_string);
#if 1
   // Check for special case of 'cmd' being a simple SUBSTITUTE
   if( !use_variant_form ) {
      start=1;
      ex_parse_command(cmd,start,cmd2);
      cmd2=ex_match(cmd2,'1');
      ex_match('','2');   // Reset
      if( cmd2=="SUBSTITUTE" ) {
         params=substr(cmd,start);
         parse params with 1 delim +1 string (delim) .;
         if( string=="" ) {
            return(ex_parse_and_execute(a1','a2:+cmd));
         }
      }
   }
#endif
   // Now create the mark we use for verifying each line
   old_mark=_duplicate_selection('');
   mark=_alloc_selection();
   if ( mark<0 ) {
      vi_message(get_message(mark));
      return(mark);
   }
   _show_selection(mark);

   // Save this in case the command called for each match mucks with it
   save_search_string=old_search_string;
   vi_set_prev_context();   // GLOBAL sets the previous context
   first_line_found=0;
   last_line=0;

   // First pass - mark all the lines that match
   if( !use_variant_form ) {
      p_line=a1;
      _select_line(mark,'P');
      p_line=a2;
      _select_line(mark,'P');
      _begin_select(mark);
   }
   i=a1;
   for (;;) {
      if ( i>a2 ) break;
      p_line=i;
      _begin_line();   // Start search at beginning of line
      if( use_variant_form ) {   // If variant form is used, then check every line explicitly
         _deselect(mark);
         _select_line(mark,'P');
      }
      //search_status=repeat_search()
      //messageNwait(_search_case());
      search_status=search(old_search_string,search_flags);   /* NOTE:  There's a good reason for
                                                               *        NOT calling repeat-search
                                                               *        here - we start a new search
                                                               *        on each iteration
                                                               */
      if ( (!search_status && !use_variant_form) ||
           (search_status && use_variant_form) ) {   // This is ~XOR
         // Found a matching line - flag it
         last_line=p_line;
         if ( !first_line_found ) {
            first_line_found=last_line;
         }
         if ( ex_flag_line() ) {
            i=p_line+step;
            continue;
         }
      } else {
         if( !use_variant_form ) break;
      }
      i=p_line+step;
   }

   prev_index(this_idx);   // Set this so we don't recurse

   // Second pass - for each marked occurrence, execute the command
   if ( first_line_found ) {
      p_line=first_line_found;
      _deselect(mark)   // Note:  this mark is already showing
      _select_line(mark,'P')
      p_line=last_line;
      _select_line(mark,'P');
      save_line= -1;   // This guarantees we go to the beginning of mark on first iteration
      status=0;
      for (;;) {
         if( p_line!=save_line ) {
            // There is no telling where the command left the cursor, so start searching at the beginning of the mark again
            mark_status=_begin_select(mark);
         } else {
            mark_status=( !select_active() );
         }
         if ( mark_status ) {
            // This could happen if the last line is deleted out of the mark
            break;
         }
         flag_status=ex_find_flagged_line();
         if ( flag_status ) {
            // No more flagged lines
            break;
         }
         // Unflag the line
         ex_flag_line('U');
         // Now execute the command on this occurrence
         save_line=p_line;
         status=ex_parse_and_execute(cmd,'1');   // The second argument tells any command being executed that it is inside GLOBAL and to delay any listing of lines

         // This is here just in case the command called mucked with 'old_search_string'
         old_search_string=save_search_string;

         if ( status ) {
            // Some lines might still be flagged - unflag them
            linenum=p_line;
            _begin_select(mark);
            for (;;) {
               //_begin_line();
               flag_status=ex_find_flagged_line();
               if ( flag_status ) break;
               ex_flag_line('U');
            }
            p_line=linenum;
            break;
         }
         last_line=p_line;
      }
   }
   _show_selection(old_mark);
   _free_selection(mark);
   if ( first_line_found ) {   // Were there any matches?
      p_line=last_line;
      vi_begin_text();   // Put cursor at beginning of text
   } else {
      status=search_status;   // This will force the message "String not found" if no lines match
   }
   if ( !status ) {   /* Don't clear a serious error message ("String not found" does'nt count) */
      clear_message();
      if ( isinteger(_ex_print_view_id) ) {
         status=__ex_print('',1,p_noflines,'','','','','1');   // The eighth argument tells __ex_print to use the view id '_ex_print_view_id' as the buffer for selection-list instead of creating a new one
      }
   }
   
   return(status);
}


/* This function performs a join of 2 or more lines */
typeless __ex_join()
{
   params=strip(arg(1));
   /* arg(2) not used */
   a2=arg(3);   // We are only interested in the last address
   /* arg(4) not used */
   /* arg(5) not used */
   
   if ( !isinteger(a2) ) {
      a2=ex_get_curlineno();
   }
   count=1;
   if ( params!='' ) {
      if ( isinteger(params) ) {
         if ( params<1 ) {
            vi_message('join requires a positive count');
            return(1);
         } else {
            count=params;
         }
      } else {
         vi_message('Extra characters');
         return(1);
      }
   }
   idx=find_index('vi-join-line',COMMAND_TYPE);
   if ( ! idx ) {
      vi_message('Can''t find command: vi-join-line');
      return(1);
   }
   p_line=a2;
   
   return(call_index(count,idx));
}


/* This function creates a mark at the current buffer location */
int __ex_k()
{
   params=strip(arg(1));   // This should be a single character mark-name
   if ( params=='' ) {
      vi_message('k requires following letter');
      return(1);
   } else {
      if ( ! isalpha(params) ) {
         vi_message('Extra characters');
         return(1);
      }
   }
   /* arg(2) not used */
   a2=arg(3);   // We are only interested in the ending address
   /* arg(4) not used */
   
   if ( !isinteger(a2) ) {
      a2=ex_get_curlineno();
   }
   p_line=a2;
   save_pos(p);
   vi_begin_text();
   status=set_bookmark('-r 'params);
   restore_pos(p);
   
   return(status);
}


/* This function lists a range of lines specified by the address given */
/* The only difference between this command and 'print' is that this
 * command marks the end of each line in the list with a '$'
 */
int __ex_list()
{
   return(__ex_print(arg(1),arg(2),arg(3),arg(4),arg(5),'1'));   // Pass a '1' as the sixth argument to mark end of lines
}



/* This function moves addressed text after a destination line number */
int __ex_move()
{
   return(__ex_copy(arg(1),arg(2),arg(3),arg(4),arg(5),'1'));   // Pass a '1' as the sixth parameter to move instead of copy
}


/* This function switches to the next buffer in the buffer list */
int __ex_next()
{
   if( !p_mdi_child ) {
      ex_msg_editctl();
      return(1);
   }

   params=strip(arg(1));   // This is of the form:  [+command] [filelist]
   /* arg(2) not used */
   /* arg(3) not used */
   use_variant_form=(arg(4)!='' && arg(4));
   
   cmd='';
   if ( substr(params,1,1)=='+' ) {
      // We might have an ex command
      params=strip(substr(params,2));   // Take what is after the '+'
      /* This is a test to see whether the command appears in between
       * double-quotes (") and is an improvement over the real vi
       * because it allows for spaces in the command
       */
      if ( substr(params,1,1)=='"' ) {
         parse params with '"' cmd '"' params;
      } else {
         parse params with cmd params;
      }
      cmd=strip(cmd);
      params=strip(params);
   }
   if ( params=='' ) {
      _next_buffer();
   } else {   // User gave a new file list to replace the current list
      buffers_modified=0;
      buf_info=buf_match('',1,'V');
      for (;;) {
         if ( rc ) break;
         parse buf_info with buf_id ModifyFlags buf_flags buf_name;
         if ( (ModifyFlags &1) && ! (buf_flags&THROW_AWAY_CHANGES) ) {
            buffers_modified=buffers_modified+1;
         }
         buf_info=buf_match('',0,'V');
      }
      if ( buffers_modified && ! use_variant_form ) {
         select=nls_letter_prompt(nls('Replace file list with 'buffers_modified' buffers modified (~Y/~N/~W)?'));
         if ( select:==3 ) {
            status=save_all();
            if ( status ) {
               return(status);
            }
            select=1;
         }
         clear_message();
         if ( select!=1 ) {
            return(COMMAND_CANCELLED_RC);
         }
      }
      if ( _process_info() ) {   // Is a process running?
         if ( def_exit_process ) {
            exit_process();
         } else {
            vi_message('Please exit concurrent process');
            return(1);
         }
      }
      
      // Now delete all the buffers to make way for the new file list
#if 0
      for (;;) {
         if ( last_buffer() ) break;
         if ( p_modify ) {
            p_modify=0;
         }
         //quit();
         close_buffer();   // close-buffer works independent of "One-file-per-window" mode
      }
      last_buf_id=p_buf_id;
      status=load_files('+t');   // Create a temp buffer so editor does not exit after last buffer is deleted
      temp_buf_id=p_buf_id;
      if ( status ) {
         vi_message('Unable to create temporary buffer.  'get_message(status));
         return(status);
      }
      load_files('+bi 'last_buf_id);
      //quit();
      close_buffer();
      // Now load the new file list AND force the first file edited to be the first displayed
      old_start_on_first=def_start_on_first;
      def_start_on_first=1;
      status=edit(params);
      first_buf_id=p_buf_id;
      def_start_on_first=old_start_on_first;   // QUICK - change it back
      if ( status ) {
         vi_message('Error loading new file list.  'get_message(status));
         return(status);
      }
      // Now quit the temporary buffer
      load_files('-bp +bi 'temp_buf_id);
      quit();
      load_files('-bp +bi 'first_buf_id);
#else
      while (!close_buffer());   // close-buffer works independent of "One-file-per-window" mode
      // Now load the new file list AND force the first file in the list to be the first displayed
      old_start_on_first=def_start_on_first;
      def_start_on_first=1;
      status=edit(params);
      def_start_on_first=old_start_on_first;   // QUICK - change it back
      if ( status ) {
         vi_message('Error loading new file list.  'get_message(status));
         return(status);
      }
#endif
   }
   if ( cmd!='' ) {
      status=ex_parse_and_execute(cmd);
      if ( status ) {
         return(status);
      }
   }
   
   return(0);
}


/* This function lists the addressed lines with preceding line numbers */
int __ex_number()
{
   return(__ex_print(arg(1),arg(2),arg(3),arg(4),arg(5),'','1'));   // The seventh argument tells __ex_print to number the lines of the list
}


/* This function prints a range of lines specified by the address given */
int __ex_print(...)
{
   params=strip(arg(1));   // This is a count of the lines to list
   a1=arg(2);
   a2=arg(3);
   // arg(4); not used
   delay_feedback=(arg(5)!='' && arg(5));
   show_tabs=__ex_set_list();
   show_end_of_lines=((arg(6)!='' && arg(6)) || (isinteger(show_tabs) && show_tabs>=1 && show_tabs<=2));
   number_lines=(arg(7)!='' && arg(7));
   use_ex_print_view_id=(arg(8)!='' && arg(8));   // Use the view id '_ex_print_view_id'?

   // Allocate a mark
   mark=_alloc_selection();
   if ( mark<0 ) {
      vi_message(get_message(mark));
      return(mark);
   }

   if( !use_ex_print_view_id ) {
      orig_view_id=p_view_id;
      if ( ! isinteger(a1) && ! isinteger(a2) ) {
         a1=ex_get_curlineno();
         a2=a1;
      } else {
         if ( ! isinteger(a1) ) {
            a1=ex_get_curlineno();
         }
         if ( ! isinteger(a2) ) {
            a2=ex_get_curlineno();
         }
      }
      if ( params!='' ) {
         if ( isinteger(params) ) {
            if ( params<=0 ) {
               vi_message('Positive count required');
               return(1);
            } else {
               // Make the beginning address the last address in the command prefix
               a1=a2;
               a2=a1+params-1;
               if ( a2>p_noflines ) {   // Is the count out of range
                  a2=p_noflines;
               }
            }
         } else {
            vi_message('Extra characters');
            return(1);
         }
      }
      // Now mark the lines to list
      p_line=a1;
      _select_line(mark,'P');
      p_line=a2;
      _select_line(mark,'P');
      // Create the view for selection-list
      if( delay_feedback ) {
         // Put marked lines into view specified by '_ex_print_view_id'
         if( !isinteger(_ex_print_view_id) ) {
            // Create one
            if( _create_temp_view(temp_view_id)=='' ) {
               _free_selection(mark);
               vi_message('Unable to load temporary list.');
               return(1);
            }
            _ex_print_view_id=temp_view_id;
            // Show tabs and end of lines?
            if( show_end_of_lines ) {
               p_ShowSpecialChars|=SHOWSPECIALCHARS_TABS;
               //p_show_tabs=1;
            }
            _delete_line();
         } else {
            p_view_id= (int)_ex_print_view_id;
            temp_view_id=_ex_print_view_id;
         }
      } else {
         if( _create_temp_view(temp_view_id)=='' ) {
            _free_selection(mark);
            vi_message('Unable to load temporary list.');
            return(1);
         }
         _delete_line();
         // Show tabs and end of lines?
         if( show_end_of_lines ) {
            p_ShowSpecialChars|=SHOWSPECIALCHARS_TABS;
            //p_show_tabs=1;
         }
      }
      bottom();
      _copy_to_cursor(mark);
      if( show_end_of_lines || number_lines ) {
         if( number_lines ) {
            line_number_width=length(p_noflines)+1;
         }
         _begin_select(mark);   // We do this instead of TOP because we could be inserting into this buffer more than once
         count=p_line-1;
         for(;;) {
            ++count;
            if ( number_lines ) {
               _begin_line();
               _insert_text(field(count,line_number_width));
            }
            if ( show_end_of_lines ) {
               _end_line();
               _insert_text('$');   // Put a '$' to mark the end of the line
            }
            if( down() ) break;
         }
      }
      _shift_selection_right(mark);
      _free_selection(mark)   // Can free this because it was never shown
      if ( delay_feedback ) {
         // Go back to original view
         p_view_id=orig_view_id;
         return(0);
      }
   }
   if( use_ex_print_view_id ) {
      show("-modal _sellist_form","Hit return to continue",SL_VIEWID,_ex_print_view_id);
   } else {
      p_view_id=orig_view_id;
      show("-modal _sellist_form","Hit return to continue",SL_VIEWID,temp_view_id);
   }
   if ( use_ex_print_view_id ) {
      _ex_print_view_id='';   // MUST CLEAR THIS!
   }
   
   return(0);
}

/* This function pastes line(s) from the clipboard */
typeless __ex_put()
{
   params=strip(arg(1));
   /* arg(2) not used */
   a2=arg(3);   // We are only interested in the last address
   /* arg(4) not used */
   /* arg(5) not used */
   if ( !isinteger(a2) ) {
      a2=ex_get_curlineno();
   }
   idx=find_index('vi-put-after-cursor',COMMAND_TYPE);
   if ( !idx ) {
      vi_message('Can''t find command: vi-put-after-cursor');
      return(1);
   }
   p_line=a2;
   count=1;
   cb_name=params;

   #if 1   // 4/21/1997 - Set the last index so that vi_repeat_info() knows to record the clipboard name
   last_index(idx);
   #endif

   return(call_index(count,cb_name,idx));
}


_str def_vi_quit_options='';   /* 'A'  = quit All buffers on ':q!'
                                * 'AX' = quit All buffers and eXit on ':q!'
                                */
/* This function quits the current buffer */
int __ex_quit(...)
{
   if( !p_mdi_child ) {
      ex_msg_editctl();
      return(1);
   }

   params=arg(1);
   if ( params!='' ) {
      vi_message('Extra characters');
      return(1);
   }
   /* arg(2) not used */
   /* arg(3) not used */
   use_variant_form=(arg(4)!='' && arg(4));
   
   if ( use_variant_form ) {
      if( pos('A',upcase(def_vi_quit_options)) ) {

         // Save the state of the editor
         status=save_window_config();
         if ( status ) {
            message get_message(status);
            return(status);
         }

         // Quit all the buffers
         while(1) {
            // Fake out close_buffer by turning the p_modify flag off
            p_modify=0;
            status=close_buffer();
            if( status ) break;
         }

         if( pos('X',upcase(def_vi_quit_options)) ) {   // Exit the editor?
            // Now setup to exit the editor
            status=save_all_forms();
            if (status) {
               return(status);
            }
            p_window_id=_mdi.p_child;
            if ( _process_info() ) {  // is a process running?
               if ( def_exit_process ) {
                  exit_process();
               } else {
                  message nls('Please exit concurrent process.');
                  return(1);
               }
            }
            exit_list();
            exit(0);   // Blow out of the editor
         }
      } else {
         // Fake out 'quit' by turning the p_modify flag off
         p_modify=0;
      }
   }
   quit();
   
   return(0);
}


/* This function reads in a file */
/* Can handle filenames with spaces if enclosed in double-quotes ("") */
int __ex_read()
{
   params=strip(arg(1));   // This is of the form: [file]|[!command]
   if ( params=='' ) {
      // No filename means use the current filename
      buf_name=p_buf_name;
      if ( buf_name=='' || buf_name=='*' ) {
         vi_message('No file name');
         return(1);
      }
      params=buf_name;
   }
   /* arg(2) not used - only concerned with last address */
   a2=arg(3);
   /* arg(4) not used */
   if ( ! isinteger(a2) ) {
      a2=ex_get_curlineno();
   }
   // Set the current line
   p_line=a2;
   // Get the current number of lines for comparison after the operation
   old_Noflines=p_noflines;
   // Check for a shell command or filename
   if ( substr(params,1,1)=='!' ) {
      // Shell command
      params=substr(params,2);
      if ( params=='' ) {
         vi_message("Incomplete shell escape command - use 'shell' to get a shell");
         return(1);
      }
      /* We are using __ex_shell_execute to read the output from the shell
       * command.  Because __ex_shell_execute replaces addressed lines and
       * inserts the output BEFORE the current line, we must insert a blank
       * line after the current line so that it will be replaced by the
       * shell output.
       */
      insert_line('');
      a2=ex_get_curlineno();
      status=__ex_shell_execute(params,a2,a2,'');
      if ( status ) {
         return(status);
      }
   } else {
      // Filename
      filename=parse_file(params);
      if ( params!='' ) {
         vi_message('Too many file names');
         return(1);
      }
      filename=file_match(filename,'1');
      if ( filename=='' ) {
         vi_message('No such file or directory');
         return(1);
      }
      old_line_insert=def_line_insert;
      def_line_insert='A';
      /* Now check if we are inserting the current buffer into itself.
       * We have to check this because 'get' won't work if this is the
       * case.
       */
      buf_name=p_buf_name;
      if ( buf_name==filename ) {
         temp_name=mktemp();
         p_buf_name=temp_name;
      }
      status=get(filename);
      def_line_insert=old_line_insert;   // QUICK change it back
      if ( buf_name==filename ) {
         p_buf_name=buf_name;
      }
      if ( status ) {
         vi_message(get_message(status));
         return(status);
      }
      down();
      vi_begin_text();   // Move down onto the newly inserted text
   }
   vi_message('"'p_buf_name'" '(p_noflines-old_Noflines)' lines');
   
   return(0);
}


/* This function undoes all changes you have made to the current buffer */
/* NOTE: Unlike the real vi, we deal with multiple buffers, and so it is
 * almost meaningless for this command to rewind to the first buffer in
 * the list since we keep a looped list of buffers
 */
int __ex_rewind()
{
   params=arg(1);   // This should be ''
   /* arg(2) not used */
   /* arg(3) not used */
   use_variant_form=(arg(4)!='' && arg(4));
      
   if ( !use_variant_form ) {
      select=nls_letter_prompt(nls('Undo all changes (~Y/~N)?'));
      if ( select!=1 ) {
         return(0);
      }
   }
   for (;;) {
      status=_undo();
      if ( (status&(MODIFY_FLAG_UNDONE)) || status==NOTHING_TO_UNDO_RC ) {
         break;
      }
   }
   clear_message();
   
   return(0);
}


definit()
{
   _ex_print_view_id='';
   
   if ( __ex_set_autoindent()=='' ) {
      __ex_set_autoindent(AUTOINDENT_DEFAULT);
   }
   if ( __ex_set_autoprint()=='' ) {
      __ex_set_autoprint(AUTOPRINT_DEFAULT);
   }
#if 0
   // Not supported
   if ( __ex_set_edcompatible()=='' ) {
      __ex_set_edcompatible(EDCOMPATIBLE_DEFAULT);
   }
#endif
   if ( __ex_set_errorbells()=='' ) {
      __ex_set_errorbells(ERRORBELLS_DEFAULT);
   }
   if ( __ex_set_ignorecase()=='' ) {
      __ex_set_ignorecase(IGNORECASE_DEFAULT);
   }
   if ( __ex_set_list()=='' ) {
      __ex_set_list(LIST_DEFAULT);
   }
   if ( __ex_set_number()=='' ) {
      __ex_set_list(NUMBER_DEFAULT);
   }
   if ( __ex_set_paragraphs()=='' ) {
      __ex_set_paragraphs(PARAGRAPHS_DEFAULT);
   }
   if ( __ex_set_prompt()=='' ) {
      __ex_set_prompt(PROMPT_DEFAULT);
   }
   if ( __ex_set_report()=='' ) {
      __ex_set_report(REPORT_DEFAULT);
   }
   if ( __ex_set_scroll()=='' ) {
      __ex_set_scroll(SCROLL_DEFAULT);
   }
   if ( __ex_set_sections()=='' ) {
      __ex_set_sections(SECTIONS_DEFAULT);
   }
   if ( __ex_set_shell()=='' ) {
      __ex_set_shell('');   // This must be set according to the OS
   }
   if ( __ex_set_shiftwidth()=='' ) {
      __ex_set_shiftwidth(SHIFTWIDTH_DEFAULT);
   }
   if ( __ex_set_showmatch()=='' ) {
      __ex_set_showmatch(SHOWMATCH_DEFAULT);
   }
   if ( __ex_set_showmode()=='' ) {
      __ex_set_showmode(SHOWMODE_DEFAULT);
   }
#if 0
   // Not supported
   if ( __ex_set_tabstop()=='' ) {
      __ex_set_tabstop(TABSTOP_DEFAULT);
   }
#endif
#if 0
   // Not supported
   if ( __ex_set_tags()=='' ) {
      __ex_set_tags(TAGS_DEFAULT);
   }
#endif
#if 0
   // Not supported
   if ( __ex_set_wrapmargin()=='' ) {
      __ex_set_wrapmargin(WRAPMARGIN_DEFAULT);
   }
#endif
   if ( __ex_set_writeany()=='' ) {
      __ex_set_writeany(WRITEANY_DEFAULT);
   }

   rc=0;
}
static typeless __ex_set_option(idx,...)
{
   val=strip(arg(2));
   if ( isinteger(idx) && idx ) {
      if ( val!='' ) {
         if( val=="''" || val=='""' ) {
            val='';
         }
         _set_var(idx,val);
         status=rc;
         if ( status ) {
            clear_message();
            info='';
         } else {
            info=val;
            _config_modify|=CFGMODIFY_DEFVAR;
         }
      } else {
         // Return the current value
         info=_get_var(idx);
      }
   } else {
      info='';
   }
   
   return(info);
}


#if 1
typeless __ex_set_autoindent()
{
   val=strip(arg(1));
   if( val=='' ) {
      // Return the current value
      val=(p_indent_style!=INDENT_NONE);
   } else {
      if( !isinteger(val) || !(val>=0 && val<=2) ) {
         vi_message('AUTOINDENT requires a value between 0 and 2');
         val='';
      } else {
         p_indent_style=val;
      }
   }
   
   return(val);
}
#endif
typeless __ex_set_autoprint()
{
   def_vi_or_ex_autoprint=def_vi_or_ex_autoprint;
   return(__ex_set_option(find_index('def-vi-or-ex-autoprint',VAR_TYPE),arg(1)));
}
typeless __ex_set_edcompatible()
{
   def_vi_or_ex_edcompatible=def_vi_or_ex_edcompatible;
   return(__ex_set_option(find_index('def-vi-or-ex-edcompatible',VAR_TYPE),arg(1)));
}
typeless __ex_set_errorbells()
{
   def_vi_or_ex_errorbells=def_vi_or_ex_errorbells;
   return(__ex_set_option(find_index('def-vi-or-ex-errorbells',VAR_TYPE),arg(1)));
}
typeless __ex_set_ignorecase()
{
   val=strip(arg(1));
   if ( val=='' ) {
      // Return the current value
      if ( upcase(_search_case())=='I' ) {
         val=1;
      } else {
         val=0;
      }
   } else {
      if ( ! val ) {
         _search_case('E');
      } else {
         _search_case('I');
      }
   }
   
   return(val);
}
typeless __ex_set_list()
{
   def_vi_or_ex_list=def_vi_or_ex_list;
   val=strip(arg(1));
   if ( val!='' ) {
      if ( isinteger(val) && val>=0 ) {
         first_buf_id=p_buf_id;
         for (;;) {
            if( val ) {
               p_ShowSpecialChars |= SHOWSPECIALCHARS_TABS;
            } else {
               p_ShowSpecialChars &= ~(SHOWSPECIALCHARS_TABS);
            }
            _next_buffer('H');   // 11/24/1997 - 'H' because might be an editor control
            for( ;p_buf_id!=first_buf_id && (p_buf_flags&HIDE_BUFFER); ) _next_buffer('H');
            if( p_buf_id==first_buf_id ) break;
         }
      } else {
         // Invalid value - return the current value
         vi_message('LIST requires a value greater than or equal to 0');
         val='';
      }
   }
   
   return(__ex_set_option(find_index('def-vi-or-ex-list',VAR_TYPE),val));
}
typeless __ex_set_number()
{
   val=strip(arg(1));
   if ( val=='' ) {
      // Return the current value
      val=p_line_numbers_len;
   } else {
      if ( !val ) {
         p_line_numbers_len=0;
      } else {
         p_line_numbers_len=LINE_NUMBERS_LEN;
      }
   }

   return(val);
}
typeless __ex_set_paragraphs()
{
   def_vi_or_ex_paragraphs=def_vi_or_ex_paragraphs;
   return(__ex_set_option(find_index('def-vi-or-ex-paragraphs',VAR_TYPE),arg(1)));
}
typeless __ex_set_prompt()
{
   def_vi_or_ex_prompt=def_vi_or_ex_prompt;
   return(__ex_set_option(find_index('def-vi-or-ex-prompt',VAR_TYPE),arg(1)));
}
typeless __ex_set_report()
{
   def_vi_or_ex_report=def_vi_or_ex_report;
   return(__ex_set_option(find_index('def-vi-or-ex-report',VAR_TYPE),arg(1)));
}
typeless __ex_set_scroll()
{
   def_vi_or_ex_scroll=def_vi_or_ex_scroll;
   val=strip(arg(1));
   if ( val=='' ) {
      // Return the current value
      val=def_vi_or_ex_scroll;
      if ( val=='' ) {
         // Return the default of 1/2 the mdi client height BUT do not set it
         val=ex_client_height() intdiv 2;
      }
      return(val);
   } else {
      if ( ! isinteger(val) || val<1 ) {
         vi_message('SCROLL requires a positive amount');
         val='';
         return(val);
      }
   }
   
   return(__ex_set_option(find_index('def-vi-or-ex-scroll',VAR_TYPE),val));
}
typeless __ex_set_sections()
{
   def_vi_or_ex_sections=def_vi_or_ex_sections;
   return(__ex_set_option(find_index('def-vi-or-ex-sections',VAR_TYPE),arg(1)));
}
typeless __ex_set_shell()
{
   def_vi_or_ex_shell=def_vi_or_ex_shell;
   val=strip(arg(1));
   if ( val=='' ) {
      // Return the current value
      val=def_vi_or_ex_shell;
      if ( val=='' ) {
#if __UNIX__
         val=get_env('SHELL');
#else
         val=get_env('COMSPEC');
#endif
      }
      return(val);
   }
   
   return(__ex_set_option(find_index('def-vi-or-ex-shell',VAR_TYPE),val));
}
typeless __ex_set_shiftwidth()
{
   def_vi_or_ex_shiftwidth=def_vi_or_ex_shiftwidth;
   return(__ex_set_option(find_index('def-vi-or-ex-shiftwidth',VAR_TYPE),arg(1)));
}
typeless __ex_set_showmatch()
{
   def_vi_or_ex_showmatch=def_vi_or_ex_showmatch;
   return(__ex_set_option(find_index('def-vi-or-ex-showmatch',VAR_TYPE),arg(1)));
}
typeless __ex_set_showmode()
{
   def_vi_or_ex_showmode=def_vi_or_ex_showmode;
   return(__ex_set_option(find_index('def-vi-or-ex-showmode',VAR_TYPE),arg(1)));
#if 0
// Not supported
typeless __ex_set_tabstop()
   def_vi_or_ex_tabstop=def_vi_or_ex_tabstop;
   return(__ex_set_option(find_index('def-vi-or-ex-tabstop',VAR_TYPE),arg(1)));
#endif
}
#if 0
// Not supported
typeless __ex_set_tags()
{
   def_vi_or_ex_tags=def_vi_or_ex_tags;
   val=strip(arg(1));
   vslicktags_val=get_env('VSLICKTAGS');
   if ( val=='' ) {
      val=vslicktags_val;
      if ( val=='' ) {
         val=TAGS_DEFAULT;
      }
      return(val);
   } else {
      if ( val!="''" && val!='""' && ! pos(val,vslicktags_val,1,'i') ) {
         if ( last_char(val)!=PATHSEP ) {
            val=val:+PATHSEP;
         }
         val=val:+vslicktags_val;
      }
   }
   if( val=="''" || val=='""' ) {
      set_env('VSLICKTAGS','');
   } else {
      set_env('VSLICKTAGS',val);
   }
   
   return(__ex_set_option(find_index('def-vi-or-ex-tags',VAR_TYPE),val));
}
#endif
#if 0
// Not supported
typeless __ex_set_wrapmargin()
{
   val=arg(1);
   if ( val=='' ) {
      // Return the current value
      parse p_margins with . val .;   // 'val' contains the right margin
      wws=p_word_wrap_style&WORD_WRAP_WWS;
      if ( !wws ) {
         val=0;
      }
   } else {
      parse p_margins with left_margin right_margin para;   // 'val' contains the right margin
      if ( isinteger(val) && val>0 && val<=MAX_LINE ) {
         word_wrap('Y');
         p_margins=left_margin' 'val' 'para;
      } else if ( val==0 ) {
         word_wrap('N');
      } else {
         vi_message('WRAPMARGIN requires a value between 0 and 'MAX_LINE);
         wws=p_word_wrap_style&WORD_WRAP_WWS;
         if ( wws ) {
            val=right_margin;
         } else {
            val=0;
         }
      }
   }
   
   return(val);
}
#endif
typeless __ex_set_writeany()
{
   def_vi_or_ex_writeany=def_vi_or_ex_writeany;
   return(__ex_set_option(find_index('def-vi-or-ex-writeany',VAR_TYPE),arg(1)));
}


/* This function is a match function for an ex set option */
typeless set_match(name,find_first)
{
   if ( find_first ) {
      _set_match_pos=1;
      if ( find_first==2 ) {
         return('');
      }
   }
   info='';
   name=upcase(strip(name));
   p=pos(' 'name'={#0[~ \t]#} ',SET_ABBR_NAMES,1,'r');
   if( p ) {
      name=substr(SET_ABBR_NAMES,pos('S0'),pos('0'));
   }
   q=pos('{#0 'name'[~ \t]@ }',SET_NAMES,_set_match_pos,'er');
   if ( q ) {
      _set_match_pos=q+pos('0')-1;   // Next match occurs at the trailing space
      info=strip(substr(SET_NAMES,pos('S0'),pos('0')));
   } else if( p ) {   // Was it a valid abbreviation?
      info=name;
   }
   
   return(info);
}


/* This function is a match function for an ex set option */
/* This function formats the return value to display the current value
 * as vi would display it if a 'set all' was issued from the ex command
 * line.  The format is as follows:  set option
 *                                   set nooption
 *                                   set option=value
 */
typeless set2_match(name,find_first)
{
   if ( find_first ) {
      _set_match_pos=1;
      if ( find_first==2 ) {
         return('');
      }
   }
   name=upcase(strip(name));
   p=pos(' 'name'={#0[~ \t]#} ',SET_ABBR_NAMES,1,'r');
   if ( p ) {
      name=substr(SET_ABBR_NAMES,pos('S0'),pos('0'));
   }
   p=pos('{#0 'name'[~ \t]@ }',SET_NAMES,_set_match_pos,'er');
   if ( p ) {
      _set_match_pos=p+pos('0')-1;   // Next match occurs at the trailing space
      info=strip(substr(SET_NAMES,pos('S0'),pos('0')));
      proc_name='--ex-set-':+lowcase(info);
      idx=find_index(proc_name,PROC_TYPE);
      if ( !idx ) {
         vi_message('Can''t find procedure: 'proc_name);
         return('');
      }
      val=call_index(idx);
      if ( pos(' 'info' ',SET_TOGGLE_NAMES) ) {
         if ( val==0 ) {
            info='NO':+info;
         }
      } else {
         info=info:+'='val;
      }
      return(info);
   }
   
   return('');
}


/* This function sets various options */
typeless __ex_set()
{
   params=upcase(strip(arg(1)));    /* This is of the form: set option
                                     *                      set nooption
                                     *                      set option=value
                                     */
   /* arg(2) not used */
   /* arg(3) not used */
   /* arg(4) not used */
   
   display_current_val=0;
   is_toggle_name=0;
   if ( params=='' || params=='ALL' ) {
      list_matches('',SET2_ARG);   // List names AND values
   } else {
      p=pos('=',params);
      if ( p && p<length(params) ) {
         parse params with name '=' val;
      } else if ( substr(params,1,2)=='NO' ) {
         name=substr(params,3);
         val=0;
      } else {
         // There is no value
         lc=last_char(params);
         if ( lc=='?' || lc=='=' ) {
            // Display the current value
            display_current_val=1;
            params=substr(params,1,length(params)-1);
         }
         name=params;
         val='';   // Toggle ON or display current value
      }
      set_name=name;
      if ( set_name!='' ) {
         set_name=set_match(set_name,'1');   // This takes care of aliases
      } else {
         vi_message(name":  No such option - 'set all' gives all option values");
         return(1);
      }

      if ( pos(' 'set_name' ',SET_NOT_SUPPORTED_NAMES) || pos(' 'name' ',SET_NOT_SUPPORTED_NAMES) ) {
         _message_box(name":  Option not supported - 'set all' gives all option values\n":+
                      "\n":+
                      "There are 2 possible reasons:\n":+
                      "\n":+
                      "\t1. Does not make sense to support the option.\n":+
                      "\n":+
                      "\t\t Example: TERM option for setting terminal type\n":+
                      "\n\n":+
                      "\t2. Visual SlickEdit provides the option in a better format",
                      'Option not supported',MB_OK|MB_ICONINFORMATION);
         vi_message(name":  Option not supported - 'set all' gives all option values");
         return(1);
      } else if( set_name=='' ) {
         vi_message(name":  No such option - 'set all' gives all option values");
         return(1);
      }

      if ( pos(' 'set_name' ',SET_TOGGLE_NAMES) ) {
         is_toggle_name=1;
         if ( val=='' ) {   // Toggle ON or display current value?
            if ( !display_current_val ) {
               // Toggle ON
               val=1;
            }
         } else {
            if ( val!='0' ) {
               vi_message('Option 'set_name' is a toggle');
               return(1);
            }
         }
      }
      proc_name='--ex-set-':+lowcase(set_name);
      idx=find_index(proc_name,PROC_TYPE);
      if ( !idx ) {
         vi_message('Can''t find procedure: 'proc_name);
         return(1);
      }
      if ( val=='' ) {
         // Display the current value
         val=call_index(idx);
         if ( is_toggle_name ) {
            if ( !val ) {
               set_name='NO':+set_name;
            }
            vi_message(set_name);
         } else {
            vi_message(set_name'='call_index(idx));
         }
      } else {
         // Set the value
         call_index(val,idx);
      }
   }
   
   return(0);
}


_str def_vi_substitute_options='';   /* 'R' = process e,E,l,L,u,U in
                                      *       replace string
                                      */

/* This handles 'substitute' on the ex command line */
int __ex_substitute(...)
{
   params=arg(1);
   a1=arg(2);
   a2=arg(3);
   /* arg(4) not used */
   delay_feedback=(arg(5)!='' && arg(5));
   repeat_last_substitute=(arg(6)!='' && arg(6));
   
   if ( repeat_last_substitute ) {
      params='';
   }
   print_cmd='';   // If a 'P' or 'L' option is given then the name of the matching command is stored here
   if ( !isinteger(a1) && !isinteger(a2) ) {
      a1=ex_get_curlineno();
      a2=a1;
   } else {
      if ( !isinteger(a1) ) {
         a1=ex_get_curlineno();
      }
      if ( !isinteger(a2) ) {
         a2=ex_get_curlineno();
      }
   }
   search_string='';
   if ( params=='' ) {
      if ( old_search_string:=='' ) {
         vi_message('No previous substitute');
         return(1);
      } else {
         //search_flags=(old_search_flags &~(POSITIONONLASTCHAR_SEARCH|INCREMENTAL_SEARCH));
         if ( repeat_last_substitute ) {
            search_flags='*':+_vi_search_type():+'m';
         }
      }
   } else {
      old_old_replace_string=old_replace_string;   /* Save this for the case
                                                    * of '~' in the replace
                                                    * string
                                                    */
      #if 1
      search_string='';   // At the end of the loop, this will hold the entire search expression
      len=length(params);
      i=1;
      delim=substr(params,i,1);
      #if 0   // Will get "Invalid delimeter" message if using alternate delim (i.e. $)
      if ( !pos(delim,'/?') ) {   // Is this a valid delimiter?
         vi_message('Invalid delimiter');
         return(1);
      }
      #endif

      // Get the search string
      ++i;
      for (;;) {
         if ( i>len ) break;
         ch=substr(params,i,1);
         if( _dbcsIsLeadByte(ch) ) {
            ch=substr(params,i,2);
            ++i;   // Only increment by 1 so that the final increment will get it right
         }
         if ( ch==delim ) {
            break;
         } else if ( ch=='\' ) {
            ch=substr(params,i+1,1);
            if( _dbcsIsLeadByte(ch) ) {
               ch=substr(params,i,3);
               ++i;   // Only increment by 1 so that the final increment will get it right
            } else {
               ch=substr(params,i,2);
            }
            search_string=search_string:+ch;   // Get the skipped over char
            i=i+2;   // Skip over the escaped character
         } else {
            search_string=search_string:+ch;
            i=i+1;
         }
      }

      // Now get the replace string
      old_replace_string='';
      ++i;
      for (;;) {
         if ( i>len ) break;
         ch=substr(params,i,1)
         if( _dbcsIsLeadByte(ch) ) {
            ch=substr(params,i,2);
            ++i;   // Only increment by 1 so that the final increment will get it right
         }
         if ( ch==delim ) {
            break;
         } else if ( ch=='\' ) {
            ch=substr(params,i+1,1);
            if( _dbcsIsLeadByte(ch) ) {
               ch=substr(params,i,3);
               ++i;   // Only increment by 1 so that the final increment will get it right
            } else {
               ch=substr(params,i,2);
            }
            old_replace_string=old_replace_string:+ch;   // Get the skipped over char
            i=i+2;   // Skip over the escaped character
         } else {
            old_replace_string=old_replace_string:+ch
            ++i;
         }
      }

      // Now get the search flags
      search_flags=substr(params,i+1);
      //messageNwait('search_string='search_string'  old_replace_string='old_replace_string'  search_flags='search_flags);
      #else
      parse params with  1 delim +1 search_string (delim) old_replace_string (delim) search_flags;
      #endif

      if( pos('R',upcase(def_vi_substitute_options),1,'e') ) {
         _ex_process_replace_string(old_replace_string,old_old_replace_string);
      }

      if( !pos('i|e',search_flags,1,'ri') ) {
         search_flags=search_flags:+_search_case();   // Use the default search-case sensitivity
      }
      if ( ! pos('r|b|u',search_flags,1,'ri') ) {
         search_flags=search_flags:+_vi_search_type();   // This is always a regular expression search
      }
      if ( ! pos('m',search_flags,1,'i') ) {
         search_flags=search_flags:+'m';
      }
      if ( pos('{c}',search_flags,1,'ri') ) {
         search_flags=substr(search_flags,1,pos('S0')-1):+substr(search_flags,pos('S0')+1);
      } else {
         search_flags=search_flags:+'*';
      }
      if ( pos('{p|l}',search_flags,1,'ri') ) {
         print_cmd=substr(search_flags,pos('S0'),pos('0'));   // Print current line after substitution
         search_flags=substr(search_flags,1,pos('S0')-1):+substr(search_flags,pos('S0')+1);
         print_cmd=ex_match(print_cmd,EX_ARG);   // Expand the option to an ex command name
         ex_match('','2');   // Reset
      }
   }
   //messageNwait('search_flags='search_flags);
   if ( search_string:!='' ) {
      old_search_string=search_string;
   }

   if( pos('R',upcase(def_vi_substitute_options),1,'e') ) {
      if( pos('r',search_flags,1,'i') ) {
         old_search_string='{#0':+old_search_string:+'}';
      } else if( pos('b',search_flags,1,'i') ) {
         old_search_string='{@0':+old_search_string:+'}';
      } else {
         old_search_string='(?0':+old_search_string:+')';
      }
   }

   // Set the step for the for() loop
   if ( a1>a2 ) {
      step= -1;
   } else {
      step=1;
   }
   // Allocate the mark we will use for substituting
   old_mark=_duplicate_selection('');
   mark=_alloc_selection();
   if ( mark<0 ) {
      vi_message(get_message(mark));
      return(mark);
   }
   _show_selection(mark);
   // Check for the 'G' flag - means replace all occurrences of 'old_search_string' on the line
   replace_all=0;   // Replace all occurrences on the line?
   if ( pos('{g}',search_flags,1,'ri') ) {
      // Replace all occurrences on a line
      replace_all=1;
      search_flags=substr(search_flags,1,pos('S0')-1):+substr(search_flags,pos('S0')+pos('0'));
   }
   lines_matched=0;
   last_line=0;
   //for (i=a1; i<=a2 ; i=i+step) {
   for (i=a1;i!=a2+step;i=i+step) {   /* We must use 'i!=a2+step' for the case
                                       * of a1 (the first address) > a2
                                       */
      p_line=i;
      _begin_line();   // Be sure to start the search at the beginning of the line
      _deselect(mark);
      if ( !replace_all ) {   // Don't replace all occurrences on the line?
         get_line(line);
         if( upcase(_vi_search_type())=='U' ) {
            p=pos('(?1'old_search_string')',line,1,'u':+_search_case());
         } else if( upcase(_vi_search_type())=='B' ) {
            p=pos('{@1'old_search_string'}',line,1,'b':+_search_case());
         } else {
            p=pos('{#1'old_search_string'}',line,1,'r':+_search_case());
         }
         if ( p ) {
            p_col=_text_colc(p,'I');
            _select_block(mark,'P');   // We do a block-mark because 'qreplace' doesn't like characer-marks
            p_col=_text_colc(p+pos('1')-1,'I');
            if( get_text():=="\t" ) {   // Are we sitting at the beginning of tab?
               // Select the entire tab
               right();
               --p_col;
            }
            //p_col=p_col+pos('1')-1;
            _select_block(mark,'P');
            _begin_select(mark);   // Must start searching at beginning of mark or will fail
         } else {
            status=STRING_NOT_FOUND_RC;
            continue;
         }
      } else {
         _select_line(mark,'P');
      }
      //messageNwait(old_search_string'|'search_flags'|'old_replace_string);

      #if 1   /* Have to do this because calling the search() built-in will put the
               * cursor on the next line for some reason.
               */
      old_line=p_line;
      status=qreplace(old_search_string,old_replace_string,search_flags'@');
      if( p_line!=old_line ) {
         p_line=old_line;
      }
      _begin_line();
      #else
      status=qreplace(old_search_string,old_replace_string,search_flags'@');
      #endif
      if ( !status ) {
         lines_matched=lines_matched+1;
         last_line=p_line;
      } else {
         if( status!=STRING_NOT_FOUND_RC ) {
            break;
         } else {
            clear_message();   // Clear the message so we don't see it during long searches
         }
      }
   }
   // Don't forget to restore the previous mark
   _show_selection(old_mark);
   _free_selection(mark);
   if ( status ) {
      if ( status==STRING_NOT_FOUND_RC ) {
         if ( a1==a2 || ! lines_matched ) {
            vi_message(get_message(status));
         } else {
            clear_message();
         }
         status=0;   // Not a serious error
      }
   } else {
      clear_message();
   }
   save_search(dummy,old_search_flags,dummy);
   if( last_line ) {
      p_line=last_line;
   }
   if ( (print_cmd=='PRINT' || print_cmd=='LIST' || __ex_set_autoprint()) ) {
      if ( print_cmd=='LIST' ) {
         status=__ex_print('','','','',delay_feedback,'1');  // Show end of line
      } else {
         status=__ex_print('','','','',delay_feedback);   // Just print the line
      }
   }
   
   return(status);
}


#if 1
// This handles 'sg' on the ex command line
// Equivalent to :s//g
int __ex_sg(...)
{
   return(__ex_substitute('//':+old_replace_string:+'/g',arg(2),arg(3),'','',''));
}
#endif


static int _ex_process_replace_string(_str &rstr,prev_rstr)
{
   /* 'prev_rstr' saves a copy of the previous replace string for '~' OR
    * if there are problems
    */

   // At end of the loop, 'rstr' will hold the evaluated replace expression
   pending_op='';
   len=length(rstr);
   i=1;
   for (;;) {
      if ( i>len ) break;
      ch=substr(rstr,i,1);
      if( _dbcsIsLeadByte(ch) ) {
         ch=substr(rstr,i,2);
         ++i;   // Only increment by 1 so that the final increment will get it right
      }
      if( ch=='\' ) {
         ++i;
         ch=substr(rstr,i,1);
         if( _dbcsIsLeadByte(ch) ) {
            ch=substr(rstr,i,2);
            ++i;   // Only increment by 1 so that the final increment will get it right
         }
         escape_ch=ch;
         if( pos(escape_ch,'eElLuU',1,'e') ) {
            /* Now evaluate the \e, \E, \l, \L, \u, or \U in the
             * replacement string.
             */
            ++i;
            ch=substr(rstr,i,1);
            switch( escape_ch ) {
            case 'E':
            case 'e':
               if( pending_op!='' ) {
                  pending_op='';
               }
               rstr=substr(rstr,1,i-3):+substr(rstr,i);
               break;
            case 'L':
               pending_op='L';
            case 'l':
               if( ch=='~' ) {
                  rstr=substr(rstr,1,i-1):+prev_rstr:+substr(rstr,i+1);
                  len=len+length(prev_rstr)-1;
                  i=i-2;   /* Put i back on the \l or \L and reprocess */
                  continue;
               }
               ch=lowcase(ch);
               if( _dbcsIsLeadByte(ch) ) {
                  ch=substr(rstr,i,2);
                  rstr=substr(rstr,1,i-3):+ch:+substr(rstr,i+2);
               } else {
                  rstr=substr(rstr,1,i-3):+ch:+substr(rstr,i+1);
               }
               break;
            case 'U':
               pending_op='U';
            case 'u':
               if( ch=='~' ) {
                  rstr=substr(rstr,1,i-1):+prev_rstr:+substr(rstr,i+1);
                  len=len+length(prev_rstr)-1;
                  i=i-2;   // Put i back on the \l or \L and reprocess
                  continue;
               }
               ch=upcase(ch);
               if( _dbcsIsLeadByte(ch) ) {
                  ch=substr(rstr,i,2);
                  rstr=substr(rstr,1,i-3):+ch:+substr(rstr,i+2);
               } else {
                  rstr=substr(rstr,1,i-3):+ch:+substr(rstr,i+1);
               }
               break;
            default:
               rstr=prev_rstr;   // Set it back to its previous value
               vi_message('should not get here');
               return(1);
            }

            // Adjust the length and current pos within replace string
            len-=2;
            i-=2;

            continue;
         } else {
            // The escaped char will be skipped over
         }
      } else if( ch=='&' ) {
         rstr=substr(rstr,1,i-1):+'#0':+substr(rstr,i+1);
         ++len;
         i+=2;
         continue;
      } else if( ch=='~' ) {
         rstr=substr(rstr,1,i-1):+prev_rstr:+substr(rstr,i+1);
         len=len+length(prev_rstr)-1;
         continue;
      }

      if( pending_op!='' && isalpha(ch) ) {
         if( pending_op=='L' ) {
            ch=lowcase(ch);
         } else {
            ch=upcase(ch);
         }
         rstr=substr(rstr,1,i-1):+ch:+substr(rstr,i+1);
      }
      ++i;
   }
   
   return(0);
}

/* By default this handles '!' pressed */
_command ex_repeat_last_substitute () name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   return(__ex_substitute('','','','','','1'));
}


/* This function forks a shell */
int __ex_shell()
{
   params=arg(1);
   if ( params!='' ) {
      vi_message('Extra characters');
      return(1);
   }
   /* arg(2) not used */
   /* arg(3) not used */
   /* arg(4) not used */
   
   sh=__ex_set_shell();
   if ( sh=='' ) {
      // Run the default shell
      execute('dos',"");
   } else {
      shell('','A',sh);
   }
   
   return(0);
}


/* This function (as far as we can tell), behaves the same as COPY */
int __ex_t()
{
   return(__ex_copy(arg(1),arg(2),arg(3),arg(4),arg(5),'0'));
}


/* This function puts cursor on the tag specified in 'params' */
int __ex_tag()
{
   params=arg(1);
   /* arg(2) not used */
   /* arg(3) not used */
   use_variant_form=(arg(4)!='' && arg(4));   // This does nothing
      
   if ( params=='' ) {
      status=pop_bookmark();
   } else {
      status=push_tag(params);
   }
   
   return(status);
}


/* This function deletes an abbreviation (alias) */
int __ex_unabbreviate()
{
   params=strip(arg(1));
   if ( params=='' ) {
      vi_message('No right hand side');
      return(1);
   }
   /* arg(2) not used */
   /* arg(3) not used */
   /* arg(4) not used */
   
   return(alias('-d 'params));
}


/* This function undoes changes in the current buffer */
typeless __ex_undo()
{
   params=strip(arg(1));
   /* arg(2) not used */
   /* arg(3) not used */
   /* arg(4) not used */
   /* arg(5) not used */
   if ( params!='' ) {
      vi_message('Extra characters');
      return(1);
   }
   idx=find_index('undo',COMMAND_TYPE);
   if ( ! idx ) {
      vi_message('Can''t find command: undo');
      return(1);
   }
   status=call_index(idx);
   
   return(status);
}


/* This function is the equivalent of a ':g!' */
typeless __ex_v()
{
   last_index(find_index('--ex-global',PROC_TYPE));   // Set this so GLOBAL does not recurse
   
   return(__ex_global(arg(1),arg(2),arg(3),'1'));
}


/* This function writes a file out */
int __ex_write(...)
{
   if( !p_mdi_child ) {
      ex_msg_editctl();
      return(1);
   }

   params=strip(arg(1));   /* This takes the form:  filename
                            *                       >>filename
                            *                       !command       addressed lines become input to command
                            */
   append_to_file=0;
   pipe_to_command=0;
   if ( substr(params,1,2)=='>>' ) {
      append_to_file=1;
      params=strip(substr(params,3));   // Take what is after the '>>'
      if ( params=='' ) {
         vi_message('Missing filename');
         return(1);
      }
   } else if ( substr(params,1,1)=='!' ) {
      pipe_to_command=1;
      params=strip(substr(params,2));   // Take what is after the '!'
   }
   a1=arg(2);
   a2=arg(3);
   writeany=__ex_set_writeany();
   use_variant_form=((arg(4)!='' && arg(4)) || (writeany!='' && writeany));
   /* arg(5) not used */
   if ( !pipe_to_command && !append_to_file && params=='' &&
        !isinteger(a1) && ! isinteger(a2) ) {
      // Simply save the file
      if ( use_variant_form ) {
         old_preplace=def_preplace;
         def_preplace=0;
         status=save();
         def_preplace=old_preplace;   // QUICK - change it back!
      } else {
         status=save();
      }
   } else {
      // Get the address range
      if ( !isinteger(a1) && !isinteger(a2) ) {
         // The whole buffer
         a1=1;
         a2=p_noflines;
      } else {
         if ( !isinteger(a1) ) {
            a1=ex_get_curlineno();
         }
         if ( !isinteger(a2) ) {
            a2=ex_get_curlineno();
         }
      }
      // Now mark the lines to save
      old_mark=_duplicate_selection('');
      mark=_alloc_selection();
      if ( mark<0 ) {
         vi_message(get_message(mark));
         return(mark);
      }
      _show_selection(mark);
      p_line=a1;
      _select_line(mark,'P');
      p_line=a2;
      _select_line(mark,'P');
      if ( pipe_to_command ) {
         temp=mktemp();
         if ( temp=='' ) {
            vi_message('Unable to create temporary file');
            return(1);
         }
         temp=absolute(temp);
         status=put(temp);
         if ( status ) {
            return(status);
         }
         params=params'<'temp;
         status=__ex_shell_execute(params,'','');
         delete_file(temp);
      } else {
         filename=parse_file(params);
         if ( params!='' ) {
            vi_message('Too many file names');
            return(1);
         }
         if ( use_variant_form ) {
            old_preplace=def_preplace;
            def_preplace=0;   // Turn off warnings
         }
         if ( append_to_file ) {
            status=append(filename);
         } else {
            if( filename=='' ) {
               filename=p_buf_name;   // Use the current filename
            }
            status=put(filename,PAUSE_COMMAND);
            if( p_buf_name=='' && filename!='' ) {
               p_buf_name=filename;
               p_modify=0;
            }
         }
         if ( use_variant_form ) {
            def_preplace=old_preplace;
         }
      }
      _show_selection(old_mark);
      _free_selection(mark);
   }
   
   return(status);
}


/* This function gives the version of SlickEdit */
typeless __ex_version()
{
   return(version())
}


/* This function works identically to '__ex_write' but also quits the current buffer */
int __ex_wq(...)
{
   if( !p_mdi_child ) {
      ex_msg_editctl();
      return(1);
   }

   params=strip(arg(1));
   a1=arg(2);
   a2=arg(3);
   use_variant_form=(arg(4)!='' && arg(4));
   /* arg(5) not used */
   
   status=__ex_write(params,a1,a2,use_variant_form);
   if ( !status ) {
      status=__ex_quit('','','',use_variant_form);
   }
   
   return(status);
}


/* This function works identically to a 'wq' */
int __ex_x()
{
   if( !p_mdi_child ) {
      ex_msg_editctl();
      return(1);
   }

   return(__ex_wq(arg(1),arg(2),arg(3),arg(4),arg(5)));
}


/* This function copies line(s) to the clipboard */
typeless __ex_yank()
{
   params=strip(arg(1));
   a1=arg(2);
   a2=arg(3);
   /* arg(4) not used */
   /* arg(5) not used */
   if ( !isinteger(a1) && !isinteger(a2) ) {
      a1=ex_get_curlineno();
      a2=a1;
   } else {
      if ( !isinteger(a1) ) {
         a1=ex_get_curlineno();
      }
      if ( !isinteger(a2) ) {
         a2=ex_get_curlineno();
      }
   }
   cb_name='';
   count='';
   if ( params!='' ) {
      #if 1
      parse params with cb_name rest;
      if( rest!='' ) {
         vi_message('Extra characters');
         return(1);
      }
      cb_name=params;
      #else
      parse params with first second;
      if ( second!='' ) {
         cb_name=first;
         count=second;
      } else {
         if ( isinteger(first) ) {
            count=first;
         }
      }
      if ( isinteger(count) ) {
         if ( count<=0 ) {
            vi_message('Positive count required');
            return(1);
         } else {
            // Make the beginning address the last address in the command prefix
            a1=a2;
            a2=a1+count-1;
            if ( a2>p_noflines ) {   /* Is the count out of range */
               a2=p_noflines;
            }
         }
      } else {
         vi_message('Extra characters');
         return(1);
      }
      #endif
   }

   // Now try finding vi-yank-line
   idx=find_index('vi-yank-line',COMMAND_TYPE);
   if ( !idx ) {
      vi_message('Can''t find command: vi-yank-line');
      return(1);
   }
   save_pos(p);
   p_line=a1;   // The YANK will start from this address
   count=a2-a1+1;
   last_index(idx);   // Set this so vi_repeat_info knows to record
   status=call_index(count,cb_name,idx);
   if ( !status ) {
      vi_message(count' lines');
   }
   restore_pos(p);
   
   return(status);
}



/* This function displays the addressed lines */
int __ex_z()
{
   params=strip(arg(1));
   /* arg(2) not used */
   a2=arg(3);   // Only interested in last address
   /* arg(4) not used */
   /* arg(5) not used */
   
   if ( params=='' ) {
      params=p_char_height intdiv 2;
   }
   if ( !isinteger(a2) ) {
      a2=ex_get_curlineno()+1;
   }
   if ( a2>p_noflines ) {
      vi_message('Not that many lines in buffer');
      return(1);
   }
   
   return(__ex_print(params,a2,a2,'','','','',''));
}


/* This command is equivalent to a 'wq!' and handles 'ZZ' by default */
_command ex_zz() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if( command_state() ) {
      key=last_event();
      if( length(key):==1 ) {
         keyin(key);
      }
      return(0);
   }

   if( !p_mdi_child ) {
      ex_msg_editctl();
      return(1);
   }

   status=0;
   key1=last_event();
   key2=get_event();
   if( key1:!=key2 ) {
      vi_message('Invalid key sequence');
      status=1;
   } else {
      status=__ex_wq('','','','1');   // The '1' is so that __ex_wq uses the variant form
   }
   
   return(status);
}

/* This procedure handles '<','>' pressed in ex mode */
static int ex_shift_text(option,...)
{
   option=upcase(strip(option));
   params=arg(2);
   a1=arg(3);
   a2=arg(4);
   if( !isinteger(a1) && !isinteger(a2) ) {
      a1=ex_get_curlineno();
      a2=a1;
   } else {
      if( !isinteger(a1) ) {
         a1=ex_get_curlineno();
      }
      if( !isinteger(a2) ) {
         a2=ex_get_curlineno();
      }
   }
   if( a2<a1 ) {
      // Backwards range, reverse it
      temp=a1;
      a1=a2;
      a2=temp;
   }
   
   if ( params!='' ) {
      if ( isinteger(params) ) {
         if ( params<1 ) {
            vi_message('< > requires a positive count');
            return(1);
         } else {
            a1=a2;   // We only use the last address when we have a count
            count=params;
         }
      } else {
         vi_message('Extra characters');
         return(1);
      }
   } else {
      count=a2-a1+1;   // Total number of lines affected
   }

   shiftwidth=def_vi_or_ex_shiftwidth;
   if ( !isinteger(shiftwidth) || shiftwidth<1 ) {
      shiftwidth=SHIFTWIDTH_DEFAULT;   // This is the real vi default value
   }

   // Now shift the text
   p_line=a1;
   up();   // Start on the line above so the FOR loop works correctly
   for (i=1; i<=count ; ++i) {
      down();
      if( !_line_length() ) continue;
      first_non_blank();
      if ( option:=='-' ) {
         // Shifting left
         shift_amount=shiftwidth;
         if ( shiftwidth>(p_col-1) ) {
            shift_amount=p_col-1;
         }
         if ( p_col>1 ) {
            lead_indent=_expand_tabsc(1,p_col-shift_amount-1,'S');
            dcount=p_col-1;
            _begin_line();
            _delete_text(dcount,'C');   // Strip leading spaces
            _insert_text(lead_indent);
         }
      } else {
         // Shifting right
         if ( (_text_colc()+shiftwidth) > MAX_LINE ) {
            vi_message('This line cannot be shifted because it would exceed the line length limit!');
            return(1);
         }
         first_non_blank();
         lead_indent=indent_string(shiftwidth+p_col-1);   // The new indent
         dcount=p_col-1;
         _begin_line();
         _delete_text(dcount,'C');   // Strip leading spaces
         _insert_text(lead_indent);
      }
   }
   //up (count-1);
   first_non_blank();
   
   return(0);
}


/* This function shifts text left by shiftwidth */
/* < */
int __ex_shift_text_left(...)
{
   params=arg(1);   // Don't care about params
   a1=arg(2);
   a2=arg(3);
   /* arg(4); not used */
   /* arg(5); not used */
   
   status=ex_shift_text('-',params,a1,a2);

   return(status);
}

/* This function shifts text right by shiftwidth */
/* > */
int __ex_shift_text_right(...)
{
   params=arg(1);   // Don't care about params
   a1=arg(2);
   a2=arg(3);
   /* arg(4); not used */
   /* arg(5); not used */
   
   status=ex_shift_text('',params,a1,a2);

   return(status);
}

