#include 'slick.sh'
#include 'diff.sh'

void _diffedit_UpdateForm();
static boolean in_cua_select;
static DIFF_UPDATE_INFO gDiffUpdateInfo={-1};
static int LastActiveEditWindowWID=0;

static typeless DiffCommands:[]={
   "wh"                        =>wh,
   "list-symbols"              =>list_symbols,
   "function-argument-help"    =>function_argument_help,
   "quote-key"                 =>diff_quote_key,
   "maybe-complete"            =>diff_maybe_complete,
   "split-insert-line"         =>diff_mode_split_insert_line,
   "maybe-split-insert-line"   =>diff_mode_split_insert_line,
   "rubout"                    =>diff_rubout,
   "linewrap-rubout"           =>diff_linewrap_rubout,
   "linewrap-delete-char"      =>diff_linewrap_delete_char,
   "delete-char"               =>diff_delete_char,
   "cut-line"                  =>diff_cut_line,
   "join-line"                 =>diff_join_line,
   "cut"                       =>diff_cut_line,
   "delete-line"               =>diff_delete_line,
   "brief-delete"              =>diff_linewrap_delete_char,
   "paste"                     =>diff_paste,
   "brief-paste"               =>diff_paste,
   "find-next"                 =>diff_find_next,

   "c-enter"                   =>diff_mode_split_insert_line,
   "c-space"                   =>diff_mode_space,

   "slick-enter"               =>diff_mode_split_insert_line,
   "slick-space"               =>diff_mode_space,

   "cmd-enter"                 =>diff_mode_split_insert_line,
   "cmd-space"                 =>diff_mode_space,

   "for-enter"                 =>diff_mode_split_insert_line,
   "for-space"                 =>diff_mode_space,

   "sql-enter"                 =>diff_mode_split_insert_line,
   "sql-space"                 =>diff_mode_space,

   "plsql-enter"               =>diff_mode_split_insert_line,
   "plsql-space"               =>diff_mode_space,

   "sqlserver-enter"           =>diff_mode_split_insert_line,
   "sqlserver-space"           =>diff_mode_space,

   "pascal-enter"              =>diff_mode_split_insert_line,
   "pascal-space"              =>diff_mode_space,

   "prg-enter"                 =>diff_mode_split_insert_line,
   "prg-space"                 =>diff_mode_space,

   "expand-alias"              =>diff_expand_alias,

   "undo"                      =>diff_undo,
   "undo-cursor"               =>diff_undo_cursor,
   "select-line"               =>diff_select_line,
   "brief-select-line"         =>diff_select_line,
   "select-char"               =>diff_select_char,
   "brief-select-char"         =>diff_select_char,
   "cua-select"                =>diff_cua_select,
   "deselect"                  =>diff_deselect,
   "shift-selection-right"     =>diff_shift_selection_right,
   "shift-selection-left"      =>diff_shift_selection_left,
   "copy-to-clipboard"         =>diff_copy_to_clipboard,
   "copy-word"                 =>diff_copy_word,

   "next-window"               =>diff_next_window,
   "prev-window"               =>diff_next_window,
   //I can get away with this because there are only 2 windows!!!

   "bottom-of-buffer"          =>{diff_maybe_deselect_command,bottom_of_buffer},

   "top-of-buffer"             =>{diff_maybe_deselect_command,top_of_buffer},

   "page-up"                   =>{diff_maybe_deselect_command,page_up},

   "vi-page-up"                =>{diff_maybe_deselect_command,page_up},

   "page-down"                 =>{diff_maybe_deselect_command,page_down},

   "vi-page-down"              =>{diff_maybe_deselect_command,page_down},

   "cursor-left"               =>diff_cursor_left,

   "cursor-right"               =>diff_cursor_right,

   "cursor-up"                 =>{diff_maybe_deselect_command,cursor_up},

   "cursor-down"               =>{diff_maybe_deselect_command,cursor_down},

   "begin-line"                =>{diff_maybe_deselect_command,begin_line},

   "begin-line-text-toggle"    =>{diff_maybe_deselect_command,begin_line_text_toggle},

   "brief-home"                =>{diff_maybe_deselect_command,begin_line},

   "vi-begin-line"             =>{diff_maybe_deselect_command,begin_line},

   "vi-begin-line-insert-mode" =>{diff_maybe_deselect_command,begin_line},

   "brief-end"                 =>{diff_maybe_deselect_command,end_line},

   //"end-line"                  =>{diff_maybe_deselect_command,end_line},

   "end-line"                  =>diff_end_line,

   "vi-end-line"               =>{diff_maybe_deselect_command,end_line},

   "vi-end-line-append-mode"   =>{diff_maybe_deselect_command,end_line},
   "mou-click"                 =>diff_mou_click,
   "mou-select-word"           =>diff_mou_select_word,
   "mou-select-line"           =>diff_mou_select_line,
   "move-text-tab"             =>diff_move_text_tab,
   "move-text-tab"             =>diff_move_text_tab,
   "ctab"                      =>diff_ctab,
   "c-tab"                     =>diff_ctab,
   "cut-end-line"              =>diff_cut_end_line,
   "cut-word"                  =>diff_cut_word,
   "delete-word"               =>diff_delete_word,
   "prev-word"                 =>diff_prev_word,
   "next-word"                 =>diff_next_word,
   "complete-prev"             =>diff_complete_prev,
   "complete-next"             =>diff_complete_next,
   "complete-more"             =>diff_complete_more,
   "save"                      =>diff_save,
   "c-endbrace"                =>c_endbrace,
   "find-matching-paren"       =>diff_find_matching_paren,
};

static _str MergeValidCommands:[] = {
    "list-symbols"           => 1
   ,"function-argument-help" => 1
   ,"end-line"               => 1
   ,"vi-end-line"            => 1
   ,"begin-line"             => 1
   ,"begin-line-text-toggle" => 1
   ,"vi-begin-line"          => 1
   ,"cursor-up"              => 1
   ,"cursor-down"            => 1
   ,"cursor-left"            => 1
   ,"cursor-right"           => 1
   ,"page-down"              => 1
   ,"page-up"                => 1
   ,"vi-page-down"           => 1
   ,"vi-page-up"             => 1
   ,"top-of-buffer"          => 1
   ,"bottom-of-buffer"       => 1
   ,"vi-escape"              => 1
   ,"esc-alt-prefix"         => 1
   ,"safe-exit"              => 1
   ,"copy-line"              => 1
   ,"copy-to-clipboard"      => 1
   ,"copy-word"              => 1
   ,"select-char"            => 1
   ,"select-line"            => 1
   ,"select-block"           => 1
   ,"mou-click"              => 1
   ,"undo"                   => 1
   ,"next-window"            => 1
   ,"undo-cursor"            => 1
};

definit()
{
   gDiffUpdateInfo.timer_handle=-1;
   gDiffUpdateInfo.wid_list._makeempty();
}

defeventtab _diff_form;
void _ctlfile1_readonly.lbutton_up()
{
   //say('b4 ap='_ctlfile1.p_ProtectReadOnlyMode);
   _ctlfile1.p_ProtectReadOnlyMode=(p_value)?VSPROTECTREADONLYMODE_ALWAYS:VSPROTECTREADONLYMODE_NEVER;
   //say('after ap='_ctlfile1.p_ProtectReadOnlyMode);
}
void _ctlfile2_readonly.lbutton_up()
{
   _ctlfile2.p_ProtectReadOnlyMode=(p_value)?VSPROTECTREADONLYMODE_ALWAYS:VSPROTECTREADONLYMODE_NEVER;
}
#define DiffParentWID   _ctlcopy_right.p_user
#define gBuf1StartTime  _ctlcopy_right_line.p_user
#define gBuf2StartTime  _ctlcopy_right_all.p_user
#define gIntraLineIsOff _ctlfile1save.p_user

void _PositionDiffLegendLabels()
{
   parse _default_color(CFG_MODIFIED_LINE) with fg bg .;
   _ctlmodified_label.p_width=_ctlmodified_label._text_width(_ctlmodified_label.p_caption);
   _ctlmodified_label.p_forecolor=fg;
   _ctlmodified_label.p_backcolor=bg;
   parse _default_color(CFG_INSERTED_LINE) with fg bg .;
   _ctlmodified_label.p_x=_ctlinserted_label.p_x+_ctlinserted_label.p_width+(_twips_per_pixel_x()*3);
   _ctlinserted_label.p_width=_ctlinserted_label._text_width(_ctlinserted_label.p_caption);
   _ctlinserted_label.p_forecolor=fg;
   _ctlinserted_label.p_backcolor=bg;
   parse _default_color(CFG_NOSAVE_LINE) with fg bg .;
   _ctlimaginary_label.p_x=_ctlmodified_label.p_x+_ctlmodified_label.p_width+(_twips_per_pixel_x()*3);
   _ctlimaginary_label.p_width=_ctlimaginary_label._text_width(_ctlimaginary_label.p_caption);
   _ctlimaginary_label.p_forecolor=fg;
   _ctlimaginary_label.p_backcolor=bg;
}

void _ctlfile1.on_create()
{
   vscroll1.p_large_change=vscroll1.p_max intdiv _ctlfile1.p_Noflines;
   vscroll1.p_user=vscroll1.p_value;
   hscroll1.p_user=hscroll1.p_value;
   _ctlok.p_visible=0;//We only want this if we are in a version control merge,
                      //and then we'll turn it on ourselves.
   _ctlok.p_enabled=0;
   p_active_form.p_user=1;
   LastActiveEditWindowWID=_ctlfile1;
   //_ctlmodified_label
   _PositionDiffLegendLabels();
   _ctlfile1label.p_caption=arg(1);
   _ctlfile2label.p_caption=arg(2);
   _ctlfile1.p_scroll_left_edge=-1;
   _ctlfile2.p_scroll_left_edge=-1;

   parse _default_font(CFG_WINDOW_TEXT) with font_name','font_size','font_flags','.;
   font_bold=font_flags&F_BOLD;
   font_italic=font_flags&F_ITALIC;
   font_strike_thru=font_flags&F_STRIKE_THRU;
   font_underline=font_flags&F_UNDERLINE;

   _ctlfile1.p_font_name=_ctlfile2.p_font_name=font_name;
   _ctlfile1.p_font_size=_ctlfile2.p_font_size=font_size;
   _ctlfile1.p_font_bold=_ctlfile2.p_font_bold=font_bold;
   _ctlfile1.p_font_italic=_ctlfile2.p_font_italic=font_italic;
   _ctlfile1.p_font_strike_thru=_ctlfile2.p_font_strike_thru=font_strike_thru;

   if (gDiffUpdateInfo._varformat()!=VF_ARRAY) {
      gDiffUpdateInfo.timer_handle=-1;
   }
   if (gDiffUpdateInfo.timer_handle<0) {
      gDiffUpdateInfo.timer_handle=_set_timer(100,_diffedit_UpdateForm);
   }
   gDiffUpdateInfo.wid_list[gDiffUpdateInfo.wid_list._length()]=p_active_form;
}

static edit_window_rbutton_up()
{
   index=find_index("_diff_menu",oi2type(OI_MENU));
   menu_handle=_mdi._menu_load(index,'P');
   mou_get_xy(x,y);
   status=_menu_show(menu_handle,VPM_RIGHTBUTTON,x-1,y-1);
}

static void RemoveImaginaryLines()
{
   //No longer need to save_pos and restore_pos because we only do this on the
   //way out, and it sometimes causes invalid point errors
   oldmodify=p_modify;
   top();up();
   while (!down()) {
      if (_lineflags()&NOSAVE_LF) {
         _delete_line();up();
      }
   }
   p_modify=oldmodify;
}

static void BlastLineFlags()
{
   save_pos(p);
   p_line=0;
   while (!down()) {
      _lineflags(0,MODIFY_LF|INSERTED_LINE_LF);
   }
   restore_pos(p);
}

//Duplicated in diff.e
static void BlastUndoInfo()
{
   old=p_undo_steps;
   p_undo_steps=0;
   p_undo_steps=old;
}

_ctlfile1.on_destroy()
{
   if (DiffParentWID!='' && _iswindow_valid(DiffParentWID) &&
       DiffParentWID.p_name=='_difftree_output_form' && 
       !DiffParentWID.p_edit) {
      _nocheck _control tree1,tree2;
      int index1=0,index2=0;

      index1=DiffParentWID.tree1._TreeCurIndex();
      DiffTextChangeCallback(0,_ctlfile1.p_buf_id);
      DiffTextChangeCallback(0,_ctlfile2.p_buf_id);
      _UpdateFileBitmaps(_ctlfile1.p_buf_name,index1,DiffParentWID.tree1,
                         _ctlfile2.p_buf_name,index2,DiffParentWID.tree2);
      wid=p_window_id;
      p_window_id=DiffParentWID;
      tree1._TreeGetInfo(index1,state,bm1,BM2,flags);

      tree1._set_focus();
      if (!(flags&TREENODE_HIDDEN) && def_diff_edit_options&DIFF_AUTO_JUMP) {
         _nocheck _control ctlnext_mismatch;
         ctlnext_mismatch.call_event(ctlnext_mismatch,LBUTTON_UP);
      }
      p_window_id=wid;
      _str filename1=_ctlfile1.p_buf_name;
      _str filename2=_ctlfile2.p_buf_name;
      File1Date=_file_date(filename1,'B');
      File2Date=_file_date(filename2,'B');
      if (File1Date!=gBuf1StartTime) {
         p_window_id=DiffParentWID
         _AppendToDiffReport(DIFF_REPORT_FILE_CHANGE,filename1);
         p_window_id=wid;
      }
      if (File2Date!=gBuf2StartTime) {
         p_window_id=DiffParentWID
         _AppendToDiffReport(DIFF_REPORT_FILE_CHANGE,filename2);
         p_window_id=wid;
      }
   }
   fid=p_active_form;
   if (substr(p_active_form.p_caption,1,5)!='Merge') {
      DiffFreeAllColorInfo(_ctlfile1.p_buf_id);
      DiffFreeAllColorInfo(_ctlfile2.p_buf_id);
   }
   if (_ctlfile1.p_user=='' && _ctlfile2.p_user=='') {
      for (i=0;i<gDiffUpdateInfo.wid_list._length();++i) {
         if (gDiffUpdateInfo.wid_list[i]==fid) {
            gDiffUpdateInfo.wid_list._deleteel(i);
            break;
         }
      }
      if (!gDiffUpdateInfo.wid_list._length() && gDiffUpdateInfo.timer_handle>-1) {
         _kill_timer(gDiffUpdateInfo.timer_handle);
         gDiffUpdateInfo.timer_handle=-1;
      }
      return('');
   }
   parse _ctlfile1.p_user with bufid1 file1inmem file1readonly;
   parse _ctlfile2.p_user with bufid2 file2inmem file2readonly;
   if (_ctlfile1.p_user!='') {
      if (!file1inmem) {
         _ctlfile1.load_files('+q +bi 'bufid1);
         _ctlfile1._delete_buffer();
      }else{
         _ctlfile1.p_readonly_mode=file1readonly;

         _ctlfile1.p_color_flags=_ctlfile1.p_buser;
         //Now blow away undo
         _ctlfile1.RemoveImaginaryLines();
         wid=p_window_id;
         _ctlfile1.BlastLineFlags();
         _ctlfile1.BlastUndoInfo();
      }
   }
   if (_ctlfile2.p_user!='') {
      if (!file2inmem) {
         _ctlfile2.load_files('+q +bi 'bufid2);
         _ctlfile2._delete_buffer();
      }else{
         _ctlfile2.p_readonly_mode=file2readonly;
         //10:55am 9/5/1997
         //If it was the same buffer this can happen
         if (_ctlfile2.p_buser!='') {
            _ctlfile2.p_color_flags=_ctlfile2.p_buser;
         }
         //Now blow away undo
         _ctlfile2.RemoveImaginaryLines();
         wid=p_window_id;
         _ctlfile2.BlastLineFlags();
         _ctlfile2.BlastUndoInfo();
         p_window_id=wid;
      }
   }
   p_window_id=_ctlfile1;
   _deselect();
   p_window_id=_ctlfile2;
   _deselect();
   for (i=0;i<gDiffUpdateInfo.wid_list._length();++i) {
      if (gDiffUpdateInfo.wid_list[i]==fid) {
         gDiffUpdateInfo.wid_list._deleteel(i);
         break;
      }
   }
   if (!gDiffUpdateInfo.wid_list._length() && gDiffUpdateInfo.timer_handle>-1) {
      _kill_timer(gDiffUpdateInfo.timer_handle);
      gDiffUpdateInfo.timer_handle=-1;
   }
}

vscroll1.on_change()
{
   if (p_object==OI_VSCROLL_BAR) {
      if (vscroll1.p_user=='') return('');//Cursor moved
      wid=p_window_id;
      if (vscroll1.p_value<vscroll1.p_user) {
         p_window_id=_ctlfile1;
         _scroll_page('u',vscroll1.p_user-vscroll1.p_value)
         p_window_id=_ctlfile2;
         _scroll_page('u',vscroll1.p_user-vscroll1.p_value)
      }else if (vscroll1.p_value>vscroll1.p_user) {
         p_window_id=_ctlfile1;
         _scroll_page('d',vscroll1.p_value-vscroll1.p_user)
         p_window_id=_ctlfile2;
         _scroll_page('d',vscroll1.p_value-vscroll1.p_user)
      }
      p_window_id=wid;
   }else if (p_object==OI_HSCROLL_BAR) {
      if (hscroll1.p_user=='') return('');
      _ctlfile1.p_scroll_left_edge=hscroll1.p_value;
      _ctlfile2.p_scroll_left_edge=hscroll1.p_value;
   }
   p_user=p_value;
}
vscroll1.on_scroll()
{
   if (p_object==OI_VSCROLL_BAR) {
      if (vscroll1.p_user=='') return('');//Cursor moved
      if (vscroll1.p_value<vscroll1.p_user) {
         //Should scroll up
         p_window_id=_ctlfile1;
         _scroll_page('u',vscroll1.p_user-vscroll1.p_value)
         p_window_id=_ctlfile2;
         _scroll_page('u',vscroll1.p_user-vscroll1.p_value)
      }else if (vscroll1.p_value>vscroll1.p_user) {
         //Should scroll down
         p_window_id=_ctlfile1;
         _scroll_page('d',vscroll1.p_value-vscroll1.p_user)
         p_window_id=_ctlfile2;
         _scroll_page('d',vscroll1.p_value-vscroll1.p_user)
      }
      vscroll1.p_user=vscroll1.p_value;
   }else if (p_object==OI_HSCROLL_BAR) {
      if (hscroll1.p_user=='') return('');//Cursor moved
      _ctlfile1.p_scroll_left_edge=hscroll1.p_value;
      _ctlfile2.p_scroll_left_edge=hscroll1.p_value;
      hscroll1.p_user=hscroll1.p_value;
   }
   p_active_form.refresh();
}

static void UpdateScrollThumbs(...)
{
   static int numbehind;
   if (numbehind < 50) {
      ++numbehind;
      return;
   }
   numbehind=0;
   old=vscroll1.p_user;
   //DiffMessage('vscroll1.p_value='vscroll1.p_value' vscroll1.p_max='vscroll1.p_max' _ctlfile1.p_line='_ctlfile1.p_line);
   vscroll1.p_user='';
   vscroll1.p_value=_ctlfile1.p_line;
   vscroll1.p_user=_ctlfile1.p_line//old;
   vscroll1.refresh();
}
static void change_edit_window()
{
   if (_get_focus()==_ctlfile1) {
      _ctlfile2._set_focus();
   }else if (_get_focus()==_ctlfile2) {
      _ctlfile1._set_focus();
   }
   p_active_form.refresh();
}


#if 0
_ctlfile1.TAB()
{
   p_window_id=_ctlfile2;
   _set_focus();
}

_ctlfile2.TAB()
{
   p_window_id=_ctlfile1;
   _set_focus();
}
#endif

static int _dont_use_diff_command=0;

static void DiffMessageBox(_str msg)
{
   //refresh();
   _message_box(nls("%s",msg));
}

static int FindButtonWithShortcut(_str key)
{
   val=(arg(1)=='')?0:1;
   p_enabled=val;
   wid=p_window_id;
   while (p_child) {
      p_window_id=p_child;
      firstwid=p_window_id;
      for (;;) {
         p_window_id=p_next;
         if (p_object==OI_COMMAND_BUTTON) {
            if (pos('&'key,p_caption,1,'i')) {
               rv=p_window_id;
               p_window_id=wid;
               return(rv);
            }
         }
         if (p_window_id==firstwid) break;
      }
   }
   p_window_id=wid;
   return(0);
}

static void _EditControlEventHandler()
{
   lastevent=last_event();
   eventname=event2name(lastevent);
   //messageNwait("_EditControlEventHandler: eventname="eventname" _select_type()="_select_type());
   if (eventname=='F1') {
      p_active_form.call_event(defeventtab _ainh_dlg_manager,F1,'e');
      return;
      //help('Diff Dialog box');
   }
   if (eventname=='A-F4' || eventname=='ESC') {
      diff_close_form();
      return;
   }
   if (eventname=='MOUSE-MOVE') {
      return;
   }
   if (eventname=='RBUTTON-DOWN ') {
      edit_window_rbutton_up();
      return;
   }
   if (substr(eventname,1,2)=='A-') {
      //If we're in an edit control, we still want the buttons to work
      wid=p_active_form.FindButtonWithShortcut(substr(eventname,3));
      if (wid) {
         wid.call_event(wid,lastevent);
         return;
      }
   }
#if 0
   if (event2name(lastevent)=='TAB') {
      if (p_window_id==_ctlfile1) {
         p_window_id=_ctlfile2;
         _set_focus();
      }else if(p_window_id==_ctlfile2) {
         p_window_id=_ctlfile1;
         _set_focus();
      }
      return;
   }
#endif
   key_index=event2index(lastevent);
   root_keys_index=find_index('default-keys',EVENTTAB_TYPE);
   name_index=eventtab_index(root_keys_index,_ctlfile1.p_mode_eventtab,key_index);
   command_name=name_name(name_index);

   //This is to handle C-X combinations
   if (name_type(name_index)==EVENTTAB_TYPE) {
      eventtab_index2=name_index;
      event2=get_event('k');
      key_index=event2index(event2);
      name_index=eventtab_index(root_keys_index,eventtab_index2,key_index);
      command_name=name_name(name_index);
   }
   //oldevent=last_event();_message_box("h1");last_event(oldevent);
   //messageNwait("_EditControlEventHandler: name="command_name);
   //DiffMessage('command_name='command_name);
   if (!_dont_use_diff_command) {
      //messageNwait("h2 _EditControlEventHandler: eventname="eventname" _select_type()="_select_type()" command_name="command_name);
      if (DiffCommands._indexin(command_name)) {
         if ((_ctlfile1_readonly.p_value && p_window_id==_ctlfile1) ||
             (_ctlfile2_readonly.p_value && p_window_id==_ctlfile2)) {
            if (MergeValidCommands:[command_name]._varformat()!=VF_EMPTY) {
               //Command is allowed, everything is cool.
            }else{
               //Command is not allowed, so beep at user and return
               _beep();
               _message_box(nls("Command not allowed in Read Only mode"));
               return;
            }
         }
#if 0//New read
only stuff should handle this
         if (!_ctlcopy_left.p_visible && p_window_id==_ctlfile1) {
            //We are in Version Control merge mode
            if (_varformat(MergeValidCommands:[command_name])!=VF_EMPTY) {
               //Command is allowed, everything is cool.
            }else{
               //Command is not allowed, so beep at user and return
               _beep();
               return('');
            }
         }
#endif
         switch (DiffCommands:[command_name]._varformat()) {
         case VF_FUNPTR:
            if (pos('\-space$',command_name,1,'r')) {
               diff_mode_space();
            }else if (pos('\-enter$',command_name,1,'r')) {
               diff_mode_split_insert_line();
            }else{
               junk=(*DiffCommands:[command_name])();
            }
            break;
         case VF_ARRAY:
            junk=(*DiffCommands:[command_name][0])(DiffCommands:[command_name][1]);
            break;
         }
      }else{
         if (command_name!='') {
            if (pos('\-space$',command_name,1,'r')) {
               diff_mode_space();
            }else if (pos('\-enter$',command_name,1,'r')) {
               diff_mode_split_insert_line();
            }else{
               DiffMessageBox(nls("Command '%s' currently not allowed in Diff mode",command_name));
            }
         }
      }
      //messageNwait("h3 _EditControlEventHandler: eventname="eventname" _select_type()="_select_type());
   }else{
      index=find_index(command_name,COMMAND_TYPE);
      if (index && index_callable(index)) {
         call_index(index);
      }
   }
   //oldevent=last_event();_message_box("h2 _ctlfile2.p_cursor_y="_ctlfile2.p_cursor_y);last_event(oldevent);
   _ctlfile1.p_scroll_left_edge=-1;
   _ctlfile2.p_scroll_left_edge=-1;
   otherwid=GetOtherWid(wid);
   wid_sle=p_scroll_left_edge;
   p_window_id=otherwid;
   p_scroll_left_edge=wid_sle;
   p_window_id=wid;//Yuck!!!!!!!!! I don't know if this really is the best
   //way to do this, but it keeps both cursors in view

   //_diffedit_UpdateForm(_ctlfile1.p_line);
   //_post_call(_diffedit_UpdateForm,_ctlfile1.p_line);
   p_active_form.p_user=1;
}

_ctlfile1.on_lost_focus()
{
   LastActiveEditWindowWID=_ctlfile1;
}

_ctlfile2.on_lost_focus()
{
   LastActiveEditWindowWID=_ctlfile2;
}

//Not sure about portablity

//defeventtab _diff_form.ctlfile1
_ctlfile1.\0-\33,\129-MBUTTON_UP,'S-LBUTTON-DOWN'-ON_SELECT()
{
   //messageNwait("event="event2name(last_event()));
   _EditControlEventHandler();
}

//Not sure about portability
//_ctlfile2.\0-\33,\129-ON_SELECT()
_ctlfile2.\0-\33,\129-MBUTTON_UP,'S-LBUTTON-DOWN'-ON_SELECT()
{
   //call_event(_ctlfile1,last_event());
   _EditControlEventHandler();
}

static void MaybeMakeLineReal()
{
   if (_lineflags()&NOSAVE_LF) {
      _lineflags(0,NOSAVE_LF);
   }
   get_line(line);
   if (line=='Imaginary Buffer Line') {
      replace_line('');
   }
}

static void docharkey()
{
   key=last_event();
   cmdname=name_name(eventtab_index(p_mode_eventtab,p_mode_eventtab,event2index(key)));
   switch (cmdname) {
   case 'c-endbrace':
      c_endbrace();
      return;
   case 'auto-codehelp-key':
      diff_auto_codehelp_key();
      return;
   case 'auto-functionhelp-key':
      diff_auto_functionhelp_key();
      return;
   default:
      keyin(key);
   }
}
//_ctlfile1.'a'-'z','A'-'Z','0-9',',',"'",'"','?','/','.','<','>'()
int _ctlfile1.\33-\128()
{
   if (_ctlfile1_readonly.p_value) {
      _message_box(nls("Command not allowed in Read Only mode"));
      return(1);
   }
   if (_ctlcopy_left.p_visible) {
      //We are not in a Version Control Merge
      _ctlfile1._undo('S');
      _ctlfile2._undo('S');
      MaybeMakeLineReal();
      if ((!select_active() ||
          ( _select_type('','U')=='P' && _select_type('','S')=='E' ))
          ) {
         //!_within_char_selection keeps us from deleting selections created
         //by word completion
         docharkey();
         _ctlfile2.right();
         AddUndoNothing(_ctlfile2);
      }else{
         if (!_within_char_selection() ) {
            deselect();
            docharkey();
            _ctlfile2.right();
            AddUndoNothing(_ctlfile2);
         } else {
            diff_multi_delete();
         }
      }
      p_active_form.p_user=1;
   }
   return(0);
}

//_ctlfile2.'a'-'z','A'-'Z'()
int _ctlfile2.\33-\128()
{
   if (_ctlfile2_readonly.p_value) {
      _message_box(nls("Command not allowed in Read Only mode"));
      return(1);
   }
   _ctlfile1._undo('S');
   _ctlfile2._undo('S');
   MaybeMakeLineReal();
   if (!select_active() ||
       ( _select_type('','U')=='P' && _select_type('','S')=='E' )) {
      docharkey();
      _ctlfile1.right();
      AddUndoNothing(_ctlfile1)//This had _ctlfile2, but I think it was wrong
   }else{
      if (!_within_char_selection() ) {
         deselect();
         docharkey();
         _ctlfile1.right();
         AddUndoNothing(_ctlfile1);
      } else {
         diff_multi_delete();
      }
   }
   p_active_form.p_user=1;
   return(0);
}

_control _ctlnext_difference;
_control _ctlprev_difference;

_ctlfile1.C_F6()
{
   call_event(_ctlnext_difference,LBUTTON_UP);
}

_ctlfile2.C_F6()
{
   call_event(_ctlnext_difference,LBUTTON_UP);
}

_ctlfile1.'C-S-F6'()
{
   call_event(_ctlprev_difference,LBUTTON_UP);
}

_ctlfile1.'C-tab'()
{
   p_window_id=_ctlfile2;_set_focus();
}

_ctlfile2.'C-tab'()
{
   p_window_id=_ctlfile1;_set_focus();
}

_ctlfile2.'C-S-F6'()
{
   call_event(_ctlprev_difference,LBUTTON_UP);
}

static void maybe_out_of_hex()
{
   if (p_hex_mode) {
      hex();
   }
}

static boolean OnLastLine()
{
   //I wanted this to be a define, but there were problems with calling it
   //ex:  wid.OnLastLine()
   return(p_line==p_Noflines);
}

//9:32am 7/7/1998
//This is duplicated in diff.e
//Such specific code I didn't want to make it global
static void maybe_show_all()
{
   if (p_Nofhidden) {
      show_all();
      //Just line them back up together.  I was not able to reproduce this,but
      //Clark and I saw some peculiarities 10:47am 4/4/1996
      otherwid=GetOtherWid(wid)
      //3:30pm 6/11/1997:
      //Changed this so that it should work for either file
      otherwid.set_scroll_pos(wid.p_left_edge,wid.p_cursor_y);
   }
}

void _diff_form.on_got_focus()
{
   _ctlfile1.maybe_out_of_hex();
   _ctlfile2.maybe_out_of_hex();
   _ctlfile1.maybe_show_all();
   _ctlfile2.maybe_show_all();
}

static void GetVisibleControlList(_str &widlist)
{
   p_window_id=p_active_form;
   first=wid=p_child;
   widlist='';
   for (;;) {
      if (wid.p_visible) {
         if (widlist=='') {
            widlist=wid;
         }else{
            widlist=widlist' 'wid;
         }
      }
      wid=wid.p_next;
      if (wid==first) break;
   }
}

static void SetListVisibleProperty(_str widlist,int value)
{
   for (;;) {
      parse widlist with cur widlist;
      if (cur=='') break;
      cur.p_visible=value!=0;
   }
}

void _diff_form.on_resize()
{
   static int in_on_resize;
   if (in_on_resize) return;
   in_on_resize=1;
   static _str FormSize;
   if (FormSize!='') {
      parse FormSize with width height .;
      if (width==p_active_form.p_width && height==p_active_form.p_height) {
         in_on_resize=0;
         return;
      }
   }
   //form_width=_lx2dx(SM_TWIP,p_active_form.p_width);
   //messageNwait("client_width="p_active_form.p_client_width" form_width="form_width);
   xbuffer=_ctlfile1.p_x;

   GetVisibleControlList(widlist);
   SetListVisibleProperty(widlist,0);

   availablespace=(p_active_form.p_client_width*_twips_per_pixel_x())-(xbuffer*2);
   _ctlfile2.p_width=_ctlfile1.p_width=(availablespace-vscroll1.p_width) intdiv 2;
   vscroll1.p_x=(_ctlfile1.p_x+_ctlfile1.p_width)-_twips_per_pixel_x();
   _ctlfile2.p_x=vscroll1.p_x+vscroll1.p_width-_twips_per_pixel_x();
   hscroll1.p_width=(_ctlfile2.p_x+_ctlfile2.p_width-_ctlfile1.p_x)/*-_twips_per_pixel_x()*/;
   _ctlfile1.p_height=((p_active_form.p_client_height*_twips_per_pixel_y())-_ctlfile1.p_y)-(xbuffer*7)-_ctlclose.p_height-hscroll1.p_height-_ctlfile1line.p_height-_ctlfile2_readonly.p_height-_ctlcopy_right.p_height-(_twips_per_pixel_y()*2);
   _ctlfile2.p_height=_ctlfile1.p_height;
   vscroll1.p_height=_ctlfile2.p_height;
   hscroll1.p_y=(_ctlfile1.p_y+_ctlfile1.p_height)-_twips_per_pixel_y();
   _ctlclose.p_x=_ctlfile1.p_x;
   //_ctlfile1line.p_y=_ctlfile1.p_y+_ctlfile1.p_height+hscroll1.p_height+xbuffer;
   _ctlfile1_readonly.p_y=_ctlfile1.p_y+_ctlfile1.p_height+hscroll1.p_height+xbuffer;
   _ctlfile2_readonly.p_y=_ctlfile1.p_y+_ctlfile1.p_height+hscroll1.p_height+xbuffer;
   _ctlfile2_readonly.p_x=_ctlfile2.p_x;
   _ctlfile1line.p_y=_ctlfile1_readonly.p_y+_ctlfile1_readonly.p_height+xbuffer;
   _ctlmodified_label.p_y=_ctlinserted_label.p_y=_ctlimaginary_label.p_y=_ctlfile1line.p_y

   _ctlcopy_right.p_y=_ctlfile1line.p_y+_ctlfile1line.p_height+xbuffer;
   _ctlcopy_right.p_x=_ctlfile1.p_x;_ctlcopy_left.p_x=_ctlfile2.p_x;
   _ctlcopy_right_line.p_x=_ctlcopy_right.p_x+_ctlcopy_right.p_width+xbuffer;
   _ctlcopy_right_all.p_x=_ctlcopy_right_line.p_x+_ctlcopy_right_line.p_width+xbuffer;
   _ctlcopy_right_line.p_y=_ctlcopy_right_all.p_y=_ctlfile2save.p_y=_ctlcopy_right.p_y;
   _ctlfile1save.p_x=_ctlcopy_right_all.p_x+_ctlcopy_right_all.p_width+xbuffer;
   _ctlfile1save.p_y=_ctlcopy_right_all.p_y;
   _ctlcopy_left_line.p_y=_ctlcopy_left_all.p_y=_ctlfile1save.p_y;
   _ctlcopy_left_line.p_x=_ctlcopy_left.p_x+_ctlcopy_left.p_width+xbuffer;
   _ctlcopy_left_all.p_x=_ctlcopy_left_line.p_x+_ctlcopy_left_line.p_width+xbuffer;
   _ctlfile2save.p_x=_ctlcopy_left_all.p_x+_ctlcopy_left_all.p_width+xbuffer;

   _ctlcopy_left.p_y=_ctlcopy_right.p_y;
   _ctlseparater.p_y=_ctlcopy_left.p_y+_ctlcopy_left.p_height+(xbuffer*2);
   _ctlseparater.p_width=p_active_form.p_width;
   _ctlclose.p_y=_ctlcopy_right.p_y+_ctlcopy_right.p_height+(xbuffer*4);
   _ctlnext_difference.p_y=_ctlprev_difference.p_y=_ctlclose.p_y;
   _ctlfile1label.p_x=_ctlfile1.p_x;_ctlfile2label.p_x=_ctlfile2.p_x;
   _ctlfile1label.p_width=_ctlfile1.p_width;_ctlfile2label.p_width=_ctlfile2.p_width;
   _ctlfind.p_y=_ctlundo.p_y=_ctlclose.p_y;
   _ctlfind.p_x=_ctlprev_difference.p_x+_ctlprev_difference.p_width+xbuffer;
   _ctlundo.p_x=_ctlfind.p_x+_ctlfind.p_width+xbuffer;
   _ctlhelp.p_y=_ctlundo.p_y;_ctlhelp.p_x=_ctlundo.p_x+_ctlundo.p_width+xbuffer;
   _ctlok.p_y=_ctlhelp.p_y;_ctlok.p_x=_ctlhelp.p_x+_ctlhelp.p_width+xbuffer;

   _ctlfile1label.p_width=_ctlfile1.p_width;_ctlfile2label.p_width=_ctlfile2.p_width;

   if (_ctlfile1.p_buf_name!='') {
      _ctlfile1label.GetFileOrBuffer(fob);_ctlfile1label.p_caption=_ctlfile1.p_buf_name:+fob;
   }
   if (_ctlfile2.p_buf_name!='') {
      _ctlfile2label.GetFileOrBuffer(fob);_ctlfile2label.p_caption=_ctlfile2.p_buf_name:+fob;
   }

   _ctlfile1label.DiffShrinkFilename(_ctlfile1label.p_width);
   _ctlfile2label.DiffShrinkFilename(_ctlfile2label.p_width);

   SetListVisibleProperty(widlist,1);
   FormSize=p_active_form.p_width' 'p_active_form.p_height;
   in_on_resize=0;
}

static void diff_mode_split_insert_line()
{
   if (arg(1)=='') {
      //DiffMessage('mysplit_insert_line');
   }else{
      //DiffMessage('my'arg(1)'_enter');
   }
   wid=p_window_id;
   if (wid==_ctlfile1) {
      otherwid=_ctlfile2;
   }else{
      otherwid=_ctlfile1;
   }
   wid._undo('S');
   otherwid._undo('S');
   oldlinenum=p_line;
   get_line(oldline);

   parse lowcase(p_mode_name) with mode_name '-' .;
   index=find_index(mode_name'_enter',COMMAND_TYPE);
   oldro=p_readonly_mode;
   p_readonly_mode=0;
   //DiffInsertColorInfo(p_buf_id,p_line);
   if (!index) {
      wid.split_insert_line();
   }else{
      //index=find_index(arg(1)'_enter',COMMAND_TYPE);
      call_index(index);
   }
   p_readonly_mode=oldro;
   up();get_line(newline);down();
   wid=p_window_id;
   p_window_id=otherwid;
   p_line=oldlinenum;
   //DiffInsertColorInfo(p_buf_id,p_line);
   InsertImaginaryLine();
   p_window_id=wid;
   AddUndoNothing(otherwid);
}

static void FixCaption(int wid,boolean modify)
{
   str=substr(wid.p_caption,length(wid.p_caption)-1);
   cap=wid.p_caption;
   if (str==' *') {
      cap=substr(cap,1,length(wid.p_caption)-2);
   }
   if (modify) {
      cap=cap' *';
   }
   if (cap!=wid.p_caption) {
      wid.p_caption=cap;
   }
}

static void MergeLabelCopyButtons()
{
   if (!_ctlfile1.p_line) {
      _ctlcopy_right.p_enabled=0;
      _ctlcopy_right_all.p_enabled=0;
   }
   if (!_ctlfile1._lineflags() && !_ctlfile2._lineflags()) {
      _ctlcopy_right.p_enabled=0;
      _ctlcopy_right_all.p_enabled=0;
   }else{
      _ctlcopy_right.p_enabled=1;
      _ctlcopy_right_all.p_enabled=1;
   }
}

static void DiffLabelCopyButtons()
{
   if (!_ctlfile1.p_line) {
      _ctlcopy_right.p_enabled=0;
      _ctlcopy_right_line.p_enabled=0;
      _ctlcopy_left.p_enabled=0;
      _ctlcopy_left_line.p_enabled=0;
   }else{
      file1line_modified=_ctlfile1._lineflags()&MODIFY_LF;
      file1line_inserted=_ctlfile1._lineflags()&INSERTED_LINE_LF;
      file2line_modified=_ctlfile2._lineflags()&MODIFY_LF;
      file2line_inserted=_ctlfile2._lineflags()&INSERTED_LINE_LF;
      if (file1line_inserted) {
         _ctlcopy_right.p_enabled=1;
         _ctlcopy_left.p_enabled=1;
         _ctlfile1.get_line(line);
         if (_ctlfile1._lineflags()&NOSAVE_LF) {//Inserted Line
            _ctlcopy_left.p_caption='<<Block';
            _ctlcopy_right.p_caption='Del Block';
            _ctlcopy_right_line.p_enabled=0;
            _ctlcopy_left_line.p_enabled=1;
         }else{//Deleted Line
            _ctlcopy_right.p_enabled=1;
            _ctlcopy_left.p_enabled=1;
            _ctlcopy_left.p_caption='Del Block'
            _ctlcopy_right.p_caption='Block>>';
            _ctlcopy_right_line.p_enabled=1;
            _ctlcopy_left_line.p_enabled=0;
         }
      }else if (file2line_inserted) {
         _ctlcopy_right.p_enabled=1;
         _ctlcopy_left.p_enabled=1;
         _ctlfile1.get_line(line);
         if (_ctlfile1._lineflags()&NOSAVE_LF) {//Inserted Line
            _ctlcopy_left.p_caption='<<Block';
            _ctlcopy_right.p_caption='Del Block';
            _ctlcopy_right_line.p_enabled=0;
            _ctlcopy_left_line.p_enabled=1;
         }else{//Deleted Line
            _ctlcopy_right.p_enabled=1;
            _ctlcopy_left.p_enabled=1;
            _ctlcopy_left.p_caption='Del Block';
            _ctlcopy_right.p_caption='Block>>';
            _ctlcopy_right_line.p_enabled=1;
            _ctlcopy_left_line.p_enabled=0;
         }
      }else if (file1line_modified||file2line_modified) {
         _ctlcopy_right.p_enabled=1;
         _ctlcopy_left.p_enabled=1;
         _ctlcopy_right_line.p_enabled=1;
         _ctlcopy_left_line.p_enabled=1;
         _ctlcopy_left.p_caption='<<Block';
         _ctlcopy_right.p_caption='Block>>';
      }else{
         _ctlcopy_left.p_caption='<<Block';
         _ctlcopy_right.p_caption='Block>>';
         _ctlcopy_right.p_enabled=0;
         _ctlcopy_left.p_enabled=0;
         _ctlcopy_right_line.p_enabled=0;
         _ctlcopy_left_line.p_enabled=0;
      }
   }
}

static boolean DialogIsDiff()
{
   return(p_active_form.p_caption=='Diff');
}

static void UpdateForm2()
{
   if (arg(1)!='') {
      if (_ctlfile1.p_line!=arg(1)) {
         return;
      }
   }
   if (!p_active_form.p_user) {
      return;
   }
   _ctlfile1line.p_caption=_ctlfile1.p_line'/'_ctlfile1.p_Noflines;
   if (DialogIsDiff()) {
      DiffLabelCopyButtons();
   }else{
      MergeLabelCopyButtons();
   }
   FixCaption(_ctlfile1label,_ctlfile1.p_modify);
   FixCaption(_ctlfile2label,_ctlfile2.p_modify);
   vscroll1.p_user='';
   vscroll1.p_value=_ctlfile1.p_line;
   vscroll1.p_user=_ctlfile1.p_line;

   hscroll1.p_user='';
   hscroll1.p_value=_ctlfile1.p_left_edge;
   hscroll1.p_user=_ctlfile1.p_left_edge;

   if (DialogIsDiff()) {
      _ctlcopy_right_all.p_enabled=!(_ctlcopy_right_all.p_user=='Files Match');
      _ctlcopy_left_all.p_enabled=!(_ctlcopy_right_all.p_user=='Files Match');
   }
   p_active_form.p_user=0;
}

void _diffedit_UpdateForm()
{
   if (gDiffUpdateInfo.wid_list._varformat()==VF_ARRAY) {
      for (i=0;i<gDiffUpdateInfo.wid_list._length();++i) {
         if (_iswindow_valid(gDiffUpdateInfo.wid_list[i])) {
            gDiffUpdateInfo.wid_list[i].UpdateForm2();
         }
      }
   }
}

int DiffModifiedFiles()
{
   if (gDiffUpdateInfo.wid_list._varformat()==VF_ARRAY) {
      for (i=0;i<gDiffUpdateInfo.wid_list._length();++i) {
         formwid=gDiffUpdateInfo.wid_list[i];
         wid=p_window_id;
         p_window_id=formwid;
         if (_ctlfile1.p_modify || _ctlfile2.p_modify) {
            p_window_id=wid;
            return(formwid);
         }
         p_window_id=wid;
      }
   }
   return(0);
}

static void diff_bas_enter()
{
   diff_split_insert_line('bas');
}

static void diff_c_enter()
{
   diff_split_insert_line('c');
}

static void diff_cmd_enter()
{
   diff_split_insert_line('cmd');
}

static void diff_for_enter()
{
   diff_split_insert_line('for');
}

static void diff_pascal_enter()
{
   diff_split_insert_line('pascal');
}

static void diff_prg_enter()
{
   diff_split_insert_line('prg');
}

static void diff_maybe_deselect_command(...)
{
   diff_maybe_deselect();
   diff_command(arg(1));
   otherwid=GetOtherWid(wid);
   otherwid.p_col=wid.p_col
   UpdateScrollThumbs(wid.p_line);
}

static void diff_command(...)
{
   otherwid=GetOtherWid(wid);
   str_uc=undo_cursor;
   str_u=undo;
   //This is the only way I could compare to see if it was a pointer to undo
   //I suppose I shouldn't do it, but please forgive me
   if (arg(1)!=str_u && arg(1)!=str_uc) {
      if (in_cua_select) {
         if (p_window_id==_ctlfile1) {
            _ctlfile2._undo('S');
         }else{
            _ctlfile1._undo('S');
         }
      }else{
         _ctlfile1._undo('S');
         _ctlfile2._undo('S');
      }
   }
   ptr=arg(1)
   p_window_id=wid;
   junk=(*ptr)();
   p_window_id=otherwid;
   junk=(*ptr)();
   p_window_id=wid;
   otherwid.p_col=wid.p_col;
}

_ctlcopy_left.lbutton_up()
{
   if (_ctlfile1_readonly.p_value) {
      _message_box(nls("Command not allowed in Read Only mode"));
      return(1);
   }
   switch (_ctlcopy_left.p_caption) {
   case 'Del Block':
      _ctlfile2.diff_delete_block();
      break;
   case '<<Block':
      _ctlfile2.diff_copy_block();
      break;
   }
   p_active_form.p_user=1;
   ReturnFocusToEditWindow();

   return(0);
}

_ctlcopy_left_all.lbutton_up()
{
   if (_ctlfile1_readonly.p_value) {
      _message_box(nls("Command not allowed in Read Only mode"));
      return(1);
   }
   mou_hour_glass(1);
   p_window_id=_ctlfile2;
   _set_focus();
   _ctlfile2.top();_ctlfile2.up();
   _ctlfile1.top();_ctlfile1.up();
   old=def_diff_edit_options;
   def_diff_edit_options|=DIFF_AUTO_JUMP;
   diff_next_difference();
   DiffTextChangeCallback(0,_ctlfile1.p_buf_id);
   DiffTextChangeCallback(0,_ctlfile2.p_buf_id);
   for (;;) {
      status=_ctlfile2.diff_copy_block('No Messages');
      if (status) break;
   }
   DiffClearAllColorInfo(_ctlfile1.p_buf_id);
   DiffClearAllColorInfo(_ctlfile2.p_buf_id);
   refresh();//This is important.  Otherwise, the callback gets called with most of the file
   DiffTextChangeCallback(1,_ctlfile1.p_buf_id);
   DiffTextChangeCallback(1,_ctlfile2.p_buf_id);
   def_diff_edit_options=old;
   p_active_form.p_user=1;
   p_window_id=_ctlfile2;
   ReturnFocusToEditWindow();
   mou_hour_glass(0);
   return(0);
}

static void CopyFile1Block()
{
   _ctlfile1._undo('S');
   _ctlfile2._undo('S');
   p_window_id=_ctlfile1;
   old_line1=_ctlfile1.p_line;
   old_line2=_ctlfile2.p_line;
   while (_lineflags()&MODIFY_LF) {
      _ctlfile1.up();_ctlfile2.up();
   }
   _ctlfile1.diff_copy_block();
   _ctlfile1.p_line=old_line1;
   _ctlfile2.p_line=old_line2;
   AddUndoNothing(_ctlfile2);
}

void _DiffAddUndoOther(int buf_id)
{
   for (i=0;i<gDiffUpdateInfo.wid_list._length();++i) {
      fid=gDiffUpdateInfo.wid_list[i];
      if (fid._ctlfile1.p_buf_id==buf_id) {
         fid._ctlfile2._undo('S');
         AddUndoNothing(fid._ctlfile2);
         return;
      }
      if (fid._ctlfile2.p_buf_id==buf_id) {
         fid._ctlfile1._undo('S');
         AddUndoNothing(fid._ctlfile1);
         return;
      }
   }
}
static void diff_quote_key()
{
   _ctlfile1._undo('S');
   _ctlfile2._undo('S');
   otherwid=GetOtherWid(wid);
   wid.quote_key();
   AddUndoNothing(otherwid);
}
                    
static void diff_auto_functionhelp_key()
{
   _ctlfile1._undo('S');
   _ctlfile2._undo('S');
   otherwid=GetOtherWid(wid);
   wid.auto_functionhelp_key();
   AddUndoNothing(otherwid);
}
static void diff_auto_codehelp_key()
{
   _ctlfile1._undo('S');
   _ctlfile2._undo('S');
   otherwid=GetOtherWid(wid);
   wid.auto_codehelp_key();
   AddUndoNothing(otherwid);
}

static void CopyFile2Block()
{
   _ctlfile1._undo('S');
   _ctlfile2._undo('S');
   p_window_id=_ctlfile1;
   old_line1=_ctlfile1.p_line;
   old_line2=_ctlfile2.p_line;
   while (!(_lineflags()&MODIFY_LF)) {
      _ctlfile1.down();_ctlfile2.down();
   }
   _ctlfile1.diff_copy_block();
   _ctlfile1.p_line=old_line1;
   _ctlfile2.p_line=old_line2;
   AddUndoNothing(_ctlfile2);
}

static void CopyLine(int wid1,int wid2)
{
   wid1._undo('S');
   wid2._undo('S');
   wid1.get_line(line);
   wid2.replace_line(line);
   wid1._lineflags(0,MODIFY_LF|NOSAVE_LF|INSERTED_LINE_LF);
   wid2._lineflags(0,MODIFY_LF|NOSAVE_LF|INSERTED_LINE_LF);
   wid1.down();
   wid2.down();
   /*if (def_diff_edit_options&DIFF_AUTO_JUMP) {
      diff_next_difference();
   } */
   wid1.refresh('w');
   wid2.refresh('w');
   ReturnFocusToEditWindow();
   p_active_form.p_user=1;
}

int _ctlcopy_right_line.lbutton_up()
{
   CopyLine(_ctlfile1,_ctlfile2);
   return(0);
}
int _ctlcopy_left_line.lbutton_up()
{
   CopyLine(_ctlfile2,_ctlfile1);
   return(0);
}
int _ctlcopy_right.lbutton_up()
{
   if (_ctlfile2_readonly.p_value) {
      _message_box(nls("Command not allowed in Read Only mode"));
      return(1);
   }
   if (DialogIsDiff()) {
      switch (_ctlcopy_right.p_caption) {
      case 'Del Block':
         _ctlfile1.diff_delete_block();
         break;
      case 'Block>>':
         _ctlfile1.diff_copy_block();
         break;
      }
   }else{
      CopyFile1Block();
      _ctlcopy_right.p_enabled=0;
   }
   p_active_form.p_user=1;
   p_window_id=_ctlfile1;
   _ctlfile1.refresh('w');
   _ctlfile2.refresh('w');
   ReturnFocusToEditWindow();
   return(0);
}

int _ctlcopy_rignt_line.lbutton_up()
{
   if (_ctlfile2_readonly.p_value) {
      _message_box(nls("Command not allowed in Read Only mode"));
      return(1);
   }

   _ctlfile1.refresh('w');
   _ctlfile2.refresh('w');
   ReturnFocusToEditWindow();
   return(0);
}


int _ctlcopy_right_all.lbutton_up()
{
   if (_ctlfile2_readonly.p_value) {
      _message_box(nls("Command not allowed in Read Only mode"));
      return(1);
   }
   mou_hour_glass(1);
   p_window_id=_ctlfile1;
   _ctlfile1._undo('S');
   _ctlfile2._undo('S');
   if (DialogIsDiff()) {
      _ctlfile2.top();_ctlfile2.up();
      _ctlfile1.top();_ctlfile1.up();
      old=def_diff_edit_options;
      def_diff_edit_options|=DIFF_AUTO_JUMP;
      diff_next_difference();
      DiffTextChangeCallback(0,_ctlfile1.p_buf_id);
      DiffTextChangeCallback(0,_ctlfile2.p_buf_id);
      for (;;) {
         status=_ctlfile1.diff_copy_block('No Messages');
         if (status) break;
      }
      DiffTextChangeCallback(1,_ctlfile1.p_buf_id);
      DiffTextChangeCallback(1,_ctlfile2.p_buf_id);
      DiffClearAllColorInfo(_ctlfile1.p_buf_id);
      DiffClearAllColorInfo(_ctlfile2.p_buf_id);
      def_diff_edit_options=old;
      p_active_form.p_user=1;
   }else{
      CopyFile2Block();
      _ctlcopy_right_all.p_enabled=0;
   }
   p_window_id=_ctlfile1;
   ReturnFocusToEditWindow();
   mou_hour_glass(0);
   return(0);
}

_ctlfind.lbutton_up()
{
   status=LastActiveEditWindowWID.gui_find();
   if (LastActiveEditWindowWID==_ctlfile1) {
      _ctlfile2.p_line=_ctlfile1.p_line;
      _ctlfile2.set_scroll_pos(_ctlfile1.p_left_edge,_ctlfile1.p_cursor_y);
   }else if (LastActiveEditWindowWID==_ctlfile2) {
      _ctlfile1.p_line=_ctlfile2.p_line;
      _ctlfile1.set_scroll_pos(_ctlfile2.p_left_edge,_ctlfile2.p_cursor_y);
   }
   if (status && status!=COMMAND_CANCELLED_RC) {
      clear_message();
      _message_box(nls("String not found"));
   }
   _ctlfile1.refresh();
   ReturnFocusToEditWindow();
}

int _ctlfile1save.lbutton_up()
{
   status=_ctlfile1.diff_save();
   ReturnFocusToEditWindow();
   return(status);
}

int _ctlfile2save.lbutton_up()
{
   status=_ctlfile2.diff_save();
   ReturnFocusToEditWindow();
   return(status);
}

_str def_ext;

static int diff_save()
{
   p_AllowSave=1;
   if (p_buf_name=="") {
      result=_OpenDialog(_stdform('_open_form')' -new -modal',
           'Save As',
           _last_wildcards,     // Initial wildcards
           //'*.c;*.h',
           def_file_types,  // file types
           OFN_SET_LAST_WILDCARDS|OFN_SAVEAS,
           def_ext,      // Default extensions
           "", // Initial filename
           '',      // Initial directory
           '',      // Reserved
           "Save As dialog box"
           );
      //messageNwait('_param1='_param1);
      if (result=='') {
         return(COMMAND_CANCELLED_RC);
      }
      ext=_modename2ext(p_mode_name,junk);
      if (file_eq(ext,"fundamental")) {
         name(result);
      } else {
         name(result);
         if (_modename_eq(p_mode_name,'fundamental') ||
             file_eq(get_extension(p_buf_name),'sql')
             ) {
            select_edit_mode(ext);
         }
         p_DocumentName="";
      }
      p_buf_flags&=~PROMPT_REPLACE_BFLAG;
      if (p_window_id==_ctlfile1) {
         labelwid=_ctlfile1label;
      }else{
         labelwid=_ctlfile2label;
      }
      labelwid.p_caption=p_buf_name'(Buffer)';//File cannot be modified
   }
   rv=save("+n -l");
   p_active_form.p_user=1;
   return(rv);
}

_ctlnext_difference.lbutton_up()
{
   _ctlfile1._undo('S');
   _ctlfile2._undo('S');
   _ctlfile1.diff_next_difference();
   //this is a nasty little trick I'm playing to get the scroll to
   //refresh properly
#if 0
   //This was messing up where I just set p_scroll_left_edge to -1 10:29am 4/30/1996
   p_window_id=_ctlfile1;
   _scroll_page('d',1);
   _scroll_page('u',1);
   p_window_id=_ctlfile2;
   _scroll_page('d',1);
   _scroll_page('u',1);
#endif

   p_active_form.p_user=1;
   ReturnFocusToEditWindow();
}

static void ReturnFocusToEditWindow()
{
   LastActiveEditWindowWID._set_focus();
}

_ctlprev_difference.lbutton_up()
{
   _ctlfile1._undo('S');
   _ctlfile2._undo('S');
   _ctlfile1.diff_next_difference('-');
   //this is a nasty little trick I'm playing to get the scroll to
   //refresh properly
   p_window_id=_ctlfile1;
   _scroll_page('d',1);
   _scroll_page('u',1);
   p_window_id=_ctlfile2;
   _scroll_page('d',1);
   _scroll_page('u',1);
   p_active_form.p_user=1;
   ReturnFocusToEditWindow();
}

static void diff_mode_space()
{
   wid=p_window_id;
   if (wid==_ctlfile1) {
      otherwid=_ctlfile2;
   }else{
      otherwid=_ctlfile1;
   }
   old_num_lines=p_Noflines;
   old_linenum=p_line;
   _ctlfile1._undo('S');
   _ctlfile2._undo('S');

   parse lowcase(p_mode_name) with mode_name '-' .;
   index=find_index(mode_name'_space',COMMAND_TYPE);
   if (index) {
      //wid.c_space();
      call_index(index);
   }else{
      maybe_complete();
   }
   if (wid.p_Noflines>old_num_lines) {
      origwid=p_window_id;
      p_window_id=otherwid;
      p_line=old_linenum;
      for (i=1;i<=wid.p_Noflines-old_num_lines;++i) {
         //DiffInsertColorInfo(p_buf_id,p_line);
         InsertImaginaryLine();
      }
#if 0
      p_window_id=wid;
      for (i=1;i<=wid.p_Noflines-old_num_lines;++i) {
         DiffInsertColorInfo(p_buf_id,p_line);
      }
#endif
      p_window_id=origwid;
   }
   AddUndoNothing(otherwid);
}

static void diff_move_text_tab()
{
   wid=p_window_id;
   if (NoSaveLine(p_line)) {
      _beep();
      return;
   }
   if (wid==_ctlfile1) {
      otherwid=_ctlfile2;
   }else{
      otherwid=_ctlfile1;
   }
   _ctlfile1._undo('S');
   _ctlfile2._undo('S');
   wid.move_text_tab();
   AddUndoNothing(otherwid);
}

static void diff_ctab()
{
   wid=p_window_id;
   if (wid==_ctlfile1) {
      otherwid=_ctlfile2;
   }else{
      otherwid=_ctlfile1;
   }
   _ctlfile1._undo('S');
   _ctlfile2._undo('S');
   wid.ctab();
   otherwid.ctab();
}

static void diff_delete_or_cut_word(typeless *pfn)
{
   wid=p_window_id;
   if (NoSaveLine(p_line)) {
      _beep();
      return;
   }
   if (wid==_ctlfile1) {
      otherwid=_ctlfile2;
   }else{
      otherwid=_ctlfile1;
   }
   _ctlfile1._undo('S');
   _ctlfile2._undo('S');
   oldwid=p_window_id;
   p_window_id=wid;
   origNumLines=wid.p_Noflines;

   markid=_alloc_selection();
   WillJoinLine=0;
   save_pos(p);
   if (!pselect_word(markid)) {
      _begin_select(markid);
      bline=p_line;
      _end_select(markid);
      eline=p_line;
      p_line=bline;
      WillJoinLine=bline!=eline;
      if (WillJoinLine) {
         if (p_Noflines>p_line) {
            //We are not on the last line
            if (NoSaveLine(p_line+1)) {
               //The next line is an imaginary buffer line
               _free_selection(markid);
               _beep();
               restore_pos(p);
               return;//Blow out so we don't bring up the imaginary line
            }
         }
      }
   }
   _free_selection(markid);

   restore_pos(p);
   (*pfn)();
   ln=p_line;col=p_col;

   if (wid.p_Noflines!=origNumLines) {
      InsertImaginaryLine();
   }
   p_line=ln;p_col=col;
   AddUndoNothing(otherwid);
   p_window_id=oldwid;
}

static void diff_cut_word()
{
   diff_delete_or_cut_word(delete_word);
}
static void diff_delete_word()
{
   diff_delete_or_cut_word(cut_word);
}

static void diff_prev_or_next_word(typeless *pfn)
{
   wid=p_window_id;
   if (wid==_ctlfile1) {
      otherwid=_ctlfile2;
   }else{
      otherwid=_ctlfile1;
   }
   _ctlfile1._undo('S');
   _ctlfile2._undo('S');

   //AddUndoNothing did not want to work on this one so I gave in and did
   //it the hard way.. shouldn't cause a problem
   (*pfn)();
   oldwid=p_window_id;
   p_window_id=otherwid;
   (*pfn)();
   p_window_id=oldwid;
   //AddUndoNothing(otherwid);
   otherwid.p_line=wid.p_line;
   otherwid.p_col=wid.p_col;
   otherwid.set_scroll_pos(wid.p_left_edge,wid.p_cursor_y);
}

static void diff_prev_word()
{
   diff_prev_or_next_word(prev_word);
}

static void diff_next_word()
{
   diff_prev_or_next_word(next_word);
}

static void diff_word_complete(_str fname)
{
   //This seems really screwy, but I gotta do some screwy stuff with undo...
   wid=p_window_id;
   if (NoSaveLine(p_line)) {
      _beep();
      return;
   }
   if (wid==_ctlfile1) {
      otherwid=_ctlfile2;
   }else{
      otherwid=_ctlfile1;
   }
   wid._undo('S');
   otherwid._undo('S');
   was_selected=select_active();
   index=find_index(fname,COMMAND_TYPE);
   rv=call_index(index);
   if (rv==1 && was_selected) {
      index1=find_index('complete-prev',COMMAND_TYPE);
      index2=find_index('complete-next',COMMAND_TYPE);
      index3=find_index('complete-more',COMMAND_TYPE);
      pi=prev_index();
      last_command_was_complete_command=(pi==index1||pi==index2||pi==index3);
      if (last_command_was_complete_command) {
         //say('AddUndoNothing 1');
         //AddUndoNothing(otherwid);
      }
   }
   if (rv==1) {
      AddUndoNothing(otherwid);
   }
   prev_index(index);
}

static void diff_complete_prev()
{
   diff_word_complete('complete-prev');
}

static void diff_complete_next()
{
   diff_word_complete('complete-next');
}

static void diff_complete_more()
{
   diff_word_complete('complete-more');
}

static void diff_find_matching_paren()
{
   otherwid=GetOtherWid(wid);
   _ctlfile1._undo('S');
   _ctlfile2._undo('S');
   status=find_matching_paren();
   if (!status) {
      otherwid.p_line=wid.p_line;
      //AddUndoNothing(otherwid);
      //Do not need to add undo information for this operation
   }
}

static void diff_cut_end_line()
{
   wid=p_window_id;
   if (wid==_ctlfile1) {
      otherwid=_ctlfile2;
   }else{
      otherwid=_ctlfile1;
   }
   _ctlfile1._undo('S');
   _ctlfile2._undo('S');

   origNumLines=wid.p_Noflines;

   p_window_id=wid;
   cut_end_line();

   ln=p_line;col=p_col;

   if (wid.p_Noflines!=origNumLines) {
      InsertImaginaryLine();
   }
   p_line=ln;p_col=col;
   AddUndoNothing(otherwid);
}

static void diff_expand_alias()
{
   wid=p_window_id;
   if (wid==_ctlfile1) {
      otherwid=_ctlfile2;
   }else{
      otherwid=_ctlfile1;
   }
   old_num_lines=p_Noflines;
   old_linenum=p_line;
   _ctlfile1._undo('S');
   _ctlfile2._undo('S');

#if 0
   parse lowcase(p_mode_name) with mode_name '-' .;
   index=find_index(mode_name'_space',COMMAND_TYPE);
   if (index) {
      //wid.c_space();
      call_index(index);
   }else{
      maybe_complete();
   }
#endif
   expand_alias();
   AddUndoNothing(otherwid);
   if (wid.p_Noflines>old_num_lines) {
      otherwid.p_line=old_linenum;
      for (i=1;i<=wid.p_Noflines-old_num_lines;++i) {
         otherwid.InsertImaginaryLine();
      }
   }
}

static void diff_undo()
{
   lindex=last_index('','C');pindex=prev_index('','C');
   status1=_ctlfile2._undo();
   last_index(lindex,'C');prev_index(pindex,'C');
   status2=_ctlfile1._undo();
   vscroll1.p_user='';
   vscroll1.p_value=_ctlfile1.p_line;
   vscroll1.p_user=_ctlfile1.p_line;//old;
   OtherWid=GetOtherWid(wid);
   OtherWid.set_scroll_pos(wid.p_left_edge,wid.p_cursor_y);
   //Have seen some peculiarities with scroll after undo, this is a "brute force" fix
   p_active_form.p_user=1;
   //prev_index(0,'C');
   //last_index(0,'C');
}

static void diff_undo_cursor()
{
   lindex=last_index('','C');pindex=prev_index('','C');
   _ctlfile2._undo('C');
   last_index(lindex,'C');prev_index(pindex,'C');
   _ctlfile1._undo('C');
   vscroll1.p_user='';
   vscroll1.p_value=_ctlfile1.p_line;
   vscroll1.p_user=_ctlfile1.p_line;//old;
   p_window_id=LastActiveEditWindowWID;
   OtherWid=GetOtherWid(wid);
   OtherWid.set_scroll_pos(wid.p_left_edge,wid.p_cursor_y);
   p_active_form.p_user=1;
   prev_index(0,'C');
   last_index(0,'C');
}

static void diff_select_line()
{
   wid=p_window_id;
   if (wid==_ctlfile1) {
      otherwid=_ctlfile2;
   }else{
      otherwid=_ctlfile1;
   }
   otherwid._undo('S');
   wid._undo('S');
   wid.select_line();
   //Look for a better way to do this
   AddUndoNothing(otherwid);
}

static void diff_select_char()
{
   wid=p_window_id;
   if (wid==_ctlfile1) {
      otherwid=_ctlfile2;
   }else{
      otherwid=_ctlfile1;
   }
   otherwid._undo('S');
   wid._undo('S');
   wid.select_char();
   //Look for a better way to do this
   AddUndoNothing(otherwid);
}

static void diff_deselect()
{
   if (!select_active()) return;
   wid=p_window_id;
   if (wid==_ctlfile1) {
      otherwid=_ctlfile2;
   }else{
      otherwid=_ctlfile1;
   }
   wid._undo('S');
   otherwid._undo('S');
   wid.deselect();
   AddUndoNothing(otherwid);
}

static int GetOtherWid(int &wid)
{
   wid=p_window_id;
   if (wid==_ctlfile1) {
      otherwid=_ctlfile2;
   }else{
      otherwid=_ctlfile1;
   }
   return(otherwid);
}

static void diff_shift_selection_right()
{
   otherwid=GetOtherWid(wid);
   wid._undo('S');
   otherwid._undo('S');

   wid.shift_selection_right();

   AddUndoNothing(otherwid);
   p_active_form.p_user=1;
}

static void diff_shift_selection_left()
{
   otherwid=p_window_id.GetOtherWid(wid);
   wid._undo('S');
   otherwid._undo('S');

   wid.shift_selection_left();

   AddUndoNothing(otherwid);
   p_active_form.p_user=1;
}

static void diff_maybe_complete()
{
   otherwid=p_window_id.GetOtherWid(wid);
   wid._undo('S');
   otherwid._undo('S');

   wid.maybe_complete();
   otherwid.right();
   AddUndoNothing(otherwid);
   p_active_form.p_user=1;
}

static void diff_cursor_left()
{
   otherwid=p_window_id.GetOtherWid(wid);
   wid._undo('S');
   otherwid._undo('S');
   wid.left();
   otherwid.left();
}

static void diff_cursor_right()
{
   otherwid=p_window_id.GetOtherWid(wid);
   wid._undo('S');
   otherwid._undo('S');
   wid.right();
   otherwid.right();
}

static void diff_mou_select_word()
{
   wid=p_window_id;
   if (wid==_ctlfile1) {
      otherwid=_ctlfile2;
   }else{
      otherwid=_ctlfile1;
   }
   otherwid._undo('S');
   wid._undo('S');
   wid.mou_select_word();
   AddUndoNothing(otherwid);
}

static void diff_mou_select_line()
{
   wid=p_window_id;
   if (wid==_ctlfile1) {
      otherwid=_ctlfile2;
   }else{
      otherwid=_ctlfile1;
   }
   otherwid._undo('S');
   wid._undo('S');
   wid.mou_select_line();
   AddUndoNothing(otherwid);
}

static void diff_rubout()
{
   if (OnImaginaryLine()) {
      return;
   }
   if (select_active() && _within_char_selection()) {
      //DiffMessage('Mark deletes not yet available');
      diff_linewrap_delete_char('delete-selection');
      return;
   }
   if (p_col==1) {
      return;
   }
   otherwid=p_window_id.GetOtherWid(wid);
   wid._undo('S');
   otherwid._undo('S');

   wid.rubout();
   otherwid.left();
   AddUndoNothing(otherwid);

   p_active_form.p_user=1;
}

static int OnImaginaryLine()
{
   return(_lineflags()&NOSAVE_LF);
}

static void diff_linewrap_rubout()
{
   if (OnImaginaryLine()) {
      return;
   }
   if (select_active() && _within_char_selection()) {
      //DiffMessage('Mark deletes not yet available');
      diff_linewrap_delete_char('delete-selection');
      return;
   }
   otherwid=p_window_id.GetOtherWid(wid);
   orig_numlines=p_Noflines;
   wid._undo('S');
   otherwid._undo('S');

   orig_line='';
   if (!wid.up()) {
      wid.get_line(orig_line);wid.down();
   }
   wid.linewrap_rubout();
   if (wid.p_Noflines<orig_numlines) {
      InsertImaginaryLine();
      up();_end_line();
      AddUndoNothing(otherwid);
      otherwid.p_line=wid.p_line;
      wid.p_col=length(orig_line)+1;
   }
   AddUndoNothing(otherwid);

   p_active_form.p_user=1;
}

static void diff_multi_delete(...)
{
   if ((arg(1)==''||p_word_wrap_style&WORD_WRAP_WWS) && OnImaginaryLine()) {
      get_line(line);
      if (p_col==length(line)) return;
   }
   if (!down()) {
      if (OnImaginaryLine()) {
         if (arg(1)=='' ||
             arg(1)=='linewrap-delete-char'||
             arg(1)=='delete-char') {
            DiffMessageBox('Cannot split Imaginary line');
            up();
            return;
         }
      }
      up();
   }

   otherwid=p_window_id.GetOtherWid(wid);
   orig_numlines=p_Noflines;
   wid._undo('S');
   otherwid._undo('S');

   origline=wid.p_line;
   wid.get_line(line);
   boolean onlast=OnLastLine();
   switch (arg(1)) {
   case 'cut':
      wid.cut();break;
   case 'linewrap-delete-char':
      wid.linewrap_delete_char();break;
   case 'delete-char':
      wid.linewrap_delete_char();break;
   case 'cut-line':
      oldmodify=wid.p_modify;
      isimaginary=wid._lineflags()&NOSAVE_LF;
      wid.cut_line();
      if (isimaginary) wid.p_modify=oldmodify;
      break;
   case 'delete-line':
      oldmodify=p_modify;
      isimaginary=_lineflags()&NOSAVE_LF;
      wid.delete_line();
      if (isimaginary) p_modify=oldmodify;
      break;
   case 'delete-selection':
      wid.delete_selection();break;
   default:
      wid._begin_select();
      oldwid=p_window_id;p_window_id=wid;
      _delete_selection();
      p_window_id=oldwid;
      wid.keyin(last_event());
      break;
   }
   if (wid.p_Noflines<orig_numlines) {
      cur_num_lines=wid.p_Noflines;
      otherwid.p_line=origline;
      if (!wid.OnLastLine()) {
         otherwid.p_line=wid.p_line;
      }
      for (i=1;i<=orig_numlines-cur_num_lines;++i) {
         old_col=p_col;
         if (!otherwid.OnImaginaryLine()) {
            if (!onlast) {
               up();
            }
            InsertImaginaryLine();
            if (!onlast) {
               down();
            }
            otherwid.set_line_inserted();
            otherwid.down();
            AddUndoNothing(otherwid);
         }else{
            AddUndoNothing(wid);
            wid=p_window_id;
            p_window_id=otherwid;
            oldmodify=p_modify;
            isimaginary=_lineflags()&NOSAVE_LF;
            _delete_line();
            if (isimaginary) {
               p_modify=oldmodify;
            }
            p_window_id=wid;
         }
         p_col=old_col;
      }
      otherwid.p_line=wid.p_line;
   }
   if (_lineflags()&MODIFY_LF) {
      otherwid._lineflags(MODIFY_LF,MODIFY_LF);
   }
   AddUndoNothing(otherwid);

   otherwid.set_scroll_pos(otherwid.p_left_edge,wid.p_cursor_y);
   p_active_form.p_user=1;
}

static void diff_linewrap_delete_char(...)
{
   if (select_active()) {
      diff_multi_delete('delete-selection');
      return;
   }
   diff_multi_delete('linewrap-delete-char');
}

static void diff_delete_char()
{
   if (select_active()) {
      diff_multi_delete('delete-selection');
      return;
   }
   diff_multi_delete('delete-char');
}

static void diff_cut_line()
{
   if (select_active()) {
      //DiffMessage('Mark deletes not yet available');
      diff_multi_delete('cut');
      return;
   }
   diff_multi_delete('cut-line');
}

static void diff_join_line()
{
   otherwid=GetOtherWid(wid);
   int origNumLines=p_Noflines;
   status=down();
   if (!status) {
      lf=_lineflags();
      up();
   }
   if (lf&NOSAVE_LF) {
      DiffMessageBox('Cannot join Imaginary line');
      return;
   }
   wid._undo('S');
   otherwid._undo('S');
   join_line();
   save_pos(p);
   if (origNumLines!=p_Noflines) {
      nlines=otherwid.GetNumberOfImaginaryLines(1);
      if (!nlines) {
         InsertImaginaryLine();
      }else{
         otherwid._delete_line();
      }
   }
   restore_pos(p);
   AddUndoNothing(otherwid);
}

static void diff_delete_line()
{
   if (select_active()) {
      //DiffMessage('Mark deletes not yet available');
      diff_multi_delete('delete-selection');
      return;
   }
   diff_multi_delete('delete-line');
}

static void AddUndoNothing(int wid)
{
   oldmodify=wid.p_modify;
   oldflags=wid._lineflags();
   wid.get_line(line);
   wid.replace_line(line);
   wid.p_modify=oldmodify;
   wid._lineflags(0,wid._lineflags()&~oldflags);
}

static _str GetClipboardType(...)
{
   get_view_id(view_id);
   activate_view(HIDDEN_VIEW_ID);
   status=find_view('.clipboards')
   if ( ! status ) {
      get_line(line);
      parse line with ':' mark_name noflines .
      if( !pos(' 'mark_name' ',' LINE CHAR BLOCK ') ) {
         retval='invalid';
      } else {
         retval=mark_name' 'noflines;
      }
   } else {
      if( !p_noflines ) {
         retval='No clipboards';
      }
   }
   get_view_id(clipbd_view_id);
   activate_view(view_id);
   arg(1)=noflines;
   return(retval);
}

static void diff_next_window()
{
   otherwid=GetOtherWid(wid);
   otherwid._set_focus();
}

static void diff_copy_to_clipboard()
{
   otherwid=GetOtherWid(wid);

   wid._undo('S');
   otherwid._undo('S');

   was_selected=select_active();
   wid.copy_to_clipboard();
   //4:27pm 4/14/1998
   //Only want this if there was a selection
   if (was_selected) {
      AddUndoNothing(otherwid);
   }
}

static void diff_copy_word()
{
   otherwid=GetOtherWid(wid);
   if (NoSaveLine(p_line)) {
      _beep();
      return;
   }

   markid=_alloc_selection();
   WillJumpLine=0;
   save_pos(p);
   if (!pselect_word(markid)) {
      _begin_select(markid);
      bline=p_line;
      _end_select(markid);
      eline=p_line;
      p_line=bline;
      WillJumpLine=bline!=eline;
      if (WillJumpLine) {
         if (p_Noflines>p_line) {
            //We are not on the last line
            if (NoSaveLine(p_line+1)) {
               //The next line is an imaginary buffer line
               _free_selection(markid);
               _beep();
               restore_pos(p);
               return;//Blow out so we don't bring up the imaginary line
            }
         }
      }
   }
   restore_pos(p);
   _free_selection(markid);
   wid._undo('S');
   otherwid._undo('S');
   wid.copy_word();
   //4:27pm 4/14/1998
   //This seems to mess things up
   //AddUndoNothing(otherwid);
   otherwid.p_line=wid.p_line;
}

static int GetNumberOfImaginaryLines(int noflines)
{
   save_pos(p);
   count=0;
   for (i=1;i<=noflines;++i) {
      if (_lineflags()&NOSAVE_LF) {
         ++count;
      }
      if (down()) {
         break;
      }
   }
   restore_pos(p);
   return(count);
}

static void diff_paste()
{
   otherwid=GetOtherWid(wid);
   orig_numlines=p_Noflines;
   wid._undo('S');otherwid._undo('S');

   noflines_pasted='';//passed by reference to GetClipboardType
   ctype=GetClipboardType(noflines_pasted);
   parse ctype with type .
   noflines_imaginary=GetNumberOfImaginaryLines(noflines_pasted);
   moved=0;
   if (noflines_imaginary>noflines_pasted) {
      for (i=1;i<=noflines_pasted;++i) {
         if (type=='LINE') {
            lf=_lineflags();
            if (lf&NOSAVE_LF) {
               _delete_line();
               moved=1;
            }
         }else{
            MaybeMakeLineReal();
         }
      }
   }else if (noflines_imaginary<=noflines_pasted) {
      //say('noflines_imaginary='noflines_imaginary);
      for (i=1;i<=noflines_imaginary;++i) {
         if (type=='LINE') {
            lf=_lineflags();
            if (lf&NOSAVE_LF) {
               _delete_line();
               moved=1;
            }
         }else{
            MaybeMakeLineReal();
         }
      }
   }
   if (moved && p_line!=p_Noflines) {
      up();
   }
   insert_after=( (type=='CHAR') || (strip(upcase(def_line_insert))=='A') );
   origline=wid.p_line;origotherline=otherwid.p_line;
   DiffTextChangeCallback(0,_ctlfile1.p_buf_id);
   DiffTextChangeCallback(0,_ctlfile2.p_buf_id);
   wid.paste();AddUndoNothing(otherwid);
   DiffTextChangeCallback(1,_ctlfile1.p_buf_id);
   DiffTextChangeCallback(1,_ctlfile2.p_buf_id);
   cur_numlines=wid.p_Noflines;
   if (cur_numlines>orig_numlines) {
      for (i=1;i<=cur_numlines-orig_numlines/*-noflines_imaginary*/;++i) {
         otherwid.InsertImaginaryLine();
         if (!insert_after) otherwid.up();
         AddUndoNothing(otherwid);
         if (!insert_after) otherwid.down();
      }
   }else if (cur_numlines<orig_numlines) {
      for (i=1;i<=orig_numlines-cur_numlines;++i) {
         InsertImaginaryLine();
         if (!insert_after) otherwid.up();
         otherwid.AddUndoNothing(otherwid);
         if (!insert_after) otherwid.down();
      }
   }
   //fsay('origline='origline' wid.p_line='wid.p_line' noflines_pasted='noflines_pasted' p_Noflines='p_Noflines);
   //say('origline='origline' wid.p_line='wid.p_line' noflines_pasted='noflines_pasted' p_Noflines='p_Noflines);
   if (noflines_pasted=='') {
      DiffUpdateColorInfo(_ctlfile1,_ctlfile1.p_line,_ctlfile2,_ctlfile2.p_line,0);
   }else{
      for (i=origline+1;i<wid.p_line+noflines_pasted-1;++i) {
         //fsay('diffing i='i);
         //say('diffing i='i);
         DiffUpdateColorInfo(_ctlfile1,i,_ctlfile2,i,0);
      }
   }
   otherwid.p_line=wid.p_line;
   otherwid.set_scroll_pos(otherwid.p_left_edge,wid.p_cursor_y);
}

static void diff_close_form()
{
   _ctlclose.call_event(_ctlclose,LBUTTON_UP);
   //p_active_form._delete_window();
}

//Could put this all in the function diff_cua_select, but with no local
//initializing yet, I can't see doing that.  This seems like it should be faster
//anyway.
static _str CUA_SELECT_TRANSLATIONS:[]=
         {
             "C-S-END"=>   C_END
            ,"C-S-HOME"=>  C_HOME

            ,"C-S-RIGHT"=> C_RIGHT
            ,"C-S-LEFT"=>  C_LEFT
            ,"C-S-UP"=>    C_UP
            ,"C-S-DOWN"=>  C_DOWN

            ,"C-S-PGUP"=>  C_PGUP
            ,"C-S-PGDN"=>  C_PGDN

            ,"S-END"=>     END
            ,"S-HOME"=>    HOME

            ,"S-RIGHT"=>   RIGHT
            ,"S-LEFT"=>    LEFT
            ,"S-UP"=>      UP
            ,"S-DOWN"=>    DOWN

            ,"S-PGUP"=>    PGUP
            ,"S-PGDN"=>    PGDN
         };

static void diff_cua_select()
{
   if (p_window_id==_ctlfile1) {
      _ctlfile2._undo('S');
   }else{
      _ctlfile1._undo('S');
   }
   event=last_event();
   event_name=event2name(event);
   otherwid=GetOtherWid(wid);
   in_cua_select=1;_argument=1;
   cua_select();
   _argument="";
   in_cua_select=0;
   _dont_use_diff_command=1;
   //messageNwait("event_name="event_name);
   //otherwid.call_event(otherwid,CUA_SELECT_TRANSLATIONS:[event_name]);
   AddUndoNothing(otherwid);
   //otherwid.p_line=wid.p_line;
   _dont_use_diff_command=0;
}

const SAA_MARK_KEYS=S_LEFT:+S_RIGHT:+S_DOWN:+S_UP:+S_PGUP:+S_PGDN:+S_HOME:+S_END;
const SAA_REPEAT_KEYS=S_LEFT:+S_RIGHT:+S_DOWN:+S_UP;
const SAA_MAP_KEYS=LEFT:+RIGHT:+DOWN:+UP:+PGUP:+PGDN:+HOME:+END;
static _str cua_col;

//Could avoid this redundant code by making cua_select call this, but then it
//would have to be global.
_command void diff_cua_select2()
{
   index=last_index();
   key=last_event();
   last_command=name_name(prev_index('','c'))
   if ((_cua_select && last_command!='diff-cua-select2' && def_persistent_select=='Y') || ! select_active() ||
      (! _cua_select && _select_type('','U')=='P' && _select_type('','s')=='E')
   ) {
      /* (not _cua_select and not select_active()) then */
      _deselect();
      /* bprint(last_command) */
   }
   inclusive='';
   if ( _select_type()!='' && _select_type('','I') ) {
      inclusive='I';
   }
   if ( def_persistent_select=='Y' ) {
      mstyle='EP':+inclusive;
   } else {
      mstyle='E':+inclusive;
   }
   if ( _select_type()=='' ) {
      cua_col=p_col;
      status=_select_char('',mstyle);
      if (status) {
         DiffMessageBox(get_message(status));
         return;
      }
   }
   i=pos(key,SAA_MARK_KEYS);
   if ( i && length(key):==2 ) {
      //if (substr(SAA_MAP_KEYS,i,2)==DOWN) trace
      // Don't want on_select called because the selection will
      // go away, These keys are ok in read only mode.
      call_key(substr(SAA_MAP_KEYS,i,2),'','s');
   } else {
      if ( key:==name2event('s-c-home') ) {
         top_of_buffer();
      } else if ( key:==name2event('s-c-end') ) {
         bottom_of_buffer();
      } else if ( key:==name2event('s-c-left') ) {
         prev_word();
      } else if ( key:==name2event('s-c-right') ) {
         next_word();
      }
   }

   /* IF start line same as end line. */
   if (!def_scursor_style) {
      select_it(_select_type(),'',mstyle);
   } else if (_begin_select_compare()==0 && _end_select_compare()==0) {
      if (_select_type()!='CHAR'){
         _select_type('','T','CHAR');
      }
      select_it(_select_type(),'',mstyle);

      if (def_scursor_style && _isnull_selection()) {
         if (_select_type()!='LINE'){
            _select_type('','T','LINE');
         }
      }
   } else {
      cc=_select_type('','P')
      _get_selinfo  bcol,ecol,junk;
      if (cc!='EB' && cc!='BB') {
         col=ecol;
      } else {
         col=bcol;
      }
      // Just mouse starting this selection, set cua_col to something
      // reasonable.
      if (cua_col!=col && cua_col!=col-1 && cua_col!=col+1) {
         cua_col=col;
      }
      if (cua_col==p_col /* && _select_type()!='BLOCK'*/) {
         /* We want a line mark. */
         if (_select_type()!='LINE' ) {
            _select_type('','T','LINE');
         }
         select_it(_select_type(),'',mstyle);
      } else {
         /* We want a block mark. */
         if (_select_type()!='BLOCK') {
            _select_type('','T','NBLOCK');
         }
         if (cua_col<p_col) {
            /* We want a non-inclusive block mark. */
            --p_col;
            select_it(_select_type(),'',mstyle);
            ++p_col;
         } else {
            select_it(_select_type(),'',mstyle);
         }
      }
   }
   last_index(index,'c');

   _cua_select=1
   if (_argument=='') {
      _undo 's'
   }
   /* call_key set the last_event to the wrong key. */
   /* Correct it here. */
   last_event(key);
}

static void diff_maybe_deselect()
{
   if (in_cua_select) return;
   if (select_active()) {
      if ( _select_type('','U')!='P') {
         diff_deselect();
      }
   }
}

static void diff_mou_click()
{
   otherwid=GetOtherWid(wid);
   wid._undo('s');
   otherwid._undo('s');
   wid.mou_click();
   otherwid.p_line=wid.p_line;
   otherwid.p_col=wid.p_col;
   otherwid.refresh('W');
   p_active_form.p_user=1;
   //otherwid.set_scroll_pos(otherwid.p_left_edge,wid.p_cursor_y);
   otherwid.set_scroll_pos(wid.p_left_edge,wid.p_cursor_y);
   //AddUndoNothing(otherwid);
}

static int MaybeSaveFile(...)
{
   if (p_modify) {
      buf_name=p_DocumentName;
      if (buf_name=="") {
         buf_name=p_buf_name;
      }
      result=_message_box(nls("Do you wish to save changes to the file '%s'",buf_name),
                          '',
                          MB_YESNOCANCEL|MB_ICONQUESTION);
      switch (result) {
      case IDNO:
         labelname=p_name'label';
         wid=p_active_form._find_control(labelname);
         if (wid) {
            lp=lastpos('(',wid.p_caption);
            lp2=lastpos(')',wid.p_caption);
            if (lp && lp2) {
               buforfile=substr(wid.p_caption,lp+1,(lp2-1)-(lp));
               if (upcase(buforfile)=='BUFFER') {
                  if (p_undo_steps) {
                     while (_undo('C')!=NOTHING_TO_UNDO_RC);
                  }
                  clear_message();
               }
            }
         }
         return(0);
      case IDCANCEL:
         return(COMMAND_CANCELLED_RC);
      case IDYES:
         arg(1)=1;
         name=substr(p_name,1,9);
         wid=p_active_form._find_control(name'save');
         if (wid) {
            return(wid.call_event(wid,LBUTTON_UP));
         }
         return(1);
      }
   }
   return(0);
}

int _ctlclose.lbutton_up()
{
   status=_ctlfile1.MaybeSaveFile();
   if (status) {
      return(status);
   }
   SavedFile2=0;
   status=_ctlfile2.MaybeSaveFile(SavedFile2);
   if (status) {
      return(status);
   }
   if (SavedFile2) {
      p_active_form._delete_window(status);//Could be vc merge - should not hurt otherwise
      return(status);
   }
   p_active_form._delete_window(COMMAND_CANCELLED_RC);
   return(COMMAND_CANCELLED_RC);
}

int _ctlok.lbutton_up()
{
   if (_ctlfile2.p_modify) {
      result=_message_box(nls("Do you wish to save changes to the file '%s'?",
                          _ctlfile2.p_buf_name)
                          ,'',MB_YESNOCANCEL|MB_ICONQUESTION);
      if (result==IDYES) {
         _ctlfile2.p_AllowSave=1;
         _ctlfile2.save("+n");
      }else if (result==IDCANCEL) {
         return(0);
      }
   }
   p_active_form._delete_window(0);
   return(0);
}

_ctlundo.lbutton_up()
{
   diff_undo_cursor();
}
static void GetFileOrBuffer(_str &Label)
{
   //Need to trim off (File) or (Buffer) (maybe a modified indicator) from label
   lp=lastpos('(',p_caption);
   if (!lp) {//Filename not really there yet
      Label='';
      return;
   }
   str=substr(p_caption,lp);
   p_caption=substr(p_caption,1,lp-1);
   Label=str;
}

static void DiffShrinkFilename(int width)
{
   //Need to trim off (File) or (Buffer) (maybe a modified indicator) from label
   lp=lastpos('(',p_caption);
   if (!lp) {//Filename not really there yet
      return;
   }
   GetFileOrBuffer(str);
   p_caption=_ShrinkFilename(p_caption,width-_text_width(str)):+str;
}

//Method on a label,(or other object with font).  width is in twips or
// controls p_scale_mode
_str _ShrinkFilename(_str value,int width)
{
   for (;;){
      //if (length(value)<=len) break;
      if (_text_width(value)<=width) break;
      /* Remove a path */
#if __UNIX__
      //start=substr(value,1,1);
      //rest=substr(value,2);
      parse value with 2 start '/','r'
      if (length(start)) {
         start='/'start:+'/';
      } else {
         start='/';
      }
      rest=substr(value,length(start)+1);
#else
      if (substr(value,1,2)=='\\') {
         parse value with '\\' server '\' share_name '\' rest;
         start='\\' server '\' share_name;
         if (rest!='') {
            start=start:+FILESEP;
         }
      } else {
         start=substr(value,1,3);
         rest=substr(value,4);
      }
#endif
      // Just incase server share name is very long
      if (rest=='..' || rest=='') {   // Bug Fix
         value='';break;
      }
      for (;;) {
         parse rest with  path (FILESEP) rest;
         if (rest=='') {
            rest='..';
            break;
         }
         if (path!='..') {
            rest='..':+FILESEP:+rest;
            break;
         }
      }
      value=start :+ rest;
   }
   return(value);
}

_command void cmd_message_box()
{
   _message_box(nls("%s",arg(1)));
}

_command int cmd_message_box_ync()
{
   return _message_box(nls("%s",arg(1)),'',MB_YESNOCANCEL|MB_ICONQUESTION);
}

int _OnUpdate_diff_toggle_intraline_color(CMDUI &cmdui,int target_wid,_str command)
{
   if (gIntraLineIsOff==1) {
      return(MF_ENABLED);
   }else if (gIntraLineIsOff=='') {
      return(MF_ENABLED|MF_CHECKED);
   }
   return(MF_ENABLED);
}

_command void diff_toggle_intraline_color()
{
   if (gIntraLineIsOff==1) {
      gIntraLineIsOff='';
      DiffIntraLineColoring(1,_ctlfile1.p_buf_id);
      DiffIntraLineColoring(1,_ctlfile2.p_buf_id);
   }else{
      gIntraLineIsOff=1;
      DiffIntraLineColoring(0,_ctlfile1.p_buf_id);
      DiffIntraLineColoring(0,_ctlfile2.p_buf_id);
   }
   _ctlfile1.refresh('W');
   _ctlfile2.refresh('W');
}

static boolean lines_dont_match()
{
   get_line(line1);
   lf1=_lineflags();
   next_window();
   get_line(line2);
   lf2=_lineflags();
   next_window();
   return((lf1==lf2) && line1!=line2);
}

static void InsertImaginaryLine()
{
   oldmodify=p_modify;
   ibl='Imaginary Buffer Line';
   insert_line(ibl);
   _lineflags(NOSAVE_LF,NOSAVE_LF);
   p_modify=oldmodify;
}

static int GetLineStatus()
{
   if (_ctlfile1.p_line!=_ctlfile2.p_line) {
#if 0
      if (arg(1)<6) {
         _message_box(nls("Lines not the same arg(1)=%s",arg(1)));
      }
#endif
   }
   _ctlfile1.get_line(line1);
   flag1=_ctlfile1._lineflags();
   _ctlfile2.get_line(line2);
   flag2=_ctlfile2._lineflags();
   if ( (!(flag1&MODIFY_LF) && !(flag1&INSERTED_LINE_LF)) &&
        (!(flag2&MODIFY_LF) && !(flag2&INSERTED_LINE_LF))) {
      return(MATCHING_LINE);
   }
   if ( (flag1&MODIFY_LF) || (flag2&MODIFY_LF) ) {
      return(CHANGED_LINE);
   }
   if (flag1&NOSAVE_LF) {
      return(DELETED_LINE);
   }
   if (flag2&NOSAVE_LF) {
      return(INSERTED_LINE);
   }
   //message('flag1='flag1' flag2='flag2' _ctlfile1.p_line='_ctlfile1.p_line' _ctlfile2.p_line='_ctlfile2.p_line);
   //_message_box(nls("How did I get here"));
   return(0);
}

static _str GetList(int OrigLineFlag,.../*MergeDialog*/)
{

   if (arg(2)=='') {
      switch (OrigLineFlag) {
      case MATCHING_LINE:
         list=' 'INSERTED_LINE' 'CHANGED_LINE' 'DELETED_LINE' ';break;
      case INSERTED_LINE:
         list=' 'CHANGED_LINE' 'DELETED_LINE' ';break;
      case CHANGED_LINE:
         list=' 'INSERTED_LINE' 'DELETED_LINE' ';break;
      case DELETED_LINE:
         list=' 'INSERTED_LINE' 'CHANGED_LINE' ';break;
      }
   }else{
      switch (OrigLineFlag) {
      case MATCHING_LINE:
         list=' 'INSERTED_LINE' 'CHANGED_LINE' 'DELETED_LINE' ';break;
      case INSERTED_LINE:
         list=' 'DELETED_LINE' ';break;
      case CHANGED_LINE:
         list=' 'INSERTED_LINE' 'DELETED_LINE' ';break;
      case DELETED_LINE:
         list=' 'INSERTED_LINE' 'CHANGED_LINE' ';break;
      }
   }
   return(list);
}

static _str GetFlags(int OrigLineFlag,.../*MergeDialog*/)
{

   if (arg(2)=='') {
      switch (OrigLineFlag) {
      case MATCHING_LINE:
         list=INSERTED_LINE|CHANGED_LINE|DELETED_LINE;break;
      case INSERTED_LINE:
         list=CHANGED_LINE|DELETED_LINE;break;
      case CHANGED_LINE:
         list=INSERTED_LINE|DELETED_LINE;break;
      case DELETED_LINE:
         list=INSERTED_LINE|CHANGED_LINE;break;
      }
   }else{
      switch (OrigLineFlag) {
      case MATCHING_LINE:
         list=INSERTED_LINE|CHANGED_LINE|DELETED_LINE;break;
      case INSERTED_LINE:
         list=DELETED_LINE;break;
      case CHANGED_LINE:
         list=INSERTED_LINE|DELETED_LINE;break;
      case DELETED_LINE:
         list=INSERTED_LINE|CHANGED_LINE;break;
      }
   }
   return(list);
}

static void diff_end_line()
{
   otherwid=p_window_id.GetOtherWid(wid);
   if (!(otherwid._lineflags()&NOSAVE_LF)) {
      wid._undo('S');
      otherwid._undo('S');
      wid.end_line();
      el1=wid.p_col;
      otherwid.end_line();
#if 0
      el2=otherwid.p_col;
      wid.p_col=max(el1,el2);
      otherwid.p_col=max(el1,el2);
#endif
   }else{
      diff_maybe_deselect_command(end_line);
   }
}

static int FlagTable[]={
   INSERTED_LINE|CHANGED_LINE|DELETED_LINE,//Matching line
   CHANGED_LINE|DELETED_LINE,
   INSERTED_LINE|DELETED_LINE,
   0,//These are in hex, so there isn't a 3
   INSERTED_LINE|CHANGED_LINE
};

static diff_next_difference(...)
{
   wid=p_window_id;
   wid=_ctlfile1;
   _ctlfile2.p_line=_ctlfile1.p_line;//Just in case

   _ctlfile1.p_col=1;_ctlfile2.p_col=1;
   _ctlfile1._refresh_scroll();_ctlfile2._refresh_scroll();

   line1flag=_ctlfile1._lineflags();
   //_ctlfile1.get_line(line1);
   line2flag=_ctlfile2._lineflags();
   //_ctlfile2.get_line(line2);

   orig=GetLineStatus();
   if (DialogIsDiff()) {
      //list=GetList(orig);
      list=FlagTable[orig];
   }else{
      //list=GetList(orig,1);
      list=GetFlags(orig,1)
   }
   found=0;
   _ctlfile1.save_pos(p);
   _ctlfile2.save_pos(p2);

   boolean isDiffDialog=DialogIsDiff();
   if (arg(1)=='') {
      while (!(_ctlfile1.down()||_ctlfile2.down())) {
         cur=GetLineStatus();
         if (!isDiffDialog && cur==MATCHING_LINE) {
            //list=GetFlags(MATCHING_LINE);
            list=FlagTable[MATCHING_LINE];
         }
         if (cur!=orig && !(orig&list)) {
            list=list|orig;
         }
         if (cur&list) {
            found=1;
            break;
         }
      }
   }else{
      while (!(_ctlfile1.up()||_ctlfile2.up())) {
         cur=GetLineStatus();
         if (!DialogIsDiff() && cur==MATCHING_LINE) {
            list=FlagTable[MATCHING_LINE];
         }
         if (cur!=orig && !(orig&list)) list=list|orig;
         if (cur&list) {
            //Don't want to find adjacent changes
            orig=GetLineStatus();
            found=1;
            difftype=GetLineStatus();
            while (!(_ctlfile1.up()||_ctlfile2.up())) {
               if (!_ctlfile1.p_line || !_ctlfile2.p_line) {
                  _ctlfile1.down();_ctlfile2.down();
                  break;
               }
               cur=GetLineStatus();
               if (cur!=difftype) {
                  _ctlfile1.down();_ctlfile2.down();
                  break;
               }
            }
            break;
         }
      }
   }
   if (!found) {
      _ctlfile1.restore_pos(p);
      _ctlfile2.restore_pos(p2);
      if (_ctlfile1.p_parent.p_visible) {//Form may not be visible
         if (DialogIsDiff()) {
            DiffMessageBox('No more differences');
         }else{
            DiffMessageBox('No more conflicts');
         }
      }
      return(1);
   }

   _ctlfile1.center_line();
   _ctlfile2.center_line();
   p_window_id=wid;

   if (!(_ctlfile1._lineflags()&NOSAVE_LF) && !(_ctlfile2._lineflags()&NOSAVE_LF)) {
      _ctlfile1.get_line(line1);
      _ctlfile2.get_line(line2);
      i=1;
      while ( (substr(line1,i,1) == substr(line2,i,1) ) &&
              i<=length(line1) && i<=length(line2)) ++i;
      _ctlfile1.p_col=_ctlfile2.p_col=text_col(line1,i,'I');
   }else{
      _ctlfile1._begin_line();
      _ctlfile2._begin_line();
   }

   _ctlfile1.p_scroll_left_edge=_ctlfile2.p_scroll_left_edge=-1
   return(0);
}

static int NoSaveLine(int LineNumber)
{
   OrigLineNum=p_line;
   p_line=LineNumber;
   get_line(line);
   //rv=line=='Imaginary Buffer Line';
   rv=_lineflags()&NOSAVE_LF;
   p_line=OrigLineNum;
   return(rv);
}

static void diff_delete_block()
{
   diff_copy_block('D');
}

static int diff_copy_block(...)
{
   boolean delete_block;
   //delete_block=upcase(arg(1))=='D';
   if (arg(1)!='No Messages') {
      _ctlfile1._undo('S');
      _ctlfile2._undo('S');
   }
   otherwid=GetOtherWid(wid);
   delete_block=(arg(1)!='') && (wid._lineflags()&NOSAVE_LF);
   orig=GetLineStatus();
   while ((_lineflags()&NOSAVE_LF) && !delete_block) {
      if (arg(1)=='') {
         DiffMessageBox('Cannot copy imaginary block');
      }else if (arg(1)=='No Messages') {
         if (diff_next_difference()) return 1;
      }
      return 0;
   }
   if (orig==MATCHING_LINE) {
      if (arg(1)=='') {
         DiffMessageBox('Block already matches');
      }
      return 1;
   }
   save_pos(p);
   while (GetLineStatus()==orig) {
      wid.up();otherwid.up();
   }
   wid.down();otherwid.down();
   topln=wid.p_line;
   status=0;
   while (GetLineStatus()==orig) {
      status=wid.down() || otherwid.down();
      if (status) break;
   }
   if (!status) {
      wid.up();otherwid.up();
   }
   bottomln=p_line;
   wid.p_line=topln-1;otherwid.p_line=wid.p_line;
   count=0;
   for (;;) {
      status=wid.down()||otherwid.down();
      if (status) {
         return(status);
      }
      if (delete_block) {
         if (count>bottomln-topln) break;
      }else{
         if (status||wid.p_line>bottomln) break;
      }
      if (delete_block) {
         wid.DeleteLineMaybeNoModify();wid.up();
         otherwid.DeleteLineMaybeNoModify();otherwid.up();
         ++count;
      }else{
         wid.get_line(line);
         otherwid.replace_line(line);
         otherwid._lineflags(0,NOSAVE_LF);//Get rid of any nosave flags
         wid.set_line_normal();
         otherwid.set_line_normal();
      }
   }
   if (DialogIsDiff() && (def_diff_edit_options&DIFF_AUTO_JUMP)) {
      flags1=wid._lineflags();flags2=otherwid._lineflags();
      if ((flags1&MODIFY_LF || flags1&INSERTED_LINE_LF || flags1&NOSAVE_LF) ||
          (flags2&MODIFY_LF || flags2&INSERTED_LINE_LF || flags2&NOSAVE_LF)) {
         //We are on the next error already
         return(0);
      }
      status=diff_next_difference();
      return(status);
   }
   return(0);
}

static int diff_find_next()
{
   status=find_next();
   if (LastActiveEditWindowWID==_ctlfile1) {
      _ctlfile2.p_line=_ctlfile1.p_line;
      _ctlfile2.set_scroll_pos(_ctlfile1.p_left_edge,_ctlfile1.p_cursor_y);
   }else if (LastActiveEditWindowWID==_ctlfile2) {
      _ctlfile1.p_line=_ctlfile2.p_line;
      _ctlfile1.set_scroll_pos(_ctlfile2.p_left_edge,_ctlfile2.p_cursor_y);
   }
   if (status) {
      clear_message();
      _message_box(nls("String not found"));
   }
   ReturnFocusToEditWindow();
   return(status);
}

static void DeleteLineMaybeNoModify()
{
   old=p_modify;
   imaginary=_lineflags()&NOSAVE_LF;
   _delete_line();
   if (imaginary) {
      p_modify=old;
   }
}

static void set_line_inserted()
{
   _lineflags(0,INSERTED_LINE_LF|MODIFY_LF);
   _lineflags(INSERTED_LINE_LF,INSERTED_LINE_LF);
}
static void set_line_normal()
{
   _lineflags(0,INSERTED_LINE_LF|MODIFY_LF);
}

static int matching_tileid_exists(int tileid)
{
   tile_id=p_tile_id
   first_window_id=p_window_id
   w2_view_id=''
   wid2=0;
   for (;;) {
      _next_window('HF');
      if ( p_window_id==first_window_id ) break;
      if ( p_tile_id==tile_id && !(p_window_flags &HIDE_WINDOW_OVERLAP)) {
         if ( w2_view_id!='' ) {
            w2_view_id='error';
            break;
         }
         w2_view_id=p_view_id;
         wid2=p_window_id;
         buf_name2=p_buf_name;
      }
   }
   return(wid2);
}
