/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNChecksumInputStream
extends InputStream {
    private InputStream mySource;
    private MessageDigest myDigest;
    private byte[] myDigestResult;

    public SVNChecksumInputStream(InputStream source) {
        this.mySource = source;
        try {
            this.myDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.mySource.read(b, off, len);
        if (r >= 0) {
            this.myDigest.update(b, 0, r);
        }
        return r;
    }

    public int read(byte[] b) throws IOException {
        int r = this.mySource.read(b);
        if (r >= 0) {
            this.myDigest.update(b, 0, r);
        }
        return r;
    }

    public int read() throws IOException {
        int r = this.mySource.read();
        if (r >= 0) {
            this.myDigest.update((byte)(r & 0xFF));
        }
        return r;
    }

    public void close() throws IOException {
        this.myDigestResult = this.myDigest.digest();
    }

    public String getDigest() {
        return SVNFileUtil.toHexDigest(this.myDigestResult);
    }
}

