/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNWCManager {
    public static final int SCHEDULE = 1;
    public static final int COPIED = 2;

    public static void add(File path, SVNAdminArea parentDir, SVNURL copyFromURL, SVNRevision copyFromRev) throws SVNException {
        SVNWCManager.add(path, parentDir, copyFromURL, copyFromRev.getNumber());
    }

    public static void add(File path, SVNAdminArea parentDir, SVNURL copyFromURL, long copyFromRev) throws SVNException {
        SVNErrorMessage err;
        SVNEntry parentEntry;
        SVNErrorMessage err2;
        SVNWCAccess wcAccess = parentDir.getWCAccess();
        SVNFileType fileType = SVNFileType.getType(path);
        if (fileType == SVNFileType.NONE) {
            err2 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' not found", path);
            SVNErrorManager.error(err2);
        } else if (fileType == SVNFileType.UNKNOWN) {
            err2 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "Unsupported node kind for path ''{0}''", path);
            SVNErrorManager.error(err2);
        }
        SVNAdminArea dir = wcAccess.probeTry(path, true, copyFromURL != null ? -1 : 0);
        SVNEntry entry = null;
        if (dir != null) {
            entry = wcAccess.getEntry(path, true);
        }
        boolean replace = false;
        SVNNodeKind kind = SVNFileType.getNodeKind(fileType);
        if (entry != null) {
            SVNErrorMessage err3;
            if (copyFromURL == null && !entry.isScheduledForDeletion() && !entry.isDeleted()) {
                err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' is already under version control", path);
                SVNErrorManager.error(err3);
            } else if (entry.getKind() != kind) {
                err3 = SVNErrorMessage.create(SVNErrorCode.WC_NODE_KIND_CHANGE, "Can''t replace ''{0}'' with a node of a different type; the deletion must be committed and the parent updated before adding ''{0}''", path);
                SVNErrorManager.error(err3);
            }
            replace = entry.isScheduledForDeletion();
        }
        if ((parentEntry = wcAccess.getEntry(path.getParentFile(), false)) == null) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Can''t find parent directory''s entry while trying to add ''{0}''", path);
            SVNErrorManager.error(err);
        }
        if (parentEntry.isScheduledForDeletion()) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "Can''t add ''{0}'' to a parent directory scheduled for deletion", path);
            SVNErrorManager.error(err);
        }
        HashMap<String, String> command = new HashMap<String, String>();
        String name = path.getName();
        if (copyFromURL != null) {
            if (parentEntry.getRepositoryRoot() != null && !SVNPathUtil.isAncestor(parentEntry.getRepositoryRoot(), copyFromURL.toString())) {
                SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "The URL ''{0}'' has a different repository root than its parent", copyFromURL);
                SVNErrorManager.error(err4);
            }
            command.put(SVNProperty.shortPropertyName("svn:entry:copyfrom-url"), copyFromURL.toString());
            command.put(SVNProperty.shortPropertyName("svn:entry:copyfrom-rev"), SVNProperty.toString(copyFromRev));
            command.put(SVNProperty.shortPropertyName("svn:entry:copied"), Boolean.TRUE.toString());
        }
        if (replace) {
            command.put(SVNProperty.shortPropertyName("svn:entry:checksum"), null);
        }
        command.put(SVNProperty.shortPropertyName("svn:entry:schedule"), "add");
        command.put(SVNProperty.shortPropertyName("svn:entry:kind"), SVNFileType.getNodeKind(fileType).toString());
        if (!replace && copyFromURL == null) {
            command.put(SVNProperty.shortPropertyName("svn:entry:revision"), "0");
        }
        parentDir.modifyEntry(name, command, true, false);
        if (entry != null && copyFromURL == null) {
            String propPath = SVNAdminUtil.getPropPath(name, entry.getKind(), false);
            File propFile = dir.getFile(propPath);
            SVNFileUtil.deleteFile(propFile);
        }
        if (kind == SVNNodeKind.DIR) {
            if (copyFromURL == null) {
                SVNEntry pEntry = wcAccess.getEntry(path.getParentFile(), false);
                SVNURL newURL = pEntry.getSVNURL().appendPath(name, false);
                SVNURL rootURL = pEntry.getRepositoryRootURL();
                SVNWCManager.ensureAdmiAreaExists(path, newURL.toString(), rootURL != null ? rootURL.toString() : null, pEntry.getUUID(), 0L);
            } else {
                SVNURL rootURL = parentEntry.getRepositoryRootURL();
                SVNWCManager.ensureAdmiAreaExists(path, copyFromURL.toString(), rootURL != null ? rootURL.toString() : null, parentEntry.getUUID(), copyFromRev);
            }
            if (entry == null || entry.isDeleted()) {
                dir = wcAccess.open(path, true, copyFromURL != null ? -1 : 0);
            }
            command.put(SVNProperty.shortPropertyName("svn:entry:incomplete"), null);
            command.put(SVNProperty.shortPropertyName("svn:entry:schedule"), replace ? "replace" : "add");
            dir.modifyEntry(dir.getThisDirName(), command, true, true);
            if (copyFromURL != null) {
                SVNURL newURL = parentEntry.getSVNURL().appendPath(name, false);
                SVNWCManager.updateCleanup(path, wcAccess, true, newURL.toString(), parentEntry.getRepositoryRoot(), -1L, false);
                SVNWCManager.markTree(dir, null, true, 2);
                SVNPropertiesManager.deleteWCProperties(dir, null, true);
            }
        }
        SVNEvent event = SVNEventFactory.createAddedEvent(parentDir, name, kind, null);
        parentDir.getWCAccess().handleEvent(event);
    }

    public static void markTree(SVNAdminArea dir, String schedule, boolean copied, int flags) throws SVNException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Iterator entries = dir.entries(false);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            if (dir.getThisDirName().equals(entry.getName())) continue;
            File path = dir.getFile(entry.getName());
            if (entry.getKind() == SVNNodeKind.DIR) {
                SVNAdminArea childDir = dir.getWCAccess().retrieve(path);
                SVNWCManager.markTree(childDir, schedule, copied, flags);
            }
            if ((flags & 1) != 0) {
                attributes.put(SVNProperty.shortPropertyName("svn:entry:schedule"), schedule);
            }
            if ((flags & 2) != 0) {
                attributes.put(SVNProperty.shortPropertyName("svn:entry:copied"), copied ? Boolean.TRUE.toString() : null);
            }
            dir.modifyEntry(entry.getName(), attributes, true, false);
            attributes.clear();
            if (!"delete".equals(schedule)) continue;
            SVNEvent event = SVNEventFactory.createDeletedEvent(dir, entry.getName());
            dir.getWCAccess().handleEvent(event);
        }
        SVNEntry dirEntry = dir.getEntry(dir.getThisDirName(), false);
        if (!dirEntry.isScheduledForAddition() || !"delete".equals(schedule)) {
            if ((flags & 1) != 0) {
                attributes.put(SVNProperty.shortPropertyName("svn:entry:schedule"), schedule);
            }
            if ((flags & 2) != 0) {
                attributes.put(SVNProperty.shortPropertyName("svn:entry:copied"), copied ? Boolean.TRUE.toString() : null);
            }
            dir.modifyEntry(dir.getThisDirName(), attributes, true, false);
            attributes.clear();
        }
        dir.saveEntries(false);
    }

    public static void markTreeCancellable(SVNAdminArea dir, String schedule, boolean copied, int flags) throws SVNException {
        SVNAdminArea childDir;
        HashMap<String, String> attributes = new HashMap<String, String>();
        HashMap<String, SVNAdminArea> recurseMap = new HashMap<String, SVNAdminArea>();
        Iterator entries = dir.entries(false);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            if (dir.getThisDirName().equals(entry.getName())) continue;
            File path = dir.getFile(entry.getName());
            if (entry.getKind() == SVNNodeKind.DIR) {
                childDir = dir.getWCAccess().retrieve(path);
                recurseMap.put(entry.getName(), childDir);
                continue;
            }
            if ((flags & 1) != 0) {
                attributes.put(SVNProperty.shortPropertyName("svn:entry:schedule"), schedule);
            }
            if ((flags & 2) != 0) {
                attributes.put(SVNProperty.shortPropertyName("svn:entry:copied"), copied ? Boolean.TRUE.toString() : null);
            }
            dir.modifyEntry(entry.getName(), attributes, true, false);
            attributes.clear();
            if (!"delete".equals(schedule)) continue;
            SVNEvent event = SVNEventFactory.createDeletedEvent(dir, entry.getName());
            dir.getWCAccess().handleEvent(event);
        }
        SVNEntry dirEntry = dir.getEntry(dir.getThisDirName(), false);
        if (!dirEntry.isScheduledForAddition() || !"delete".equals(schedule)) {
            if ((flags & 1) != 0) {
                attributes.put(SVNProperty.shortPropertyName("svn:entry:schedule"), schedule);
            }
            if ((flags & 2) != 0) {
                attributes.put(SVNProperty.shortPropertyName("svn:entry:copied"), copied ? Boolean.TRUE.toString() : null);
            }
            dir.modifyEntry(dir.getThisDirName(), attributes, true, false);
            attributes.clear();
        }
        dir.saveEntries(false);
        dir.getWCAccess().checkCancelled();
        Iterator dirs = recurseMap.keySet().iterator();
        while (dirs.hasNext()) {
            String entryName = (String)dirs.next();
            childDir = (SVNAdminArea)recurseMap.get(entryName);
            if ((flags & 1) != 0) {
                attributes.put(SVNProperty.shortPropertyName("svn:entry:schedule"), schedule);
            }
            if ((flags & 2) != 0) {
                attributes.put(SVNProperty.shortPropertyName("svn:entry:copied"), copied ? Boolean.TRUE.toString() : null);
            }
            dir.modifyEntry(entryName, attributes, true, false);
            attributes.clear();
            if ("delete".equals(schedule)) {
                SVNEvent event = SVNEventFactory.createDeletedEvent(dir, entryName);
                dir.getWCAccess().handleEvent(event);
            }
            dir.saveEntries(false);
            SVNWCManager.markTree(childDir, schedule, copied, flags);
        }
    }

    public static void updateCleanup(File path, SVNWCAccess wcAccess, boolean recursive, String baseURL, String rootURL, long newRevision, boolean removeMissingDirs) throws SVNException {
        SVNEntry entry = wcAccess.getEntry(path, true);
        if (entry == null) {
            return;
        }
        if (entry.isFile() || entry.isDirectory() && (entry.isAbsent() || entry.isDeleted())) {
            SVNAdminArea dir = wcAccess.retrieve(path.getParentFile());
            if (dir.tweakEntry(path.getName(), baseURL, rootURL, newRevision, false)) {
                dir.saveEntries(false);
            }
        } else if (entry.isDirectory()) {
            SVNAdminArea dir = wcAccess.retrieve(path);
            SVNWCManager.tweakEntries(dir, baseURL, rootURL, newRevision, removeMissingDirs, recursive);
        } else {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Unrecognized node kind: ''{0}''", path);
            SVNErrorManager.error(err);
        }
    }

    private static void tweakEntries(SVNAdminArea dir, String baseURL, String rootURL, long newRevision, boolean removeMissingDirs, boolean recursive) throws SVNException {
        boolean write = dir.tweakEntry(dir.getThisDirName(), baseURL, rootURL, newRevision, false);
        Iterator entries = dir.entries(true);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            if (dir.getThisDirName().equals(entry.getName())) continue;
            String childURL = null;
            if (baseURL != null) {
                childURL = SVNPathUtil.append(baseURL, SVNEncodingUtil.uriEncode(entry.getName()));
            }
            if (entry.isFile() || entry.isDirectory() && (entry.isAbsent() || entry.isDeleted())) {
                write |= dir.tweakEntry(entry.getName(), childURL, rootURL, newRevision, true);
                continue;
            }
            if (!entry.isDirectory() || !recursive) continue;
            File path = dir.getFile(entry.getName());
            if (removeMissingDirs && dir.getWCAccess().isMissing(path)) {
                if (entry.isScheduledForAddition()) continue;
                dir.deleteEntry(entry.getName());
                dir.getWCAccess().handleEvent(SVNEventFactory.createUpdateDeleteEvent(null, dir, entry));
                continue;
            }
            SVNAdminArea childDir = dir.getWCAccess().retrieve(path);
            SVNWCManager.tweakEntries(childDir, childURL, rootURL, newRevision, removeMissingDirs, recursive);
        }
        if (write) {
            dir.saveEntries(false);
        }
    }

    public static boolean ensureAdmiAreaExists(File path, String url, String rootURL, String uuid, long revision) throws SVNException {
        SVNFileType fileType = SVNFileType.getType(path);
        if (fileType != SVNFileType.DIRECTORY && fileType != SVNFileType.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "''{0}'' is not a directory", path);
            SVNErrorManager.error(err);
        }
        if (fileType == SVNFileType.NONE) {
            SVNAdminAreaFactory.createVersionedDirectory(path, url, rootURL, uuid, revision);
            return true;
        }
        SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);
        try {
            SVNErrorMessage err;
            wcAccess.open(path, false, 0);
            SVNEntry entry = wcAccess.getEntry(path, false);
            if (entry == null) {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "No entry for ''{0}''", path);
                SVNErrorManager.error(err);
            }
            if (!entry.isScheduledForDeletion()) {
                if (entry.getRevision() != revision) {
                    err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Revision {0} doesn''t match existing revision {1} in ''{2}''", new Object[]{new Long(revision), new Long(entry.getRevision()), path});
                    SVNErrorManager.error(err);
                }
                if (!entry.getURL().equals(url)) {
                    err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "URL {0} doesn''t match existing URL {1} in ''{2}''", new Object[]{url, entry.getURL(), path});
                    SVNErrorManager.error(err);
                }
            }
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                SVNAdminAreaFactory.createVersionedDirectory(path, url, rootURL, uuid, revision);
                boolean bl = true;
                return bl;
            }
            throw e;
        }
        finally {
            wcAccess.close();
        }
        return false;
    }

    public static void canDelete(File path, ISVNOptions options, final ISVNEventHandler eventHandler) throws SVNException {
        SVNStatusClient statusClient = new SVNStatusClient((ISVNAuthenticationManager)null, options);
        if (eventHandler != null) {
            statusClient.setEventHandler(new ISVNEventHandler(){

                public void checkCancelled() throws SVNCancelException {
                    eventHandler.checkCancelled();
                }

                public void handleEvent(SVNEvent event, double progress) throws SVNException {
                }
            });
        }
        statusClient.doStatus(path, SVNRevision.UNDEFINED, true, false, false, false, false, new ISVNStatusHandler(){

            public void handleStatus(SVNStatus status) throws SVNException {
                if (status.getContentsStatus() == SVNStatusType.STATUS_OBSTRUCTED) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "''{0}'' is in the way of the resource actually under version control", status.getFile());
                    SVNErrorManager.error(err);
                } else if (status.getEntry() == null) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", status.getFile());
                    SVNErrorManager.error(err);
                } else if (status.getContentsStatus() != SVNStatusType.STATUS_NORMAL && status.getContentsStatus() != SVNStatusType.STATUS_DELETED && status.getContentsStatus() != SVNStatusType.STATUS_MISSING || status.getPropertiesStatus() != SVNStatusType.STATUS_NONE && status.getPropertiesStatus() != SVNStatusType.STATUS_NORMAL) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_MODIFIED, "''{0}'' has local modifications", status.getFile());
                    SVNErrorManager.error(err);
                }
            }
        });
    }

    public static void delete(SVNWCAccess wcAccess, SVNAdminArea root, File path, boolean deleteFiles, boolean cancellable) throws SVNException {
        SVNAdminArea dir = wcAccess.probeTry(path, true, -1);
        SVNEntry entry = null;
        if (dir == null) {
            SVNWCManager.doDeleteUnversionedFiles(wcAccess, path, deleteFiles);
            return;
        }
        entry = wcAccess.getEntry(path, false);
        if (entry == null) {
            SVNWCManager.doDeleteUnversionedFiles(wcAccess, path, deleteFiles);
            return;
        }
        String schedule = entry.getSchedule();
        SVNNodeKind kind = entry.getKind();
        boolean copied = entry.isCopied();
        boolean deleted = false;
        String name = path.getName();
        if (kind == SVNNodeKind.DIR) {
            SVNAdminArea parent = wcAccess.retrieve(path.getParentFile());
            SVNEntry entryInParent = parent.getEntry(name, true);
            boolean bl = deleted = entryInParent != null ? entryInParent.isDeleted() : false;
            if (!deleted && "add".equals(schedule)) {
                if (dir != root) {
                    dir.removeFromRevisionControl("", false, false);
                } else {
                    parent.deleteEntry(name);
                    parent.saveEntries(false);
                }
            } else if (dir != root) {
                if (cancellable) {
                    SVNWCManager.markTreeCancellable(dir, "delete", false, 1);
                } else {
                    SVNWCManager.markTree(dir, "delete", false, 1);
                }
            }
        }
        if (kind != SVNNodeKind.DIR || !"add".equals(schedule) || deleted) {
            SVNLog log = root.getLog();
            HashMap<String, String> command = new HashMap<String, String>();
            command.put("name", name);
            command.put(SVNProperty.shortPropertyName("svn:entry:schedule"), "delete");
            log.addCommand("modify-entry", command, false);
            command.clear();
            if ("replace".equals(schedule) && copied) {
                if (kind != SVNNodeKind.DIR) {
                    command.put("name", SVNAdminUtil.getTextRevertPath(name, false));
                    command.put("dest", SVNAdminUtil.getTextBasePath(name, false));
                    log.addCommand("mv", command, false);
                    command.clear();
                }
                command.put("name", SVNAdminUtil.getPropRevertPath(name, kind, false));
                command.put("dest", SVNAdminUtil.getPropBasePath(name, kind, false));
                log.addCommand("mv", command, false);
                command.clear();
            }
            if ("add".equals(schedule)) {
                command.put("name", SVNAdminUtil.getPropPath(name, kind, false));
                log.addCommand("rm", command, false);
                command.clear();
            }
            log.save();
            root.runLogs();
        }
        SVNEvent event = SVNEventFactory.createDeletedEvent(root, name);
        wcAccess.handleEvent(event);
        if ("add".equals(schedule)) {
            SVNWCManager.doDeleteUnversionedFiles(wcAccess, path, deleteFiles);
        } else {
            SVNWCManager.doEraseFromWC(path, root, kind, deleteFiles);
        }
    }

    public static void doDeleteUnversionedFiles(SVNWCAccess wcAccess, File path, boolean deleteFiles) throws SVNException {
        wcAccess.checkCancelled();
        SVNFileType fileType = SVNFileType.getType(path);
        if (fileType == SVNFileType.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_FILENAME, "''{0}'' does not exist", path);
            SVNErrorManager.error(err);
        }
        if (deleteFiles) {
            SVNFileUtil.deleteAll(path, true, wcAccess.getEventHandler());
        }
    }

    public static void doEraseFromWC(File path, SVNAdminArea dir, SVNNodeKind kind, boolean deleteFiles) throws SVNException {
        SVNFileType type = SVNFileType.getType(path);
        if (type == SVNFileType.NONE) {
            return;
        }
        dir.getWCAccess().checkCancelled();
        if (kind == SVNNodeKind.FILE) {
            if (deleteFiles) {
                SVNFileUtil.deleteFile(path);
            }
        } else if (kind == SVNNodeKind.DIR) {
            SVNAdminArea childDir = dir.getWCAccess().retrieve(path);
            HashSet<String> versioned = new HashSet<String>();
            Iterator entries = childDir.entries(false);
            while (entries.hasNext()) {
                SVNEntry entry = (SVNEntry)entries.next();
                versioned.add(entry.getName());
                if (childDir.getThisDirName().equals(entry.getName())) continue;
                File childPath = childDir.getFile(entry.getName());
                SVNWCManager.doEraseFromWC(childPath, childDir, entry.getKind(), deleteFiles);
            }
            File[] children = SVNFileListUtil.listFiles(path);
            for (int i = 0; children != null && i < children.length; ++i) {
                if (SVNFileUtil.getAdminDirectoryName().equals(children[i].getName()) || versioned.contains(children[i].getName())) continue;
                SVNWCManager.doDeleteUnversionedFiles(dir.getWCAccess(), children[i], deleteFiles);
            }
        }
    }

    public static void addRepositoryFile(SVNAdminArea dir, String fileName, File text, File textBase, Map baseProperties, Map properties, String copyFromURL, long copyFromRev) throws SVNException {
        SVNEntry parentEntry = dir.getEntry(dir.getThisDirName(), false);
        if (parentEntry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", dir.getRoot());
            SVNErrorManager.error(err);
        }
        String newURL = SVNPathUtil.append(parentEntry.getURL(), SVNEncodingUtil.uriEncode(fileName));
        if (copyFromURL != null && parentEntry.getRepositoryRoot() != null && !SVNPathUtil.isAncestor(parentEntry.getRepositoryRoot(), copyFromURL)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Copyfrom-url ''{0}'' has different repository root than ''{1}''", new Object[]{copyFromURL, parentEntry.getRepositoryRoot()});
            SVNErrorManager.error(err);
        }
        SVNEntry dstEntry = dir.getEntry(fileName, false);
        SVNLog log = dir.getLog();
        HashMap<String, String> command = new HashMap<String, String>();
        if (dstEntry != null && dstEntry.isScheduledForDeletion()) {
            String revertTextPath = SVNAdminUtil.getTextRevertPath(fileName, false);
            String baseTextPath = SVNAdminUtil.getTextBasePath(fileName, false);
            String revertPropsPath = SVNAdminUtil.getPropRevertPath(fileName, SVNNodeKind.FILE, false);
            String basePropsPath = SVNAdminUtil.getPropBasePath(fileName, SVNNodeKind.FILE, false);
            command.put("name", baseTextPath);
            command.put("dest", revertTextPath);
            log.addCommand("mv", command, false);
            command.clear();
            if (dir.getFile(basePropsPath).isFile()) {
                command.put("name", basePropsPath);
                command.put("dest", revertPropsPath);
                log.addCommand("mv", command, false);
                command.clear();
            }
        }
        HashMap<String, String> entryAttrs = new HashMap<String, String>();
        entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:schedule"), "add");
        if (copyFromURL != null) {
            entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:copied"), SVNProperty.toString(true));
            entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:copyfrom-url"), copyFromURL);
            entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:copyfrom-rev"), SVNProperty.toString(copyFromRev));
        }
        log.logChangedEntryProperties(fileName, entryAttrs);
        entryAttrs.clear();
        entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:kind"), "file");
        entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:revision"), SVNProperty.toString(dstEntry != null ? dstEntry.getRevision() : parentEntry.getRevision()));
        entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:url"), newURL);
        entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:absent"), null);
        entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:deleted"), null);
        log.logChangedEntryProperties(fileName, entryAttrs);
        entryAttrs.clear();
        SVNWCManager.addProperties(dir, fileName, baseProperties, true, log);
        SVNWCManager.addProperties(dir, fileName, properties, false, log);
        File tmpTextBase = dir.getBaseFile(fileName, true);
        if (!tmpTextBase.equals(textBase) && textBase != null) {
            SVNFileUtil.rename(textBase, tmpTextBase);
        }
        if (text != null) {
            File tmpFile = SVNFileUtil.createUniqueFile(dir.getRoot(), fileName, ".tmp");
            SVNFileUtil.rename(text, tmpFile);
            if (baseProperties != null && baseProperties.containsKey("svn:special")) {
                command.put("name", tmpFile.getName());
                command.put("dest", fileName);
                command.put("arg1", "true");
                log.addCommand("cp", command, false);
                command.clear();
                command.put("name", tmpFile.getName());
                log.addCommand("rm", command, false);
                command.clear();
            } else {
                command.put("name", tmpFile.getName());
                command.put("dest", fileName);
                log.addCommand("mv", command, false);
                command.clear();
            }
        } else {
            command.put("name", SVNAdminUtil.getTextBasePath(fileName, true));
            command.put("dest", fileName);
            log.addCommand("cp-and-translate", command, false);
            command.clear();
            command.put(SVNProperty.shortPropertyName("svn:entry:text-time"), "working");
            log.logChangedEntryProperties(fileName, command);
            command.clear();
        }
        command.put("name", SVNAdminUtil.getTextBasePath(fileName, true));
        command.put("dest", SVNAdminUtil.getTextBasePath(fileName, false));
        log.addCommand("mv", command, false);
        command.clear();
        command.put("name", SVNAdminUtil.getTextBasePath(fileName, false));
        log.addCommand("readonly", command, false);
        command.clear();
        String checksum = SVNFileUtil.computeChecksum(dir.getBaseFile(fileName, true));
        entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:checksum"), checksum);
        log.logChangedEntryProperties(fileName, entryAttrs);
        entryAttrs.clear();
        log.save();
        dir.runLogs();
    }

    public static void addProperties(SVNAdminArea dir, String fileName, Map properties, boolean base, SVNLog log) throws SVNException {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        HashMap<String, String> regularProps = new HashMap<String, String>();
        HashMap<String, String> entryProps = new HashMap<String, String>();
        HashMap<String, String> wcProps = new HashMap<String, String>();
        Iterator names = properties.keySet().iterator();
        while (names.hasNext()) {
            String propName = (String)names.next();
            String propValue = (String)properties.get(propName);
            if (SVNProperty.isEntryProperty(propName)) {
                entryProps.put(SVNProperty.shortPropertyName(propName), propValue);
                continue;
            }
            if (SVNProperty.isWorkingCopyProperty(propName)) {
                wcProps.put(propName, propValue);
                continue;
            }
            regularProps.put(propName, propValue);
        }
        SVNVersionedProperties props = base ? dir.getBaseProperties(fileName) : dir.getProperties(fileName);
        props.removeAll();
        Iterator propNames = regularProps.keySet().iterator();
        while (propNames.hasNext()) {
            String propName = (String)propNames.next();
            String propValue = (String)regularProps.get(propName);
            props.setPropertyValue(propName, propValue);
        }
        dir.saveVersionedProperties(log, false);
        log.logChangedEntryProperties(fileName, entryProps);
        log.logChangedWCProperties(fileName, wcProps);
    }
}

