/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.AbstractDiffCallback;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNStatusEditor;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;

public class SVNDiffEditor
implements ISVNEditor {
    private SVNWCAccess myWCAccess;
    private boolean myUseAncestry;
    private boolean myIsReverseDiff;
    private boolean myIsCompareToBase;
    private boolean myIsRootOpen;
    private long myTargetRevision;
    private SVNDirectoryInfo myCurrentDirectory;
    private SVNFileInfo myCurrentFile;
    private SVNDeltaProcessor myDeltaProcessor;
    private SVNAdminAreaInfo myAdminInfo;
    private boolean myIsRecursive;
    private File myTempDirectory;
    private AbstractDiffCallback myDiffCallback;

    public SVNDiffEditor(SVNWCAccess wcAccess, SVNAdminAreaInfo info, AbstractDiffCallback callback, boolean useAncestry, boolean reverseDiff, boolean compareToBase, boolean recursive) {
        this.myWCAccess = wcAccess;
        this.myAdminInfo = info;
        this.myUseAncestry = useAncestry;
        this.myIsReverseDiff = reverseDiff;
        this.myIsRecursive = recursive;
        this.myIsCompareToBase = compareToBase;
        this.myDiffCallback = callback;
        this.myDeltaProcessor = new SVNDeltaProcessor();
    }

    public void targetRevision(long revision) throws SVNException {
        this.myTargetRevision = revision;
    }

    public void openRoot(long revision) throws SVNException {
        this.myIsRootOpen = true;
        this.myCurrentDirectory = this.createDirInfo(null, "", false);
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        File fullPath = new File(this.myAdminInfo.getAnchor().getRoot(), path);
        SVNAdminArea dir = this.myWCAccess.probeRetrieve(fullPath);
        SVNEntry entry = this.myWCAccess.getEntry(fullPath, false);
        if (entry == null) {
            return;
        }
        String name = SVNPathUtil.tail(path);
        this.myCurrentDirectory.myComparedEntries.add(name);
        if (!this.myIsCompareToBase && entry.isScheduledForDeletion()) {
            return;
        }
        if (entry.isFile()) {
            if (this.myIsReverseDiff) {
                File baseFile = dir.getBaseFile(name, false);
                Map baseProps = dir.getBaseProperties(name).asMap();
                this.getDiffCallback().fileDeleted(path, baseFile, null, null, null, baseProps);
            } else {
                this.reportAddedFile(this.myCurrentDirectory, path, entry);
            }
        } else if (entry.isDirectory()) {
            SVNDirectoryInfo info = this.createDirInfo(this.myCurrentDirectory, path, false);
            this.reportAddedDir(info);
        }
    }

    private void reportAddedDir(SVNDirectoryInfo info) throws SVNException {
        SVNAdminArea dir = this.retrieve(info.myPath);
        Map wcProps = this.myIsCompareToBase ? dir.getBaseProperties(dir.getThisDirName()).asMap() : dir.getProperties(dir.getThisDirName()).asMap();
        Map propDiff = SVNDiffEditor.computePropsDiff(new HashMap(), wcProps);
        if (!propDiff.isEmpty()) {
            this.getDiffCallback().propertiesChanged(info.myPath, null, propDiff);
        }
        Iterator entries = dir.entries(false);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            if (dir.getThisDirName().equals(entry.getName()) || !this.myIsCompareToBase && entry.isScheduledForDeletion()) continue;
            if (entry.isFile()) {
                this.reportAddedFile(info, SVNPathUtil.append(info.myPath, entry.getName()), entry);
                continue;
            }
            if (!entry.isDirectory() || !this.myIsRecursive) continue;
            SVNDirectoryInfo childInfo = this.createDirInfo(info, SVNPathUtil.append(info.myPath, entry.getName()), false);
            this.reportAddedDir(childInfo);
        }
    }

    private void reportAddedFile(SVNDirectoryInfo info, String path, SVNEntry entry) throws SVNException {
        if (entry.isCopied()) {
            if (this.myIsCompareToBase) {
                return;
            }
            this.reportModifiedFile(info, entry);
            return;
        }
        SVNAdminArea dir = this.retrieve(info.myPath);
        String name = SVNPathUtil.tail(path);
        Map wcProps = null;
        wcProps = this.myIsCompareToBase ? dir.getBaseProperties(name).asMap() : dir.getProperties(name).asMap();
        String mimeType = (String)wcProps.get("svn:mime-type");
        Map propDiff = SVNDiffEditor.computePropsDiff(new HashMap(), wcProps);
        File sourceFile = this.myIsCompareToBase ? dir.getBaseFile(name, false) : this.detranslateFile(dir, name);
        this.getDiffCallback().fileAdded(path, null, sourceFile, 0L, entry.getRevision(), null, mimeType, null, propDiff);
    }

    private void reportModifiedFile(SVNDirectoryInfo dirInfo, SVNEntry entry) throws SVNException {
        String mimeType;
        SVNAdminArea dir = this.retrieve(dirInfo.myPath);
        String schedule = entry.getSchedule();
        String fileName = entry.getName();
        if (entry.isCopied()) {
            schedule = null;
        }
        if (!this.myUseAncestry && entry.isScheduledForReplacement()) {
            schedule = null;
        }
        Map propDiff = null;
        Map baseProps = null;
        File baseFile = dir.getBaseFile(fileName, false);
        if (!entry.isScheduledForDeletion()) {
            boolean modified = dir.hasPropModifications(fileName);
            if (modified) {
                baseProps = dir.getBaseProperties(fileName).asMap();
                propDiff = SVNDiffEditor.computePropsDiff(baseProps, dir.getProperties(fileName).asMap());
            } else {
                propDiff = new HashMap();
            }
        } else {
            baseProps = dir.getBaseProperties(fileName).asMap();
        }
        boolean isAdded = schedule != null && entry.isScheduledForAddition();
        String filePath = SVNPathUtil.append(dirInfo.myPath, fileName);
        if (schedule != null && (entry.isScheduledForDeletion() || entry.isScheduledForReplacement())) {
            mimeType = dir.getBaseProperties(fileName).getPropertyValue("svn:mime-type");
            this.getDiffCallback().fileDeleted(filePath, baseFile, null, mimeType, null, dir.getBaseProperties(fileName).asMap());
            isAdded = entry.isScheduledForReplacement();
        }
        if (isAdded) {
            mimeType = dir.getProperties(fileName).getPropertyValue("svn:mime-type");
            File tmpFile = this.detranslateFile(dir, fileName);
            this.getDiffCallback().fileAdded(filePath, null, tmpFile, 0L, entry.getRevision(), mimeType, null, dir.getBaseProperties(fileName).asMap(), propDiff);
        } else if (schedule == null) {
            boolean modified = dir.hasTextModifications(fileName, false);
            File tmpFile = null;
            if (modified) {
                tmpFile = this.detranslateFile(dir, fileName);
            }
            if (modified || propDiff != null && !propDiff.isEmpty()) {
                String baseMimeType = dir.getBaseProperties(fileName).getPropertyValue("svn:mime-type");
                String mimeType2 = dir.getProperties(fileName).getPropertyValue("svn:mime-type");
                this.getDiffCallback().fileChanged(filePath, modified ? baseFile : null, tmpFile, entry.getRevision(), -1L, baseMimeType, mimeType2, baseProps, propDiff);
            }
        }
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentDirectory = this.createDirInfo(this.myCurrentDirectory, path, true);
    }

    public void openDir(String path, long revision) throws SVNException {
        this.myCurrentDirectory = this.createDirInfo(this.myCurrentDirectory, path, false);
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        if (this.myCurrentDirectory.myPropertyDiff == null) {
            this.myCurrentDirectory.myPropertyDiff = new HashMap();
        }
        this.myCurrentDirectory.myPropertyDiff.put(name, value);
    }

    public void closeDir() throws SVNException {
        Map diff = this.myCurrentDirectory.myPropertyDiff;
        if (diff != null && !diff.isEmpty()) {
            Map originalProps = null;
            if (this.myCurrentDirectory.myIsAdded) {
                originalProps = new HashMap();
            } else {
                SVNAdminArea dir = this.retrieve(this.myCurrentDirectory.myPath);
                if (dir != null && this.myIsCompareToBase) {
                    originalProps = dir.getBaseProperties(dir.getThisDirName()).asMap();
                } else {
                    originalProps = dir.getProperties(dir.getThisDirName()).asMap();
                    Map baseProps = dir.getBaseProperties(dir.getThisDirName()).asMap();
                    HashMap reposProps = new HashMap(baseProps);
                    Iterator diffNames = diff.keySet().iterator();
                    while (diffNames.hasNext()) {
                        String diffName = (String)diffNames.next();
                        reposProps.put(diffName, diff.get(diffName));
                    }
                    diff = SVNDiffEditor.computePropsDiff(originalProps, reposProps);
                }
            }
            if (!this.myIsReverseDiff) {
                SVNDiffEditor.reversePropChanges(originalProps, diff);
            }
            this.getDiffCallback().propertiesChanged(this.myCurrentDirectory.myPath, originalProps, diff);
            this.myCurrentDirectory.myComparedEntries.add("");
        }
        if (!this.myCurrentDirectory.myIsAdded) {
            this.localDirectoryDiff(this.myCurrentDirectory);
        }
        String name = SVNPathUtil.tail(this.myCurrentDirectory.myPath);
        this.myCurrentDirectory = this.myCurrentDirectory.myParent;
        if (this.myCurrentDirectory != null) {
            this.myCurrentDirectory.myComparedEntries.add(name);
        }
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        String name = SVNPathUtil.tail(path);
        this.myCurrentFile = this.createFileInfo(this.myCurrentDirectory, path, true);
        this.myCurrentDirectory.myComparedEntries.add(name);
    }

    public void openFile(String path, long revision) throws SVNException {
        String name = SVNPathUtil.tail(path);
        this.myCurrentFile = this.createFileInfo(this.myCurrentDirectory, path, false);
        this.myCurrentDirectory.myComparedEntries.add(name);
    }

    public void changeFileProperty(String path, String name, String value) throws SVNException {
        if (this.myCurrentFile.myPropertyDiff == null) {
            this.myCurrentFile.myPropertyDiff = new HashMap();
        }
        this.myCurrentFile.myPropertyDiff.put(name, value);
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        SVNEntry entry = this.myWCAccess.getEntry(this.myAdminInfo.getAnchor().getFile(this.myCurrentFile.myPath), false);
        if (entry != null && entry.isCopied()) {
            this.myCurrentFile.myIsAdded = false;
        }
        if (!this.myCurrentFile.myIsAdded) {
            SVNAdminArea dir = this.retrieve(this.myCurrentDirectory.myPath);
            String fileName = SVNPathUtil.tail(this.myCurrentFile.myPath);
            this.myCurrentFile.myBaseFile = dir.getBaseFile(fileName, false);
        }
        this.myCurrentFile.myFile = this.createTempFile();
        this.myDeltaProcessor.applyTextDelta(this.myCurrentFile.myBaseFile, this.myCurrentFile.myFile, false);
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        return this.myDeltaProcessor.textDeltaChunk(diffWindow);
    }

    public void textDeltaEnd(String path) throws SVNException {
        this.myDeltaProcessor.textDeltaEnd();
    }

    public void closeFile(String commitPath, String textChecksum) throws SVNException {
        boolean modified;
        String fileName = SVNPathUtil.tail(this.myCurrentFile.myPath);
        File filePath = this.myAdminInfo.getAnchor().getFile(this.myCurrentFile.myPath);
        SVNAdminArea dir = this.myWCAccess.probeRetrieve(filePath);
        SVNEntry entry = this.myWCAccess.getEntry(filePath, false);
        Map baseProperties = null;
        baseProperties = this.myCurrentFile.myIsAdded ? new HashMap() : (dir != null ? dir.getBaseProperties(fileName).asMap() : new HashMap());
        HashMap reposProperties = new HashMap(baseProperties);
        if (this.myCurrentFile.myPropertyDiff != null) {
            Iterator propNames = this.myCurrentFile.myPropertyDiff.keySet().iterator();
            while (propNames.hasNext()) {
                String propName = (String)propNames.next();
                reposProperties.put(propName, this.myCurrentFile.myPropertyDiff.get(propName));
            }
        }
        String reposMimeType = (String)reposProperties.get("svn:mime-type");
        File reposFile = this.myCurrentFile.myFile;
        File localFile = null;
        if (reposFile == null) {
            reposFile = dir.getBaseFile(fileName, false);
        }
        if (this.myCurrentFile.myIsAdded || !this.myIsCompareToBase && entry.isScheduledForDeletion()) {
            if (this.myIsReverseDiff) {
                this.getDiffCallback().fileAdded(commitPath, null, reposFile, 0L, this.myTargetRevision, null, reposMimeType, null, this.myCurrentFile.myPropertyDiff);
            } else {
                this.getDiffCallback().fileDeleted(commitPath, reposFile, null, reposMimeType, null, reposProperties);
            }
            return;
        }
        boolean bl = modified = this.myCurrentFile.myFile != null;
        if (!modified && !this.myIsCompareToBase) {
            modified = dir.hasTextModifications(fileName, false);
        }
        if (modified) {
            localFile = this.myIsCompareToBase ? dir.getBaseFile(fileName, false) : this.detranslateFile(dir, fileName);
        } else {
            localFile = null;
            reposFile = null;
        }
        Map originalProps = null;
        if (this.myIsCompareToBase) {
            originalProps = baseProperties;
        } else {
            originalProps = dir.getProperties(fileName).asMap();
            this.myCurrentFile.myPropertyDiff = SVNDiffEditor.computePropsDiff(originalProps, reposProperties);
        }
        if (localFile != null || this.myCurrentFile.myPropertyDiff != null && !this.myCurrentFile.myPropertyDiff.isEmpty()) {
            String originalMimeType = (String)originalProps.get("svn:mime-type");
            if (this.myCurrentFile.myPropertyDiff != null && !this.myCurrentFile.myPropertyDiff.isEmpty() && !this.myIsReverseDiff) {
                SVNDiffEditor.reversePropChanges(originalProps, this.myCurrentFile.myPropertyDiff);
            }
            if (localFile != null || reposFile != null || this.myCurrentFile.myPropertyDiff != null && !this.myCurrentFile.myPropertyDiff.isEmpty()) {
                this.getDiffCallback().fileChanged(commitPath, this.myIsReverseDiff ? localFile : reposFile, this.myIsReverseDiff ? reposFile : localFile, this.myIsReverseDiff ? -1L : this.myTargetRevision, this.myIsReverseDiff ? this.myTargetRevision : -1L, this.myIsReverseDiff ? originalMimeType : reposMimeType, this.myIsReverseDiff ? reposMimeType : originalMimeType, originalProps, this.myCurrentFile.myPropertyDiff);
            }
        }
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        if (!this.myIsRootOpen) {
            this.localDirectoryDiff(this.createDirInfo(null, "", false));
        }
        return null;
    }

    public void abortEdit() throws SVNException {
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    public void cleanup() {
        if (this.myTempDirectory != null) {
            SVNFileUtil.deleteAll(this.myTempDirectory, true);
        }
    }

    private void localDirectoryDiff(SVNDirectoryInfo info) throws SVNException {
        boolean anchor;
        if (this.myIsCompareToBase) {
            return;
        }
        SVNAdminArea dir = this.retrieve(info.myPath);
        boolean bl = anchor = !"".equals(this.myAdminInfo.getTargetName()) && dir == this.myAdminInfo.getAnchor();
        if (!anchor && !info.myComparedEntries.contains("") && dir.hasPropModifications(dir.getThisDirName())) {
            SVNVersionedProperties baseProps = dir.getBaseProperties(dir.getThisDirName());
            Map propDiff = baseProps.compareTo(dir.getProperties(dir.getThisDirName())).asMap();
            this.getDiffCallback().propertiesChanged(info.myPath, baseProps.asMap(), propDiff);
        }
        HashSet<String> processedFiles = null;
        if (this.getDiffCallback().isDiffUnversioned()) {
            processedFiles = new HashSet<String>();
        }
        Iterator entries = dir.entries(false);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            if (processedFiles != null && !dir.getThisDirName().equals(entry.getName())) {
                processedFiles.add(entry.getName());
            }
            if (anchor && !this.myAdminInfo.getTargetName().equals(entry.getName()) || dir.getThisDirName().equals(entry.getName()) || info.myComparedEntries.contains(entry.getName())) continue;
            info.myComparedEntries.add(entry.getName());
            if (entry.isFile()) {
                this.reportModifiedFile(info, entry);
                continue;
            }
            if (!entry.isDirectory() || !anchor && !this.myIsRecursive) continue;
            SVNDirectoryInfo childInfo = this.createDirInfo(info, SVNPathUtil.append(info.myPath, entry.getName()), false);
            this.localDirectoryDiff(childInfo);
        }
        if (this.getDiffCallback().isDiffUnversioned()) {
            this.diffUnversioned(dir.getRoot(), dir, anchor, processedFiles);
        }
    }

    private void diffUnversioned(File root, SVNAdminArea dir, boolean anchor, Set processedFiles) throws SVNException {
        File[] allFiles = SVNFileListUtil.listFiles(root);
        for (int i = 0; allFiles != null && i < allFiles.length; ++i) {
            Collection globalIgnores;
            Collection ignores;
            File file = allFiles[i];
            if (SVNFileUtil.getAdminDirectoryName().equals(file.getName()) || processedFiles != null && processedFiles.contains(file.getName()) || anchor && !this.myAdminInfo.getTargetName().equals(file.getName()) || dir != null && SVNStatusEditor.isIgnored(ignores = SVNStatusEditor.getIgnorePatterns(dir, globalIgnores = SVNStatusEditor.getGlobalIgnores(this.myWCAccess.getOptions())), file.getName())) continue;
            SVNFileType fileType = SVNFileType.getType(file);
            if (fileType == SVNFileType.DIRECTORY) {
                this.diffUnversioned(file, null, false, null);
                continue;
            }
            if (fileType != SVNFileType.FILE) continue;
            String mimeType1 = null;
            String mimeType2 = SVNFileUtil.detectMimeType(file);
            String filePath = SVNPathUtil.append(dir.getRelativePath(this.myAdminInfo.getAnchor()), file.getName());
            this.getDiffCallback().fileAdded(filePath, null, file, 0L, 0L, mimeType1, mimeType2, null, null);
        }
    }

    private SVNDirectoryInfo createDirInfo(SVNDirectoryInfo parent, String path, boolean added) {
        SVNDirectoryInfo info = new SVNDirectoryInfo();
        info.myParent = parent;
        info.myPath = path;
        info.myIsAdded = added;
        return info;
    }

    private SVNFileInfo createFileInfo(SVNDirectoryInfo parent, String path, boolean added) {
        SVNFileInfo info = new SVNFileInfo();
        info.myPath = path;
        info.myIsAdded = added;
        if (parent.myIsAdded) {
            while (parent.myIsAdded) {
                parent = parent.myParent;
            }
            info.myPath = SVNPathUtil.append(parent.myPath, "fake");
        }
        return info;
    }

    private File detranslateFile(SVNAdminArea dir, String name) throws SVNException {
        boolean special;
        SVNVersionedProperties properties = dir.getProperties(name);
        String keywords = properties.getPropertyValue("svn:keywords");
        String eolStyle = properties.getPropertyValue("svn:eol-style");
        boolean bl = special = properties.getPropertyValue("svn:special") != null;
        if (keywords == null && eolStyle == null && (!special || SVNFileUtil.isWindows)) {
            return dir.getFile(name);
        }
        byte[] eol = SVNTranslator.getEOL(eolStyle);
        File tmpFile = this.createTempFile();
        Map keywordsMap = SVNTranslator.computeKeywords(keywords, null, null, null, null, null);
        SVNTranslator.translate(dir.getFile(name), tmpFile, eol, keywordsMap, special, false);
        return tmpFile;
    }

    private File createTempFile() throws SVNException {
        File tmpFile = null;
        try {
            return File.createTempFile("diff.", ".tmp", this.getTempDirectory());
        }
        catch (IOException e) {
            SVNFileUtil.deleteFile(tmpFile);
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
            SVNErrorManager.error(err);
            return null;
        }
    }

    private File getTempDirectory() throws SVNException {
        if (this.myTempDirectory == null) {
            this.myTempDirectory = this.getDiffCallback().createTempDirectory();
        }
        return this.myTempDirectory;
    }

    private SVNAdminArea retrieve(String path) throws SVNException {
        File dir = this.myAdminInfo.getAnchor().getFile(path);
        return this.myWCAccess.retrieve(dir);
    }

    private AbstractDiffCallback getDiffCallback() {
        return this.myDiffCallback;
    }

    private static void reversePropChanges(Map base, Map diff) {
        ArrayList namesList = new ArrayList(diff.keySet());
        Iterator names = namesList.iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            String newValue = (String)diff.get(name);
            String oldValue = (String)base.get(name);
            if (oldValue == null && newValue != null) {
                base.put(name, newValue);
                diff.put(name, null);
                continue;
            }
            if (oldValue != null && newValue == null) {
                base.put(name, null);
                diff.put(name, oldValue);
                continue;
            }
            if (oldValue == null || newValue == null) continue;
            base.put(name, newValue);
            diff.put(name, oldValue);
        }
    }

    private static Map computePropsDiff(Map props1, Map props2) {
        HashMap propsDiff = new HashMap();
        Iterator names = props2.keySet().iterator();
        while (names.hasNext()) {
            String newPropName = (String)names.next();
            if (props1.containsKey(newPropName)) {
                Object oldValue = props2.get(newPropName);
                if (oldValue != null && !oldValue.equals(props1.get(newPropName))) {
                    propsDiff.put(newPropName, props2.get(newPropName));
                    continue;
                }
                if (oldValue != null || props1.get(newPropName) == null) continue;
                propsDiff.put(newPropName, props2.get(newPropName));
                continue;
            }
            propsDiff.put(newPropName, props2.get(newPropName));
        }
        names = props1.keySet().iterator();
        while (names.hasNext()) {
            String oldPropName = (String)names.next();
            if (props2.containsKey(oldPropName)) continue;
            propsDiff.put(oldPropName, null);
        }
        return propsDiff;
    }

    private static class SVNFileInfo {
        private boolean myIsAdded;
        private String myPath;
        private File myFile;
        private File myBaseFile;
        private Map myPropertyDiff;

        private SVNFileInfo() {
        }
    }

    private static class SVNDirectoryInfo {
        private boolean myIsAdded;
        private String myPath;
        private Map myPropertyDiff;
        private SVNDirectoryInfo myParent;
        private Set myComparedEntries = new HashSet();

        private SVNDirectoryInfo() {
        }
    }
}

