/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVProperties;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.xml.sax.Attributes;

public class DAVPropertiesHandler
extends BasicDAVHandler {
    private static final Set PROP_ELEMENTS = new HashSet();
    private DAVProperties myCurrentResource;
    private int myStatusCode;
    private String myEncoding;
    private Map myResources;
    private Map myCurrentProperties;

    public static StringBuffer generatePropertiesRequest(StringBuffer body, DAVElement[] properties) {
        body = body == null ? new StringBuffer() : body;
        body.append("<?xml version=\"1.0\" encoding=\"utf-8\"?><propfind xmlns=\"DAV:\">");
        if (properties != null) {
            body.append("<prop>");
            for (int i = 0; i < properties.length; ++i) {
                body.append("<");
                body.append(properties[i].getName());
                body.append(" xmlns=\"");
                body.append(properties[i].getNamespace());
                body.append("\"/>");
            }
            body.append("</prop></propfind>");
        } else {
            body.append("<allprop/></propfind>");
        }
        return body;
    }

    public DAVPropertiesHandler() {
        this.init();
    }

    public Map getDAVProperties() {
        return this.myResources;
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (element == DAVElement.RESPONSE) {
            if (this.myCurrentResource != null) {
                this.invalidXML();
            }
            this.myCurrentResource = new DAVProperties();
            this.myCurrentProperties = new HashMap();
            this.myStatusCode = 0;
        } else if (element == DAVElement.PROPSTAT) {
            this.myStatusCode = 0;
        } else if (element == DAVElement.COLLECTION) {
            this.myCurrentResource.setCollection(true);
        } else {
            this.myEncoding = attrs.getValue("encoding");
        }
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        DAVElement name = null;
        String value = null;
        if (element == DAVElement.RESPONSE) {
            if (this.myCurrentResource.getURL() == null) {
                this.invalidXML();
            }
            this.myResources.put(this.myCurrentResource.getURL(), this.myCurrentResource);
            this.myCurrentResource = null;
            return;
        }
        if (element == DAVElement.PROPSTAT) {
            if (this.myStatusCode != 0) {
                Iterator names = this.myCurrentProperties.keySet().iterator();
                while (names.hasNext()) {
                    DAVElement propName = (DAVElement)names.next();
                    String propValue = (String)this.myCurrentProperties.get(propName);
                    if (this.myStatusCode != 200) continue;
                    this.myCurrentResource.setProperty(propName, propValue);
                }
                this.myCurrentProperties.clear();
            } else {
                this.invalidXML();
            }
            return;
        }
        if (element == DAVElement.STATUS) {
            if (cdata == null) {
                this.invalidXML();
            }
            try {
                HTTPStatus status = HTTPStatus.createHTTPStatus(cdata.toString());
                if (status == null) {
                    this.invalidXML();
                }
                this.myStatusCode = status.getCode();
            }
            catch (ParseException e) {
                this.invalidXML();
            }
            return;
        }
        if (element == DAVElement.HREF) {
            if (parent == DAVElement.RESPONSE) {
                String path = cdata.toString();
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                this.myCurrentResource.setURL(path);
                return;
            }
            name = parent;
            if (name == null) {
                return;
            }
            value = cdata.toString();
        } else if (cdata != null) {
            if (this.myCurrentProperties.containsKey(element)) {
                return;
            }
            name = element;
            if (this.myEncoding == null) {
                value = cdata.toString();
            } else if ("base64".equals(this.myEncoding)) {
                byte[] buffer = this.allocateBuffer(cdata.length());
                int length = SVNBase64.base64ToByteArray(new StringBuffer(cdata.toString().trim()), buffer);
                try {
                    value = new String(buffer, 0, length, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    value = new String(buffer, 0, length);
                }
            } else {
                this.invalidXML();
            }
            this.myEncoding = null;
        }
        if (name != null && value != null) {
            this.myCurrentProperties.put(name, value);
        }
    }

    public void setDAVProperties(Map result) {
        this.myResources = result;
    }

    static {
        PROP_ELEMENTS.add(DAVElement.HREF);
        PROP_ELEMENTS.add(DAVElement.STATUS);
        PROP_ELEMENTS.add(DAVElement.BASELINE);
        PROP_ELEMENTS.add(DAVElement.BASELINE_COLLECTION);
        PROP_ELEMENTS.add(DAVElement.COLLECTION);
        PROP_ELEMENTS.add(DAVElement.VERSION_NAME);
        PROP_ELEMENTS.add(DAVElement.GET_CONTENT_LENGTH);
        PROP_ELEMENTS.add(DAVElement.CREATION_DATE);
        PROP_ELEMENTS.add(DAVElement.CREATOR_DISPLAY_NAME);
        PROP_ELEMENTS.add(DAVElement.BASELINE_RELATIVE_PATH);
        PROP_ELEMENTS.add(DAVElement.MD5_CHECKSUM);
        PROP_ELEMENTS.add(DAVElement.REPOSITORY_UUID);
    }
}

