/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.xml.sax.Attributes;

public class DAVMergeHandler
extends BasicDAVHandler {
    private ISVNWorkspaceMediator myMediator;
    private Map myPathsMap;
    private static final DAVElement RESPONSE = DAVElement.getElement("DAV:", "response");
    private static final DAVElement POST_COMMIT_ERROR = DAVElement.getElement("svn:", "post-commit-err");
    private String myAuthor;
    private Date myCommitDate;
    private long myRevision;
    private String myRepositoryPath;
    private String myVersionPath;
    private DAVElement myResourceType;
    private SVNCommitInfo myCommitInfo;
    private SVNErrorMessage myPostCommitError;

    public static StringBuffer generateMergeRequest(StringBuffer request, String path, String activityURL, Map locks) {
        request = request == null ? new StringBuffer() : request;
        request.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        request.append("<D:merge xmlns:D=\"DAV:\">");
        request.append("<D:source><D:href>");
        request.append(activityURL);
        request.append("</D:href></D:source>");
        request.append("<D:no-auto-merge/><D:no-checkout/>");
        request.append("<D:prop>");
        request.append("<D:checked-in/><D:version-name/><D:resourcetype/>");
        request.append("<D:creationdate/><D:creator-displayname/>");
        request.append("</D:prop>");
        if (locks != null) {
            request = DAVMergeHandler.generateLockDataRequest(request, path, null, locks);
        }
        request.append("</D:merge>");
        return request;
    }

    public static StringBuffer generateLockDataRequest(StringBuffer target, String root, String path, Map locks) {
        target = target == null ? new StringBuffer() : target;
        target.append("<S:lock-token-list xmlns:S=\"svn:\">");
        Iterator paths = locks.keySet().iterator();
        while (paths.hasNext()) {
            String lockPath = (String)paths.next();
            if (path != null && !DAVMergeHandler.isChildPath(path, lockPath)) continue;
            String token = (String)locks.get(lockPath);
            target.append("<S:lock><S:lock-path>");
            lockPath = DAVMergeHandler.getRelativePath(lockPath, root);
            target.append(SVNEncodingUtil.xmlEncodeCDATA(SVNEncodingUtil.uriDecode(lockPath)));
            target.append("</S:lock-path><S:lock-token>");
            target.append(token);
            target.append("</S:lock-token></S:lock>");
        }
        target.append("</S:lock-token-list>");
        return target;
    }

    private static String getRelativePath(String path, String root) {
        if (path.length() <= root.length()) {
            return "";
        }
        return path.substring(root.length() + 1);
    }

    public static boolean hasChildPaths(String path, Map locks) {
        Iterator paths = locks.keySet().iterator();
        while (paths.hasNext()) {
            String lockPath = (String)paths.next();
            if (!DAVMergeHandler.isChildPath(path, lockPath)) continue;
            return true;
        }
        return false;
    }

    private static boolean isChildPath(String path, String childPath) {
        if (path.equals(childPath)) {
            return true;
        }
        return childPath.startsWith(path + "/");
    }

    public DAVMergeHandler(ISVNWorkspaceMediator mediator, Map pathsMap) {
        this.myMediator = mediator;
        this.myPathsMap = pathsMap;
        this.init();
    }

    public SVNCommitInfo getCommitInfo() {
        return this.myCommitInfo;
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (element == RESPONSE) {
            this.myResourceType = null;
            this.myRepositoryPath = null;
            this.myVersionPath = null;
            this.myAuthor = null;
            this.myCommitDate = null;
            this.myRevision = -1L;
        }
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (element == POST_COMMIT_ERROR) {
            this.myPostCommitError = SVNErrorMessage.create(SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED, cdata.toString(), 1);
        } else if (element == DAVElement.HREF) {
            if (parent == RESPONSE) {
                this.myRepositoryPath = cdata.toString();
                this.myRepositoryPath = SVNEncodingUtil.uriDecode(this.myRepositoryPath);
            } else if (parent == DAVElement.CHECKED_IN) {
                this.myVersionPath = cdata.toString();
            }
        } else if (parent == DAVElement.RESOURCE_TYPE && element == DAVElement.BASELINE) {
            this.myResourceType = element;
        } else if (parent == DAVElement.RESOURCE_TYPE && element == DAVElement.COLLECTION) {
            this.myResourceType = element;
        } else if (element == RESPONSE) {
            if (this.myResourceType == DAVElement.BASELINE) {
                this.myCommitInfo = new SVNCommitInfo(this.myRevision, this.myAuthor, this.myCommitDate, this.myPostCommitError);
            } else {
                String reposPath = SVNEncodingUtil.uriEncode(this.myRepositoryPath);
                String path = (String)this.myPathsMap.get(reposPath);
                if (path != null && this.myMediator != null) {
                    this.myMediator.setWorkspaceProperty(SVNEncodingUtil.uriDecode(path), "svn:wc:ra_dav:version-url", this.myVersionPath);
                }
            }
        } else if (element == DAVElement.CREATION_DATE) {
            this.myCommitDate = SVNTimeUtil.parseDate(cdata.toString());
        } else if (element == DAVElement.CREATOR_DISPLAY_NAME) {
            this.myAuthor = cdata.toString();
        } else if (element == DAVElement.VERSION_NAME) {
            this.myRevision = Long.parseLong(cdata.toString());
        } else if (parent != DAVElement.PROPSTAT || element == DAVElement.STATUS) {
            // empty if block
        }
    }
}

