/*
 * Decompiled with CFR 0.152.
 */
package test.imageviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jvnet.flamingo.bcb.BreadcrumbItem;
import org.jvnet.flamingo.bcb.BreadcrumbPathEvent;
import org.jvnet.flamingo.bcb.BreadcrumbPathListener;
import org.jvnet.flamingo.bcb.core.BreadcrumbFileSelector;
import org.jvnet.flamingo.common.AbstractFileViewPanel;
import org.jvnet.flamingo.common.CommandButtonDisplayState;
import org.jvnet.flamingo.common.JCommandButton;
import org.jvnet.flamingo.common.StringValuePair;
import org.jvnet.flamingo.common.icon.ImageWrapperResizableIcon;
import org.jvnet.flamingo.common.icon.ResizableIcon;

public class Viewer
extends JFrame {
    private BreadcrumbFileSelector bar = new BreadcrumbFileSelector();
    private AbstractFileViewPanel fileViewPanel;
    private JSlider iconSizeSlider;
    private int currIconSize;

    public Viewer() {
        super("Image Viewer");
        this.bar.getModel().addPathListener(new BreadcrumbPathListener(){

            public void breadcrumbPathEvent(BreadcrumbPathEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        final List newPath = Viewer.this.bar.getModel().getItems();
                        System.out.println("New path is ");
                        for (BreadcrumbItem item : newPath) {
                            System.out.println("\t" + ((File)item.getData()).getAbsolutePath());
                        }
                        if (newPath.size() > 0) {
                            SwingWorker<List<StringValuePair<File>>, Void> worker = new SwingWorker<List<StringValuePair<File>>, Void>(){

                                @Override
                                protected List<StringValuePair<File>> doInBackground() {
                                    return Viewer.this.bar.getCallback().getLeafs(newPath);
                                }

                                @Override
                                protected void done() {
                                    try {
                                        Viewer.this.fileViewPanel.setFolder((List)this.get());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            };
                            worker.execute();
                        }
                    }
                });
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.bar, "North");
        int initialSize = 100;
        this.fileViewPanel = new AbstractFileViewPanel<File>(64, null){

            @Override
            protected void configureCommandButton(AbstractFileViewPanel.Leaf leaf, JCommandButton button, ResizableIcon icon) {
            }

            @Override
            protected InputStream getLeafContent(File leaf) {
                try {
                    return new FileInputStream(leaf);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    return null;
                }
            }

            @Override
            protected ResizableIcon getResizableIcon(AbstractFileViewPanel.Leaf leaf, InputStream stream, CommandButtonDisplayState state, Dimension dimension) {
                int prefSize = state.getPreferredIconSize();
                if (prefSize > 0) {
                    dimension = new Dimension(prefSize, prefSize);
                }
                return ImageWrapperResizableIcon.getIcon(stream, dimension);
            }

            @Override
            protected boolean toShowFile(StringValuePair<File> pair) {
                String name = ((String)pair.getKey()).toLowerCase();
                return name.endsWith(".jpeg") || name.endsWith(".jpg") || name.endsWith(".gif") || name.endsWith(".png") || name.endsWith(".bmp");
            }
        };
        JScrollPane jsp = new JScrollPane(this.fileViewPanel, 22, 32);
        this.add((Component)jsp, "Center");
        this.iconSizeSlider = new JSlider();
        this.iconSizeSlider.setMinimum(50);
        this.iconSizeSlider.setMaximum(200);
        this.iconSizeSlider.setSnapToTicks(true);
        this.iconSizeSlider.setPaintLabels(true);
        this.iconSizeSlider.setPaintTicks(true);
        this.iconSizeSlider.setMajorTickSpacing(50);
        this.iconSizeSlider.setMinorTickSpacing(10);
        this.iconSizeSlider.setValue(initialSize);
        this.currIconSize = initialSize;
        this.iconSizeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int newValue;
                if (!Viewer.this.iconSizeSlider.getModel().getValueIsAdjusting() && (newValue = Viewer.this.iconSizeSlider.getValue()) != Viewer.this.currIconSize) {
                    Viewer.this.currIconSize = newValue;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Viewer.this.fileViewPanel.setIconDimension(Viewer.this.currIconSize);
                            Viewer.this.invalidate();
                            Viewer.this.doLayout();
                        }
                    });
                }
            }
        });
        this.add((Component)this.iconSizeSlider, "South");
    }

    public static void main(String ... args) {
        Viewer test = new Viewer();
        test.setSize(400, 400);
        test.setLocationRelativeTo(null);
        test.setVisible(true);
        test.setDefaultCloseOperation(2);
    }
}

