/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import java.awt.Component;
import java.awt.Container;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jvnet.flamingo.common.JCommandButton;
import org.jvnet.flamingo.common.RichTooltip;
import test.common.TestCommandButtons;
import test.common.TestRichTooltipPanels;

public class TestCommandButtonsRichTooltips
extends TestCommandButtons {
    protected void configureControlPanel(JPanel controlPanel) {
        TestCommandButtonsRichTooltips.apply(this, new Command(){

            public void apply(JCommandButton button) {
                RichTooltip actionRichTooltip = new RichTooltip();
                actionRichTooltip.setTitle("Action tooltip");
                actionRichTooltip.addDescriptionSection("Simple description that can go over multiple lines of text even exceeding the bigger");
                actionRichTooltip.addDescriptionSection("Second paragraph that can be multiline as well to test this feature");
                try {
                    actionRichTooltip.setMainImage(ImageIO.read(TestRichTooltipPanels.class.getResource("/test/resource/address-book-new.png")));
                    actionRichTooltip.setFooterImage(ImageIO.read(TestRichTooltipPanels.class.getResource("/test/resource/help-browser.png")));
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                actionRichTooltip.addFooterSection("Multiline footer description to provide a little bit more information on this subject");
                button.setActionRichTooltip(actionRichTooltip);
                RichTooltip popupRichTooltip = new RichTooltip();
                popupRichTooltip.setTitle("Popup tooltip");
                popupRichTooltip.addDescriptionSection("Simple description that can go over multiple lines of text even exceeding the bigger");
                try {
                    popupRichTooltip.setFooterImage(ImageIO.read(TestRichTooltipPanels.class.getResource("/test/resource/help-browser.png")));
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                popupRichTooltip.addFooterSection("Multiline footer description to provide a little bit more information on this subject");
                button.setPopupRichTooltip(popupRichTooltip);
            }
        });
    }

    private static void apply(Container cont, Command cmd) {
        for (int i = 0; i < cont.getComponentCount(); ++i) {
            Component comp = cont.getComponent(i);
            if (comp instanceof JCommandButton) {
                JCommandButton cb = (JCommandButton)comp;
                cmd.apply(cb);
            }
            if (!(comp instanceof Container)) continue;
            TestCommandButtonsRichTooltips.apply((Container)comp, cmd);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestCommandButtonsRichTooltips frame = new TestCommandButtonsRichTooltips();
                frame.setSize(800, 400);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                frame.setDefaultCloseOperation(2);
            }
        });
    }

    private static interface Command {
        public void apply(JCommandButton var1);
    }
}

