/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jvnet.flamingo.common.JCommandButtonPanel;
import org.jvnet.flamingo.common.JCommandToggleButton;
import org.jvnet.flamingo.common.icon.DecoratedResizableIcon;
import test.svg.transcoded.font_x_generic;

public class QuickStylesPanel
extends JCommandButtonPanel {
    public QuickStylesPanel() {
        super(32);
        for (int groupIndex = 0; groupIndex < 4; ++groupIndex) {
            String iconGroupName = "Styles " + groupIndex;
            this.addButtonGroup(iconGroupName, groupIndex);
            for (int i = 0; i < 15; ++i) {
                final int index = i;
                font_x_generic fontIcon = new font_x_generic();
                DecoratedResizableIcon finalIcon = new DecoratedResizableIcon(fontIcon, new DecoratedResizableIcon.IconDecorator(){

                    public void paintIconDecoration(Component c, Graphics g, int x, int y, int width, int height) {
                        Graphics2D g2d = (Graphics2D)g.create();
                        g2d.setColor(Color.black);
                        g2d.drawString("" + index, x + 2, y + height - 2);
                        g2d.dispose();
                    }
                });
                JCommandToggleButton jrb = new JCommandToggleButton(null, finalIcon);
                jrb.setName("Group " + groupIndex + ", index " + i);
                jrb.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        System.out.println("Invoked action on " + index);
                    }
                });
                this.addButtonToLastGroup(jrb);
            }
        }
        this.setSingleSelectionMode(true);
        this.setToShowGroupLabels(false);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame("Command button panel");
                final QuickStylesPanel buttonPanel = new QuickStylesPanel();
                frame.add((Component)new JScrollPane(buttonPanel), "Center");
                JPanel controlPanel = new JPanel(new FlowLayout(2));
                final JCheckBox toShowGroupLabels = new JCheckBox("show group labels");
                toShowGroupLabels.setSelected(buttonPanel.isToShowGroupLabels());
                toShowGroupLabels.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        buttonPanel.setToShowGroupLabels(toShowGroupLabels.isSelected());
                        buttonPanel.revalidate();
                    }
                });
                controlPanel.add(toShowGroupLabels);
                final JCheckBox isRowFillLayout = new JCheckBox("use row fill layout");
                isRowFillLayout.setSelected(buttonPanel.getLayoutKind() == JCommandButtonPanel.LayoutKind.ROW_FILL);
                isRowFillLayout.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        buttonPanel.setLayoutKind(isRowFillLayout.isSelected() ? JCommandButtonPanel.LayoutKind.ROW_FILL : JCommandButtonPanel.LayoutKind.COLUMN_FILL);
                    }
                });
                controlPanel.add(isRowFillLayout);
                frame.add((Component)controlPanel, "South");
                frame.setSize(500, 300);
                frame.setDefaultCloseOperation(3);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }
}

