/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.jvnet.flamingo.bcb.BreadcrumbPathEvent;
import org.jvnet.flamingo.bcb.BreadcrumbPathListener;
import org.jvnet.flamingo.bcb.core.BreadcrumbFileSelector;
import org.jvnet.flamingo.common.CommandButtonDisplayState;
import org.jvnet.flamingo.common.StringValuePair;
import test.common.ExplorerFileViewPanel;

public class FileExplorerStates
extends JFrame {
    private ExplorerFileViewPanel<File> filePanel;
    private BreadcrumbFileSelector bar = new BreadcrumbFileSelector();

    public FileExplorerStates() {
        super("File explorer");
        this.setLayout(new BorderLayout());
        this.add((Component)this.bar, "North");
        this.filePanel = new ExplorerFileViewPanel<File>(this.bar, CommandButtonDisplayState.BIG, null);
        JScrollPane fileListScrollPane = new JScrollPane(this.filePanel);
        this.bar.getModel().addPathListener(new BreadcrumbPathListener(){

            public void breadcrumbPathEvent(BreadcrumbPathEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        final List newPath = FileExplorerStates.this.bar.getModel().getItems();
                        if (newPath.size() > 0) {
                            SwingWorker<List<StringValuePair<File>>, Void> worker = new SwingWorker<List<StringValuePair<File>>, Void>(){

                                @Override
                                protected List<StringValuePair<File>> doInBackground() throws Exception {
                                    return FileExplorerStates.this.bar.getCallback().getLeafs(newPath);
                                }

                                @Override
                                protected void done() {
                                    try {
                                        FileExplorerStates.this.filePanel.setFolder((List)this.get());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            };
                            worker.execute();
                        }
                    }
                });
            }
        });
        final JComboBox<Object> states = new JComboBox<Object>(new DefaultComboBoxModel<Object>(new Object[]{CommandButtonDisplayState.BIG, CommandButtonDisplayState.TILE, CommandButtonDisplayState.MEDIUM, CommandButtonDisplayState.SMALL}));
        states.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                CommandButtonDisplayState selected = (CommandButtonDisplayState)states.getSelectedItem();
                FileExplorerStates.this.filePanel.cancelMainWorker();
                FileExplorerStates.this.filePanel.setIconState(selected);
            }
        });
        JPanel controls = new JPanel(new FlowLayout(2));
        controls.add(states);
        this.add((Component)controls, "South");
        this.add((Component)fileListScrollPane, "Center");
    }

    public static void main(String ... args) throws Exception {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FileExplorerStates test = new FileExplorerStates();
                test.setSize(500, 400);
                test.setLocationRelativeTo(null);
                test.setVisible(true);
                test.setDefaultCloseOperation(3);
            }
        });
    }
}

