/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageListDialog
extends JDialog {
    private boolean toExitOnDispose;

    private MessageListDialog(Frame owner, String mainMessage, LinkedList<String> messages) {
        super(owner, "Message list");
        JLabel messageLabel = new JLabel(mainMessage);
        JList<Object> messageList = new JList<Object>(messages.toArray());
        messageList.setForeground(Color.red);
        messageList.setFont(UIManager.getFont("Panel.font").deriveFont(1));
        JScrollPane mesScrollPane = new JScrollPane(messageList);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MessageListDialog.this.dispose();
                        if (MessageListDialog.this.toExitOnDispose) {
                            System.exit(0);
                        }
                    }
                });
            }
        });
        this.setLayout(new BorderLayout());
        JPanel upperPanel = new JPanel();
        upperPanel.setLayout(new FlowLayout(1));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(1));
        upperPanel.add(messageLabel);
        bottomPanel.add(closeButton);
        this.add((Component)upperPanel, "North");
        this.add((Component)mesScrollPane, "Center");
        this.add((Component)bottomPanel, "South");
        int width = 400;
        int height = 250;
        Dimension thisDim = new Dimension(width, height);
        this.setSize(thisDim);
        this.setPreferredSize(thisDim);
        this.setResizable(true);
        if (owner != null) {
            Dimension ownerDim = owner.getSize();
            Point ownerLoc = owner.getLocation();
            int xc = ownerLoc.x + ownerDim.width / 2;
            int yc = ownerLoc.y + ownerDim.height / 2;
            this.setLocation(xc - width / 2, yc - height / 2);
        } else {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((d.width - width) / 2, (d.height - height) / 2);
        }
        this.getRootPane().setDefaultButton(closeButton);
        this.toExitOnDispose = false;
    }

    public static MessageListDialog showMessageDialog(Frame owner, String mainMessage, LinkedList<String> messages) {
        MessageListDialog mld = new MessageListDialog(owner, mainMessage, messages);
        mld.setModal(owner != null);
        mld.setVisible(true);
        return mld;
    }

    public static MessageListDialog showMessageDialog(Frame owner, String message, Throwable throwable) {
        LinkedList<String> errors = new LinkedList<String>();
        while (true) {
            StackTraceElement[] stack;
            String mainMessage = throwable.getClass().getName() + " : " + throwable.getMessage();
            errors.addLast(mainMessage);
            for (StackTraceElement ste : stack = throwable.getStackTrace()) {
                String className = ste.getClassName();
                String methodName = ste.getMethodName();
                String lineNumber = "" + ste.getLineNumber();
                String steMessage = "      in " + className + "." + methodName + "(); [line " + lineNumber + "]";
                errors.addLast(steMessage);
            }
            if ((throwable = throwable.getCause()) == null) break;
            errors.addLast("Caused by");
        }
        return MessageListDialog.showMessageDialog(owner, message, errors);
    }

    public void setToExitOnDispose(boolean toExitOnDispose) {
        this.toExitOnDispose = toExitOnDispose;
    }
}

