/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.slider;

import javax.swing.event.ChangeListener;

public interface FlexiRangeModel {
    public Value getValue();

    public void setValue(Value var1);

    public void setRanges(Range ... var1);

    public int getRangeCount();

    public Range getRange(int var1);

    public void setValueIsAdjusting(boolean var1);

    public boolean getValueIsAdjusting();

    public void addChangeListener(ChangeListener var1);

    public void removeChangeListener(ChangeListener var1);

    public static class Value {
        public Range range;
        public double rangeFraction;

        public Value(Range range, double rangeFraction) {
            this.range = range;
            this.rangeFraction = rangeFraction;
        }

        public Value(Value value) {
            this(value.range, value.rangeFraction);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Value) {
                Value value2 = (Value)obj;
                return this.range == value2.range && this.rangeFraction == value2.rangeFraction;
            }
            return false;
        }

        public String toString() {
            return this.range.toString() + ":" + this.rangeFraction;
        }
    }

    public static class Range {
        private boolean isDiscrete;
        private double weight;
        private String name;

        public Range(boolean isDiscrete, double weight) {
            this(null, isDiscrete, weight);
        }

        public Range(String name, boolean isDiscrete, double weight) {
            this.name = name;
            this.isDiscrete = isDiscrete;
            this.weight = weight;
        }

        public Range(Range range) {
            this(range.name, range.isDiscrete, range.weight);
        }

        public boolean isDiscrete() {
            return this.isDiscrete;
        }

        public double getWeight() {
            return this.weight;
        }

        public String toString() {
            String name;
            String string = name = this.name == null ? "Range" : this.name;
            if (this.isDiscrete) {
                return "{DSC}" + name + " [" + this.hashCode() + "]";
            }
            return "{CTG}" + name + " [" + this.hashCode() + "] " + this.weight;
        }
    }
}

