/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon.ui.appmenu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.image.ColorConvertOp;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.jvnet.flamingo.common.AbstractCommandButton;
import org.jvnet.flamingo.common.CommandButtonDisplayState;
import org.jvnet.flamingo.common.CommandButtonLayoutManager;
import org.jvnet.flamingo.common.JCommandButton;
import org.jvnet.flamingo.common.JCommandButtonPanel;
import org.jvnet.flamingo.common.JCommandMenuButton;
import org.jvnet.flamingo.common.RolloverActionListener;
import org.jvnet.flamingo.common.icon.FilteredResizableIcon;
import org.jvnet.flamingo.common.popup.JPopupPanel;
import org.jvnet.flamingo.common.ui.BasicPopupPanelUI;
import org.jvnet.flamingo.ribbon.RibbonApplicationMenu;
import org.jvnet.flamingo.ribbon.RibbonApplicationMenuEntryFooter;
import org.jvnet.flamingo.ribbon.RibbonApplicationMenuEntryPrimary;
import org.jvnet.flamingo.ribbon.ui.appmenu.CommandButtonLayoutManagerMenuTileLevel1;
import org.jvnet.flamingo.ribbon.ui.appmenu.JRibbonApplicationMenuButton;
import org.jvnet.flamingo.ribbon.ui.appmenu.JRibbonApplicationMenuPopupPanel;
import org.jvnet.flamingo.ribbon.ui.appmenu.JRibbonApplicationMenuPopupPanelSecondary;
import org.jvnet.flamingo.utils.FlamingoUtilities;

public class BasicRibbonApplicationMenuPopupPanelUI
extends BasicPopupPanelUI {
    protected JCommandButtonPanel panelLevel1;
    protected JPanel panelLevel2;
    protected JPanel footerPanel;
    protected static final CommandButtonDisplayState MENU_TILE_LEVEL_1 = new CommandButtonDisplayState("Ribbon application menu tile level 1", 32){

        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton commandButton) {
            return new CommandButtonLayoutManagerMenuTileLevel1();
        }

        public CommandButtonDisplayState.CommandButtonSeparatorOrientation getSeparatorOrientation() {
            return CommandButtonDisplayState.CommandButtonSeparatorOrientation.VERTICAL;
        }
    };
    protected JRibbonApplicationMenuPopupPanel applicationMenuPopupPanel;
    protected JPanel mainPanel;

    public static ComponentUI createUI(JComponent c) {
        return new BasicRibbonApplicationMenuPopupPanelUI();
    }

    public void installUI(JComponent c) {
        this.applicationMenuPopupPanel = (JRibbonApplicationMenuPopupPanel)c;
        this.popupPanel = (JPopupPanel)c;
        this.applicationMenuPopupPanel.setLayout(new BorderLayout());
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.applicationMenuPopupPanel = null;
    }

    protected void installDefaults() {
        super.installDefaults();
    }

    protected void installComponents() {
        super.installComponents();
        this.mainPanel = this.createMainPanel();
        this.panelLevel1 = new JCommandButtonPanel(MENU_TILE_LEVEL_1);
        this.panelLevel1.setMaxButtonColumns(1);
        this.panelLevel1.addButtonGroup("main");
        this.panelLevel1.setToShowGroupLabels(false);
        RibbonApplicationMenu ribbonAppMenu = this.applicationMenuPopupPanel.getRibbonAppMenu();
        if (ribbonAppMenu != null) {
            for (final RibbonApplicationMenuEntryPrimary menuEntry : ribbonAppMenu.getPrimaryEntries()) {
                final JCommandMenuButton commandButton = new JCommandMenuButton(menuEntry.getText(), menuEntry.getIcon());
                commandButton.setCommandButtonKind(menuEntry.getEntryKind());
                commandButton.addActionListener(menuEntry.getMainActionListener());
                commandButton.setActionKeyTip(menuEntry.getActionKeyTip());
                commandButton.setPopupKeyTip(menuEntry.getPopupKeyTip());
                if (menuEntry.getSecondaryGroupCount() == 0) {
                    commandButton.addRolloverActionListener(new RolloverActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback callback = menuEntry.getRolloverCallback();
                            if (callback != null) {
                                callback.menuEntryActivated(BasicRibbonApplicationMenuPopupPanelUI.this.panelLevel2);
                            } else {
                                BasicRibbonApplicationMenuPopupPanelUI.this.panelLevel2.removeAll();
                                BasicRibbonApplicationMenuPopupPanelUI.this.panelLevel2.revalidate();
                                BasicRibbonApplicationMenuPopupPanelUI.this.panelLevel2.repaint();
                            }
                        }
                    });
                } else {
                    final RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback coreCallback = new RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback(){

                        public void menuEntryActivated(JPanel targetPanel) {
                            targetPanel.removeAll();
                            targetPanel.setLayout(new BorderLayout());
                            JRibbonApplicationMenuPopupPanelSecondary secondary = new JRibbonApplicationMenuPopupPanelSecondary(menuEntry){

                                public void removeNotify() {
                                    super.removeNotify();
                                    commandButton.getPopupModel().setPopupShowing(false);
                                }
                            };
                            targetPanel.add((Component)secondary, "Center");
                        }
                    };
                    commandButton.addRolloverActionListener(new RolloverActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            coreCallback.menuEntryActivated(BasicRibbonApplicationMenuPopupPanelUI.this.panelLevel2);
                            commandButton.getPopupModel().setPopupShowing(true);
                        }
                    });
                }
                commandButton.setDisplayState(MENU_TILE_LEVEL_1);
                commandButton.setHorizontalAlignment(10);
                commandButton.setPopupOrientationKind(JCommandButton.CommandButtonPopupOrientationKind.SIDEWARD);
                commandButton.setEnabled(menuEntry.isEnabled());
                this.panelLevel1.addButtonToLastGroup(commandButton);
            }
        }
        this.mainPanel.add((Component)this.panelLevel1, "West");
        this.panelLevel2 = new JPanel();
        this.panelLevel2.setBorder(new Border(){

            public Insets getBorderInsets(Component c) {
                return new Insets(0, 1, 0, 0);
            }

            public boolean isBorderOpaque() {
                return true;
            }

            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(FlamingoUtilities.getColor(Color.gray, "Label.disabledForeground"));
                g.drawLine(x, y, x, y + height);
            }
        });
        this.panelLevel2.setPreferredSize(new Dimension(30 * FlamingoUtilities.getFont(this.panelLevel1, "Ribbon.font", "Button.font", "Panel.font").getSize() - 30, 10));
        this.mainPanel.add((Component)this.panelLevel2, "Center");
        this.applicationMenuPopupPanel.add((Component)this.mainPanel, "Center");
        this.footerPanel = new JPanel(new FlowLayout(4)){

            protected void paintComponent(Graphics g) {
                FlamingoUtilities.renderSurface(g, BasicRibbonApplicationMenuPopupPanelUI.this.footerPanel, new Rectangle(0, 0, BasicRibbonApplicationMenuPopupPanelUI.this.footerPanel.getWidth(), BasicRibbonApplicationMenuPopupPanelUI.this.footerPanel.getHeight()), false, false, false);
            }
        };
        if (ribbonAppMenu != null) {
            for (RibbonApplicationMenuEntryFooter footerEntry : ribbonAppMenu.getFooterEntries()) {
                JCommandButton commandFooterButton = new JCommandButton(footerEntry.getText(), footerEntry.getIcon());
                commandFooterButton.setDisabledIcon(new FilteredResizableIcon(footerEntry.getIcon(), new ColorConvertOp(ColorSpace.getInstance(1003), null)));
                commandFooterButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                commandFooterButton.addActionListener(footerEntry.getMainActionListener());
                commandFooterButton.setDisplayState(CommandButtonDisplayState.MEDIUM);
                commandFooterButton.setFlat(false);
                commandFooterButton.setEnabled(footerEntry.isEnabled());
                this.footerPanel.add(commandFooterButton);
            }
        }
        this.applicationMenuPopupPanel.add((Component)this.footerPanel, "South");
        this.applicationMenuPopupPanel.setBorder(new Border(){

            public Insets getBorderInsets(Component c) {
                return new Insets(20, 2, 2, 2);
            }

            public boolean isBorderOpaque() {
                return true;
            }

            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(FlamingoUtilities.getColor(Color.gray, "Label.disabledForeground"));
                g.drawRect(x, y, width - 1, height - 1);
                g.setColor(FlamingoUtilities.getColor(Color.gray, "Label.disabledForeground").brighter().brighter());
                g.drawRect(x + 1, y + 1, width - 3, height - 3);
                FlamingoUtilities.renderSurface(g, BasicRibbonApplicationMenuPopupPanelUI.this.applicationMenuPopupPanel, new Rectangle(x + 2, y + 2, width - 4, 24), false, false, false);
                JRibbonApplicationMenuButton button = BasicRibbonApplicationMenuPopupPanelUI.this.applicationMenuPopupPanel.getAppMenuButton();
                JRibbonApplicationMenuButton rendererButton = new JRibbonApplicationMenuButton();
                rendererButton.setPopupKeyTip(button.getPopupKeyTip());
                rendererButton.setIcon(button.getIcon());
                rendererButton.getPopupModel().setRollover(false);
                rendererButton.getPopupModel().setPressed(true);
                rendererButton.getPopupModel().setArmed(true);
                rendererButton.getPopupModel().setPopupShowing(true);
                CellRendererPane buttonRendererPane = new CellRendererPane();
                Point buttonLoc = button.getLocationOnScreen();
                Point panelLoc = c.getLocationOnScreen();
                buttonRendererPane.setBounds(panelLoc.x - buttonLoc.x, panelLoc.y - buttonLoc.y, button.getWidth(), button.getHeight());
                buttonRendererPane.paintComponent(g, rendererButton, (Container)c, -panelLoc.x + buttonLoc.x, -panelLoc.y + buttonLoc.y, button.getWidth(), button.getHeight(), true);
            }
        });
    }

    protected JPanel createMainPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(new Border(){

            public Insets getBorderInsets(Component c) {
                return new Insets(2, 2, 2, 2);
            }

            public boolean isBorderOpaque() {
                return true;
            }

            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(FlamingoUtilities.getColor(Color.gray, "Label.disabledForeground").brighter().brighter());
                g.drawRect(x, y, width - 1, height - 1);
                g.setColor(FlamingoUtilities.getColor(Color.gray, "Label.disabledForeground"));
                g.drawRect(x + 1, y + 1, width - 3, height - 3);
            }
        });
        return result;
    }

    protected void installListeners() {
        super.installListeners();
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
    }

    protected void uninstallComponents() {
        super.uninstallComponents();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
    }

    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.dispose();
    }

    public JCommandButtonPanel getPanelLevel1() {
        return this.panelLevel1;
    }

    public JPanel getPanelLevel2() {
        return this.panelLevel2;
    }
}

