/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ColorConvertOp;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import org.jvnet.flamingo.common.HorizontalAlignment;
import org.jvnet.flamingo.common.icon.FilteredResizableIcon;
import org.jvnet.flamingo.common.icon.ResizableIcon;
import org.jvnet.flamingo.ribbon.JRibbonComponent;
import org.jvnet.flamingo.ribbon.ui.RibbonComponentUI;

public class BasicRibbonComponentUI
extends RibbonComponentUI {
    protected JRibbonComponent ribbonComponent;
    protected JLabel captionLabel;
    protected PropertyChangeListener propertyChangeListener;
    protected ResizableIcon disabledIcon;

    public static ComponentUI createUI(JComponent c) {
        return new BasicRibbonComponentUI();
    }

    public void installUI(JComponent c) {
        this.ribbonComponent = (JRibbonComponent)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        c.setLayout(this.createLayoutManager());
    }

    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
    }

    protected void installDefaults() {
        ResizableIcon icon;
        if (!this.ribbonComponent.isSimpleWrapper() && (icon = this.ribbonComponent.getIcon()) != null) {
            icon.setDimension(new Dimension(16, 16));
            this.disabledIcon = this.createDisabledIcon();
        }
        this.ribbonComponent.getMainComponent().setOpaque(false);
        this.ribbonComponent.setOpaque(false);
    }

    protected void installComponents() {
        this.captionLabel = new JLabel(this.ribbonComponent.getCaption());
        this.captionLabel.setEnabled(this.ribbonComponent.isEnabled());
        this.ribbonComponent.add(this.captionLabel);
        JComponent mainComponent = this.ribbonComponent.getMainComponent();
        this.ribbonComponent.add(mainComponent);
    }

    protected void installListeners() {
        this.propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    boolean isEnabled = (Boolean)evt.getNewValue();
                    BasicRibbonComponentUI.this.ribbonComponent.getMainComponent().setEnabled(isEnabled);
                    if (!BasicRibbonComponentUI.this.ribbonComponent.isSimpleWrapper()) {
                        BasicRibbonComponentUI.this.captionLabel.setEnabled(isEnabled);
                    }
                    BasicRibbonComponentUI.this.ribbonComponent.repaint();
                }
            }
        };
        this.ribbonComponent.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallComponents() {
        JComponent mainComponent = this.ribbonComponent.getMainComponent();
        this.ribbonComponent.remove(mainComponent);
        this.ribbonComponent.remove(this.captionLabel);
        this.captionLabel = null;
    }

    protected void uninstallListeners() {
        this.ribbonComponent.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public Point getKeyTipAnchorCenterPoint() {
        if (this.ribbonComponent.isSimpleWrapper()) {
            return new Point(this.ribbonComponent.getMainComponent().getX() + 10, this.ribbonComponent.getHeight());
        }
        return new Point(this.captionLabel.getX(), this.ribbonComponent.getHeight());
    }

    protected LayoutManager createLayoutManager() {
        return new ExtComponentLayout();
    }

    public void paint(Graphics g, JComponent c) {
        JRibbonComponent ribbonComp = (JRibbonComponent)c;
        if (!ribbonComp.isSimpleWrapper()) {
            ResizableIcon icon;
            Insets ins = ribbonComp.getInsets();
            ResizableIcon resizableIcon = icon = ribbonComp.isEnabled() ? ribbonComp.getIcon() : this.disabledIcon;
            if (icon != null) {
                int availableHeight = ribbonComp.getHeight() - ins.top - ins.bottom;
                int iconY = Math.max(0, ins.top + (availableHeight - icon.getIconHeight()) - 2);
                this.paintIcon(g, ribbonComp, icon, ins.left, iconY);
            }
        }
    }

    protected void paintIcon(Graphics g, JRibbonComponent ribbonComp, Icon icon, int x, int y) {
        icon.paintIcon(ribbonComp, g, x, y);
    }

    protected int getLayoutGap() {
        return 4;
    }

    protected ResizableIcon createDisabledIcon() {
        return new FilteredResizableIcon(this.ribbonComponent.getIcon(), new ColorConvertOp(ColorSpace.getInstance(1003), null));
    }

    protected class ExtComponentLayout
    implements LayoutManager {
        protected ExtComponentLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension minimumLayoutSize(Container parent) {
            Insets ins = BasicRibbonComponentUI.this.ribbonComponent.getInsets();
            JComponent mainComponent = BasicRibbonComponentUI.this.ribbonComponent.getMainComponent();
            Dimension minMain = mainComponent.getMinimumSize();
            if (BasicRibbonComponentUI.this.ribbonComponent.isSimpleWrapper()) {
                return new Dimension(ins.left + ins.right + minMain.width, ins.top + ins.bottom + minMain.height);
            }
            Dimension minCaption = BasicRibbonComponentUI.this.captionLabel.getMinimumSize();
            ResizableIcon icon = BasicRibbonComponentUI.this.ribbonComponent.getIcon();
            return new Dimension(ins.left + ins.right + (icon == null ? 0 : icon.getIconWidth()) + minCaption.width + minMain.width + 2 * BasicRibbonComponentUI.this.getLayoutGap(), ins.top + ins.bottom + Math.max(icon == null ? 0 : icon.getIconHeight(), Math.max(minCaption.height, minMain.height)));
        }

        public Dimension preferredLayoutSize(Container parent) {
            Insets ins = BasicRibbonComponentUI.this.ribbonComponent.getInsets();
            JComponent mainComponent = BasicRibbonComponentUI.this.ribbonComponent.getMainComponent();
            Dimension prefMain = mainComponent.getPreferredSize();
            if (BasicRibbonComponentUI.this.ribbonComponent.isSimpleWrapper()) {
                return new Dimension(ins.left + ins.right + prefMain.width, ins.top + ins.bottom + prefMain.height);
            }
            Dimension prefCaption = BasicRibbonComponentUI.this.captionLabel.getPreferredSize();
            ResizableIcon icon = BasicRibbonComponentUI.this.ribbonComponent.getIcon();
            return new Dimension(ins.left + ins.right + (icon == null ? 0 : icon.getIconWidth()) + prefCaption.width + prefMain.width + 2 * BasicRibbonComponentUI.this.getLayoutGap(), ins.top + ins.bottom + Math.max(icon == null ? 0 : icon.getIconHeight(), Math.max(prefCaption.height, prefMain.height)));
        }

        public void layoutContainer(Container parent) {
            JRibbonComponent ribbonComp = (JRibbonComponent)parent;
            Insets ins = ribbonComp.getInsets();
            int gap = BasicRibbonComponentUI.this.getLayoutGap();
            int availableHeight = ribbonComp.getHeight() - ins.top - ins.bottom;
            int availableWidth = ribbonComp.getWidth() - ins.left - ins.right;
            HorizontalAlignment horizAlignment = ribbonComp.getHorizontalAlignment();
            JComponent mainComp = ribbonComp.getMainComponent();
            Dimension prefMainDim = mainComp.getPreferredSize();
            int prefMainWidth = prefMainDim.width;
            int finalHeight = Math.min(prefMainDim.height, availableHeight);
            if (ribbonComp.isSimpleWrapper()) {
                int finalMainWidth = Math.min(availableWidth, prefMainWidth);
                int offset = availableWidth - prefMainWidth;
                int topMain = ins.top + (availableHeight - finalHeight) / 2;
                switch (horizAlignment) {
                    case LEADING: {
                        ribbonComp.getMainComponent().setBounds(ins.left, topMain, finalMainWidth, finalHeight);
                        break;
                    }
                    case TRAILING: {
                        ribbonComp.getMainComponent().setBounds(ins.left + offset, topMain, finalMainWidth, finalHeight);
                        break;
                    }
                    case CENTER: {
                        ribbonComp.getMainComponent().setBounds(ins.left + offset / 2, topMain, finalMainWidth, finalHeight);
                        break;
                    }
                    case FILL: {
                        ribbonComp.getMainComponent().setBounds(ins.left, topMain, availableWidth, finalHeight);
                    }
                }
            } else {
                int iconW = ribbonComp.getIcon() != null ? ribbonComp.getIcon().getIconWidth() : 0;
                Dimension prefCaptionDim = BasicRibbonComponentUI.this.captionLabel.getPreferredSize();
                int x = ins.left + iconW + gap;
                BasicRibbonComponentUI.this.captionLabel.setBounds(x, ins.top + (availableHeight - prefCaptionDim.height) / 2, prefCaptionDim.width, prefCaptionDim.height);
                int topMain = ins.top + (availableHeight - finalHeight) / 2;
                int finalMainWidth = Math.min(ribbonComp.getWidth() - ins.right - (x += prefCaptionDim.width + gap), prefMainWidth);
                int offset = ribbonComp.getWidth() - ins.right - x - prefMainWidth;
                switch (horizAlignment) {
                    case LEADING: {
                        ribbonComp.getMainComponent().setBounds(x, topMain, finalMainWidth, finalHeight);
                        break;
                    }
                    case TRAILING: {
                        ribbonComp.getMainComponent().setBounds(x + offset, topMain, finalMainWidth, finalHeight);
                        break;
                    }
                    case CENTER: {
                        ribbonComp.getMainComponent().setBounds(x + offset / 2, topMain, finalMainWidth, finalHeight);
                        break;
                    }
                    case FILL: {
                        ribbonComp.getMainComponent().setBounds(x, topMain, ribbonComp.getWidth() - ins.right - x, finalHeight);
                    }
                }
            }
        }
    }
}

