/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon;

import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jvnet.flamingo.common.AbstractCommandButton;
import org.jvnet.flamingo.common.JCommandToggleButton;
import org.jvnet.flamingo.common.StringValuePair;
import org.jvnet.flamingo.common.icon.ResizableIcon;
import org.jvnet.flamingo.common.popup.JCommandPopupMenu;
import org.jvnet.flamingo.ribbon.AbstractRibbonBand;
import org.jvnet.flamingo.ribbon.JRibbonComponent;
import org.jvnet.flamingo.ribbon.RibbonElementPriority;
import org.jvnet.flamingo.ribbon.resize.CoreRibbonResizePolicies;
import org.jvnet.flamingo.ribbon.ui.JBandControlPanel;
import org.jvnet.flamingo.ribbon.ui.JRibbonGallery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRibbonBand
extends AbstractRibbonBand<JBandControlPanel> {
    public JRibbonBand(String title, ResizableIcon icon) {
        this(title, icon, null);
    }

    public JRibbonBand(String title, ResizableIcon icon, ActionListener expandActionListener) {
        super(title, icon, expandActionListener, new JBandControlPanel());
        this.resizePolicies = Collections.unmodifiableList(CoreRibbonResizePolicies.getCorePoliciesPermissive(this));
        this.updateUI();
    }

    public void addCommandButton(AbstractCommandButton commandButton, RibbonElementPriority priority) {
        commandButton.setHorizontalAlignment(2);
        ((JBandControlPanel)this.controlPanel).addCommandButton(commandButton, priority);
    }

    public void addRibbonGallery(String galleryName, List<StringValuePair<List<JCommandToggleButton>>> buttons, Map<RibbonElementPriority, Integer> preferredVisibleButtonCounts, int preferredPopupMaxButtonColumns, int preferredPopupMaxVisibleButtonRows, RibbonElementPriority priority) {
        JRibbonGallery gallery = new JRibbonGallery();
        gallery.setName(galleryName);
        for (Map.Entry<RibbonElementPriority, Integer> prefCountEntry : preferredVisibleButtonCounts.entrySet()) {
            gallery.setPreferredVisibleButtonCount(prefCountEntry.getKey(), prefCountEntry.getValue());
        }
        gallery.setGroupMapping(buttons);
        gallery.setPreferredPopupPanelDimension(preferredPopupMaxButtonColumns, preferredPopupMaxVisibleButtonRows);
        ((JBandControlPanel)this.controlPanel).addRibbonGallery(gallery, priority);
    }

    public void addRibbonGalleryButtons(String galleryName, String buttonGroupName, JCommandToggleButton ... buttons) {
        JRibbonGallery gallery = ((JBandControlPanel)this.controlPanel).getRibbonGallery(galleryName);
        if (gallery == null) {
            return;
        }
        gallery.addRibbonGalleryButtons(buttonGroupName, buttons);
    }

    public void removeRibbonGalleryButtons(String galleryName, JCommandToggleButton ... buttons) {
        JRibbonGallery gallery = ((JBandControlPanel)this.controlPanel).getRibbonGallery(galleryName);
        if (gallery == null) {
            return;
        }
        gallery.removeRibbonGalleryButtons(buttons);
    }

    public void setSelectedRibbonGalleryButton(String galleryName, JCommandToggleButton buttonToSelect) {
        JRibbonGallery gallery = ((JBandControlPanel)this.controlPanel).getRibbonGallery(galleryName);
        if (gallery == null) {
            return;
        }
        gallery.setSelectedButton(buttonToSelect);
    }

    public void setRibbonGalleryPopupCallback(String galleryName, RibbonGalleryPopupCallback popupCallback) {
        JRibbonGallery gallery = ((JBandControlPanel)this.controlPanel).getRibbonGallery(galleryName);
        if (gallery == null) {
            return;
        }
        gallery.setPopupCallback(popupCallback);
    }

    public void setRibbonGalleryExpandKeyTip(String galleryName, String expandKeyTip) {
        JRibbonGallery gallery = ((JBandControlPanel)this.controlPanel).getRibbonGallery(galleryName);
        if (gallery == null) {
            return;
        }
        gallery.setExpandKeyTip(expandKeyTip);
    }

    public void addRibbonComponent(JRibbonComponent comp) {
        ((JBandControlPanel)this.controlPanel).addRibbonComponent(comp);
    }

    public void addRibbonComponent(JRibbonComponent comp, int rowSpan) {
        int availableRows;
        int groupCount = ((JBandControlPanel)this.controlPanel).getControlPanelGroupCount();
        String groupTitle = groupCount > 0 ? ((JBandControlPanel)this.controlPanel).getControlPanelGroupTitle(groupCount - 1) : null;
        int n = availableRows = groupTitle == null ? 3 : 2;
        if (rowSpan <= 0 || rowSpan > availableRows) {
            throw new IllegalArgumentException("Row span value not supported. Should be in 1.." + availableRows + " range");
        }
        ((JBandControlPanel)this.controlPanel).addRibbonComponent(comp, rowSpan);
    }

    public void startGroup() {
        ((JBandControlPanel)this.controlPanel).startGroup();
    }

    public void startGroup(String groupTitle) {
        ((JBandControlPanel)this.controlPanel).startGroup(groupTitle);
    }

    @Override
    public AbstractRibbonBand<JBandControlPanel> cloneBand() {
        return new JRibbonBand(this.getTitle(), this.getIcon(), this.getExpandActionListener());
    }

    public static interface RibbonGalleryPopupCallback {
        public void popupToBeShown(JCommandPopupMenu var1);
    }
}

