/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.common.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.jvnet.flamingo.common.JCommandButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScrollablePanel<T extends JComponent>
extends JPanel {
    private JCommandButton leftScroller;
    private JCommandButton rightScroller;
    private JScrollPane scrollPane;
    private T view = null;
    private MouseListener scrollMouseListener = null;
    private int widthToScrollTo = 0;
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean scrollOnRollover;

    public ScrollablePanel(T c, ScrollableSupport scrollableSupport) {
        this.view = c;
        this.scrollPane = new JScrollPane();
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setAutoscrolls(false);
        this.scrollPane.setViewportView((Component)c);
        this.add(this.scrollPane);
        this.leftScroller = scrollableSupport.createLeftScroller();
        this.configureLeftScrollerButtonAction();
        this.rightScroller = scrollableSupport.createRightScroller();
        this.configureRightScrollerButtonAction();
        this.setLayout(new ScrollablePanelLayout());
    }

    public void setScrollOnRollover(boolean toScrollOnRollover) {
        this.leftScroller.setFireActionOnRollover(toScrollOnRollover);
        this.rightScroller.setFireActionOnRollover(toScrollOnRollover);
    }

    public void increaseWidthBy(int increaseBy, ScrollTo scrollTo) {
        this.validateScrolling(this.widthToScrollTo + increaseBy, scrollTo);
    }

    public void validateScrolling(int width, ScrollTo scrollTo) {
        this.widthToScrollTo = width;
        int visibleWidth = this.getWidth();
        if (visibleWidth > 0 && visibleWidth < this.widthToScrollTo) {
            this.addScrollers();
            if (scrollTo != null) {
                int x = 0;
                if (scrollTo == ScrollTo.LAST) {
                    x = this.widthToScrollTo + this.leftScroller.getWidth() + this.rightScroller.getWidth();
                }
                this.scrollTo(x);
            } else {
                this.rightScroller.setEnabled(((JComponent)this.view).getVisibleRect().getX() + ((JComponent)this.view).getVisibleRect().getWidth() < (double)width);
                this.leftScroller.setEnabled(((JComponent)this.view).getVisibleRect().getX() > 0.0);
            }
        } else {
            this.removeScrollers();
        }
    }

    public void scrollTo(int x) {
        ((JComponent)this.view).scrollRectToVisible(new Rectangle(x, 0, 8, 0));
        this.rightScroller.setEnabled(((JComponent)this.view).getVisibleRect().getX() + ((JComponent)this.view).getVisibleRect().getWidth() < (double)this.widthToScrollTo);
        this.leftScroller.setEnabled(((JComponent)this.view).getVisibleRect().getX() > 0.0);
        this.fireStateChanged();
    }

    public void removeScrollers() {
        if (this.leftScroller.getParent() == this) {
            ((JComponent)this.view).scrollRectToVisible(new Rectangle(0, 0, 2, 2));
            this.remove(this.leftScroller);
            this.remove(this.rightScroller);
            this.revalidate();
            this.repaint();
        }
    }

    private void addScrollers() {
        this.add((Component)this.leftScroller, "West");
        this.add((Component)this.rightScroller, "East");
        this.revalidate();
        ((JComponent)this.view).setPreferredSize(((JComponent)this.view).getMinimumSize());
        ((Component)this.view).setSize(((JComponent)this.view).getMinimumSize());
        this.doLayout();
        this.repaint();
    }

    protected void configureLeftScrollerButtonAction() {
        this.leftScroller.setAutoRepeatAction(true);
        this.leftScroller.setAutoRepeatActionIntervals(200, 50);
        this.leftScroller.setFireActionOnRollover(true);
        this.leftScroller.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int scrollBy = 12;
                double x = ScrollablePanel.this.view.getVisibleRect().getX() - (double)scrollBy;
                if (x <= (double)(-scrollBy)) {
                    ScrollablePanel.this.leftScroller.setEnabled(false);
                    return;
                }
                ScrollablePanel.this.scrollTo((int)x);
            }
        });
    }

    protected void configureRightScrollerButtonAction() {
        this.rightScroller.setAutoRepeatAction(true);
        this.rightScroller.setAutoRepeatActionIntervals(200, 50);
        this.rightScroller.setFireActionOnRollover(true);
        this.rightScroller.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                double x = ScrollablePanel.this.view.getVisibleRect().getX() + ScrollablePanel.this.view.getVisibleRect().getWidth();
                if (x >= (double)ScrollablePanel.this.widthToScrollTo) {
                    ScrollablePanel.this.rightScroller.setEnabled(false);
                    return;
                }
                ScrollablePanel.this.scrollTo((int)x);
            }
        });
    }

    public T getView() {
        return this.view;
    }

    public JViewport getViewport() {
        return this.scrollPane.getViewport();
    }

    public boolean isShowingScrollButtons() {
        return this.leftScroller.getParent() == this;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(changeEvent);
        }
    }

    protected class ScrollablePanelLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(c.getWidth(), 21);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            int spw;
            int width = c.getWidth();
            int height = c.getHeight();
            ScrollablePanel sPanel = (ScrollablePanel)c;
            boolean isScrollerButtonsShowing = sPanel.leftScroller.getParent() == sPanel;
            int scrollPanelWidth = isScrollerButtonsShowing ? width - ((ScrollablePanel)sPanel).leftScroller.getPreferredSize().width - ((ScrollablePanel)sPanel).rightScroller.getPreferredSize().width - 4 : width;
            int x = 0;
            if (isScrollerButtonsShowing) {
                spw = ((ScrollablePanel)sPanel).leftScroller.getPreferredSize().width;
                sPanel.leftScroller.setBounds(0, 0, spw, height);
                x += spw + 2;
            }
            sPanel.scrollPane.setBounds(x, 0, scrollPanelWidth, height);
            x += scrollPanelWidth + 2;
            if (isScrollerButtonsShowing) {
                spw = ((ScrollablePanel)sPanel).rightScroller.getPreferredSize().width;
                sPanel.rightScroller.setBounds(x, 0, spw, height);
            }
        }
    }

    public static interface ScrollableSupport {
        public JCommandButton createLeftScroller();

        public JCommandButton createRightScroller();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScrollTo {
        FIRST,
        LAST;

    }
}

