/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.common.ui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.swing.JSeparator;
import org.jvnet.flamingo.common.AbstractCommandButton;
import org.jvnet.flamingo.common.CommandButtonLayoutManager;
import org.jvnet.flamingo.common.JCommandButton;
import org.jvnet.flamingo.common.icon.ResizableIcon;
import org.jvnet.flamingo.utils.FlamingoUtilities;

public class CommandButtonLayoutManagerMedium
implements CommandButtonLayoutManager {
    public int getPreferredIconSize() {
        return 16;
    }

    public Dimension getPreferredSize(AbstractCommandButton commandButton) {
        Insets borderInsets = commandButton.getInsets();
        int bx = borderInsets.left + borderInsets.right;
        int by = borderInsets.top + borderInsets.bottom;
        FontMetrics fm = commandButton.getFontMetrics(commandButton.getFont());
        JSeparator jsep = new JSeparator(1);
        int titleWidth = fm.stringWidth(commandButton.getText());
        int layoutHGap = FlamingoUtilities.getHLayoutGap(commandButton);
        int width = bx;
        width += this.getPreferredIconSize();
        width += layoutHGap;
        width += jsep.getPreferredSize().width;
        width += layoutHGap;
        width += titleWidth;
        if (FlamingoUtilities.hasPopupAction(commandButton)) {
            width += 2 * layoutHGap;
            width += 1 + fm.getHeight() / 2;
            width += 2 * layoutHGap;
        }
        return new Dimension(width, by + Math.max(this.getPreferredIconSize(), fm.getAscent() + fm.getDescent()));
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public Point getKeyTipAnchorCenterPoint(AbstractCommandButton commandButton) {
        Insets ins = commandButton.getInsets();
        int height = commandButton.getHeight();
        ResizableIcon buttonIcon = commandButton.getIcon();
        return new Point(ins.left + buttonIcon.getIconWidth(), (height + buttonIcon.getIconHeight()) / 2);
    }

    public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo(AbstractCommandButton commandButton, Graphics g) {
        int extraMediumSpace;
        JCommandButton.CommandButtonKind buttonKind;
        CommandButtonLayoutManager.CommandButtonLayoutInfo result = new CommandButtonLayoutManager.CommandButtonLayoutInfo();
        result.actionClickArea = new Rectangle(0, 0, 0, 0);
        result.popupClickArea = new Rectangle(0, 0, 0, 0);
        Insets ins = commandButton.getInsets();
        result.iconRect = new Rectangle();
        result.popupActionRect = new Rectangle();
        int width = commandButton.getWidth();
        int height = commandButton.getHeight();
        int x = ins.left;
        FontMetrics fm = g.getFontMetrics();
        int labelHeight = fm.getAscent() + fm.getDescent();
        JCommandButton.CommandButtonKind commandButtonKind = buttonKind = commandButton instanceof JCommandButton ? ((JCommandButton)commandButton).getCommandButtonKind() : JCommandButton.CommandButtonKind.ACTION_ONLY;
        if (buttonKind == JCommandButton.CommandButtonKind.ACTION_ONLY) {
            result.actionClickArea.x = 0;
            result.actionClickArea.y = 0;
            result.actionClickArea.width = width;
            result.actionClickArea.height = height;
            result.isTextInActionArea = true;
        }
        if (buttonKind == JCommandButton.CommandButtonKind.POPUP_ONLY) {
            result.popupClickArea.x = 0;
            result.popupClickArea.y = 0;
            result.popupClickArea.width = width;
            result.popupClickArea.height = height;
            result.isTextInActionArea = false;
        }
        JSeparator jsep = new JSeparator(1);
        int layoutHGap = FlamingoUtilities.getHLayoutGap(commandButton);
        ResizableIcon buttonIcon = commandButton.getIcon();
        result.iconRect.x = x;
        result.iconRect.y = (height - buttonIcon.getIconHeight()) / 2;
        result.iconRect.width = buttonIcon.getIconWidth();
        result.iconRect.height = buttonIcon.getIconHeight();
        x += commandButton.getIcon().getIconWidth();
        if (buttonKind == JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP) {
            result.actionClickArea.x = 0;
            result.actionClickArea.y = 0;
            result.actionClickArea.width = x + layoutHGap;
            result.actionClickArea.height = height;
            result.popupClickArea.x = x + layoutHGap;
            result.popupClickArea.y = 0;
            result.popupClickArea.width = width - x - layoutHGap;
            result.popupClickArea.height = height;
            result.isTextInActionArea = false;
        }
        CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
        lineLayoutInfo.text = commandButton.getText();
        lineLayoutInfo.textRect = new Rectangle();
        lineLayoutInfo.textRect.x = x += 2 * layoutHGap + jsep.getPreferredSize().width;
        lineLayoutInfo.textRect.y = (height - labelHeight) / 2;
        lineLayoutInfo.textRect.width = fm.stringWidth(commandButton.getText());
        lineLayoutInfo.textRect.height = labelHeight;
        result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
        result.textLayoutInfoList.add(lineLayoutInfo);
        x += (int)fm.getStringBounds(commandButton.getText(), g).getWidth();
        if (buttonKind == JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION) {
            result.actionClickArea.x = 0;
            result.actionClickArea.y = 0;
            result.actionClickArea.width = x + layoutHGap;
            result.actionClickArea.height = height;
            result.popupClickArea.x = x + layoutHGap;
            result.popupClickArea.y = 0;
            result.popupClickArea.width = width - x - layoutHGap;
            result.popupClickArea.height = height;
            result.isTextInActionArea = true;
        }
        x += 2 * layoutHGap + jsep.getPreferredSize().width;
        if (FlamingoUtilities.hasPopupAction(commandButton)) {
            result.popupActionRect.x = x;
            result.popupActionRect.y = (height - labelHeight) / 2 - 1;
            result.popupActionRect.width = 1 + labelHeight / 2;
            result.popupActionRect.height = labelHeight + 2;
            x += result.popupActionRect.width;
        }
        if (commandButton.getHorizontalAlignment() == 0 && (extraMediumSpace = width - (x += ins.right)) > 0) {
            if (FlamingoUtilities.hasPopupAction(commandButton)) {
                result.popupActionRect.x += extraMediumSpace;
            }
            if (buttonKind == JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION) {
                result.popupClickArea.x += extraMediumSpace;
                result.actionClickArea.width += extraMediumSpace;
            }
            if (buttonKind == JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP) {
                result.popupClickArea.x += extraMediumSpace / 2;
                result.actionClickArea.width += extraMediumSpace / 2;
            }
            result.iconRect.x += extraMediumSpace / 2;
            lineLayoutInfo.textRect.x += extraMediumSpace / 2;
        }
        return result;
    }
}

