/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.jvnet.flamingo.common.AbstractCommandButton;
import org.jvnet.flamingo.common.JCommandButtonPanel;
import org.jvnet.flamingo.common.ui.CommandButtonPanelUI;
import org.jvnet.flamingo.utils.FlamingoUtilities;

public class BasicCommandButtonPanelUI
extends CommandButtonPanelUI {
    protected JCommandButtonPanel buttonPanel;
    protected JLabel[] groupLabels;
    protected JSeparator[] groupSeparators;
    protected Rectangle[] groupRects;
    protected PropertyChangeListener propertyChangeListener;
    protected ChangeListener changeListener;
    protected static final Insets GROUP_INSETS = new Insets(4, 4, 4, 4);

    public static ComponentUI createUI(JComponent c) {
        return new BasicCommandButtonPanelUI();
    }

    public void installUI(JComponent c) {
        this.buttonPanel = (JCommandButtonPanel)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    protected void installDefaults() {
        this.buttonPanel.setLayout(this.createLayoutManager());
        Font currFont = this.buttonPanel.getFont();
        if (currFont == null || currFont instanceof UIResource) {
            FontUIResource titleFont = FlamingoUtilities.getFont(null, "CommandButtonPanel.font", "Button.font", "Panel.font");
            this.buttonPanel.setFont(titleFont);
        }
    }

    protected void installComponents() {
        this.recomputeGroupHeaders();
    }

    protected void installListeners() {
        this.propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("maxButtonColumns".equals(evt.getPropertyName()) || "maxButtonRows".equals(evt.getPropertyName()) || "toShowGroupLabels".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (BasicCommandButtonPanelUI.this.buttonPanel != null) {
                                BasicCommandButtonPanelUI.this.recomputeGroupHeaders();
                                BasicCommandButtonPanelUI.this.buttonPanel.revalidate();
                                BasicCommandButtonPanelUI.this.buttonPanel.doLayout();
                            }
                        }
                    });
                }
                if ("layoutKind".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (BasicCommandButtonPanelUI.this.buttonPanel != null) {
                                BasicCommandButtonPanelUI.this.buttonPanel.setLayout(BasicCommandButtonPanelUI.this.createLayoutManager());
                                BasicCommandButtonPanelUI.this.buttonPanel.revalidate();
                                BasicCommandButtonPanelUI.this.buttonPanel.doLayout();
                            }
                        }
                    });
                }
            }
        };
        this.buttonPanel.addPropertyChangeListener(this.propertyChangeListener);
        this.changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                BasicCommandButtonPanelUI.this.recomputeGroupHeaders();
                BasicCommandButtonPanelUI.this.buttonPanel.revalidate();
                BasicCommandButtonPanelUI.this.buttonPanel.doLayout();
            }
        };
        this.buttonPanel.addChangeListener(this.changeListener);
    }

    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.buttonPanel = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallComponents() {
        if (this.groupLabels != null) {
            for (JLabel groupLabel : this.groupLabels) {
                this.buttonPanel.remove(groupLabel);
            }
        }
    }

    protected void uninstallListeners() {
        this.buttonPanel.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.buttonPanel.removeChangeListener(this.changeListener);
        this.changeListener = null;
    }

    protected LayoutManager createLayoutManager() {
        if (this.buttonPanel.getLayoutKind() == JCommandButtonPanel.LayoutKind.ROW_FILL) {
            return new RowFillLayout();
        }
        return new ColumnFillLayout();
    }

    public void paint(Graphics g, JComponent c) {
        Color bg = this.buttonPanel.getBackground();
        g.setColor(bg);
        g.fillRect(0, 0, c.getWidth(), c.getHeight());
        for (int i = 0; i < this.buttonPanel.getGroupCount(); ++i) {
            Rectangle groupRect = this.groupRects[i];
            this.paintGroupBackground(g, i, groupRect.x, groupRect.y, groupRect.width, groupRect.height);
            if (!this.groupLabels[i].isVisible()) continue;
            Rectangle groupTitleBackground = this.groupLabels[i].getBounds();
            this.paintGroupTitleBackground(g, i, groupRect.x, groupTitleBackground.y - this.getGroupInsets().top, groupRect.width, groupTitleBackground.height + this.getGroupInsets().top + this.getLayoutGap());
        }
    }

    protected void paintGroupBackground(Graphics g, int groupIndex, int x, int y, int width, int height) {
        Color c = this.buttonPanel.getBackground();
        if (c == null || c instanceof UIResource) {
            c = UIManager.getColor("Panel.background");
            if (c == null) {
                c = new Color(190, 190, 190);
            }
            if (groupIndex % 2 == 1) {
                double coef = 0.95;
                c = new Color((int)((double)c.getRed() * coef), (int)((double)c.getGreen() * coef), (int)((double)c.getBlue() * coef));
            }
        }
        g.setColor(c);
        g.fillRect(x, y, width, height);
    }

    protected void paintGroupTitleBackground(Graphics g, int groupIndex, int x, int y, int width, int height) {
        FlamingoUtilities.renderSurface(g, this.buttonPanel, new Rectangle(x, y, width, height), false, groupIndex > 0, true);
    }

    protected int getGroupTitleHeight(int groupIndex) {
        return this.groupLabels[groupIndex].getPreferredSize().height;
    }

    protected Insets getGroupInsets() {
        return GROUP_INSETS;
    }

    protected int getLayoutGap() {
        return 4;
    }

    protected void recomputeGroupHeaders() {
        if (this.groupLabels != null) {
            for (JLabel groupLabel : this.groupLabels) {
                this.buttonPanel.remove(groupLabel);
            }
        }
        int groupCount = this.buttonPanel.getGroupCount();
        this.groupLabels = new JLabel[groupCount];
        this.groupSeparators = new JSeparator[groupCount];
        for (int i = 0; i < groupCount; ++i) {
            this.groupLabels[i] = new JLabel(this.buttonPanel.getGroupTitleAt(i));
            this.buttonPanel.add(this.groupLabels[i]);
            this.groupLabels[i].setVisible(this.buttonPanel.isToShowGroupLabels());
        }
    }

    public int getPreferredHeight(int buttonVisibleRows, int titleVisibleRows) {
        Insets bInsets = this.buttonPanel.getInsets();
        Insets groupInsets = this.getGroupInsets();
        int maxButtonHeight = 0;
        int groupCount = this.buttonPanel.getGroupCount();
        for (int i = 0; i < groupCount; ++i) {
            for (AbstractCommandButton button : this.buttonPanel.getGroupButtons(i)) {
                maxButtonHeight = Math.max(maxButtonHeight, button.getPreferredSize().height);
            }
        }
        int gap = this.getLayoutGap();
        int totalHeight = bInsets.top + bInsets.bottom;
        totalHeight += buttonVisibleRows * maxButtonHeight;
        totalHeight += (buttonVisibleRows - 1) * gap;
        totalHeight += titleVisibleRows * this.getGroupTitleHeight(0);
        return totalHeight += (titleVisibleRows - 1) * (groupInsets.top + groupInsets.bottom);
    }

    protected class ColumnFillLayout
    implements LayoutManager {
        protected ColumnFillLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void layoutContainer(Container parent) {
            Insets bInsets = parent.getInsets();
            Insets groupInsets = BasicCommandButtonPanelUI.this.getGroupInsets();
            int left = bInsets.left + groupInsets.left;
            int top = bInsets.top;
            int bottom = bInsets.bottom;
            int x = left;
            JCommandButtonPanel panel = (JCommandButtonPanel)parent;
            int maxButtonWidth = 0;
            int maxButtonHeight = 0;
            int groupCount = panel.getGroupCount();
            for (int i = 0; i < groupCount; ++i) {
                for (AbstractCommandButton button : panel.getGroupButtons(i)) {
                    maxButtonWidth = Math.max(maxButtonWidth, button.getPreferredSize().width);
                    maxButtonHeight = Math.max(maxButtonHeight, button.getPreferredSize().height);
                }
            }
            BasicCommandButtonPanelUI.this.groupRects = new Rectangle[groupCount];
            int gap = BasicCommandButtonPanelUI.this.getLayoutGap();
            int maxHeight = parent.getHeight() - bInsets.top - bInsets.bottom - groupInsets.top - groupInsets.bottom;
            int buttonsInRow = maxButtonHeight == 0 ? 0 : (maxHeight + gap) / (maxButtonHeight + gap);
            for (int i = 0; i < groupCount; ++i) {
                int leftGroupX = x;
                x += groupInsets.left;
                int currY = top + groupInsets.top;
                int buttonColumns = buttonsInRow == 0 ? 0 : (int)Math.ceil((double)panel.getGroupButtons(i).size() / (double)buttonsInRow);
                int actualButtonHeight = buttonColumns > 1 ? (maxHeight - (buttonsInRow - 1) * gap) / buttonsInRow : maxButtonWidth;
                for (AbstractCommandButton button : panel.getGroupButtons(i)) {
                    int endY = currY + actualButtonHeight;
                    if (endY > parent.getHeight() - bottom - groupInsets.bottom) {
                        currY = top + groupInsets.top;
                        x += maxButtonWidth;
                        x += gap;
                    }
                    button.setBounds(x, currY, maxButtonWidth, actualButtonHeight);
                    currY += actualButtonHeight;
                    currY += gap;
                }
                int rightGroupX = x += maxButtonWidth + groupInsets.bottom;
                BasicCommandButtonPanelUI.this.groupRects[i] = new Rectangle(leftGroupX, top, rightGroupX - leftGroupX, parent.getHeight() - top - bottom);
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            JCommandButtonPanel panel = (JCommandButtonPanel)parent;
            int maxButtonRowsToUse = panel.getMaxButtonRows();
            Insets bInsets = parent.getInsets();
            Insets groupInsets = BasicCommandButtonPanelUI.this.getGroupInsets();
            int insetsHeight = bInsets.top + groupInsets.top + bInsets.bottom + groupInsets.bottom;
            int maxButtonWidth = 0;
            int maxButtonHeight = 0;
            int groupCount = panel.getGroupCount();
            for (int i = 0; i < groupCount; ++i) {
                for (AbstractCommandButton button : panel.getGroupButtons(i)) {
                    maxButtonWidth = Math.max(maxButtonWidth, button.getPreferredSize().width);
                    maxButtonHeight = Math.max(maxButtonHeight, button.getPreferredSize().height);
                }
            }
            int gap = BasicCommandButtonPanelUI.this.getLayoutGap();
            boolean usePanelHeight = maxButtonRowsToUse <= 0;
            Container container = panel.getParent();
            int availableHeight = panel.getHeight();
            availableHeight -= insetsHeight;
            if (usePanelHeight) {
                maxButtonRowsToUse = (availableHeight + gap) / (maxButtonHeight + gap);
            }
            int width = bInsets.left + bInsets.right;
            for (int i = 0; i < groupCount; ++i) {
                width += groupInsets.left + groupInsets.right;
                int buttonColumns = (int)Math.ceil((double)panel.getGroupButtons(i).size() / (double)maxButtonRowsToUse);
                width += buttonColumns * maxButtonWidth + (buttonColumns - 1) * gap;
            }
            int prefHeight = usePanelHeight ? availableHeight : maxButtonRowsToUse * maxButtonWidth + (maxButtonRowsToUse - 1) * gap + bInsets.top + bInsets.bottom + groupInsets.top + groupInsets.bottom;
            return new Dimension(Math.max(10, width), Math.max(10, prefHeight));
        }
    }

    protected class RowFillLayout
    implements LayoutManager {
        protected RowFillLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void layoutContainer(Container parent) {
            Insets bInsets = parent.getInsets();
            Insets groupInsets = BasicCommandButtonPanelUI.this.getGroupInsets();
            int left = bInsets.left;
            int right = bInsets.right;
            int y = bInsets.top;
            JCommandButtonPanel panel = (JCommandButtonPanel)parent;
            int maxButtonWidth = 0;
            int maxButtonHeight = 0;
            int groupCount = panel.getGroupCount();
            for (int i = 0; i < groupCount; ++i) {
                for (AbstractCommandButton button : panel.getGroupButtons(i)) {
                    maxButtonWidth = Math.max(maxButtonWidth, button.getPreferredSize().width);
                    maxButtonHeight = Math.max(maxButtonHeight, button.getPreferredSize().height);
                }
            }
            BasicCommandButtonPanelUI.this.groupRects = new Rectangle[groupCount];
            int gap = BasicCommandButtonPanelUI.this.getLayoutGap();
            int maxWidth = parent.getWidth() - bInsets.left - bInsets.right - groupInsets.left - groupInsets.right;
            int buttonsInRow = maxButtonWidth == 0 ? 0 : (maxWidth + gap) / (maxButtonWidth + gap);
            int maxButtonColumnsToUse = panel.getMaxButtonColumns();
            if (maxButtonColumnsToUse > 0) {
                buttonsInRow = Math.min(buttonsInRow, maxButtonColumnsToUse);
            }
            for (int i = 0; i < groupCount; ++i) {
                int actualButtonWidth;
                int buttonRows;
                int topGroupY = y;
                y += groupInsets.top;
                JLabel groupLabel = BasicCommandButtonPanelUI.this.groupLabels[i];
                if (BasicCommandButtonPanelUI.this.buttonPanel.isToShowGroupLabels()) {
                    int labelWidth = groupLabel.getPreferredSize().width;
                    int labelHeight = BasicCommandButtonPanelUI.this.getGroupTitleHeight(i);
                    groupLabel.setBounds(left + groupInsets.left, y, labelWidth, labelHeight);
                    y += labelHeight + gap;
                }
                int currX = left + groupInsets.left;
                int n = buttonRows = buttonsInRow == 0 ? 0 : (int)Math.ceil((double)panel.getGroupButtons(i).size() / (double)buttonsInRow);
                if (maxButtonColumnsToUse > 0) {
                    buttonsInRow = Math.min(buttonsInRow, maxButtonColumnsToUse);
                }
                int n2 = actualButtonWidth = buttonRows > 1 ? (maxWidth - (buttonsInRow - 1) * gap) / buttonsInRow : maxButtonWidth;
                if (maxButtonColumnsToUse == 1) {
                    actualButtonWidth = maxWidth;
                }
                for (AbstractCommandButton button : panel.getGroupButtons(i)) {
                    int endX = currX + actualButtonWidth;
                    if (endX > parent.getWidth() - right - groupInsets.right) {
                        currX = left + groupInsets.left;
                        y += maxButtonHeight;
                        y += gap;
                    }
                    button.setBounds(currX, y, actualButtonWidth, maxButtonHeight);
                    currX += actualButtonWidth;
                    currX += gap;
                }
                int bottomGroupY = y += maxButtonHeight + groupInsets.bottom;
                BasicCommandButtonPanelUI.this.groupRects[i] = new Rectangle(left, topGroupY, parent.getWidth() - left - right, bottomGroupY - topGroupY);
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            JCommandButtonPanel panel = (JCommandButtonPanel)parent;
            int maxButtonColumnsToUse = panel.getMaxButtonColumns();
            Insets bInsets = parent.getInsets();
            Insets groupInsets = BasicCommandButtonPanelUI.this.getGroupInsets();
            int insetsWidth = bInsets.left + groupInsets.left + bInsets.right + groupInsets.right;
            int maxButtonWidth = 0;
            int maxButtonHeight = 0;
            int groupCount = panel.getGroupCount();
            for (int i = 0; i < groupCount; ++i) {
                for (AbstractCommandButton button : panel.getGroupButtons(i)) {
                    maxButtonWidth = Math.max(maxButtonWidth, button.getPreferredSize().width);
                    maxButtonHeight = Math.max(maxButtonHeight, button.getPreferredSize().height);
                }
            }
            int gap = BasicCommandButtonPanelUI.this.getLayoutGap();
            boolean usePanelWidth = maxButtonColumnsToUse <= 0;
            Container container = panel.getParent();
            int availableWidth = panel.getWidth();
            availableWidth -= insetsWidth;
            if (usePanelWidth) {
                maxButtonColumnsToUse = (availableWidth + gap) / (maxButtonWidth + gap);
            }
            int height = bInsets.top + bInsets.bottom;
            for (int i = 0; i < groupCount; ++i) {
                if (BasicCommandButtonPanelUI.this.groupLabels[i].isVisible()) {
                    height += BasicCommandButtonPanelUI.this.getGroupTitleHeight(i) + gap;
                }
                height += groupInsets.top + groupInsets.bottom;
                int buttonRows = (int)Math.ceil((double)panel.getGroupButtons(i).size() / (double)maxButtonColumnsToUse);
                height += buttonRows * maxButtonHeight + (buttonRows - 1) * gap;
            }
            int prefWidth = usePanelWidth ? availableWidth : maxButtonColumnsToUse * maxButtonWidth + (maxButtonColumnsToUse - 1) * gap + bInsets.left + bInsets.right + groupInsets.left + groupInsets.right;
            return new Dimension(Math.max(10, prefWidth), Math.max(10, height));
        }
    }
}

