/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.common.popup;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jvnet.flamingo.common.CommandButtonDisplayState;
import org.jvnet.flamingo.common.JCommandButtonPanel;
import org.jvnet.flamingo.common.JCommandMenuButton;
import org.jvnet.flamingo.common.popup.JPopupPanel;
import org.jvnet.flamingo.common.ui.BasicCommandPopupMenuUI;
import org.jvnet.flamingo.common.ui.PopupPanelUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCommandPopupMenu
extends JPopupPanel {
    public static final String uiClassID = "CommandPopupMenuUI";
    protected JCommandButtonPanel mainButtonPanel;
    protected List<Component> menuComponents = new ArrayList<Component>();
    protected int maxButtonColumns;
    protected int maxVisibleButtonRows;

    public JCommandPopupMenu() {
    }

    public JCommandPopupMenu(JCommandButtonPanel buttonPanel, int maxButtonColumns, int maxVisibleButtonRows) {
        this();
        this.mainButtonPanel = buttonPanel;
        this.maxButtonColumns = maxButtonColumns;
        this.maxVisibleButtonRows = maxVisibleButtonRows;
        this.updateUI();
    }

    public void addMenuButton(JCommandMenuButton menuButton) {
        menuButton.setDisplayState(CommandButtonDisplayState.MEDIUM);
        menuButton.setHorizontalAlignment(2);
        this.menuComponents.add(menuButton);
        this.fireStateChanged();
    }

    public void addMenuSeparator() {
        this.menuComponents.add(new JPopupMenu.Separator());
        this.fireStateChanged();
    }

    public boolean hasCommandButtonPanel() {
        return this.mainButtonPanel != null;
    }

    public JCommandButtonPanel getMainButtonPanel() {
        return this.mainButtonPanel;
    }

    public List<Component> getMenuComponents() {
        if (this.menuComponents == null) {
            return null;
        }
        return Collections.unmodifiableList(this.menuComponents);
    }

    public int getMaxButtonColumns() {
        return this.maxButtonColumns;
    }

    public int getMaxVisibleButtonRows() {
        return this.maxVisibleButtonRows;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((PopupPanelUI)UIManager.getUI(this));
        } else {
            this.setUI(BasicCommandPopupMenuUI.createUI(this));
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }
}

