/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.common;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jvnet.flamingo.common.AbstractCommandButton;
import org.jvnet.flamingo.common.CommandButtonDisplayState;
import org.jvnet.flamingo.common.ui.BasicCommandButtonStripUI;
import org.jvnet.flamingo.common.ui.CommandButtonStripUI;

public class JCommandButtonStrip
extends JComponent {
    public static final String uiClassID = "CommandButtonStripUI";
    protected CommandButtonDisplayState displayState;
    protected double hgapScaleFactor;
    protected double vgapScaleFactor;
    private StripOrientation orientation;

    public JCommandButtonStrip() {
        this(StripOrientation.HORIZONTAL);
    }

    public JCommandButtonStrip(StripOrientation orientation) {
        this.orientation = orientation;
        this.displayState = CommandButtonDisplayState.SMALL;
        switch (orientation) {
            case HORIZONTAL: {
                this.hgapScaleFactor = 0.75;
                this.vgapScaleFactor = 1.0;
                break;
            }
            case VERTICAL: {
                this.hgapScaleFactor = 1.0;
                this.vgapScaleFactor = 0.75;
            }
        }
        this.setOpaque(false);
        this.updateUI();
    }

    public void setDisplayState(CommandButtonDisplayState elementState) {
        if (this.getComponentCount() > 0) {
            throw new IllegalStateException("Can't call this method after buttons have been already added");
        }
        this.displayState = elementState;
    }

    public void setHGapScaleFactor(double hgapScaleFactor) {
        if (this.getComponentCount() > 0) {
            throw new IllegalStateException("Can't call this method after buttons have been already added");
        }
        this.hgapScaleFactor = hgapScaleFactor;
    }

    public void setVGapScaleFactor(double vgapScaleFactor) {
        if (this.getComponentCount() > 0) {
            throw new IllegalStateException("Can't call this method after buttons have been already added");
        }
        this.vgapScaleFactor = vgapScaleFactor;
    }

    public void add(Component comp, Object constraints, int index) {
        throw new UnsupportedOperationException();
    }

    public void add(Component comp, Object constraints) {
        throw new UnsupportedOperationException();
    }

    public Component add(Component comp, int index) {
        if (!(comp instanceof AbstractCommandButton)) {
            throw new UnsupportedOperationException();
        }
        this.configureCommandButton((AbstractCommandButton)comp);
        return super.add(comp, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component add(Component comp) {
        if (!(comp instanceof AbstractCommandButton)) {
            throw new UnsupportedOperationException();
        }
        try {
            Component result;
            this.configureCommandButton((AbstractCommandButton)comp);
            Component component = result = super.add(comp);
            return component;
        }
        finally {
            this.fireStateChanged();
        }
    }

    private void configureCommandButton(AbstractCommandButton button) {
        button.setDisplayState(this.displayState);
        button.setHGapScaleFactor(this.hgapScaleFactor);
        button.setVGapScaleFactor(this.vgapScaleFactor);
        button.setFlat(false);
    }

    public Component add(String name, Component comp) {
        throw new UnsupportedOperationException();
    }

    public void setUI(CommandButtonStripUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((CommandButtonStripUI)UIManager.getUI(this));
        } else {
            this.setUI(BasicCommandButtonStripUI.createUI(this));
        }
    }

    public CommandButtonStripUI getUI() {
        return (CommandButtonStripUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public int getButtonCount() {
        return this.getComponentCount();
    }

    public AbstractCommandButton getButton(int index) {
        return (AbstractCommandButton)this.getComponent(index);
    }

    public boolean isFirst(AbstractCommandButton button) {
        return button == this.getButton(0);
    }

    public boolean isLast(AbstractCommandButton button) {
        return button == this.getButton(this.getButtonCount() - 1);
    }

    public StripOrientation getOrientation() {
        return this.orientation;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StripOrientation {
        HORIZONTAL,
        VERTICAL;

    }
}

