/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.bcb.ui;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLabelUI;
import org.jvnet.flamingo.bcb.JBreadcrumbBar;
import org.jvnet.flamingo.bcb.ui.BreadcrumbBarUI;
import org.jvnet.flamingo.bcb.ui.BreadcrumbParticle;
import org.jvnet.flamingo.bcb.ui.ChoicesSelector;
import org.jvnet.flamingo.utils.FlamingoUtilities;

public class BasicBreadcrumbParticleUI
extends BasicLabelUI {
    protected BreadcrumbParticle particle;
    protected FocusListener baseFocusListener;
    protected MouseListener baseMouseListener;
    protected KeyListener baseKeyListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicBreadcrumbParticleUI();
    }

    public void installUI(JComponent c) {
        this.particle = (BreadcrumbParticle)c;
        this.installDefaults(this.particle);
        this.installComponents(this.particle);
        this.installListeners(this.particle);
    }

    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners((BreadcrumbParticle)c);
        this.uninstallComponents((BreadcrumbParticle)c);
        this.uninstallDefaults((BreadcrumbParticle)c);
        this.particle = null;
    }

    protected void installDefaults(BreadcrumbParticle particle) {
        Font currFont = particle.getFont();
        if (currFont == null || currFont instanceof UIResource) {
            FontUIResource font = FlamingoUtilities.getFont(null, "BreadcrumbBar.font", "Button.font", "Panel.font");
            particle.setFont(font);
        }
        particle.setCursor(Cursor.getPredefinedCursor(12));
        particle.setBorder(new EmptyBorder(0, 2, 0, 2));
    }

    protected void installComponents(BreadcrumbParticle particle) {
    }

    protected void installListeners(final BreadcrumbParticle particle) {
        this.baseMouseListener = new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                particle.getModel().setRollover(true);
                particle.getBar().repaint();
            }

            public void mouseExited(MouseEvent e) {
                particle.getModel().setRollover(false);
                particle.getBar().repaint();
            }

            public void mouseClicked(MouseEvent me) {
                if (me.getModifiers() == 16) {
                    particle.onSelection();
                }
            }
        };
        particle.addMouseListener(this.baseMouseListener);
        this.baseKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40) {
                    particle.getBar().getUI().popup(particle.getIndex());
                }
            }

            public void keyTyped(KeyEvent e) {
                if (!(e.getSource() instanceof JLabel)) {
                    return;
                }
                if (e.getKeyChar() == '\u001b') {
                    return;
                }
                if (e.getKeyChar() == '\n') {
                    particle.onSelection();
                    return;
                }
            }
        };
        particle.addKeyListener(this.baseKeyListener);
    }

    protected void uninstallDefaults(BreadcrumbParticle particle) {
    }

    protected void uninstallComponents(BreadcrumbParticle particle) {
    }

    protected void uninstallListeners(BreadcrumbParticle particle) {
        particle.removeKeyListener(this.baseKeyListener);
        this.baseKeyListener = null;
        particle.removeMouseListener(this.baseMouseListener);
        this.baseMouseListener = null;
    }

    public void paint(Graphics g, JComponent c) {
        boolean toMark;
        Graphics2D graphics = (Graphics2D)g.create();
        boolean bl = toMark = this.particle.getModel().isSelected() || this.particle.getModel().isArmed() || this.particle.getModel().isRollover() || this.particle.getModel().isPressed();
        if (toMark) {
            JBreadcrumbBar bar = this.particle.getBar();
            BreadcrumbBarUI barUI = bar.getUI();
            ChoicesSelector selector = barUI.getSelector(this.particle.getIndex() + 1);
            this.paintSelectedBackground(graphics, c, selector);
        }
        super.paint(g, c);
        if (toMark) {
            this.paintSelectedForeground(graphics, c);
        }
        graphics.dispose();
    }

    protected void paintSelectedBackground(Graphics2D graphics, JComponent c, ChoicesSelector selector) {
    }

    protected void paintSelectedForeground(Graphics2D graphics, JComponent c) {
        graphics.setColor(this.particle.getForeground());
        Rectangle viewR = new Rectangle();
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Insets paintViewInsets = new Insets(0, 0, 0, 0);
        Insets insets = c.getInsets(paintViewInsets);
        viewR.x = insets.left;
        viewR.y = insets.top;
        viewR.width = c.getWidth() - (insets.left + insets.right);
        viewR.height = c.getHeight() - (insets.top + insets.bottom);
        SwingUtilities.layoutCompoundLabel(this.particle, this.particle.getFontMetrics(this.particle.getFont()), this.particle.getText(), this.particle.getIcon(), this.particle.getVerticalAlignment(), this.particle.getHorizontalAlignment(), this.particle.getVerticalTextPosition(), this.particle.getHorizontalTextPosition(), viewR, iconR, textR, this.particle.getIconTextGap());
        graphics.drawLine(textR.x, textR.y + textR.height, textR.x + textR.width, textR.y + textR.height);
    }
}

