/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.bcb.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.jvnet.flamingo.bcb.BreadcrumbBarCallBack;
import org.jvnet.flamingo.bcb.BreadcrumbBarException;
import org.jvnet.flamingo.bcb.BreadcrumbBarExceptionHandler;
import org.jvnet.flamingo.bcb.BreadcrumbItem;
import org.jvnet.flamingo.bcb.BreadcrumbPathEvent;
import org.jvnet.flamingo.bcb.BreadcrumbPathListener;
import org.jvnet.flamingo.bcb.JBreadcrumbBar;
import org.jvnet.flamingo.bcb.core.BreadcrumbSvnSelector;
import org.jvnet.flamingo.common.StringValuePair;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreadcrumbMultiSvnSelector
extends JBreadcrumbBar<String> {
    public BreadcrumbMultiSvnSelector(SvnRepositoryInfo ... repositories) {
        super(null);
        this.callback = new PathCallback(repositories);
        this.callback.setup();
        this.getModel().reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PathCallback
    extends BreadcrumbBarCallBack<String> {
        protected List<SvnRepositoryInfo> repositories = new ArrayList<SvnRepositoryInfo>();
        private SVNRepository currRepository;
        private CountDownLatch connectionLatch;

        public PathCallback(SvnRepositoryInfo ... repoList) {
            if (repoList != null) {
                for (SvnRepositoryInfo repository : repoList) {
                    this.addSvnRepositoryInfo(repository);
                }
            }
            BreadcrumbMultiSvnSelector.this.getModel().addPathListener(new BreadcrumbPathListener(){

                public void breadcrumbPathEvent(BreadcrumbPathEvent event) {
                    final List newPath = BreadcrumbMultiSvnSelector.this.getModel().getItems();
                    if (newPath.size() == 1) {
                        PathCallback.this.connectionLatch = new CountDownLatch(1);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (newPath.size() != 1) {
                                return;
                            }
                            String newSvnName = (String)((BreadcrumbItem)newPath.get(0)).getData();
                            for (final SvnRepositoryInfo repoInfo : PathCallback.this.repositories) {
                                if (!newSvnName.equals(repoInfo.name)) continue;
                                SwingWorker<SVNRepository, Void> worker = new SwingWorker<SVNRepository, Void>(){

                                    @Override
                                    protected SVNRepository doInBackground() throws Exception {
                                        try {
                                            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)repoInfo.url));
                                            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)repoInfo.user, (String)repoInfo.password);
                                            repository.setAuthenticationManager(authManager);
                                            return repository;
                                        }
                                        catch (SVNException svne) {
                                            List<BreadcrumbBarExceptionHandler> handlers = BreadcrumbMultiSvnSelector.this.getExceptionHandlers();
                                            for (BreadcrumbBarExceptionHandler handler : handlers) {
                                                handler.onException(svne);
                                            }
                                            return null;
                                        }
                                    }

                                    @Override
                                    protected void done() {
                                        try {
                                            PathCallback.this.currRepository = (SVNRepository)this.get();
                                            PathCallback.this.connectionLatch.countDown();
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                };
                                worker.execute();
                            }
                        }
                    });
                }
            });
        }

        public void addSvnRepositoryInfo(SvnRepositoryInfo repositoryInfo) {
            this.repositories.add(repositoryInfo);
        }

        @Override
        public void setup() {
            DAVRepositoryFactory.setup();
            SVNRepositoryFactoryImpl.setup();
            FSRepositoryFactory.setup();
        }

        @Override
        public List<StringValuePair<String>> getPathChoices(List<BreadcrumbItem<String>> path) throws BreadcrumbBarException {
            try {
                if (this.connectionLatch != null) {
                    this.connectionLatch.await();
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (path == null) {
                ArrayList<StringValuePair<String>> result = new ArrayList<StringValuePair<String>>();
                for (SvnRepositoryInfo repoInfo : this.repositories) {
                    StringValuePair<String> toAdd = new StringValuePair<String>(repoInfo.name, repoInfo.name);
                    result.add(toAdd);
                }
                return result;
            }
            String lastPath = path.size() == 1 ? "" : path.get(path.size() - 1).getData();
            try {
                return BreadcrumbSvnSelector.getPathChoices(this.currRepository, lastPath);
            }
            catch (SVNException svne) {
                if (this.throwsExceptions) {
                    throw new BreadcrumbBarException(svne);
                }
                return null;
            }
        }

        @Override
        public List<StringValuePair<String>> getLeafs(List<BreadcrumbItem<String>> path) throws BreadcrumbBarException {
            if (path == null) {
                return null;
            }
            try {
                if (this.connectionLatch != null) {
                    this.connectionLatch.await();
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            String lastPath = path.size() == 1 ? "" : path.get(path.size() - 1).getData();
            try {
                return BreadcrumbSvnSelector.getLeafs(this.currRepository, lastPath);
            }
            catch (SVNException svne) {
                if (this.throwsExceptions) {
                    throw new BreadcrumbBarException(svne);
                }
                return null;
            }
        }

        @Override
        public InputStream getLeafContent(String leaf) throws BreadcrumbBarException {
            try {
                return BreadcrumbSvnSelector.getLeafContent(this.currRepository, leaf);
            }
            catch (SVNException svne) {
                if (this.throwsExceptions) {
                    throw new BreadcrumbBarException(svne);
                }
                return null;
            }
        }
    }

    public static class SvnRepositoryInfo {
        public String name;
        public String url;
        public String user;
        public String password;

        public SvnRepositoryInfo(String name, String url, String user, String password) {
            this.name = name;
            this.url = url;
            this.user = user;
            this.password = password;
        }
    }
}

