/*
 * Decompiled with CFR 0.152.
 */
package gamemaker.events;

import gamemaker.Exceptions.PanelNotPassedException;
import gamemaker.GameMap;
import gamemaker.MessageInput;
import gamemaker.Panels.EventPanel;
import gamemaker.events.GameEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class soutEvent
extends GameEvent
implements ActionListener {
    String theMessage = "";
    private GameMap gameMap;
    private MessageInput messageInput;

    public soutEvent(EventPanel eventPanel, GameMap gameMap) {
        super(eventPanel, "message");
        this.gameMap = gameMap;
    }

    public void setMessageText(String s) {
        this.theMessage = s;
    }

    public void configureEvent(boolean requireCondition) {
        if (this.createCondition(requireCondition)) {
            this.messageInput = new MessageInput(this);
            this.theMessage = this.messageInput.getInput();
        } else {
            this.deleteMyself();
        }
    }

    public boolean eventAction() {
        if (this.isEventActionAbleToRun()) {
            try {
                String[] parts = this.theMessage.split("[{|}]");
                String newMessage = "";
                int index = 0;
                boolean changeTheMessage = false;
                for (int i = 0; i < parts.length; ++i) {
                    if (i % 2 == 1) {
                        try {
                            index = Integer.parseInt(parts[i]);
                            newMessage = newMessage + this.gameMap.getSpritePanel().getSprite().getSpriteVar(index %= 10);
                            changeTheMessage = true;
                        }
                        catch (NumberFormatException nfe) {}
                        continue;
                    }
                    newMessage = newMessage + parts[i];
                }
                if (changeTheMessage) {
                    this.eventPanel.getDialoguePanel().setMessage(newMessage);
                } else {
                    this.eventPanel.getDialoguePanel().setMessage(this.theMessage);
                }
                this.gameMap.toggleDialogue();
            }
            catch (PanelNotPassedException pnpe) {
                System.err.println(pnpe);
                pnpe.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("setmessage_ok")) {
            if (this.messageInput != null) {
                this.messageInput.closeDialogue();
            }
        } else if (e.getActionCommand().equals("setmessage_cancel")) {
            this.deleteMyself();
            if (this.messageInput != null) {
                this.messageInput.closeDialogue();
            }
        }
    }

    public String toXML() {
        String opening = "<event type=\"" + this.getEventFuntion() + "\" " + "trigger=\"" + this.eventTriggerToString() + "\" >";
        String closing = "</event>";
        return this.toXML(opening, closing);
    }

    public String toXML(String openTag, String closeTag) {
        String xml = "";
        xml = xml + openTag + "\n";
        xml = xml + this.alwaysToXML();
        xml = xml + "\n" + this.theMessage + "\n";
        xml = xml + closeTag + "\n";
        return xml;
    }

    public static void main(String[] args) {
        String s = "hello } how";
        String[] parts = s.split("[{|}]");
        System.out.println(parts[0]);
    }
}

