/*
 * Decompiled with CFR 0.152.
 */
package gamemaker;

import gamemaker.Exceptions.GameXmlIncorrectException;
import gamemaker.Exceptions.ImageNotSelectedException;
import gamemaker.FileHandler;
import gamemaker.GameMap;
import gamemaker.GameMaps;
import gamemaker.ImageWithDetails;
import gamemaker.MapsContainer;
import gamemaker.MyFileFilter;
import gamemaker.Player.PlayFrame;
import gamemaker.RightPanels.RightPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jvnet.flamingo.common.JCommandButton;
import org.jvnet.flamingo.common.JCommandToggleButton;
import org.jvnet.flamingo.common.StringValuePair;
import org.jvnet.flamingo.common.icon.ImageWrapperResizableIcon;
import org.jvnet.flamingo.common.icon.ResizableIcon;
import org.jvnet.flamingo.ribbon.JRibbonBand;
import org.jvnet.flamingo.ribbon.JRibbonComponent;
import org.jvnet.flamingo.ribbon.JRibbonFrame;
import org.jvnet.flamingo.ribbon.RibbonElementPriority;
import org.jvnet.flamingo.ribbon.RibbonTask;
import org.jvnet.flamingo.ribbon.resize.CoreRibbonResizePolicies;

public class Ribbon
extends JRibbonFrame
implements ActionListener,
MapsContainer {
    private GameMaps maps;
    private JScrollPane contentScroll;
    private RightPanel rightPanel;
    private File nullFile;
    private File lastSaveorLoadLocation;
    private JCheckBox conditional;
    private JCommandToggleButton squareButton;
    private JCommandToggleButton circleButton;
    private JCommandToggleButton areaButton;
    private JCommandToggleButton messageButton;
    private JCommandToggleButton teleportButton;
    private JCommandToggleButton variableButton;
    private JRibbonBand eventShapeBand;

    public GameMaps getGameMaps() {
        return this.maps;
    }

    public JScrollPane getJScrollPane() {
        return this.contentScroll;
    }

    public String getContainterType() {
        return "ribbon";
    }

    public void updatePreferredSizes() {
        this.repaint();
        int newWidth = (int)this.getSize().getWidth() - (int)this.rightPanel.getPreferredSize().getWidth() - 17;
        int newHeight = this.getHeight() - this.getRibbonHeight() - 38;
        this.contentScroll.setPreferredSize(new Dimension(newWidth, newHeight));
        this.pack();
    }

    public Ribbon() {
        this.lastSaveorLoadLocation = this.nullFile = new File("This a null file alsbalibflaibflabh9892214");
        try {
            this.setTitle("Game Maker");
            Image iconImage = FileHandler.imageFromFileOnly(FileHandler.getFilesLocation() + "gamelogo.png");
            this.setIconImage(iconImage);
            RibbonTask homeTask = new RibbonTask("Tools", this.getCommonToolsBand(), this.getMapEditBand(), this.getLayerBand());
            RibbonTask mapTask = new RibbonTask("Events", this.getEventsBand(), this.getEventShapeBand(), this.getEventConfigBand());
            this.getRibbon().addTask(homeTask);
            this.getRibbon().addTask(mapTask);
            this.configureTaskBar();
            this.setSize(800, 600);
            this.setLocationRelativeTo(null);
            this.setDefaultCloseOperation(2);
            this.maps = new GameMaps(this);
            this.contentScroll = new JScrollPane();
            this.contentScroll.add(this.maps.getCurrentMap());
            this.contentScroll.setViewportView(this.maps.getCurrentMap());
            this.contentScroll.setVisible(true);
            this.repaint();
            this.add((Component)this.contentScroll, "Center");
            this.rightPanel = new RightPanel(this);
            this.add((Component)this.rightPanel, "East");
            this.setExtendedState(6);
        }
        catch (MalformedURLException e) {
            System.err.println(e.toString());
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            ioe.printStackTrace();
        }
    }

    public void newGame() throws IOException, JDOMException {
        int reply = JOptionPane.showConfirmDialog(this, "Are you sure that you want to start a new game?");
        if (reply == 0) {
            reply = JOptionPane.showConfirmDialog(this, "Do you want to save your game?\nIf not then all game data will be lost.");
            boolean saveSuccess = true;
            if (reply == 0) {
                saveSuccess = this.saveGame();
            }
            if (reply == 0 && saveSuccess || reply == 1) {
                this.lastSaveorLoadLocation = this.nullFile;
                this.maps = new GameMaps(this);
                this.contentScroll.remove(this.maps.getCurrentMap());
                this.remove(this.rightPanel);
                this.contentScroll.remove(this.maps.getCurrentMap());
                this.contentScroll.add(this.maps.getCurrentMap());
                this.contentScroll.setViewportView(this.maps.getCurrentMap());
                this.contentScroll.setEnabled(true);
                this.contentScroll.setVisible(true);
                this.add((Component)this.contentScroll, "Center");
                this.rightPanel = new RightPanel(this);
                this.add((Component)this.rightPanel, "East");
                this.updatePreferredSizes();
            }
        }
    }

    private JRibbonBand getEventConfigBand() throws MalformedURLException {
        JRibbonBand eventConfigShapeBand = new JRibbonBand("Event Creation", this.makeIcon("icons/thunder.png"));
        this.conditional = new JCheckBox("Conditional Events");
        JRibbonComponent conditionalWrapper = new JRibbonComponent(this.conditional);
        eventConfigShapeBand.addRibbonComponent(conditionalWrapper);
        this.conditional.addActionListener(this);
        return eventConfigShapeBand;
    }

    private JRibbonBand getEventShapeBand() throws MalformedURLException {
        this.eventShapeBand = new JRibbonBand("Event Shape", this.makeIcon("icons/thunder.png"));
        ResizableIcon SquareIcon = this.makeIcon("icons/square.png");
        ResizableIcon circleIcon = this.makeIcon("icons/circle.png");
        ResizableIcon areaIcon = this.makeIcon("icons/area.png");
        this.squareButton = new JCommandToggleButton("Square", SquareIcon);
        this.circleButton = new JCommandToggleButton("circle", circleIcon);
        this.areaButton = new JCommandToggleButton("Area", areaIcon);
        this.squareButton.addActionListener(this);
        this.squareButton.setActionCommand("SQUARE_EVENTSHAPE");
        this.circleButton.addActionListener(this);
        this.circleButton.setActionCommand("CIRCLE_EVENTSHAPE");
        this.areaButton.addActionListener(this);
        this.areaButton.setActionCommand("AREA_EVENTSHAPE");
        HashMap<RibbonElementPriority, Integer> buttonCount = new HashMap<RibbonElementPriority, Integer>();
        buttonCount.put(RibbonElementPriority.LOW, 2);
        buttonCount.put(RibbonElementPriority.MEDIUM, 3);
        buttonCount.put(RibbonElementPriority.TOP, 3);
        ArrayList<JCommandToggleButton> galleryButtonsList = new ArrayList<JCommandToggleButton>();
        galleryButtonsList.add(this.areaButton);
        galleryButtonsList.add(this.squareButton);
        galleryButtonsList.add(this.circleButton);
        ArrayList<StringValuePair<List<JCommandToggleButton>>> galleryButtons = new ArrayList<StringValuePair<List<JCommandToggleButton>>>();
        galleryButtons.add(new StringValuePair(null, galleryButtonsList));
        this.eventShapeBand.addRibbonGallery("Event Shapes", galleryButtons, buttonCount, 3, 3, RibbonElementPriority.MEDIUM);
        this.eventShapeBand.setSelectedRibbonGalleryButton("Event Shapes", this.areaButton);
        return this.eventShapeBand;
    }

    public void deselectEventButtons() {
        this.messageButton.getActionModel().setSelected(false);
        this.teleportButton.getActionModel().setSelected(false);
        this.variableButton.getActionModel().setSelected(false);
    }

    private JRibbonBand getEventsBand() throws MalformedURLException {
        JRibbonBand transitionBand = new JRibbonBand("Events", this.makeIcon("icons/thunder.png"));
        ResizableIcon bubbleIcon = this.makeIcon("icons/bubble.png");
        ResizableIcon keyIcon = this.makeIcon("icons/threeballs4.png");
        ResizableIcon teleportIcon = this.makeIcon("icons/thunder.png");
        this.messageButton = new JCommandToggleButton("Message", bubbleIcon);
        this.messageButton.addActionListener(this);
        this.messageButton.setActionCommand("Message_Event");
        this.teleportButton = new JCommandToggleButton("Teleport", teleportIcon);
        this.teleportButton.addActionListener(this);
        this.teleportButton.setActionCommand("Message_Teleport");
        this.variableButton = new JCommandToggleButton("Variable", keyIcon);
        this.variableButton.addActionListener(this);
        this.variableButton.setActionCommand("Variable_Event");
        HashMap<RibbonElementPriority, Integer> buttonCount = new HashMap<RibbonElementPriority, Integer>();
        buttonCount.put(RibbonElementPriority.LOW, 1);
        buttonCount.put(RibbonElementPriority.MEDIUM, 2);
        buttonCount.put(RibbonElementPriority.TOP, 3);
        ArrayList<JCommandToggleButton> galleryButtonsList = new ArrayList<JCommandToggleButton>();
        galleryButtonsList.add(this.messageButton);
        galleryButtonsList.add(this.variableButton);
        galleryButtonsList.add(this.teleportButton);
        ArrayList<StringValuePair<List<JCommandToggleButton>>> galleryButtons = new ArrayList<StringValuePair<List<JCommandToggleButton>>>();
        galleryButtons.add(new StringValuePair(null, galleryButtonsList));
        transitionBand.addRibbonGallery("Transitions", galleryButtons, buttonCount, 6, 4, RibbonElementPriority.MEDIUM);
        return transitionBand;
    }

    private JRibbonBand getMapEditBand() throws MalformedURLException {
        ResizableIcon musicIcon = this.makeIcon("icons/music.png");
        ResizableIcon locationIcon = this.makeIcon("icons/location.png");
        ResizableIcon bgImageIcon = this.makeIcon("icons/bgimage.png");
        JRibbonBand mapTools = new JRibbonBand("Map Tools", locationIcon);
        JCommandButton addForegroundImage = new JCommandButton("Add Foreground", bgImageIcon);
        addForegroundImage.setActionCommand("AddForeground");
        addForegroundImage.addActionListener(this);
        JCommandButton setDefaultLocation = new JCommandButton("Default Location", locationIcon);
        setDefaultLocation.setActionCommand("DefaultLocation");
        setDefaultLocation.addActionListener(this);
        JCommandButton setBackgroundImage = new JCommandButton("Background Image", bgImageIcon);
        setBackgroundImage.setActionCommand("Background");
        setBackgroundImage.addActionListener(this);
        mapTools.addCommandButton(addForegroundImage, RibbonElementPriority.LOW);
        mapTools.addCommandButton(setDefaultLocation, RibbonElementPriority.LOW);
        mapTools.addCommandButton(setBackgroundImage, RibbonElementPriority.LOW);
        return mapTools;
    }

    private JRibbonBand getCommonToolsBand() throws MalformedURLException {
        ResizableIcon saveIcon = this.makeIcon("icons/save.png");
        ResizableIcon saveAsIcon = this.makeIcon("icons/saveas.png");
        ResizableIcon loadIcon = this.makeIcon("icons/load2.png");
        ResizableIcon newProjectIcon = this.makeIcon("icons/newproject.png");
        ResizableIcon newMapIcon = this.makeIcon("icons/newMap.png");
        ResizableIcon deleteIcon = this.makeIcon("icons/delete.png");
        ResizableIcon playIcon = this.makeIcon("icons/play_1.png");
        JCommandButton newMapButton = new JCommandButton("New Map", newMapIcon);
        newMapButton.setActionCommand("Add New Map");
        newMapButton.addActionListener(this);
        JCommandButton saveGameIcon = new JCommandButton("Save", saveIcon);
        saveGameIcon.setActionCommand("Save Game");
        saveGameIcon.addActionListener(this);
        JCommandButton saveAsGameIcon = new JCommandButton("Save As", saveAsIcon);
        saveAsGameIcon.setActionCommand("Save Game As");
        saveAsGameIcon.addActionListener(this);
        JCommandButton loadGameIcon = new JCommandButton("Load", loadIcon);
        loadGameIcon.setActionCommand("Load Game");
        loadGameIcon.addActionListener(this);
        JCommandButton testPlay = new JCommandButton("Test Play", playIcon);
        testPlay.setActionCommand("Test Play");
        testPlay.addActionListener(this);
        JCommandButton newGame = new JCommandButton("New Game", newProjectIcon);
        newGame.setActionCommand("New Game");
        newGame.addActionListener(this);
        JCommandButton deleteMap = new JCommandButton("Delete Map", deleteIcon);
        deleteMap.setActionCommand("Delete Map");
        deleteMap.addActionListener(this);
        JRibbonBand commonTools = new JRibbonBand("Common Tools", newProjectIcon);
        commonTools.addCommandButton(saveGameIcon, RibbonElementPriority.MEDIUM);
        commonTools.addCommandButton(saveAsGameIcon, RibbonElementPriority.MEDIUM);
        commonTools.addCommandButton(loadGameIcon, RibbonElementPriority.MEDIUM);
        commonTools.addCommandButton(newGame, RibbonElementPriority.MEDIUM);
        commonTools.addCommandButton(newMapButton, RibbonElementPriority.MEDIUM);
        commonTools.addCommandButton(deleteMap, RibbonElementPriority.MEDIUM);
        commonTools.addCommandButton(testPlay, RibbonElementPriority.MEDIUM);
        return commonTools;
    }

    private JRibbonBand getZoomBand() throws MalformedURLException {
        ResizableIcon zoomIcon = this.makeIcon("icons/zoom.png");
        ResizableIcon zoomIconSmall = this.makeIcon("icons/zoom.png");
        JRibbonBand zoomBand = new JRibbonBand("Zoom", zoomIcon);
        JCommandButton formatButton = new JCommandButton("Zoom", zoomIcon);
        zoomBand.addCommandButton(formatButton, RibbonElementPriority.TOP);
        zoomBand.addCommandButton(new JCommandButton("100%", zoomIconSmall), RibbonElementPriority.MEDIUM);
        zoomBand.addCommandButton(new JCommandButton("200%", zoomIconSmall), RibbonElementPriority.MEDIUM);
        zoomBand.addCommandButton(new JCommandButton("400%", zoomIconSmall), RibbonElementPriority.MEDIUM);
        zoomBand.setResizePolicies(CoreRibbonResizePolicies.getCorePoliciesRestrictive(zoomBand));
        return zoomBand;
    }

    private JRibbonBand getPlayBand() throws MalformedURLException {
        ResizableIcon playIcon = this.makeIcon("icons/play_1.png");
        ResizableIcon buildIcon = this.makeIcon("icons/build2.png");
        JCommandButton testPlay = new JCommandButton("Test Play", playIcon);
        JRibbonBand playBand = new JRibbonBand("Build Tools", playIcon);
        playBand.addCommandButton(testPlay, RibbonElementPriority.MEDIUM);
        testPlay.addActionListener(this);
        playBand.addCommandButton(new JCommandButton("Make Game", buildIcon), RibbonElementPriority.MEDIUM);
        playBand.setResizePolicies(CoreRibbonResizePolicies.getCorePoliciesRestrictive(playBand));
        return playBand;
    }

    protected void configureTaskBar() throws MalformedURLException {
        ResizableIcon saveasIcon = this.makeIcon("icons/saveas.png");
        ResizableIcon saveIcon = this.makeIcon("icons/save.png");
        ResizableIcon loadIcon = this.makeIcon("icons/load2.png");
        ResizableIcon testPlayIcon = this.makeIcon("icons/play_1.png");
        ResizableIcon finishJobIcon = this.makeIcon("icons/tick.png");
        JCommandButton taskbarButtonSaveAs = new JCommandButton("", saveasIcon);
        taskbarButtonSaveAs.setActionCommand("Save Game As");
        taskbarButtonSaveAs.addActionListener(this);
        JCommandButton taskbarButtonSave = new JCommandButton("", saveIcon);
        taskbarButtonSave.setActionCommand("Save Game");
        taskbarButtonSave.addActionListener(this);
        JCommandButton taskbarButtonLoad = new JCommandButton("", loadIcon);
        taskbarButtonLoad.setActionCommand("Load Game");
        taskbarButtonLoad.addActionListener(this);
        JCommandButton taskbarButtonTestPlay = new JCommandButton("", testPlayIcon);
        taskbarButtonTestPlay.setActionCommand("Test Play");
        taskbarButtonTestPlay.addActionListener(this);
        JCommandButton taskbarfinishJob = new JCommandButton("", finishJobIcon);
        taskbarfinishJob.setActionCommand("Done Editing");
        taskbarfinishJob.addActionListener(this);
        this.getRibbon().addTaskbarComponent(taskbarButtonSave);
        this.getRibbon().addTaskbarComponent(taskbarButtonSaveAs);
        this.getRibbon().addTaskbarComponent(taskbarButtonLoad);
        this.getRibbon().addTaskbarComponent(new JSeparator(1));
        this.getRibbon().addTaskbarComponent(taskbarButtonTestPlay);
        this.getRibbon().addTaskbarComponent(new JSeparator(1));
        this.getRibbon().addTaskbarComponent(taskbarfinishJob);
    }

    private JRibbonBand getLayerBand() throws MalformedURLException {
        ResizableIcon layersIcon = this.makeIcon("icons/layers.png");
        ResizableIcon walkoverIcon = this.makeIcon("icons/Wo.png");
        ResizableIcon backgroundIcon = this.makeIcon("icons/Bg.png");
        ResizableIcon eventIcon = this.makeIcon("icons/Ev.png");
        ResizableIcon foregroundIcon = this.makeIcon("icons/Fg.png");
        ResizableIcon PerspectiveIcon = this.makeIcon("icons/Pe.png");
        ResizableIcon finishJobIcon = this.makeIcon("icons/tick.png");
        JCommandButton walkOverButton = new JCommandButton("Walk-Over", walkoverIcon);
        walkOverButton.addActionListener(this);
        JCommandButton backgroundLayerButton = new JCommandButton("Background", backgroundIcon);
        backgroundLayerButton.addActionListener(this);
        JCommandButton eventLayerButton = new JCommandButton("Event", eventIcon);
        eventLayerButton.addActionListener(this);
        JCommandButton foregroundButton = new JCommandButton("Foreground", foregroundIcon);
        foregroundButton.setActionCommand("EditForeground");
        foregroundButton.addActionListener(this);
        JCommandButton perspectiveButton = new JCommandButton("Perspective", PerspectiveIcon);
        perspectiveButton.setActionCommand("Edit Perspective");
        perspectiveButton.addActionListener(this);
        JCommandButton taskbarfinishJob = new JCommandButton("Finish Current Edit", finishJobIcon);
        taskbarfinishJob.setActionCommand("Done Editing");
        taskbarfinishJob.addActionListener(this);
        JRibbonBand layerBand = new JRibbonBand("Layer To Edit", layersIcon);
        layerBand.addCommandButton(foregroundButton, RibbonElementPriority.MEDIUM);
        layerBand.addCommandButton(eventLayerButton, RibbonElementPriority.MEDIUM);
        layerBand.addCommandButton(perspectiveButton, RibbonElementPriority.MEDIUM);
        layerBand.addCommandButton(walkOverButton, RibbonElementPriority.MEDIUM);
        layerBand.addCommandButton(backgroundLayerButton, RibbonElementPriority.MEDIUM);
        layerBand.addCommandButton(taskbarfinishJob, RibbonElementPriority.MEDIUM);
        layerBand.setResizePolicies(CoreRibbonResizePolicies.getCorePoliciesRestrictive(layerBand));
        return layerBand;
    }

    private ResizableIcon makeIcon(String iconLocation) throws MalformedURLException {
        return this.makeIcon(this.getClass().getResource(iconLocation));
    }

    private ResizableIcon makeIcon(URL location) throws MalformedURLException {
        Dimension initialDim = new Dimension(150, 150);
        return ImageWrapperResizableIcon.getIcon(location, initialDim);
    }

    public boolean saveGame(String location) throws IOException, JDOMException {
        return this.saveGame(new File(location));
    }

    public boolean saveGame() throws IOException, JDOMException {
        block5: {
            block4: {
                JFileChooser jfc = new JFileChooser();
                jfc.setSelectedFile(new File(FileHandler.getFilesLocation() + File.separator + "files"));
                jfc.setDialogTitle("Please select a save location");
                jfc.setSelectedFile(new File("mygame.game"));
                jfc.setFileFilter(new MyFileFilter("game", "Game Files (.game)"));
                int result = jfc.showDialog(this, "Save");
                File f = jfc.getSelectedFile();
                if (result == 0) {
                    this.saveGame(f);
                    this.lastSaveorLoadLocation = f;
                    return true;
                }
                if (result == 1) break block4;
                if (result != -1) break block5;
            }
            System.out.println("Save was not competed.");
            return false;
        }
        return true;
    }

    public boolean saveGame(File location) throws IOException, JDOMException {
        String fileExtension = "canceledfileselection";
        if (location != null) {
            fileExtension = FileHandler.getFileExtension(location).toLowerCase();
        }
        if (fileExtension.equals("canceledfileselection")) {
            return false;
        }
        String s = this.maps.toXML();
        SAXBuilder builder = new SAXBuilder(false);
        Document document = builder.build((Reader)new StringReader(s));
        FileHandler.deleteDirectory(FileHandler.getFilesLocation() + "gamesave" + File.separator);
        FileHandler.createDefaultSaveDirectories();
        this.maps.saveImages();
        XMLOutputter x = new XMLOutputter();
        x.setFormat(Format.getPrettyFormat());
        FileWriter fileWrite = new FileWriter(FileHandler.getFilesLocation() + "gamesave" + File.separator + "gamesave.xml");
        BufferedWriter buffWrite = new BufferedWriter(fileWrite);
        x.output(document, (Writer)buffWrite);
        FileHandler.zipDir(FileHandler.getFilesLocation() + "gamesave", location.getAbsolutePath());
        fileWrite.close();
        buffWrite.close();
        this.lastSaveorLoadLocation = location;
        return true;
    }

    public void repaint() {
        super.repaint();
        if (this.contentScroll != null) {
            this.contentScroll.setViewportView(this.maps.getCurrentMap());
            this.contentScroll.repaint();
        }
    }

    public void loadGameFileIntoPlayFrame(String fileLocation, PlayFrame playFrame) throws IOException, JDOMException, GameXmlIncorrectException {
        FileHandler.deleteDirectory(FileHandler.getFilesLocation() + "gamesave/");
        FileHandler.createDefaultSaveDirectories();
        FileHandler.unzipDir(fileLocation, FileHandler.getFilesLocation() + "gamesave");
        SAXBuilder builder = new SAXBuilder(false);
        Document document = builder.build(FileHandler.getFilesLocation() + "gamesave/gamesave.xml");
        Element gameElement = document.getRootElement();
        GameMaps newMaps = new GameMaps(playFrame);
        newMaps.fromXML(gameElement);
        newMaps.setPlayMode();
        newMaps.setCurrentMap(newMaps.getSprite().getCurrentMap());
        playFrame.setUpPlayFrame(newMaps);
        newMaps.setMapsContainer(playFrame);
        newMaps.getSprite().toString();
    }

    public void loadGameFile(String fileLocation) throws IOException, JDOMException, GameXmlIncorrectException {
        FileHandler.deleteDirectory(FileHandler.getFilesLocation() + "gamesave" + File.separator);
        FileHandler.createDefaultSaveDirectories();
        FileHandler.unzipDir(fileLocation, FileHandler.getFilesLocation() + "gamesave");
        SAXBuilder builder = new SAXBuilder(false);
        Document document = builder.build(FileHandler.getFilesLocation() + "gamesave" + File.separator + "gamesave.xml");
        Element game = document.getRootElement();
        GameMaps temp = this.maps;
        this.maps = new GameMaps(this);
        this.maps.fromXML(game);
        this.contentScroll.remove(temp.getCurrentMap());
        this.contentScroll.add(this.maps.getCurrentMap());
        this.contentScroll.setViewportView(this.maps.getCurrentMap());
        this.maps.repaint();
        this.remove(this.rightPanel);
        this.rightPanel = new RightPanel(this);
        this.add((Component)this.rightPanel, "East");
        this.updatePreferredSizes();
        this.lastSaveorLoadLocation = new File(fileLocation);
    }

    public void actionPerformed(ActionEvent e) {
        block79: {
            if (e.getActionCommand().equals("New Game")) {
                try {
                    this.newGame();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                catch (JDOMException jdome) {
                    jdome.printStackTrace();
                }
            } else if (e.getActionCommand().equals("Delete Map")) {
                int reply = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete the current map?\nAll events referencing it will also be deleted.");
                if (reply == 0) {
                    if (this.maps.size() >= 2) {
                        this.maps.removeCurrentMap();
                        this.rightPanel.updatePanelData();
                        this.rightPanel.repaint();
                        this.repaint();
                    } else {
                        JOptionPane.showMessageDialog(this, "You can not delete the last remaining map.\nPlease add a new map first.");
                    }
                }
            } else if (e.getActionCommand().equals("Done Editing")) {
                this.maps.getCurrentMap().setIdle();
            } else if (e.getActionCommand().equals("Conditional Events")) {
                if (this.conditional.isSelected()) {
                    this.maps.setEventsConditional(true);
                } else {
                    this.maps.setEventsConditional(false);
                }
            }
            if (e.getActionCommand().equals("Load Game")) {
                try {
                    JFileChooser jfc = new JFileChooser();
                    jfc.setSelectedFile(new File(FileHandler.getFilesLocation() + File.separator + "files"));
                    jfc.setFileFilter(new MyFileFilter("game", "Game Files (.game)"));
                    jfc.showOpenDialog(jfc);
                    File f = jfc.getSelectedFile();
                    String fileExtension = "canceledfileselection";
                    if (f != null) {
                        fileExtension = FileHandler.getFileExtension(f).toLowerCase();
                    }
                    if (fileExtension.equals("canceledfileselection")) break block79;
                    if (!fileExtension.equals("game")) {
                        System.out.println("You must load a file of type .game");
                        JOptionPane.showMessageDialog(this, "You must load a file of type .game");
                        break block79;
                    }
                    this.loadGameFile(f.getAbsolutePath());
                    this.lastSaveorLoadLocation = jfc.getSelectedFile();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Error loading the game file.");
                }
                catch (JDOMException jdome) {
                    jdome.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Error with the game XML formatting.");
                }
                catch (GameXmlIncorrectException gxie) {
                    gxie.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Error with the game XML formatting.");
                }
            } else if (e.getActionCommand().equals("Save Game As")) {
                if (this.maps.getCurrentMap().getCurrentTask() == 0) {
                    try {
                        this.saveGame();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        JOptionPane.showMessageDialog(this, "Error saving the game file.");
                    }
                    catch (JDOMException jdome) {
                        jdome.printStackTrace();
                        JOptionPane.showMessageDialog(this, "Error with the game XML formatting.");
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "Finish what you are doing first");
                }
            } else if (e.getActionCommand().equals("Save Game")) {
                if (this.maps.getCurrentMap().getCurrentTask() == 0) {
                    try {
                        if (this.lastSaveorLoadLocation.equals(this.nullFile)) {
                            this.saveGame();
                            break block79;
                        }
                        this.saveGame(this.lastSaveorLoadLocation);
                        System.out.println("save in last location");
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        JOptionPane.showMessageDialog(this, "Error saving the game file.");
                    }
                    catch (JDOMException jdome) {
                        jdome.printStackTrace();
                        JOptionPane.showMessageDialog(this, "Error with the game XML formatting.");
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "Finish what you are doing first");
                }
            } else if (e.getActionCommand().equals("Walk-Over")) {
                this.maps.getCurrentMap().editWalkable();
            } else if (e.getActionCommand().equals("Background Music")) {
                try {
                    URL musicURL = this.getMusicURL();
                    this.maps.getCurrentMap().setMusic(musicURL);
                }
                catch (MalformedURLException mue) {
                    System.err.println("url or file incorrect");
                    JOptionPane.showMessageDialog(this, "URL or File Incorrect.");
                }
            } else if (e.getActionCommand().equals("DefaultLocation")) {
                this.maps.getCurrentMap().setStartLocation();
            } else if (e.getActionCommand().equals("Test Play")) {
                if (this.maps.getCurrentMap().getCurrentTask() == 0) {
                    this.maps.setCurrentMap(this.maps.getSprite().getCurrentMap());
                    File tempGame = new File(FileHandler.getFilesLocation() + "testplay.game");
                    try {
                        File temp = this.lastSaveorLoadLocation;
                        this.saveGame(tempGame);
                        this.loadGameFile(tempGame.getAbsolutePath());
                        PlayFrame testPlay = new PlayFrame();
                        this.loadGameFileIntoPlayFrame(tempGame.getAbsolutePath(), testPlay);
                        this.setVisible(false);
                        testPlay.setRibbon(this);
                        this.conditional.setSelected(false);
                        this.areaButton.getActionModel().setSelected(true);
                        this.lastSaveorLoadLocation = temp;
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        JOptionPane.showMessageDialog(this, "Error saving the game file for test play.");
                    }
                    catch (JDOMException jdome) {
                        jdome.printStackTrace();
                        JOptionPane.showMessageDialog(this, "Error in the games XML.");
                    }
                    catch (GameXmlIncorrectException gxie) {
                        gxie.printStackTrace();
                        JOptionPane.showMessageDialog(this, "Error in the games XML.");
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "Finish what you are doing first");
                }
            } else if (e.getActionCommand().equals("Edit Perspective")) {
                this.maps.getCurrentMap().editPerspective();
            } else if (e.getActionCommand().equals("Add New Map")) {
                int shape = this.maps.getCurrentMap().getEventCreatorShape();
                this.maps.getCurrentMap().setIdle();
                this.contentScroll.remove(this.maps.getCurrentMap());
                this.maps.addNewMap();
                this.contentScroll.add(this.maps.getCurrentMap());
                this.rightPanel.updatePanelData();
                this.rightPanel.repaint();
                this.repaint();
                this.maps.getCurrentMap().setEventCreatorShape(shape);
                this.messageButton.getActionModel().setSelected(false);
                this.teleportButton.getActionModel().setSelected(false);
                this.variableButton.getActionModel().setSelected(false);
            } else if (e.getActionCommand().equals("EditForeground")) {
                this.maps.getCurrentMap().editForeground();
            } else if (e.getActionCommand().equals("AddForeground")) {
                this.maps.getCurrentMap().addForeground();
            } else if (e.getActionCommand().equals("Background")) {
                this.maps.getCurrentMap().setBackgroundImage();
                this.rightPanel.updatePanelData();
                this.rightPanel.repaint();
            } else if (e.getActionCommand().equals("Message_Teleport")) {
                this.maps.getCurrentMap().editEvents();
                GameMap gameMap = this.maps.getCurrentMap();
                this.maps.getCurrentMap();
                gameMap.setEventCreator(2);
            } else if (e.getActionCommand().equals("Variable_Event")) {
                int n = this.maps.getCurrentMap().getEventCreator();
                this.maps.getCurrentMap();
                if (n != 3) {
                    this.maps.getCurrentMap().setCurrentTask(0);
                }
                this.maps.getCurrentMap().editEvents();
                GameMap gameMap = this.maps.getCurrentMap();
                this.maps.getCurrentMap();
                gameMap.setEventCreator(3);
            } else if (e.getActionCommand().equals("Message_Event")) {
                int n = this.maps.getCurrentMap().getEventCreator();
                this.maps.getCurrentMap();
                if (n != 1) {
                    this.maps.getCurrentMap().setCurrentTask(0);
                }
                this.maps.getCurrentMap().editEvents();
                GameMap gameMap = this.maps.getCurrentMap();
                this.maps.getCurrentMap();
                gameMap.setEventCreator(1);
            } else if (e.getActionCommand().equals("SQUARE_EVENTSHAPE")) {
                GameMap gameMap = this.maps.getCurrentMap();
                this.maps.getCurrentMap().getClass();
                gameMap.setEventCreatorShape(1);
                this.squareButton.getActionModel().setSelected(true);
            } else if (e.getActionCommand().equals("CIRCLE_EVENTSHAPE")) {
                this.maps.getCurrentMap().setEventCreatorShape(this.maps.getCurrentMap().SHAPE_CIRCLE);
                this.circleButton.getActionModel().setSelected(true);
            } else if (e.getActionCommand().equals("AREA_EVENTSHAPE")) {
                this.maps.getCurrentMap().setEventCreatorShape(this.maps.getCurrentMap().SHAPE_AREA);
                this.areaButton.getActionModel().setSelected(true);
            } else if (e.getActionCommand().equals("Event")) {
                this.maps.getCurrentMap().editEvents();
            }
        }
    }

    public void setCursorCrosshair() {
        Cursor hourglassCursor = new Cursor(1);
        this.setCursor(hourglassCursor);
    }

    public void setCursorNormal() {
        Cursor normalCursor = new Cursor(0);
        this.setCursor(normalCursor);
        this.deselectEventButtons();
    }

    public void paintComponent(Graphics g) {
        int height = (int)this.getSize().getHeight() - this.getRibbonHeight();
        int width = (int)this.getSize().getWidth() - 100;
        this.contentScroll.setPreferredSize(new Dimension(width, height));
    }

    public URL getMusicURL() throws MalformedURLException {
        URL theURL = null;
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            theURL = new URL("file://" + chooser.getSelectedFile().getPath());
        }
        return theURL;
    }

    public ImageWithDetails getImageChooser() throws ImageNotSelectedException, IOException {
        JFileChooser chooser = new JFileChooser();
        chooser.setSelectedFile(new File(FileHandler.getFilesLocation() + File.separator + "files"));
        MyFileFilter filter = new MyFileFilter();
        chooser.setFileFilter(filter);
        BufferedImage theImage = null;
        ImageWithDetails theImageWithDetails = null;
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            theImage = ImageIO.read(chooser.getSelectedFile());
            theImageWithDetails = new ImageWithDetails(theImage);
            theImageWithDetails.setFileName(chooser.getSelectedFile().getName());
        }
        return theImageWithDetails;
    }

    public String toString() {
        return "Ribbon";
    }
}

