/*
 * Decompiled with CFR 0.152.
 */
package gamemaker.Player;

import gamemaker.Coordinate;
import gamemaker.Exceptions.ImageNotSelectedException;
import gamemaker.Exceptions.PanelNotPassedException;
import gamemaker.GameMaps;
import gamemaker.ImageWithDetails;
import gamemaker.MapsContainer;
import gamemaker.Player.MovementThread;
import gamemaker.Player.RepaintThread;
import gamemaker.Ribbon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JFrame;

public class PlayFrame
extends JFrame
implements MapsContainer,
WindowListener,
KeyListener {
    private Ribbon passingRibbon;
    private GameMaps maps;
    private MovementThread movementHandler;
    private RepaintThread repaintHandler;
    private Clip audioClip;
    AudioInputStream ais;
    private final int UP = 0;
    private final int RIGHT = 1;
    private final int DOWN = 2;
    private final int LEFT = 3;
    private boolean[] keypressed = new boolean[4];
    private GraphicsDevice graphicsDevice;
    private final int WIDTH = 1024;
    private final int HEIGHT = 768;
    private int width = 500;
    public DisplayMode previousDisplayMode;
    public boolean fullscreenModeSet = false;

    public String getContainterType() {
        return "playframe";
    }

    public PlayFrame() {
        this.setSize(1024, 768);
        this.setVisible(true);
        this.setMinimumSize(new Dimension(640, 480));
        this.setTitle("Play Game");
    }

    public void setUpPlayFrame() {
        this.setUpPlayFrame(this.maps);
    }

    public void setUpPlayFrame(GameMaps maps) {
        this.graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.previousDisplayMode = this.graphicsDevice.getDisplayMode();
        this.setLocationRelativeTo(null);
        this.addWindowListener(this);
        this.addKeyListener(this);
        System.out.println("ok");
        maps.setPlayMode();
        maps.setMapsContainer(this);
        this.maps = maps;
        this.setTitle("Play Game");
        this.add((Component)maps.getPaintPanel(), "Center");
        this.movementHandler = new MovementThread(maps.getSprite().getCurrentGameMap());
        this.repaintHandler = new RepaintThread(this);
        this.movementHandler.setMoveSpeed((int)maps.getCurrentMap().getSpritePanel().getSprite().getSpriteSpeed());
        this.movementHandler.start();
        this.repaintHandler.start();
        this.setBackground(Color.black);
        this.repaint();
    }

    public void setMusic(URL url) throws IOException, LineUnavailableException, UnsupportedAudioFileException {
        this.audioClip = AudioSystem.getClip();
        URL clipURL = new URL("file://C:/WINDOWS/Media/CHIMES.wav");
        this.ais = AudioSystem.getAudioInputStream(clipURL);
    }

    public void stopMusic() {
        this.audioClip.stop();
    }

    public void changeMusic(URL url) throws IOException, LineUnavailableException, UnsupportedAudioFileException {
        this.audioClip.stop();
        this.setMusic(url);
        this.playMusic();
    }

    public void playMusic() throws LineUnavailableException, IOException {
        this.audioClip.open(this.ais);
        this.audioClip.start();
    }

    public void setFocusOnSprite() {
        this.setFocusOnSprite(this.maps.getSprite().getSpritePositionCoord());
    }

    public void setFocusOnSprite(Coordinate c) {
        this.maps.getPaintPanel().repaint();
    }

    public void setRibbon(Ribbon r) {
        this.passingRibbon = r;
    }

    public void repaint() {
        super.repaint();
        if (this.maps != null) {
            if (this.maps.isPaintPanelSet()) {
                this.maps.getPaintPanel().repaint();
            }
            if (this.maps.getCurrentMap() != null && this.movementHandler != null) {
                this.movementHandler.setMap(this.maps.getCurrentMap());
            }
        }
    }

    public void setCursorCrosshair() {
        Cursor hourglassCursor = new Cursor(1);
        this.setCursor(hourglassCursor);
    }

    public void setCursorNormal() {
        Cursor normalCursor = new Cursor(0);
        this.setCursor(normalCursor);
    }

    public ImageWithDetails getImageChooser() throws ImageNotSelectedException, IOException {
        return null;
    }

    public void windowClosing(WindowEvent w) {
        if (this.passingRibbon != null) {
            this.passingRibbon.setVisible(true);
            this.passingRibbon.repaint();
        }
        this.movementHandler.endThread();
        this.repaintHandler.endThread();
        this.setVisible(false);
        this.dispose();
    }

    public void keyTyped(KeyEvent e) {
    }

    /*
     * Unable to fully structure code
     */
    public void keyPressed(KeyEvent e) {
        block13: {
            block14: {
                block12: {
                    setMove = false;
                    if (e.getKeyCode() != 16) break block12;
                    this.movementHandler.setMoveFast();
                    break block13;
                }
                if (e.getKeyCode() != 49) break block14;
                this.setExtendedState(6);
                break block13;
            }
            if (e.getKeyCode() == 10) ** GOTO lbl-1000
            if (e.getKeyCode() == 32) lbl-1000:
            // 2 sources

            {
                try {
                    this.maps.getCurrentMap().action();
                    this.maps.getPaintPanel().updateUI();
                    this.maps.getPaintPanel().repaint();
                    this.maps.getPaintPanel().updateImage();
                }
                catch (PanelNotPassedException pnpe) {
                    System.err.println(pnpe);
                }
            } else if (e.getKeyCode() == 38) {
                this.keypressed[0] = true;
                setMove = true;
            } else if (e.getKeyCode() == 40) {
                this.keypressed[2] = true;
                setMove = true;
            } else if (e.getKeyCode() == 37) {
                this.keypressed[3] = true;
                setMove = true;
            } else if (e.getKeyCode() == 39) {
                this.keypressed[1] = true;
                setMove = true;
            }
        }
        this.updateDirection();
        if (setMove) {
            this.movementHandler.setMove(true);
        }
    }

    private void updateDirection() {
        if (this.keypressed[0]) {
            if (this.keypressed[1]) {
                this.movementHandler.setDirection(this.movementHandler.DIRECTION_NE);
            } else if (this.keypressed[3]) {
                this.movementHandler.setDirection(this.movementHandler.DIRECTION_NW);
            } else {
                this.movementHandler.setDirection(this.movementHandler.DIRECTION_N);
            }
        } else if (this.keypressed[2]) {
            if (this.keypressed[1]) {
                this.movementHandler.setDirection(this.movementHandler.DIRECTION_SE);
            } else if (this.keypressed[3]) {
                this.movementHandler.setDirection(this.movementHandler.DIRECTION_SW);
            } else {
                this.movementHandler.setDirection(this.movementHandler.DIRECTION_S);
            }
        } else if (this.keypressed[3]) {
            if (this.keypressed[0]) {
                this.movementHandler.setDirection(this.movementHandler.DIRECTION_NW);
            } else if (this.keypressed[2]) {
                this.movementHandler.setDirection(this.movementHandler.DIRECTION_SW);
            } else {
                this.movementHandler.setDirection(this.movementHandler.DIRECTION_W);
            }
        } else if (this.keypressed[1]) {
            if (this.keypressed[0]) {
                this.movementHandler.setDirection(this.movementHandler.DIRECTION_NE);
            } else if (this.keypressed[2]) {
                this.movementHandler.setDirection(this.movementHandler.DIRECTION_SE);
            } else {
                this.movementHandler.setDirection(this.movementHandler.DIRECTION_E);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            this.movementHandler.setMoveNormal();
        } else if (e.getKeyCode() == 27) {
            if (this.fullscreenModeSet) {
                this.setFullScreen(false);
            } else {
                if (this.passingRibbon != null) {
                    this.passingRibbon.setVisible(true);
                    this.passingRibbon.repaint();
                }
                this.setVisible(false);
                this.movementHandler.endThread();
                this.repaintHandler.endThread();
                this.dispose();
            }
        } else if (e.getKeyCode() == 122) {
            GraphicsConfiguration gc = this.graphicsDevice.getDefaultConfiguration();
            double ratio = gc.getBounds().getHeight() / gc.getBounds().getWidth();
            if (this.graphicsDevice.isFullScreenSupported()) {
                if (this.fullscreenModeSet) {
                    this.setFullScreen(false);
                } else {
                    this.setFullScreen(true);
                }
            }
        }
        if (e.getKeyCode() == 38) {
            this.keypressed[0] = false;
        } else if (e.getKeyCode() == 40) {
            this.keypressed[2] = false;
        } else if (e.getKeyCode() == 37) {
            this.keypressed[3] = false;
        } else if (e.getKeyCode() == 39) {
            this.keypressed[1] = false;
        }
        boolean stopMove = true;
        for (int i = 0; i < 4 && stopMove; ++i) {
            if (!this.keypressed[i]) continue;
            stopMove = false;
        }
        if (stopMove) {
            this.movementHandler.setMove(false);
            this.maps.getCurrentMap().getSpritePanel().repaint();
        } else {
            this.updateDirection();
        }
    }

    private void setFullScreen(Boolean set) {
        if (!set.booleanValue()) {
            this.removeNotify();
            this.setVisible(false);
            this.setUndecorated(false);
            this.setResizable(true);
            this.graphicsDevice.setFullScreenWindow(null);
            this.fullscreenModeSet = false;
            this.setSize(1024, 768);
            this.setPreferredSize(new Dimension(1024, 768));
            this.addNotify();
            this.setVisible(true);
        } else {
            DisplayMode mode = new DisplayMode(1024, 768, 32, 0);
            this.removeNotify();
            this.setVisible(false);
            this.setResizable(false);
            this.setUndecorated(true);
            this.graphicsDevice.setFullScreenWindow(this);
            this.graphicsDevice.setDisplayMode(mode);
            this.fullscreenModeSet = true;
            this.addNotify();
            this.setVisible(true);
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        this.movementHandler.endThread();
        this.repaintHandler.endThread();
        System.gc();
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public String toString() {
        return "Playframe";
    }
}

