/*
 * Decompiled with CFR 0.152.
 */
package gamemaker.Player;

import gamemaker.GameMap;
import gamemaker.Sprite;
import java.awt.Point;

public class MovementThread
extends Thread {
    private GameMap gameMap;
    private GameMap tempMap;
    private int counter = 0;
    private final int MOVE_NORM = 60;
    private final int MOVE_FAST = 200;
    private double moveSpeed = 60.0;
    private int switchSpeed = 3;
    private int framerate = 50;
    private boolean threadAlive = true;
    private boolean move = false;
    public final int oneSecond = 1000;
    public final int DIRECTION_N = 1;
    public final int DIRECTION_NE = 2;
    public final int DIRECTION_E = 3;
    public final int DIRECTION_SE = 4;
    public final int DIRECTION_S = 5;
    public final int DIRECTION_SW = 6;
    public final int DIRECTION_W = 7;
    public final int DIRECTION_NW = 8;
    private int currentDirection;
    private Point newPosition = new Point(0, 0);

    public void setMoveFast() {
        this.moveSpeed = 200.0;
        this.switchSpeed = 10;
    }

    public void setMoveNormal() {
        this.moveSpeed = 60.0;
        this.switchSpeed = 3;
    }

    public MovementThread(GameMap gameMap) {
        this.gameMap = gameMap;
        this.currentDirection = 5;
        this.tempMap = null;
    }

    public void setMap(GameMap newMap) {
        this.tempMap = newMap;
    }

    public void setMove(boolean canMove) {
        this.move = canMove;
    }

    public void setMoveSpeed(int speed) {
        this.moveSpeed = speed;
    }

    public void setDirection(int direction) {
        this.currentDirection = direction;
        Sprite s = this.gameMap.getSpritePanel().getSprite();
        if (this.currentDirection == 1) {
            s.setSpriteFacing(s.NORTH);
        } else if (this.currentDirection == 5) {
            s.setSpriteFacing(s.SOUTH);
        } else if (this.currentDirection == 3) {
            s.setSpriteFacing(s.EAST);
        } else if (this.currentDirection == 7) {
            s.setSpriteFacing(s.WEST);
        } else if (this.currentDirection == 2) {
            s.setSpriteFacing(s.NORTHEAST);
        } else if (this.currentDirection == 4) {
            s.setSpriteFacing(s.SOUTHEAST);
        } else if (this.currentDirection == 6) {
            s.setSpriteFacing(s.SOUTHWEST);
        } else if (this.currentDirection == 8) {
            s.setSpriteFacing(s.NORTHWEST);
        }
    }

    public void setSwitchSpeed(int speed) {
        this.switchSpeed = speed;
    }

    private void moveSpriteIncrement() {
        double x = this.gameMap.getSpritePanel().getSpritePosition().getX();
        double y = this.gameMap.getSpritePanel().getSpritePosition().getY();
        Point p = new Point();
        p.setLocation(x, y);
        Double currentPerspective = this.gameMap.getSpritePanel().getPerspective().getPerspectiveAt(p);
        Double newMoveSpeed = this.moveSpeed * currentPerspective;
        if (currentPerspective < 1.0) {
            newMoveSpeed = 1.0 / this.moveSpeed * (currentPerspective + 0.0);
        }
        double c = newMoveSpeed / ((double)this.framerate + 0.0);
        double edge = c * 0.6;
        double movedist = Math.round(newMoveSpeed / (double)this.framerate);
        if (movedist < 1.0) {
            movedist = this.moveSpeed == 200.0 ? 3.0 : 1.0;
        }
        if (edge < 1.0) {
            edge = this.moveSpeed == 200.0 ? 3.0 : 1.0;
        }
        if (this.currentDirection == 1) {
            y -= movedist;
        } else if (this.currentDirection == 5) {
            y += movedist;
        } else if (this.currentDirection == 3) {
            x += movedist;
        } else if (this.currentDirection == 7) {
            x -= movedist;
        } else if (this.currentDirection == 2) {
            y -= edge;
            x += edge;
        } else if (this.currentDirection == 4) {
            y += edge;
            x += edge;
        } else if (this.currentDirection == 6) {
            y += edge;
            x -= edge;
        } else if (this.currentDirection == 8) {
            y -= edge;
            x -= edge;
        } else {
            System.out.println("problem here");
        }
        this.newPosition = new Point();
        this.newPosition.setLocation(x, y);
        Boolean canMove = this.gameMap.getWalkableAreaPanel().isPointWithin(this.newPosition);
        if (canMove.booleanValue()) {
            this.gameMap.getSpritePanel().setSpritePosition(this.newPosition);
        }
    }

    private void stepHandler() {
        ++this.counter;
        if (this.counter >= this.framerate / this.switchSpeed) {
            this.gameMap.getSpritePanel().getSprite().takeStep();
            this.counter = 0;
        }
    }

    public void endThread() {
        this.threadAlive = false;
    }

    public void run() {
        boolean canStop = true;
        while (this.threadAlive) {
            this.wait(1000 / this.framerate);
            if (this.move && !this.gameMap.getDialoguePanel().isDialogueDisplayed()) {
                this.moveSpriteIncrement();
                this.stepHandler();
                this.gameMap.getSpritePanel().repaint();
                canStop = true;
            } else if (canStop && !this.gameMap.getDialoguePanel().isDialogueDisplayed()) {
                canStop = false;
                this.gameMap.getSpritePanel().getSprite().stopWalk();
                this.gameMap.getSpritePanel().repaint();
                this.counter = 32000000;
            }
            if (this.tempMap == null) continue;
            this.gameMap = this.tempMap;
            this.tempMap = null;
        }
    }

    public void wait(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

