/*
 * Decompiled with CFR 0.152.
 */
package gamemaker;

import java.awt.Dimension;
import java.awt.Point;

public class Perspective {
    private double frontPercentage;
    private double backPercentage;
    private double logicalHeight;
    private double top = 300.0;
    private final double standardSpriteWidth = 70.0;

    public Perspective() {
        this(0.6, 1.8);
    }

    public Perspective(double backPercentage, double frontPercentage) {
        this.backPercentage = backPercentage;
        this.frontPercentage = frontPercentage;
        this.logicalHeight = 600.0;
    }

    public double getStandardSpriteWidth() {
        return 70.0;
    }

    public void setDefaultPerspective() {
        this.backPercentage = 0.6;
        this.frontPercentage = 1.8;
    }

    public Dimension getPerspetiveDimensions(Dimension d, Point p) {
        double perspective = this.getPerspectiveAt(p);
        double widthRatio = (d.getHeight() + 0.0) / (d.getWidth() + 0.0);
        return new Dimension((int)(70.0 * perspective), (int)(70.0 * widthRatio * perspective));
    }

    public void setHorizon(int y) {
        this.top = y;
    }

    public double getHorizon() {
        return this.top;
    }

    public double getPerspectiveAt(Point p) {
        double position = p.getY() > 0.0 ? p.getY() : 0.0;
        position = p.getY() < this.logicalHeight ? p.getY() : this.logicalHeight;
        if (position < this.top) {
            return this.backPercentage;
        }
        double difference = Math.abs(this.frontPercentage - this.backPercentage);
        double positionAsPercentage = (position - this.top) / ((this.logicalHeight - this.top) / 100.0);
        difference = difference * positionAsPercentage / 100.0;
        double thePerspective = this.frontPercentage > this.backPercentage ? this.backPercentage + difference : this.backPercentage - difference;
        return thePerspective;
    }

    public void setLogicalHeight(double height) {
        this.logicalHeight = Math.abs(height);
    }

    public void setFrontPercentage(double frontPercentage) {
        this.frontPercentage = frontPercentage;
    }

    public double getFrontPercentage() {
        return this.frontPercentage;
    }

    public void setBackPercentage(double backPercentage) {
        this.backPercentage = backPercentage;
    }

    public double getBackPercentage() {
        return this.backPercentage;
    }

    public String toXML() {
        return this.toXML("", "");
    }

    public String toXML(String openTag, String closeTag) {
        String xml = "";
        xml = xml + openTag + "\n";
        xml = xml + "<perspective front=\"" + this.frontPercentage + "\" back=\"" + this.backPercentage + "\" horizon=\"" + this.top + "\" />";
        xml = xml + closeTag + "\n";
        return xml;
    }
}

