/*
 * Decompiled with CFR 0.152.
 */
package gamemaker.Panels;

import gamemaker.Coordinate;
import gamemaker.Exceptions.GameXmlIncorrectException;
import gamemaker.FileHandler;
import gamemaker.GameMap;
import gamemaker.ImageWithDetails;
import gamemaker.Panels.ForegroundItem;
import gamemaker.Panels.GamePanel;
import gamemaker.Panels.GlassPaneDrawer;
import gamemaker.Panels.XMLable;
import gamemaker.XMLSimplify;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.jdom.Element;

public class ForegroundPanel
extends GamePanel
implements XMLable,
GlassPaneDrawer {
    private ArrayList<ForegroundItem> items = new ArrayList(20);
    private GameMap gameMap;
    private int selectedItem = -1;
    private JPanel glassPanel;

    public ForegroundPanel(GameMap gameMap, JPanel glassPanel) {
        this.gameMap = gameMap;
        this.setOpaque(false);
        this.setLayout(null);
        this.glassPanel = glassPanel;
    }

    public void paintComponentTwo(Graphics g) {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            this.items.get(i).paintComponentTwo(g);
        }
    }

    public void saveImages(String location) throws IOException {
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).saveImage(location + "foreground-");
        }
    }

    public void addImage(Coordinate c, ImageWithDetails i) throws IOException {
        ForegroundItem newItem = new ForegroundItem(this.gameMap);
        newItem.setImage(c, i);
        this.items.add(newItem);
        this.add(newItem);
        this.repaint();
    }

    public void addImage(Coordinate c, String location) throws IOException {
        this.addImage(c, FileHandler.imageFromFile(FileHandler.getFilesLocation() + location));
    }

    public int checkSelectedResizer(Coordinate c) {
        int found = -1;
        if (this.selectedItem > -1 && this.items.size() > 0) {
            found = this.items.get(this.selectedItem).checkResizers(c);
        }
        return found;
    }

    public int getSelectedItem() {
        return this.selectedItem;
    }

    public boolean select(Coordinate c) {
        boolean found = false;
        for (int i = this.items.size() - 1; i >= 0 && !found; --i) {
            if (!this.items.get(i).isPointWithin(c)) continue;
            this.selectedItem = i;
            found = true;
        }
        if (!found) {
            this.deSelectAll();
        } else {
            this.setComponentZOrder(this.items.get(this.selectedItem), 0);
        }
        return found;
    }

    public void deSelectAll() {
        this.selectedItem = -1;
    }

    private void swapItemPositions(int first, int second) {
        ForegroundItem temp = this.items.get(first);
        this.items.set(first, this.items.get(second));
        this.items.set(second, temp);
    }

    public void moveSelected(Coordinate from, Coordinate to) {
        if (this.selectedItem >= 0 && this.selectedItem < this.items.size()) {
            this.items.get(this.selectedItem).startMoveItem(from, to);
            this.repaint();
        }
    }

    public void resizeSelected(int ResizerIndex, Coordinate from, Coordinate to) {
        this.items.get(this.selectedItem).resizeItem(ResizerIndex, from, to);
        this.repaint();
    }

    public void setFinishResize() {
        this.items.get(this.selectedItem).finishResize();
    }

    public void removeImage(Coordinate c) {
        boolean found = false;
        for (int i = this.items.size() - 1; i >= 0 && !found; --i) {
            if (!this.items.get(i).isPointWithin(c)) continue;
            this.remove(this.items.get(i));
            this.items.remove(i);
            found = true;
        }
    }

    public void fromXML(Element rootElement) throws GameXmlIncorrectException {
        List elements = rootElement.getChildren("foregrounditem");
        for (int i = 0; i < elements.size(); ++i) {
            String img = ((Element)elements.get(i)).getAttributeValue("img");
            int xaxis = XMLSimplify.getXMLInt((Element)elements.get(i), "xaxis");
            int yaxis = XMLSimplify.getXMLInt((Element)elements.get(i), "yaxis");
            try {
                this.addImage(new Coordinate(xaxis, yaxis), "gamesave" + File.separator + img);
                continue;
            }
            catch (IOException ioe) {
                throw new GameXmlIncorrectException("Unable to add foreground item. The Image '" + img + "' could not be found.");
            }
        }
    }

    public String toXML() {
        return this.toXML("<foreground>", "</foreground>");
    }

    public String toXML(String openTag, String closeTag) {
        String xml = "";
        xml = xml + openTag + "\n";
        int x = 0;
        int y = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            x = (int)Math.round(this.items.get(i).getLocation().getX()) + this.items.get(i).getWidth() / 2;
            y = (int)Math.round(this.items.get(i).getLocation().getY()) + this.items.get(i).getHeight() / 2;
            xml = xml + "<foregrounditem img=\"foreground-" + this.items.get(i).getImageHashCode() + ".png\" xaxis=\"" + x + "\" yaxis=\"" + y + "\" />";
            xml = xml + "\n";
        }
        xml = xml + closeTag + "\n";
        return xml;
    }

    public void drawOnGlass(Graphics2D g) {
        Graphics2D g2 = g;
        if (this.selectedItem > -1 && this.selectedItem < this.items.size()) {
            this.items.get(this.selectedItem).drawResizers(g2);
        }
    }
}

