/*
 * Decompiled with CFR 0.152.
 */
package gamemaker.Panels;

import gamemaker.Exceptions.GameXmlIncorrectException;
import gamemaker.FileHandler;
import gamemaker.GameMap;
import gamemaker.ImageWithDetails;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import javax.swing.JPanel;
import org.jdom.Element;

public class BackgroundPanel
extends JPanel {
    private GameMap gameMap;
    private ImageWithDetails bgImage;
    private int imageHeight = 600;
    private int imageWidth = 800;

    public BackgroundPanel(GameMap gameMap) {
        this.gameMap = gameMap;
        this.setOpaque(true);
    }

    public void saveImage(String location) throws IOException {
        FileHandler.imageToFile(this.bgImage.getImage(), location + "background-" + this.bgImage.hashCode() + ".png");
    }

    public Image getBackgroundImage() {
        return this.bgImage.getImage();
    }

    public Image getBackgroundImageThumb() {
        if (this.bgImage != null) {
            int newHeight = 60;
            double ratio = this.bgImage.getImage().getHeight(this.gameMap) / newHeight;
            int newWidth = (int)((double)this.bgImage.getImage().getWidth(this.gameMap) / ratio);
            return this.bgImage.getImage().getScaledInstance(newWidth, newHeight, 1);
        }
        return null;
    }

    public int getHeight() {
        return this.imageHeight;
    }

    public int getWidth() {
        return this.imageWidth;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.bgImage != null) {
            g2.drawImage(this.bgImage.getImage(), 0, 0, this.imageWidth, this.imageHeight, this);
        } else {
            g2.setBackground(Color.yellow);
        }
    }

    public void fromXML(Element rootElement) throws GameXmlIncorrectException {
        String ps = File.separator;
        String[] parts = rootElement.getAttributeValue("img").split("/");
        String img = "gamesave" + ps + parts[parts.length - 1];
        try {
            this.setImage(img);
        }
        catch (IOException ioe) {
            throw new GameXmlIncorrectException("Unable to add background. The Image '" + img + "' could not be found.");
        }
    }

    public String toXML() {
        return this.toXML("", "");
    }

    public String toXML(String openTag, String closeTag) {
        String xml = "";
        xml = xml + "<background img=\"background-" + this.bgImage.hashCode() + ".png\"/>";
        xml = xml + "\n";
        return xml;
    }

    public void setImage(String location) throws IOException {
        this.setImage(FileHandler.imageFromFile(FileHandler.getFilesLocation() + location));
    }

    public void setImage(ImageWithDetails newImage) throws IOException {
        this.bgImage = newImage;
        this.imageWidth = newImage.getImage().getWidth(this.gameMap);
        this.imageHeight = newImage.getImage().getHeight(this.gameMap);
        this.gameMap.setMapDimensions(this.imageWidth, this.imageHeight);
        this.gameMap.updateSizeOfAll();
        this.repaint();
        this.gameMap.repaint();
    }
}

