/*
 * Decompiled with CFR 0.152.
 */
package gamemaker;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MessageInput {
    private JDialog theDialog;
    private JTextArea theText;
    private ActionListener actionListener;

    public MessageInput(ActionListener actionListener) {
        this.actionListener = actionListener;
        this.theText = new JTextArea();
        this.theText.setLineWrap(true);
        this.theText.setSize(300, 200);
    }

    public void closeDialogue() {
        this.theDialog.setVisible(false);
        this.theDialog.dispose();
    }

    private void constructFrame() {
        this.theDialog = new JDialog();
        this.theDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.theDialog.setSize(300, 150);
        this.theDialog.setTitle("Please Enter A Message");
        this.theDialog.setDefaultCloseOperation(2);
        this.theDialog.setLocationRelativeTo(null);
        Container contentPane = this.theDialog.getContentPane();
        BoxLayout boxLayout = new BoxLayout(contentPane, 1);
        contentPane.setLayout(boxLayout);
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 2));
        JScrollPane scroller = new JScrollPane(this.theText);
        contentPane.add((Component)scroller, "Center");
        contentPane.add((Component)bottom, "Last");
        JButton ok = new JButton("OK");
        ok.setActionCommand("setmessage_ok");
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("setmessage_cancel");
        ok.setAlignmentX(0.5f);
        ok.addActionListener(this.actionListener);
        cancel.setAlignmentX(0.5f);
        cancel.addActionListener(this.actionListener);
        bottom.add(ok);
        bottom.add(cancel);
        this.theDialog.setVisible(true);
        scroller.setVisible(true);
        scroller.repaint();
        this.theDialog.repaint();
    }

    public String getInput() {
        this.theText.setText("");
        this.constructFrame();
        String text = this.theText.getText() + " ";
        text = text.replace("<", "");
        text = text.replace(">", "");
        return text;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setSize(200, 200);
        f.setVisible(true);
    }
}

