/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnadmin;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svnadmin.SVNAdminCommand;
import org.tmatesoft.svn.cli.svnadmin.SVNAdminOption;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAdminSetLogCommand
extends SVNAdminCommand {
    public SVNAdminSetLogCommand() {
        super("setlog", null);
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNAdminOption> options = new LinkedList<SVNAdminOption>();
        options.add(SVNAdminOption.REVISION);
        options.add(SVNAdminOption.BYPASS_HOOKS);
        return options;
    }

    public void run() throws SVNException {
        SVNPath target;
        if (this.getSVNAdminEnvironment().getStartRevision() == SVNRevision.UNDEFINED) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Missing revision"), SVNLogType.CLIENT);
        }
        if (this.getSVNAdminEnvironment().getEndRevision() != SVNRevision.UNDEFINED) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Only one revision allowed"), SVNLogType.CLIENT);
        }
        File repos = this.getLocalRepository();
        List targets = this.getEnvironment().combineTargets(null, false);
        if (!targets.isEmpty()) {
            targets.remove(0);
        }
        if (targets.size() != 1) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Exactly one file argument required"), SVNLogType.CLIENT);
        }
        if (!(target = new SVNPath((String)targets.get(0))).isFile()) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Exactly one file argument required"), SVNLogType.CLIENT);
        }
        SVNPropertyValue propertyValue = SVNPropertyValue.create("svn:log", this.getEnvironment().readFromFile(target.getFile()));
        SVNURL url = SVNURL.fromFile(repos);
        FSRepository repository = (FSRepository)SVNRepositoryFactory.create(url);
        long rev = this.getRevisionNumber(this.getSVNAdminEnvironment().getStartRevision(), repository.getLatestRevision(), repository);
        repository.setRevisionPropertyValue(rev, "svn:log", propertyValue, this.getSVNAdminEnvironment().isBypassHooks());
    }
}

