/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MathUtils {
    protected MathUtils() {
    }

    public static double sum(List<Number> numbers) {
        double sum = 0.0;
        for (Number value : numbers) {
            sum += value.doubleValue();
        }
        return sum;
    }

    public static double mean(List<Number> numbers) {
        double sum = MathUtils.sum(numbers);
        return sum / (double)numbers.size();
    }

    public static double min(List<Number> numbers) {
        double min = 2.147483647E9;
        for (Number value : numbers) {
            double v = value.doubleValue();
            if (!(v < min)) continue;
            min = v;
        }
        return min;
    }

    public static double max(List<Number> numbers) {
        double max = -2.147483648E9;
        for (Number value : numbers) {
            double v = value.doubleValue();
            if (!(v > max)) continue;
            max = v;
        }
        return max;
    }

    public static double stddev(List<Number> numbers, boolean biasCorrected) {
        double stddev = Double.NaN;
        int n = numbers.size();
        if (n > 0) {
            stddev = n > 1 ? Math.sqrt(MathUtils.var(numbers, biasCorrected)) : 0.0;
        }
        return stddev;
    }

    public static double var(List<Number> numbers, boolean biasCorrected) {
        int n = numbers.size();
        if (n == 0) {
            return Double.NaN;
        }
        if (n == 1) {
            return 0.0;
        }
        double mean = MathUtils.mean(numbers);
        ArrayList<Number> squares = new ArrayList<Number>();
        for (Number number : numbers) {
            double XminMean = number.doubleValue() - mean;
            squares.add(Math.pow(XminMean, 2.0));
        }
        double sum = MathUtils.sum(squares);
        return sum / (double)(biasCorrected ? n - 1 : n);
    }
}

