@ -----------------------------------------------------------------
@ Sample of keywords file for the keywords highlighting feature of EPM
@ -----------------------------------------------------------------
@  This file is used by EPM to figure out which keywords to highlight
@  It contains all the ANSI C keywords, plus all the #defines,
@  typedefs and function prototypes of the 2.1 toolkit.
@  Since it is huge, it takes a long time to load (8 sec on my 486-33 machine).
@  EPM looks for this file along the EPMPATH.
@  The loading time can be reduced by removing some keywords from the list.
@  The format to follow is described below.
@
@ ------------------------------------------------------------------
@ Format of the file
@ ------------------------------------------------------------------
@ The first character of the first line is the "special" character.
@ If it appears at the beginning of a line after, it is
@ either followed by a space and marks then a comment, or
@ by any other character and is then a topic name.
@ Currently the only topics are :
@  DELIM
@     What's between the 'start' and 'end' delimiters is set to the 'color' color.
@     If no 'end' is specified, the whole line after any 'start' string is colored.
@     If an 'Escape' character appears just before a 'end' string, it won't be considered an end delimiter.
@     An 'Escape' character can be escaped by another 'Escape' character
@     If the end delimiter is not on the same line as the start, no color changes will be done.
@  KEYWORDS
@     They must include only characters specified in the CHARSET section, case sensitive.
@  INSENSITIVE
@     Same as KEYWORDS except case insensitive.
@  CHARSET
@     List of characters allowed in the names of the KEYWORDS and INSENSITIVE sections.
@  SPECIAL
@     Any occurrence of these strings will be changed to the specified color.
@     They can include any character.
@
@  The background and foreground colors are values between 0 and 15
@  (see the EPM doc). If a value of -1 is given then the default
@  foreground or background color is used.
@
@ -----------------------------------------------------------------
@ Actual description of the keywords
@ -----------------------------------------------------------------
@
@DELIM
@
@ Start   Color Color  End     Escape
@ string  bg    fg     string  character
  /*       -1      2   */
  //       -1      2
  "        -1      2   "       \
  '        -1      2   '       \
@
@SPECIAL
@
.  -1  12
,  -1  12
;  -1  12
)  -1  12
(  -1  12
[  -1  12
]  -1  12
{  -1  12
}  -1  12
@
@CHARSET
@
.abcdefghijklmnopqrstuvwxyz_#ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789
@
@INSENSITIVE
@
@ -------------------- Java primitive types -------------------------------
boolean         -1      13
char            -1      13
byte            -1      13
short           -1      13
int             -1      13
long            -1      13
float           -1      13
double          -1      13
void            -1      13

@ -------------------- Special literals -----------------------------------
true            -1      2
false           -1      2
null            -1      2
@ -------------------- Java keywords --------------------------------------
abstract        -1      1
break           -1      1
case            -1      1
catch           -1      1
class           -1      1
const           -1      1
continue        -1      1
do              -1      1
else            -1      1
extends         -1      1
final           -1      1
finally         -1      1
for             -1      1
default         -1      1
implements      -1      1
import          -1      1
instanceof      -1      1
interface       -1      1
native          -1      1
new             -1      1
goto            -1      1
if              -1      1
public          -1      1
super           -1      1
switch          -1      1
synchronized    -1      1
package         -1      1
private         -1      1
protected       -1      1
transient       -1      1
return          -1      1
static          -1      1
while           -1      1
this            -1      1
throw           -1      1
try             -1      1
volatile        -1      1
throws          -1      1
@
@KEYWORDS
@
@ -------------------- Standard Java Classes ------------------------------
@
@ -------------------- Package java.applet --------------------------------
java.applet.Applet                 -1      3
java.applet.AppletContext          -1      3
java.applet.AppletStub             -1      3
java.applet.AudioClip              -1      3
AppletContext                      -1      3
AudioClip                          -1      3
AppletStub                         -1      3
Applet                             -1      3
@ -------------------- Package java.awt -----------------------------------
java.awt.AWTError                  -1      3
java.awt.AWTException              -1      3
java.awt.BorderLayout              -1      3
java.awt.Button                    -1      3
java.awt.Canvas                    -1      3
java.awt.CardLayout                -1      3
java.awt.Checkbox                  -1      3
java.awt.CheckboxGroup             -1      3
java.awt.CheckboxMenuItem          -1      3
java.awt.Choice                    -1      3
java.awt.Color                     -1      3
java.awt.Component                 -1      3
java.awt.Container                 -1      3
java.awt.Dialog                    -1      3
java.awt.Dimension                 -1      3
java.awt.Event                     -1      3
java.awt.FileDialog                -1      3
java.awt.FlowLayout                -1      3
java.awt.Font                      -1      3
java.awt.FontMetrics               -1      3
java.awt.Frame                     -1      3
java.awt.Graphics                  -1      3
java.awt.GridBagConstraints        -1      3
java.awt.GridBagLayout             -1      3
java.awt.GridLayout                -1      3
java.awt.Insets                    -1      3
java.awt.Label                     -1      3
java.awt.LayoutManager             -1      3
java.awt.List                      -1      3
java.awt.MediaTracker              -1      3
java.awt.Menu                      -1      3
java.awt.MenuBar                   -1      3
java.awt.MenuComponent             -1      3
java.awt.MenuContainer             -1      3
java.awt.MenuItem                  -1      3
java.awt.Panel                     -1      3
java.awt.Point                     -1      3
java.awt.Polygon                   -1      3
java.awt.Rectangle                 -1      3
java.awt.Scrollbar                 -1      3
java.awt.TextArea                  -1      3
java.awt.TextComponent             -1      3
java.awt.TextField                 -1      3
java.awt.Toolkit                   -1      3
java.awt.Window                    -1      3
AWTError                           -1      3
AWTException                       -1      3
BorderLayout                       -1      3
Button                             -1      3
Canvas                             -1      3
CardLayout                         -1      3
Checkbox                           -1      3
CheckboxGroup                      -1      3
CheckboxMenuItem                   -1      3
Choice                             -1      3
Color                              -1      3
Component                          -1      3
Container                          -1      3
Dialog                             -1      3
Dimension                          -1      3
Event                              -1      3
FileDialog                         -1      3
FlowLayout                         -1      3
Font                               -1      3
FontMetrics                        -1      3
Frame                              -1      3
Graphics                           -1      3
GridBagConstraints                 -1      3
GridBagLayout                      -1      3
GridLayout                         -1      3
Insets                             -1      3
Label                              -1      3
LayoutManager                      -1      3
List                               -1      3
MediaTracker                       -1      3
Menu                               -1      3
MenuBar                            -1      3
MenuComponent                      -1      3
MenuContainer                      -1      3
MenuItem                           -1      3
Panel                              -1      3
Point                              -1      3
Polygon                            -1      3
Rectangle                          -1      3
Scrollbar                          -1      3
TextArea                           -1      3
TextComponent                      -1      3
TextField                          -1      3
Toolkit                            -1      3
Window                             -1      3

@ -------------------- Package java.awt.image -----------------------------
java.awt.image.ColorModel          -1      3
java.awt.image.CropImageFilter     -1      3
java.awt.image.DirectColorModel    -1      3
java.awt.image.FilteredImageSource -1      3
java.awt.image.ImageConsumer       -1      3
java.awt.image.ImageFilter         -1      3
java.awt.image.ImageObserver       -1      3
java.awt.image.ImageProducer       -1      3
java.awt.image.IndexColorModel     -1      3
java.awt.image.MemoryImageSource   -1      3
java.awt.image.PixelGrabber        -1      3
java.awt.image.RGBImageFilter      -1      3
ColorModel                         -1      3
CropImageFilter                    -1      3
DirectColorModel                   -1      3
FilteredImageSource                -1      3
ImageConsumer                      -1      3
ImageFilter                        -1      3
ImageObserver                      -1      3
ImageProducer                      -1      3
IndexColorModel                    -1      3
MemoryImageSource                  -1      3
PixelGrabber                       -1      3
RGBImageFilter                     -1      3

@ -------------------- Package java.awt.peer ------------------------------
java.awt.peer.ButtonPeer           -1      3
java.awt.peer.CanvasPeer           -1      3
java.awt.peer.CheckboxMenuItemPeer -1      3
java.awt.peer.CheckboxPeer         -1      3
java.awt.peer.ChoicePeer           -1      3
java.awt.peer.ComponentPeer        -1      3
java.awt.peer.ContainerPeer        -1      3
java.awt.peer.DialogPeer           -1      3
java.awt.peer.FileDialogPeer       -1      3
java.awt.peer.FramePeer            -1      3
java.awt.peer.LabelPeer            -1      3
java.awt.peer.ListPeer             -1      3
java.awt.peer.MenuBarPeer          -1      3
java.awt.peer.MenuComponentPeer    -1      3
java.awt.peer.MenuItemPeer         -1      3
java.awt.peer.MenuPeer             -1      3
java.awt.peer.PanelPeer            -1      3
java.awt.peer.ScrollbarPeer        -1      3
java.awt.peer.TextAreaPeer         -1      3
java.awt.peer.TextComponentPeer    -1      3
java.awt.peer.TextFieldPeer        -1      3
java.awt.peer.WindowPeer           -1      3
ButtonPeer                         -1      3
CanvasPeer                         -1      3
CheckboxMenuItemPeer               -1      3
CheckboxPeer                       -1      3
ChoicePeer                         -1      3
ComponentPeer                      -1      3
ContainerPeer                      -1      3
DialogPeer                         -1      3
FileDialogPeer                     -1      3
FramePeer                          -1      3
LabelPeer                          -1      3
ListPeer                           -1      3
MenuBarPeer                        -1      3
MenuComponentPeer                  -1      3
MenuItemPeer                       -1      3
MenuPeer                           -1      3
PanelPeer                          -1      3
ScrollbarPeer                      -1      3
TextAreaPeer                       -1      3
TextComponentPeer                  -1      3
TextFieldPeer                      -1      3
WindowPeer                         -1      3

@ -------------------- Package java.io ------------------------------------
java.io.BufferedInputStream        -1      3
java.io.BufferedOutputStream       -1      3
java.io.ByteArrayInputStream       -1      3
java.io.ByteArrayOutputStream      -1      3
java.io.DataInput                  -1      3
java.io.DataInputStream            -1      3
java.io.DataOutput                 -1      3
java.io.DataOutputStream           -1      3
java.io.EOFException               -1      3
java.io.File                       -1      3
java.io.FileDescriptor             -1      3
java.io.FileInputStream            -1      3
java.io.FilenameFilter             -1      3
java.io.FileNotFoundException      -1      3
java.io.FileOutputStream           -1      3
java.io.FilterInputStream          -1      3
java.io.FilterOutputStream         -1      3
java.io.InputStream                -1      3
java.io.InterruptedIOException     -1      3
java.io.IOException                -1      3
java.io.LineNumberInputStream      -1      3
java.io.OutputStream               -1      3
java.io.PipedInputStream           -1      3
java.io.PipedOutputStream          -1      3
java.io.PrintStream                -1      3
java.io.PushbackInputStream        -1      3
java.io.RandomAccessFile           -1      3
java.io.SequenceInputStream        -1      3
java.io.StreamTokenizer            -1      3
java.io.StringBufferInputStream    -1      3
java.io.UTFDataFormatException     -1      3
BufferedInputStream                -1      3
BufferedOutputStream               -1      3
ByteArrayInputStream               -1      3
ByteArrayOutputStream              -1      3
DataInput                          -1      3
DataInputStream                    -1      3
DataOutput                         -1      3
DataOutputStream                   -1      3
EOFException                       -1      3
File                               -1      3
FileDescriptor                     -1      3
FileInputStream                    -1      3
FilenameFilter                     -1      3
FileNotFoundException              -1      3
FileOutputStream                   -1      3
FilterInputStream                  -1      3
FilterOutputStream                 -1      3
InputStream                        -1      3
InterruptedIOException             -1      3
IOException                        -1      3
LineNumberInputStream              -1      3
OutputStream                       -1      3
PipedInputStream                   -1      3
PipedOutputStream                  -1      3
PrintStream                        -1      3
PushbackInputStream                -1      3
RandomAccessFile                   -1      3
SequenceInputStream                -1      3
StreamTokenizer                    -1      3
StringBufferInputStream            -1      3
UTFDataFormatException             -1      3

@ -------------------- Package java.lang ----------------------------------
java.lang.AbstractMethodError              -1      3
java.lang.ArithmeticException              -1      3
java.lang.ArrayIndexOutOfBoundsException   -1      3
java.lang.ArrayStoreException              -1      3
java.lang.Boolean                          -1      3
java.lang.Character                        -1      3
java.lang.Class                            -1      3
java.lang.ClassCastException               -1      3
java.lang.ClassCircularityError            -1      3
java.lang.ClassFormatError                 -1      3
java.lang.ClassLoader                      -1      3
java.lang.ClassNotFoundException           -1      3
java.lang.Cloneable                        -1      3
java.lang.CloneNotSupportedException       -1      3
java.lang.Compiler                         -1      3
java.lang.Double                           -1      3
java.lang.Error                            -1      3
java.lang.Exception                        -1      3
java.lang.Float                            -1      3
java.lang.IllegalAccessError               -1      3
java.lang.IllegalAccessException           -1      3
java.lang.IllegalArgumentException         -1      3
java.lang.IllegalMonitorStateException     -1      3
java.lang.IllegalThreadStateException      -1      3
java.lang.IncompatibleClassChangeError     -1      3
java.lang.IndexOutOfBoundsException        -1      3
java.lang.InstantiationError               -1      3
java.lang.InstantiationException           -1      3
java.lang.Integer                          -1      3
java.lang.InternalError                    -1      3
java.lang.InterruptedException             -1      3
java.lang.LinkageError                     -1      3
java.lang.Long                             -1      3
java.lang.Math                             -1      3
java.lang.NegativeArraySizeException       -1      3
java.lang.NoClassDefFoundError             -1      3
java.lang.NoSuchFieldError                 -1      3
java.lang.NoSuchMethodError                -1      3
java.lang.NoSuchMethodException            -1      3
java.lang.NullPointerException             -1      3
java.lang.Number                           -1      3
java.lang.NumberFormatException            -1      3
java.lang.Object                           -1      3
java.lang.OutOfMemoryError                 -1      3
java.lang.Process                          -1      3
java.lang.Runnable                         -1      3
java.lang.Runtime                          -1      3
java.lang.RuntimeException                 -1      3
java.lang.SecurityException                -1      3
java.lang.SecurityManager                  -1      3
java.lang.StackOverflowError               -1      3
java.lang.String                           -1      3
java.lang.StringBuffer                     -1      3
java.lang.StringIndexOutOfBoundsException  -1      3
java.lang.System                           -1      3
java.lang.Thread                           -1      3
java.lang.ThreadDeath                      -1      3
java.lang.ThreadGroup                      -1      3
java.lang.Throwable                        -1      3
java.lang.UnknownError                     -1      3
java.lang.UnsatisfiedLinkError             -1      3
java.lang.VerifyError                      -1      3
java.lang.VirtualMachineError              -1      3
AbstractMethodError                        -1      3
ArithmeticException                        -1      3
ArrayIndexOutOfBoundsException             -1      3
ArrayStoreException                        -1      3
Boolean                                    -1      3
Character                                  -1      3
Class                                      -1      3
ClassCastException                         -1      3
ClassCircularityError                      -1      3
ClassFormatError                           -1      3
ClassLoader                                -1      3
ClassNotFoundException                     -1      3
Cloneable                                  -1      3
CloneNotSupportedException                 -1      3
Compiler                                   -1      3
Double                                     -1      3
Error                                      -1      3
Exception                                  -1      3
Float                                      -1      3
IllegalAccessError                         -1      3
IllegalAccessException                     -1      3
IllegalArgumentException                   -1      3
IllegalMonitorStateException               -1      3
IllegalThreadStateException                -1      3
IncompatibleClassChangeError               -1      3
IndexOutOfBoundsException                  -1      3
InstantiationError                         -1      3
InstantiationException                     -1      3
Integer                                    -1      3
InternalError                              -1      3
InterruptedException                       -1      3
LinkageError                               -1      3
Long                                       -1      3
Math                                       -1      3
NegativeArraySizeException                 -1      3
NoClassDefFoundError                       -1      3
NoSuchFieldError                           -1      3
NoSuchMethodError                          -1      3
NoSuchMethodException                      -1      3
NullPointerException                       -1      3
Number                                     -1      3
NumberFormatException                      -1      3
Object                                     -1      3
OutOfMemoryError                           -1      3
Process                                    -1      3
Runnable                                   -1      3
Runtime                                    -1      3
RuntimeException                           -1      3
SecurityException                          -1      3
SecurityManager                            -1      3
StackOverflowError                         -1      3
String                                     -1      3
StringBuffer                               -1      3
StringIndexOutOfBoundsException            -1      3
System                                     -1      3
Thread                                     -1      3
ThreadDeath                                -1      3
ThreadGroup                                -1      3
Throwable                                  -1      3
UnknownError                               -1      3
UnsatisfiedLinkError                       -1      3
VerifyError                                -1      3
VirtualMachineError                        -1      3

@ -------------------- Package java.net -----------------------------------
java.net.ContentHandler                    -1      3
java.net.ContentHandlerFactory             -1      3
java.net.DatagramPacket                    -1      3
java.net.DatagramSocket                    -1      3
java.net.InetAddress                       -1      3
java.net.MalformedURLException             -1      3
java.net.ProtocolException                 -1      3
java.net.ServerSocket                      -1      3
java.net.Socket                            -1      3
java.net.SocketException                   -1      3
java.net.SocketImpl                        -1      3
java.net.SocketImplFactory                 -1      3
java.net.UnknownHostException              -1      3
java.net.UnknownServiceException           -1      3
java.net.URL                               -1      3
java.net.URLConnection                     -1      3
java.net.URLEncoder                        -1      3
java.net.URLStreamHandler                  -1      3
java.net.URLStreamHandlerFactory           -1      3
ContentHandler                             -1      3
ContentHandlerFactory                      -1      3
DatagramPacket                             -1      3
DatagramSocket                             -1      3
InetAddress                                -1      3
MalformedURLException                      -1      3
ProtocolException                          -1      3
ServerSocket                               -1      3
Socket                                     -1      3
SocketException                            -1      3
SocketImpl                                 -1      3
SocketImplFactory                          -1      3
UnknownHostException                       -1      3
UnknownServiceException                    -1      3
URL                                        -1      3
URLConnection                              -1      3
URLEncoder                                 -1      3
URLStreamHandler                           -1      3
URLStreamHandlerFactory                    -1      3

@ -------------------- Package java.util ----------------------------------
java.util.BitSet                           -1      3
java.util.Date                             -1      3
java.util.Dictionary                       -1      3
java.util.EmptyStackException              -1      3
java.util.Enumeration                      -1      3
java.util.Hashtable                        -1      3
java.util.NoSuchElementException           -1      3
java.util.Observable                       -1      3
java.util.Observer                         -1      3
java.util.Properties                       -1      3
java.util.Random                           -1      3
java.util.Stack                            -1      3
java.util.StringTokenizer                  -1      3
java.util.Vector                           -1      3
BitSet                                     -1      3
Date                                       -1      3
Dictionary                                 -1      3
EmptyStackException                        -1      3
Enumeration                                -1      3
Hashtable                                  -1      3
NoSuchElementException                     -1      3
Observable                                 -1      3
Observer                                   -1      3
Properties                                 -1      3
Random                                     -1      3
Stack                                      -1      3
StringTokenizer                            -1      3
Vector                                     -1      3

@ -------------------- Package sun.tools.debug ----------------------------
sun.tools.debug.DebuggerCallback           -1      3
sun.tools.debug.NoSuchFieldException       -1      3
sun.tools.debug.NoSuchLineNumberException  -1      3
sun.tools.debug.RemoteArray                -1      3
sun.tools.debug.RemoteBoolean              -1      3
sun.tools.debug.RemoteByte                 -1      3
sun.tools.debug.RemoteChar                 -1      3
sun.tools.debug.RemoteClass                -1      3
sun.tools.debug.RemoteDebugger             -1      3
sun.tools.debug.RemoteDouble               -1      3
sun.tools.debug.RemoteField                -1      3
sun.tools.debug.RemoteFloat                -1      3
sun.tools.debug.RemoteInt                  -1      3
sun.tools.debug.RemoteLong                 -1      3
sun.tools.debug.RemoteObject               -1      3
sun.tools.debug.RemoteShort                -1      3
sun.tools.debug.RemoteStackFrame           -1      3
sun.tools.debug.RemoteStackVariable        -1      3
sun.tools.debug.RemoteString               -1      3
sun.tools.debug.RemoteThread               -1      3
sun.tools.debug.RemoteThreadGroup          -1      3
sun.tools.debug.RemoteValue                -1      3
sun.tools.debug.StackFrame                 -1      3
DebuggerCallback                           -1      3
NoSuchFieldException                       -1      3
NoSuchLineNumberException                  -1      3
RemoteArray                                -1      3
RemoteBoolean                              -1      3
RemoteByte                                 -1      3
RemoteChar                                 -1      3
RemoteClass                                -1      3
RemoteDebugger                             -1      3
RemoteDouble                               -1      3
RemoteField                                -1      3
RemoteFloat                                -1      3
RemoteInt                                  -1      3
RemoteLong                                 -1      3
RemoteObject                               -1      3
RemoteShort                                -1      3
RemoteStackFrame                           -1      3
RemoteStackVariable                        -1      3
RemoteString                               -1      3
RemoteThread                               -1      3
RemoteThreadGroup                          -1      3
RemoteValue                                -1      3
StackFrame                                 -1      3
