/*
 * Decompiled with CFR 0.152.
 */
package cpusim.module;

import cpusim.Module;
import cpusim.module.Register;
import cpusim.util.Assert;

public class ConditionBit
extends Module {
    private Register register;
    private int bit;
    private boolean halt;

    public ConditionBit(String name, Register register, int bit, boolean halt) {
        super(name);
        this.register = register;
        this.bit = bit;
        this.halt = halt;
    }

    public Register getRegister() {
        return this.register;
    }

    public void setRegister(Register r) {
        this.register = r;
    }

    public int getBit() {
        return this.bit;
    }

    public void setBit(int newBit) {
        this.bit = newBit;
    }

    public boolean getHalt() {
        return this.halt;
    }

    public void setHalt(boolean newHalt) {
        this.halt = newHalt;
    }

    @Override
    public Object clone() {
        return new ConditionBit(this.getName(), this.register, this.bit, this.halt);
    }

    @Override
    public void copyDataTo(Module newConditionBit) {
        Assert.That(newConditionBit instanceof ConditionBit, "Passed non-ConditionBit to ConditionBit.copyDataTo()");
        ConditionBit newBit = (ConditionBit)newConditionBit;
        newBit.setName(this.getName());
        newBit.setRegister(this.register);
        newBit.setBit(this.bit);
        newBit.setHalt(this.halt);
    }

    public void set(int bitValue) {
        Assert.That(bitValue == 0 || bitValue == 1, "Illegal argument: " + bitValue + " to ConditionBit.set().");
        long mask = 1L << this.register.getWidth() - this.bit - 1;
        long value = this.register.getValue();
        value = bitValue == 1 ? (value |= mask) : (value &= mask ^ 0xFFFFFFFFFFFFFFFFL);
        value = value << 64 - this.register.getWidth() >> 64 - this.register.getWidth();
        this.register.setValue(value);
    }

    public boolean isSet() {
        long registerValue = this.register.getValue();
        return (registerValue <<= 64 - this.register.getWidth() + this.bit) < 0L;
    }

    @Override
    public String getXMLDescription() {
        return "<ConditionBit name=\"" + this.getHTMLName() + "\" bit=\"" + this.getBit() + "\" register=\"" + this.getRegister().getID() + "\" halt=\"" + this.getHalt() + "\" id=\"" + this.getID() + "\" />";
    }

    @Override
    public String getHTMLDescription() {
        return "<TR><TD>" + this.getHTMLName() + "</TD><TD>" + this.getRegister().getHTMLName() + "</TD><TD>" + this.getBit() + "</TD><TD>" + this.getHalt() + "</TD></TR>";
    }
}

