/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.microinstruction.MemoryAccess;
import cpusim.microinstruction.MicroFactory;
import cpusim.module.RAM;
import cpusim.module.Register;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

public class MemoryAccessFactory
extends MicroFactory {
    private Vector currentMicros;
    private MemoryAccess prototype;

    public MemoryAccessFactory(Machine machine) {
        super(machine);
        this.currentMicros = machine.getMicros("memoryAccess");
        Register r = machine.getAllRegisters().size() == 0 ? null : (Register)machine.getAllRegisters().elementAt(0);
        RAM ram = machine.getModule("rams").size() == 0 ? null : (RAM)machine.getModule("rams").elementAt(0);
        this.prototype = new MemoryAccess("???", "read", ram, r, r);
        this.clones = (Microinstruction[])this.createClones();
    }

    @Override
    public HashMap getCellEditors() {
        HashMap<String, DefaultCellEditor> editors = new HashMap<String, DefaultCellEditor>();
        JComboBox<String> directionsCombo = new JComboBox<String>(MemoryAccess.DIRECTIONS);
        editors.put("direction", new DefaultCellEditor(directionsCombo));
        Vector rams = this.machine.getModule("rams");
        JComboBox ramsCombo = new JComboBox(rams);
        editors.put("memory", new DefaultCellEditor(ramsCombo));
        Vector registers = this.machine.getAllRegisters();
        JComboBox datasCombo = new JComboBox(registers);
        editors.put("data", new DefaultCellEditor(datasCombo));
        JComboBox addressesCombo = new JComboBox(registers);
        editors.put("address", new DefaultCellEditor(addressesCombo));
        return editors;
    }

    @Override
    Microinstruction getPrototype() {
        return this.prototype;
    }

    @Override
    Class getMicroClass() {
        return MemoryAccess.class;
    }

    @Override
    public Vector getCurrentMicros() {
        return this.currentMicros;
    }

    @Override
    public String toString() {
        return "MemoryAccess";
    }

    @Override
    public String[] getProperties() {
        return new String[]{"name", "direction", "memory", "data", "address"};
    }

    @Override
    public boolean checkValidity(Object[] micros) {
        Microinstruction[] memoryAccesses = new MemoryAccess[micros.length];
        for (int i = 0; i < memoryAccesses.length; ++i) {
            memoryAccesses[i] = (MemoryAccess)micros[i];
        }
        return this.allNamesAreUnique(memoryAccesses) && !this.someNamesAreEmpty(memoryAccesses);
    }

    @Override
    public void updateCurrentMicrosFromClones() {
        this.machine.setMicros("memoryAccess", this.createNewMicroList(this.clones));
    }

    @Override
    public void setClones(Object[] newClones) {
        MemoryAccess[] memoryAccesses = new MemoryAccess[newClones.length];
        for (int i = 0; i < newClones.length; ++i) {
            memoryAccesses[i] = (MemoryAccess)newClones[i];
        }
        this.clones = memoryAccesses;
    }

    @Override
    public boolean newMicrosAreAllowed() {
        return this.machine.getModule("registers").size() > 0 && this.machine.getModule("rams").size() > 0;
    }

    @Override
    public String getHelpPageID() {
        return "MemoryAccess";
    }
}

