/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.module.RAM;
import cpusim.util.Assert;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.table.AbstractTableModel;

public class RAMTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    public static final int BREAK_COLUMN = 0;
    public static final int ADDRESS_COLUMN = 1;
    public static final int DATA_COLUMN = 2;
    public static final int COMMENT_COLUMN = 3;
    String[] columnNames = new String[]{"Break", "Address", "Data", "Comments"};
    private RAM ram;
    private int numMemCellsPerRow;
    private int numRows;

    public RAMTableModel(RAM ram, int memCellsPerRow) {
        this.ram = ram;
        this.setNumMemCellsPerTableCell(memCellsPerRow);
        ram.addPropertyChangeListener(this);
    }

    public void setNumMemCellsPerTableCell(int newSize) {
        this.numMemCellsPerRow = newSize;
        this.numRows = this.ram.getLength() % this.numMemCellsPerRow == 0 ? this.ram.getLength() / this.numMemCellsPerRow : this.ram.getLength() / this.numMemCellsPerRow + 1;
        this.fireTableDataChanged();
    }

    public int getNumMemCellsPerTableCell() {
        return this.numMemCellsPerRow;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.numRows;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            boolean result = this.ram.getBreaks()[row * this.numMemCellsPerRow];
            for (int next = row * this.numMemCellsPerRow + 1; next < (row + 1) * this.numMemCellsPerRow && next < this.ram.getLength(); ++next) {
                result = result || this.ram.getBreaks()[next];
            }
            return result;
        }
        if (col == 1) {
            return new Long(row * this.numMemCellsPerRow);
        }
        if (col == 2) {
            int cellsPerRow = (row + 1) * this.numMemCellsPerRow <= this.ram.getLength() ? this.numMemCellsPerRow : this.ram.getLength() - row * this.numMemCellsPerRow;
            long value = this.ram.getData(row * this.numMemCellsPerRow, cellsPerRow * this.ram.getCellSize());
            return value;
        }
        String result = this.ram.getComments()[row * this.numMemCellsPerRow];
        for (int next = row * this.numMemCellsPerRow + 1; next < (row + 1) * this.numMemCellsPerRow && next < this.ram.getLength(); ++next) {
            String nextComment = this.ram.getComments()[next];
            result = result + (nextComment.equals("") ? "" : " | " + nextComment.trim());
        }
        return result;
    }

    public Class getColumnClass(int col) {
        return this.getValueAt(0, col).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 1;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            boolean result = (Boolean)value;
            for (int next = row * this.numMemCellsPerRow; next < (row + 1) * this.numMemCellsPerRow && next < this.ram.getLength(); ++next) {
                this.ram.getBreaks()[next] = result;
            }
        } else if (col == 2) {
            long result = (Long)value;
            int cellsPerRow = (row + 1) * this.numMemCellsPerRow <= this.ram.getLength() ? this.numMemCellsPerRow : this.ram.getLength() - row * this.numMemCellsPerRow;
            this.ram.setData(row * this.numMemCellsPerRow, result, cellsPerRow * this.ram.getCellSize());
        } else if (col == 3) {
            String comments = (String)value;
            int numComments = (row + 1) * this.numMemCellsPerRow <= this.ram.getLength() ? this.numMemCellsPerRow : this.ram.getLength() - row * this.numMemCellsPerRow;
            for (int i = 0; i < numComments; ++i) {
                String comment;
                int semicolonIndex = comments.indexOf(59);
                if (semicolonIndex == -1) {
                    semicolonIndex = comments.length();
                }
                this.ram.getComments()[row * this.numMemCellsPerRow + i] = comment = comments.substring(0, semicolonIndex);
                comments = semicolonIndex == comments.length() ? "" : comments.substring(semicolonIndex + 1);
            }
        }
        if (col != 1) {
            this.fireTableCellUpdated(row, col);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Assert.That(event.getPropertyName().equals("data") || event.getPropertyName().equals("length") || event.getPropertyName().equals("breaks") || event.getPropertyName().equals("comments"), "event in RAMTableModel.propertyChange() is of name: " + event.getPropertyName());
        if (event.getPropertyName().equals("length")) {
            this.fireTableDataChanged();
        } else if (!event.getPropertyName().equals("data")) {
            int startIndex = ((Point)event.getNewValue()).x;
            int endIndex = startIndex + ((Point)event.getNewValue()).y - 1;
            this.fireTableRowsUpdated(startIndex / this.numMemCellsPerRow, endIndex / this.numMemCellsPerRow);
        }
    }
}

