/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.Machine;
import cpusim.gui.HelpDialog;
import cpusim.gui.LangUnit;
import cpusim.module.RAM;
import cpusim.util.CPUSimConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class LoadOptionsDialog
extends JDialog
implements CPUSimConstants {
    private Machine machine;
    private JButton okButton;
    private JTextField addressField;
    private JComboBox ramsComboBox;

    public LoadOptionsDialog(Frame parent, Machine machine, boolean modal) {
        super(parent, LangUnit.LU_LOAD_OPT.str(), modal);
        this.machine = machine;
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.createBottomButtonPanel(), "South");
        contentPane.add((Component)this.createLoadOptionsPanel(), "Center");
    }

    private JPanel createLoadOptionsPanel() {
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        optionsPanel.setLayout(new GridLayout(2, 2, 2, 2));
        this.addressField = new JTextField("" + this.machine.getStartingAddressForLoading(), 4);
        if (this.machine.getModule("rams").size() == 0) {
            this.ramsComboBox = new JComboBox<String>(new String[]{"<empty>"});
            this.ramsComboBox.setEnabled(false);
            this.okButton.setEnabled(false);
        } else {
            this.ramsComboBox = new JComboBox(this.machine.getModule("rams"));
            this.ramsComboBox.setSelectedItem(this.machine.getCodeStore());
        }
        optionsPanel.add(new JLabel(LangUnit.LU_CODE_STORE.str()));
        optionsPanel.add(this.ramsComboBox);
        optionsPanel.add(new JLabel(LangUnit.LU_START_ADDR.str()));
        optionsPanel.add(this.addressField);
        return optionsPanel;
    }

    private JPanel createBottomButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        buttonPanel.setLayout(new GridLayout(1, 4, 10, 10));
        this.okButton = new JButton(LangUnit.LU_OK.str());
        JButton cancelButton = new JButton(LangUnit.LU_CANCEL.str());
        JButton helpButton = new JButton();
        if (MAC_OS_X) {
            helpButton.putClientProperty("JButton.buttonType", "help");
        } else {
            helpButton.setText(LangUnit.LU_HELP_B.str());
        }
        this.okButton.addActionListener(new OkButtonListener());
        CancelButtonListener cancelListener = new CancelButtonListener();
        cancelButton.addActionListener(cancelListener);
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().registerKeyboardAction(cancelListener, stroke, 2);
        this.getRootPane().setDefaultButton(this.okButton);
        helpButton.addActionListener(new HelpButtonListener());
        buttonPanel.add(helpButton);
        JPanel invisiblePanel = new JPanel();
        buttonPanel.add(invisiblePanel);
        buttonPanel.add(this.okButton);
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    private class HelpButtonListener
    implements ActionListener {
        private HelpButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HelpDialog d = new HelpDialog(LoadOptionsDialog.this);
            d.showPage("executeMenu");
        }
    }

    private class CancelButtonListener
    implements ActionListener {
        private CancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LoadOptionsDialog.this.setVisible(false);
        }
    }

    private class OkButtonListener
    implements ActionListener {
        private OkButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int startAddress;
            RAM ram = (RAM)LoadOptionsDialog.this.ramsComboBox.getSelectedItem();
            try {
                startAddress = Integer.parseInt(LoadOptionsDialog.this.addressField.getText());
            }
            catch (NumberFormatException exc) {
                JOptionPane.showMessageDialog(LoadOptionsDialog.this, LangUnit.LU_ERR_START_ADDR.str(), LangUnit.LU_NUM_FORMAT_ERR.str(), 0);
                return;
            }
            if (startAddress < 0) {
                JOptionPane.showMessageDialog(LoadOptionsDialog.this, LangUnit.LU_ERR_NEGATIVE.str(), LangUnit.LU_NUM_FORMAT_ERR.str(), 0);
                return;
            }
            if (LoadOptionsDialog.this.machine.getCodeStore() != ram || LoadOptionsDialog.this.machine.getStartingAddressForLoading() != startAddress) {
                LoadOptionsDialog.this.machine.setDirty(true);
                LoadOptionsDialog.this.machine.setCodeStore(ram);
                LoadOptionsDialog.this.machine.setStartingAddressForLoading(startAddress);
            }
            LoadOptionsDialog.this.setVisible(false);
        }
    }
}

