/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.ConsoleChannel;
import cpusim.FileChannel;
import cpusim.IOChannel;
import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.UserChannel;
import cpusim.gui.HelpDialog;
import cpusim.gui.IOConnectionsCellEditor;
import cpusim.gui.LangUnit;
import cpusim.microinstruction.IO;
import cpusim.util.Assert;
import cpusim.util.CPUSimConstants;
import cpusim.util.ExtendedJTable;
import cpusim.util.OOTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class IOOptionsDialog
extends JDialog
implements CPUSimConstants {
    protected Machine machine;
    private ExtendedJTable table;
    private HashMap<IO, IO> assocList;
    private HashMap<String, FileChannel> channelTable;

    public IOOptionsDialog(Frame owner, Machine machine) {
        super(owner, LangUnit.LU_IO_MICRO_CONNECT.str(), true);
        this.machine = machine;
        this.assocList = new HashMap();
        this.channelTable = new HashMap();
        this.initializeChannelTable();
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.createConnectionsPanel(), "Center");
        contentPane.add((Component)this.createBottomButtonPanel(), "South");
    }

    public HashMap<String, FileChannel> getChannelTable() {
        return this.channelTable;
    }

    private void createExtendedJTable() {
        OOTableModel model = null;
        Vector<Microinstruction> oldIOs = this.machine.getMicros("io");
        Object[] clones = new IO[oldIOs.size()];
        for (int i = 0; i < oldIOs.size(); ++i) {
            IO oldIO = (IO)oldIOs.elementAt(i);
            IO clone = (IO)oldIO.clone();
            clones[i] = clone;
            this.assocList.put(clone, oldIO);
        }
        try {
            model = new OOTableModel(clones);
            model.setColumns(new String[]{"name", "connection"});
        }
        catch (IntrospectionException e) {
            Assert.That(false, e + LangUnit.LU_EXCEPT_IOPORTS.str());
        }
        HashMap<String, IOConnectionsCellEditor> editors = new HashMap<String, IOConnectionsCellEditor>();
        editors.put("connection", new IOConnectionsCellEditor(this));
        this.table = new ExtendedJTable((TableModel)model, editors);
        this.table.setSelectionMode(0);
        this.table.getOOModel().setReadOnly(new String[]{"name"});
        this.table.setDefaultRenderer(IOChannel.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JComponent comp = (JComponent)super.getTableCellRendererComponent(table, value.toString(), isSelected, hasFocus, row, column);
                comp.setToolTipText(value instanceof UserChannel || value instanceof ConsoleChannel ? value.toString() : ((FileChannel)value).getFile().toString());
                return comp;
            }
        });
    }

    private JPanel createConnectionsPanel() {
        JPanel connectionsPanel = new JPanel();
        connectionsPanel.setLayout(new BorderLayout());
        this.createExtendedJTable();
        Dimension tablePreferredSize = this.table.getPreferredScrollableViewportSize();
        connectionsPanel.setPreferredSize(new Dimension(tablePreferredSize.width, 120));
        connectionsPanel.add((Component)new JScrollPane(this.table), "Center");
        connectionsPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        return connectionsPanel;
    }

    private JPanel createBottomButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        buttonPanel.setLayout(new GridLayout(1, 4, 10, 10));
        JButton okButton = new JButton(LangUnit.LU_OK.str());
        JButton cancelButton = new JButton(LangUnit.LU_CANCEL.str());
        JButton helpButton = new JButton();
        if (MAC_OS_X) {
            helpButton.putClientProperty("JButton.buttonType", "help");
        } else {
            helpButton.setText(LangUnit.LU_HELP_B.str());
        }
        okButton.addActionListener(new OkButtonListener());
        CancelButtonListener cancelListener = new CancelButtonListener();
        cancelButton.addActionListener(cancelListener);
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().registerKeyboardAction(cancelListener, stroke, 2);
        this.getRootPane().setDefaultButton(okButton);
        helpButton.addActionListener(new HelpButtonListener());
        buttonPanel.add(helpButton);
        JPanel invisiblePanel = new JPanel();
        buttonPanel.add(invisiblePanel);
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    private void initializeChannelTable() {
        Vector<Microinstruction> ios = this.machine.getMicros("io");
        for (int i = 0; i < ios.size(); ++i) {
            IOChannel channel = ((IO)ios.elementAt(i)).getConnection();
            if (!(channel instanceof FileChannel)) continue;
            this.channelTable.put(((FileChannel)channel).getFile().toString(), (FileChannel)channel);
        }
    }

    private class HelpButtonListener
    implements ActionListener {
        private HelpButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HelpDialog d = new HelpDialog(IOOptionsDialog.this);
            d.showPage("executeMenu");
        }
    }

    private class CancelButtonListener
    implements ActionListener {
        private CancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IOOptionsDialog.this.setVisible(false);
        }
    }

    private class OkButtonListener
    implements ActionListener {
        private OkButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] objects;
            OOTableModel model = IOOptionsDialog.this.table.getOOModel();
            for (Object object : objects = model.getAllObjects()) {
                IO clone = (IO)object;
                IO oldIO = (IO)IOOptionsDialog.this.assocList.get(clone);
                if (!clone.getConnection().equals(oldIO.getConnection())) {
                    oldIO.getConnection().reset();
                }
                oldIO.setConnection(clone.getConnection());
            }
            IOOptionsDialog.this.setVisible(false);
        }
    }
}

