/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.gui.Desktop;
import cpusim.gui.HelpDialog;
import cpusim.gui.LangUnit;
import cpusim.gui.MicroDialog;
import cpusim.microinstruction.Comment;
import cpusim.microinstruction.End;
import cpusim.util.Assert;
import cpusim.util.CPUSimConstants;
import cpusim.util.DraggableEditableJList;
import cpusim.util.MicroListCellEditor;
import cpusim.util.MicroListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class FetchSequenceDialog
extends JDialog
implements CPUSimConstants {
    private Machine machine;
    private DraggableEditableJList microList;
    private JTree microTree;
    private JButton deleteMicroButton;
    private JButton insertMicroButton;
    private Desktop desktop;

    public FetchSequenceDialog(Frame parent, Machine machine) {
        super(parent, LangUnit.LU_EDIT_FETCH_SEQ.str(), true);
        Container contentPane = this.getContentPane();
        this.machine = machine;
        this.desktop = (Desktop)parent;
        contentPane.add((Component)this.createMicroListPanel(), "Center");
        contentPane.add((Component)this.createBottomButtonPanel(), "South");
    }

    private JPanel createBottomButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        buttonPanel.setLayout(new GridLayout(1, 4, 10, 10));
        JButton okButton = new JButton(LangUnit.LU_OK.str());
        JButton cancelButton = new JButton(LangUnit.LU_CANCEL.str());
        JButton helpButton = new JButton();
        if (MAC_OS_X) {
            helpButton.putClientProperty("JButton.buttonType", "help");
        } else {
            helpButton.setText(LangUnit.LU_HELP_B.str());
        }
        okButton.addActionListener(new OkButtonListener());
        CancelButtonListener cancelListener = new CancelButtonListener();
        cancelButton.addActionListener(cancelListener);
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().registerKeyboardAction(cancelListener, stroke, 2);
        this.getRootPane().setDefaultButton(okButton);
        helpButton.addActionListener(new HelpButtonListener());
        buttonPanel.add(helpButton);
        JPanel invisiblePanel = new JPanel();
        buttonPanel.add(invisiblePanel);
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    private JPanel createMicroListPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        mainPanel.setLayout(new GridLayout(1, 3, 5, 0));
        MicroListModel listModel = new MicroListModel();
        List<Microinstruction> micros = this.machine.getFetchSequence().getMicros();
        for (Microinstruction micro : micros) {
            listModel.addElement(micro);
        }
        this.microList = new DraggableEditableJList((ListModel)listModel);
        this.microList.setListCellEditor(new MicroListCellEditor(new JTextField()));
        this.microList.addMouseListener(new MicroListDoubleClickListener());
        JScrollPane microListPane = new JScrollPane(this.microList);
        TitledBorder listBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), LangUnit.LU_IMPLEMENT.str());
        listBorder.setTitleJustification(2);
        Border innerBorder = BorderFactory.createLineBorder(Color.black);
        microListPane.setBorder(BorderFactory.createCompoundBorder(listBorder, innerBorder));
        mainPanel.add(microListPane);
        JPanel middlePanel = new JPanel();
        middlePanel.setLayout(new GridLayout(6, 1, 0, 5));
        middlePanel.add(new JPanel());
        middlePanel.add(new JPanel());
        JPanel deletePanel = new JPanel();
        this.deleteMicroButton = new JButton(LangUnit.LU_DIR_DEL.str());
        this.deleteMicroButton.addActionListener(new DeleteMicroButtonListener());
        deletePanel.add(this.deleteMicroButton);
        JPanel insertPanel = new JPanel();
        this.insertMicroButton = new JButton(LangUnit.LU_DIR_INSERT.str());
        this.insertMicroButton.addActionListener(new InsertMicroButtonListener());
        insertPanel.add(this.insertMicroButton);
        middlePanel.add(insertPanel);
        middlePanel.add(deletePanel);
        mainPanel.add(middlePanel);
        this.deleteMicroButton.setEnabled(false);
        this.insertMicroButton.setEnabled(false);
        this.createMicroTree();
        TitledBorder treeBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), LangUnit.LU_ALL_MICROS.str());
        treeBorder.setTitleJustification(2);
        Border innerTreeBorder = BorderFactory.createLineBorder(Color.black);
        JScrollPane treePane = new JScrollPane(this.microTree);
        treePane.setBorder(BorderFactory.createCompoundBorder(treeBorder, innerTreeBorder));
        mainPanel.add(treePane);
        this.microList.addKeyListener(new MicroListKeyListener());
        this.microList.addListSelectionListener(new MicroListSelectionListener());
        this.microTree.addTreeSelectionListener(new MicroTreeSelectionListener());
        this.microTree.getSelectionModel().setSelectionMode(1);
        this.microTree.addMouseListener(new MicroTreeDoubleClickListener());
        this.microTree.expandRow(0);
        return mainPanel;
    }

    private void createMicroTree() {
        int i;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("", true);
        DefaultMutableTreeNode microType = new DefaultMutableTreeNode("TransferRtoR", true);
        root.add(microType);
        for (i = 0; i < this.machine.getMicros("transferRtoR").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("transferRtoR").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("TransferAtoR", true);
        root.add(microType);
        for (i = 0; i < this.machine.getMicros("transferAtoR").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("transferAtoR").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("TransferRtoA", true);
        root.add(microType);
        for (i = 0; i < this.machine.getMicros("transferRtoA").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("transferRtoA").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("Set", true);
        root.add(microType);
        for (i = 0; i < this.machine.getMicros("set").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("set").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("Test", true);
        root.add(microType);
        for (i = 0; i < this.machine.getMicros("test").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("test").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("Increment");
        root.add(microType);
        for (i = 0; i < this.machine.getMicros("increment").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("increment").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("Arithmetic", true);
        root.add(microType);
        for (i = 0; i < this.machine.getMicros("arithmetic").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("arithmetic").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("Shift", true);
        root.add(microType);
        for (i = 0; i < this.machine.getMicros("shift").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("shift").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("Branch", true);
        root.add(microType);
        for (i = 0; i < this.machine.getMicros("branch").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("branch").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("Logical", true);
        root.add(microType);
        for (i = 0; i < this.machine.getMicros("logical").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("logical").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("Decode", true);
        root.add(microType);
        for (i = 0; i < this.machine.getMicros("decode").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("decode").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("MemoryAccess", true);
        root.add(microType);
        for (i = 0; i < this.machine.getMicros("memoryAccess").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("memoryAccess").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("IO", true);
        root.add(microType);
        for (i = 0; i < this.machine.getMicros("io").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("io").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("SetCondBit", true);
        root.add(microType);
        for (i = 0; i < this.machine.getMicros("setCondBit").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("setCondBit").elementAt(i), false));
        }
        root.add(new DefaultMutableTreeNode(this.machine.getEnd(), false));
        root.add(new DefaultMutableTreeNode(new Comment(), false));
        this.microTree = new JTree(root, true);
        this.microTree.setRootVisible(false);
        this.microTree.setShowsRootHandles(true);
    }

    private class MicroTreeDoubleClickListener
    extends MouseAdapter {
        private MicroTreeDoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int i;
            int count = e.getClickCount();
            if (count != 2) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)FetchSequenceDialog.this.microTree.getLastSelectedPathComponent();
            Class selectedType = Microinstruction.class;
            if (node != null) {
                Object nodeInfo = node.getUserObject();
                if (nodeInfo instanceof Microinstruction) {
                    selectedType = nodeInfo.getClass();
                    if (selectedType == End.class || selectedType == Comment.class) {
                        return;
                    }
                } else {
                    try {
                        if ("Set".equals(nodeInfo)) {
                            nodeInfo = "CpusimSet";
                        }
                        selectedType = Class.forName("cpusim.microinstruction." + nodeInfo);
                    }
                    catch (ClassNotFoundException cnfe) {
                        Assert.That(false, "Class not found in FetchSequenceDialog's doubleclick listener.");
                    }
                }
            }
            if (FetchSequenceDialog.this.machine.getModule("registers").size() == 0) {
                JOptionPane.showMessageDialog(FetchSequenceDialog.this, LangUnit.LU_NEED_REG_CREATE.str(), LangUnit.LU_ERR.str(), 0);
                return;
            }
            MicroDialog d = new MicroDialog((Dialog)FetchSequenceDialog.this, FetchSequenceDialog.this.machine, selectedType);
            d.pack();
            Rectangle bounds = FetchSequenceDialog.this.desktop.getDialogSizePrefs("MicroDialog");
            if (bounds.x > 0) {
                d.setBounds(bounds);
            } else {
                Dimension d1 = d.getSize();
                Dimension d2 = d.getOwner().getSize();
                int x = Math.max((d2.width - (d1.width + 50)) / 2, 0);
                int y = Math.max((d2.height - (d1.height + 30)) / 2, 0);
                bounds = new Rectangle(x + d.getOwner().getX(), y + d.getOwner().getY(), d1.width + 50, d1.height + 30);
                d.setBounds(bounds);
            }
            d.setVisible(true);
            if (!FetchSequenceDialog.this.machine.isDirty()) {
                return;
            }
            DefaultListModel model = (DefaultListModel)FetchSequenceDialog.this.microList.getModel();
            Object[] microArray = model.toArray();
            model.clear();
            for (Object o : microArray) {
                Microinstruction micro = (Microinstruction)o;
                if (!(micro instanceof Comment) && !FetchSequenceDialog.this.machine.contains(micro)) continue;
                model.addElement(micro);
            }
            DefaultTreeModel treeModel = (DefaultTreeModel)FetchSequenceDialog.this.microTree.getModel();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
            Enumeration<TreeNode> enumer = root.children();
            while (enumer.hasMoreElements()) {
                node = (DefaultMutableTreeNode)enumer.nextElement();
                node.removeAllChildren();
            }
            DefaultMutableTreeNode microType = (DefaultMutableTreeNode)root.getChildAt(0);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("transferRtoR").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("transferRtoR").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(1);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("transferAtoR").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("transferAtoR").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(2);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("transferRtoA").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("transferRtoA").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(3);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("set").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("set").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(4);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("test").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("test").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(5);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("increment").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("increment").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(6);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("arithmetic").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("arithmetic").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(7);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("shift").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("shift").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(8);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("branch").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("branch").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(9);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("logical").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("logical").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(10);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("decode").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("decode").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(11);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("memoryAccess").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("memoryAccess").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(12);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("io").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("io").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(13);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("setCondBit").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("setCondBit").elementAt(i), false));
            }
            treeModel.nodeStructureChanged(root);
        }
    }

    private class MicroListDoubleClickListener
    extends MouseAdapter {
        private MicroListDoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int i;
            int count = e.getClickCount();
            if (count != 2) {
                return;
            }
            int index = FetchSequenceDialog.this.microList.getSelectedIndex();
            if (index == -1) {
                return;
            }
            Microinstruction micro = (Microinstruction)FetchSequenceDialog.this.microList.getSelectedValue();
            if (micro instanceof End || micro instanceof Comment) {
                return;
            }
            Class<?> selectedType = micro.getClass();
            MicroDialog d = new MicroDialog((Dialog)FetchSequenceDialog.this, FetchSequenceDialog.this.machine, selectedType);
            d.pack();
            Rectangle bounds = FetchSequenceDialog.this.desktop.getDialogSizePrefs("MicroDialog");
            if (bounds.x > 0) {
                d.setBounds(bounds);
            } else {
                Dimension d1 = d.getSize();
                Dimension d2 = d.getOwner().getSize();
                int x = Math.max((d2.width - (d1.width + 50)) / 2, 0);
                int y = Math.max((d2.height - (d1.height + 30)) / 2, 0);
                bounds = new Rectangle(x + d.getOwner().getX(), y + d.getOwner().getY(), d1.width + 50, d1.height + 30);
                d.setBounds(bounds);
            }
            d.setVisible(true);
            if (!FetchSequenceDialog.this.machine.isDirty()) {
                return;
            }
            DefaultListModel model = (DefaultListModel)FetchSequenceDialog.this.microList.getModel();
            model.clear();
            List<Microinstruction> micros = FetchSequenceDialog.this.machine.getFetchSequence().getMicros();
            for (Microinstruction aMicro : micros) {
                model.addElement(aMicro);
            }
            DefaultTreeModel treeModel = (DefaultTreeModel)FetchSequenceDialog.this.microTree.getModel();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
            Enumeration<TreeNode> enumer = root.children();
            while (enumer.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumer.nextElement();
                node.removeAllChildren();
            }
            DefaultMutableTreeNode microType = (DefaultMutableTreeNode)root.getChildAt(0);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("transferRtoR").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("transferRtoR").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(1);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("transferAtoR").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("transferAtoR").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(2);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("transferRtoA").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("transferRtoA").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(3);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("set").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("set").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(4);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("test").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("test").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(5);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("increment").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("increment").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(6);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("arithmetic").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("arithmetic").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(7);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("shift").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("shift").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(8);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("branch").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("branch").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(9);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("logical").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("logical").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(10);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("decode").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("decode").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(11);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("memoryAccess").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("memoryAccess").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(12);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("io").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("io").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(13);
            for (i = 0; i < FetchSequenceDialog.this.machine.getMicros("setCondBit").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(FetchSequenceDialog.this.machine.getMicros("setCondBit").elementAt(i), false));
            }
            treeModel.nodeStructureChanged(root);
        }
    }

    class HelpButtonListener
    implements ActionListener {
        HelpButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HelpDialog d = new HelpDialog(FetchSequenceDialog.this);
            d.showPage("fetchSequenceDialog");
        }
    }

    class MicroTreeSelectionListener
    implements TreeSelectionListener {
        MicroTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)FetchSequenceDialog.this.microTree.getLastSelectedPathComponent();
            if (node == null || node.getAllowsChildren()) {
                FetchSequenceDialog.this.insertMicroButton.setEnabled(false);
            } else {
                FetchSequenceDialog.this.insertMicroButton.setEnabled(true);
            }
        }
    }

    class MicroListSelectionListener
    implements ListSelectionListener {
        MicroListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedIndex = FetchSequenceDialog.this.microList.getSelectedIndex();
            FetchSequenceDialog.this.deleteMicroButton.setEnabled(selectedIndex != -1);
        }
    }

    class MicroListKeyListener
    implements KeyListener {
        MicroListKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 8 || keyCode == 127) {
                int[] selected = FetchSequenceDialog.this.microList.getSelectedIndices();
                DefaultListModel model = (DefaultListModel)FetchSequenceDialog.this.microList.getModel();
                for (int i = 0; i < selected.length; ++i) {
                    model.removeElementAt(selected[i] - i);
                }
                if (model.size() == 0) {
                    FetchSequenceDialog.this.deleteMicroButton.setEnabled(false);
                } else {
                    FetchSequenceDialog.this.microList.setSelectedIndex(0);
                }
            }
        }
    }

    class DeleteMicroButtonListener
    implements ActionListener {
        DeleteMicroButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = FetchSequenceDialog.this.microList.getSelectedIndices();
            DefaultListModel model = (DefaultListModel)FetchSequenceDialog.this.microList.getModel();
            for (int i = 0; i < selected.length; ++i) {
                model.removeElementAt(selected[i] - i);
            }
            if (model.size() == 0) {
                FetchSequenceDialog.this.deleteMicroButton.setEnabled(false);
            } else {
                FetchSequenceDialog.this.microList.setSelectedIndex(0);
            }
        }
    }

    class InsertMicroButtonListener
    implements ActionListener {
        InsertMicroButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)FetchSequenceDialog.this.microTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object nodeInfo = node.getUserObject();
            if (!node.isLeaf()) {
                return;
            }
            Microinstruction selectedMicro = (Microinstruction)nodeInfo;
            if (selectedMicro instanceof Comment) {
                selectedMicro = new Comment();
            }
            int[] selected = FetchSequenceDialog.this.microList.getSelectedIndices();
            DefaultListModel model = (DefaultListModel)FetchSequenceDialog.this.microList.getModel();
            if (selected.length > 0) {
                model.insertElementAt(selectedMicro, selected[0]);
            } else {
                model.insertElementAt(selectedMicro, 0);
            }
        }
    }

    class CancelButtonListener
    implements ActionListener {
        CancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FetchSequenceDialog.this.setVisible(false);
        }
    }

    class OkButtonListener
    implements ActionListener {
        OkButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Vector<Microinstruction> result = new Vector<Microinstruction>();
            DefaultListModel model = (DefaultListModel)FetchSequenceDialog.this.microList.getModel();
            for (int i = 0; i < model.size(); ++i) {
                result.add((Microinstruction)model.getElementAt(i));
            }
            FetchSequenceDialog.this.machine.getFetchSequence().setMicros(result);
            FetchSequenceDialog.this.setVisible(false);
        }
    }
}

