/*
 * Decompiled with CFR 0.152.
 */
package acm.io;

import acm.io.ConsoleModel;
import acm.io.ConsoleReader;
import acm.io.ConsoleWriter;
import acm.io.IODialog;
import acm.io.IOModel;
import acm.io.StandardConsoleModel;
import acm.io.SystemConsole;
import acm.program.ProgramMenuBar;
import acm.util.ErrorException;
import acm.util.JTFTools;
import acm.util.Platform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.JMenuItem;

public class IOConsole
extends Container
implements IOModel {
    public static final IOConsole SYSTEM_CONSOLE = new SystemConsole();
    protected static final Font DEFAULT_FONT = new Font("Monospaced", 0, 12);
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final int MINIMUM_CONSOLE_WIDTH = 50;
    protected static final int MINIMUM_CONSOLE_HEIGHT = 40;
    private static final String[] CONSOLE_MENU_ACTIONS = new String[]{"Save", "Save As", "Print Console", "Script", "Cut", "Copy", "Paste", "Select All"};
    private ConsoleModel consoleModel = this.createConsoleModel();
    private boolean exceptionOnError;
    private Color inputColor;
    private int inputStyle;
    private Color errorColor;
    private int errorStyle;
    private BufferedReader reader;
    private PrintWriter writer;
    private File file;
    private ProgramMenuBar menuBar;

    public IOConsole() {
        this.consoleModel.setConsole(this);
        this.setBackground(Color.WHITE);
        this.setInputColor(Color.BLUE);
        this.setInputStyle(1);
        this.setErrorColor(Color.RED);
        this.setErrorStyle(1);
        this.setFont(JTFTools.getStandardFont(DEFAULT_FONT));
        Component consolePane = this.consoleModel.getConsolePane();
        if (consolePane != null) {
            this.setLayout(new BorderLayout());
            this.add(consolePane, "Center");
        }
        this.reader = null;
        this.writer = null;
        this.exceptionOnError = false;
    }

    public void clear() {
        this.consoleModel.clear();
    }

    @Override
    public void print(String value) {
        this.getWriter().print(value);
    }

    @Override
    public final void print(boolean x) {
        this.print("" + x);
    }

    @Override
    public final void print(char x) {
        this.print("" + x);
    }

    @Override
    public final void print(double x) {
        this.print("" + x);
    }

    @Override
    public final void print(float x) {
        this.print("" + x);
    }

    @Override
    public final void print(int x) {
        this.print("" + x);
    }

    @Override
    public final void print(long x) {
        this.print("" + x);
    }

    @Override
    public final void print(Object x) {
        this.print("" + x);
    }

    @Override
    public void println() {
        this.getWriter().println();
    }

    @Override
    public void println(String value) {
        this.getWriter().println(value);
    }

    @Override
    public final void println(boolean x) {
        this.println("" + x);
    }

    @Override
    public final void println(char x) {
        this.println("" + x);
    }

    @Override
    public final void println(double x) {
        this.println("" + x);
    }

    @Override
    public final void println(float x) {
        this.println("" + x);
    }

    @Override
    public final void println(int x) {
        this.println("" + x);
    }

    @Override
    public final void println(long x) {
        this.println("" + x);
    }

    @Override
    public final void println(Object x) {
        this.println("" + x);
    }

    @Override
    public void showErrorMessage(String msg) {
        this.consoleModel.print(msg, 2);
        this.consoleModel.print("\n", 2);
    }

    @Override
    public final String readLine() {
        return this.readLine(null);
    }

    @Override
    public String readLine(String prompt) {
        if (prompt != null) {
            this.print(prompt);
        }
        this.consoleModel.requestFocus();
        try {
            String str = this.getReader().readLine();
            return str;
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    @Override
    public final int readInt() {
        return this.readInt(null, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public final int readInt(int low, int high) {
        return this.readInt(null, low, high);
    }

    @Override
    public final int readInt(String prompt) {
        return this.readInt(prompt, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public int readInt(String prompt, int low, int high) {
        String msg = null;
        while (true) {
            String line = this.readLine(prompt);
            try {
                int n = Integer.parseInt(line);
                if (n >= low && n <= high) {
                    return n;
                }
                msg = "Value is outside the range [" + low + ":" + high + "]";
            }
            catch (NumberFormatException ex) {
                msg = "Illegal numeric format";
            }
            this.showErrorMessage(msg);
            if (prompt != null) continue;
            prompt = "Retry: ";
        }
    }

    @Override
    public final double readDouble() {
        return this.readDouble(null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public final double readDouble(double low, double high) {
        return this.readDouble(null, low, high);
    }

    @Override
    public final double readDouble(String prompt) {
        return this.readDouble(prompt, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public double readDouble(String prompt, double low, double high) {
        String msg = null;
        while (true) {
            String line = this.readLine(prompt);
            try {
                double d = Double.valueOf(line);
                if (d >= low && d <= high) {
                    return d;
                }
                msg = "Value is outside the range [" + low + ":" + high + "]";
            }
            catch (NumberFormatException ex) {
                msg = "Illegal numeric format";
            }
            this.showErrorMessage(msg);
            if (prompt != null) continue;
            prompt = "Retry: ";
        }
    }

    @Override
    public final boolean readBoolean() {
        return this.readBoolean(null);
    }

    @Override
    public final boolean readBoolean(String prompt) {
        return this.readBoolean(prompt, "true", "false");
    }

    @Override
    public boolean readBoolean(String prompt, String trueLabel, String falseLabel) {
        while (true) {
            String line;
            if ((line = this.readLine(prompt)) == null) {
                throw new ErrorException("End of file encountered");
            }
            if (line.equalsIgnoreCase(trueLabel)) {
                return true;
            }
            if (line.equalsIgnoreCase(falseLabel)) {
                return false;
            }
            if (this.exceptionOnError) {
                throw new ErrorException("Illegal boolean format");
            }
            this.showErrorMessage("Illegal boolean format");
            if (prompt != null) continue;
            prompt = "Retry: ";
        }
    }

    public BufferedReader getReader() {
        if (this.reader == null) {
            this.reader = new BufferedReader(new ConsoleReader(this.consoleModel));
        }
        return this.reader;
    }

    public PrintWriter getWriter() {
        if (this.writer == null) {
            this.writer = new PrintWriter(new ConsoleWriter(this.consoleModel));
        }
        return this.writer;
    }

    public void setExceptionOnError(boolean flag) {
        this.exceptionOnError = flag;
    }

    public boolean getExceptionOnError() {
        return this.exceptionOnError;
    }

    public void setInputStyle(int style) {
        this.inputStyle = style;
        this.consoleModel.setInputStyle(style);
    }

    public int getInputStyle() {
        return this.inputStyle;
    }

    public void setInputColor(Color color) {
        this.inputColor = color;
        this.consoleModel.setInputColor(color);
    }

    public Color getInputColor() {
        return this.inputColor;
    }

    public void setErrorStyle(int style) {
        this.errorStyle = style;
        this.consoleModel.setErrorStyle(style);
    }

    public int getErrorStyle() {
        return this.errorStyle;
    }

    public void setErrorColor(Color color) {
        this.errorColor = color;
        this.consoleModel.setErrorColor(color);
    }

    public Color getErrorColor() {
        return this.errorColor;
    }

    public void setFont(String str) {
        this.setFont(JTFTools.decodeFont(str, this.getFont()));
    }

    public void setInputScript(BufferedReader rd) {
        this.consoleModel.setInputScript(rd);
    }

    public BufferedReader getInputScript() {
        return this.consoleModel.getInputScript();
    }

    public void cut() {
        this.consoleModel.cut();
    }

    public void copy() {
        this.consoleModel.copy();
    }

    public void paste() {
        this.consoleModel.paste();
    }

    public void selectAll() {
        this.consoleModel.selectAll();
    }

    public void save() {
        FileWriter wr = null;
        while (wr == null) {
            try {
                if (this.file == null) {
                    Frame frame = JTFTools.getEnclosingFrame(this);
                    if (frame == null) {
                        return;
                    }
                    String dir = System.getProperty("user.dir");
                    FileDialog dialog = new FileDialog(frame, "Save Console As", 1);
                    dialog.setDirectory(dir);
                    dialog.setVisible(true);
                    String filename = dialog.getFile();
                    if (filename == null) {
                        return;
                    }
                    this.file = new File(dialog.getDirectory(), filename);
                }
                wr = new FileWriter(this.file);
                this.save(wr);
                ((Writer)wr).close();
                Platform.setFileTypeAndCreator(this.file, "TEXT", "ttxt");
            }
            catch (IOException ex) {
                IODialog dialog = new IODialog(this);
                dialog.showErrorMessage(ex.getMessage());
            }
        }
    }

    public void saveAs() {
        this.file = null;
        this.save();
    }

    public void save(Writer wr) {
        try {
            wr.write(this.consoleModel.getText());
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    public void printConsole() {
        Frame frame = JTFTools.getEnclosingFrame(this);
        if (frame == null) {
            return;
        }
        PrintJob pj = this.getToolkit().getPrintJob(frame, "Console", null);
        if (pj == null) {
            return;
        }
        this.printConsole(pj);
        pj.end();
    }

    public void printConsole(PrintJob pj) {
        this.consoleModel.print(pj);
    }

    public void script() {
        Frame frame = JTFTools.getEnclosingFrame(this);
        FileDialog dialog = new FileDialog(frame, "Input Script", 0);
        dialog.setDirectory(System.getProperty("user.dir"));
        dialog.setVisible(true);
        String dirname = dialog.getDirectory();
        String filename = dialog.getFile();
        if (filename != null) {
            try {
                FileReader rd = new FileReader(new File(new File(dirname), filename));
                this.setInputScript(new BufferedReader(rd));
            }
            catch (IOException ex) {
                throw new ErrorException(ex);
            }
        }
    }

    public void setMenuBar(ProgramMenuBar mbar) {
        this.menuBar = mbar;
        this.consoleModel.setMenuBar(mbar);
    }

    public ProgramMenuBar getMenuBar() {
        return this.menuBar;
    }

    public boolean menuAction(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Cut")) {
            this.cut();
            return true;
        }
        if (cmd.equals("Copy")) {
            this.copy();
            return true;
        }
        if (cmd.equals("Paste")) {
            this.paste();
            return true;
        }
        if (cmd.equals("Select All")) {
            this.selectAll();
            return true;
        }
        if (cmd.equals("Save")) {
            this.save();
            return true;
        }
        if (cmd.equals("Save As")) {
            this.saveAs();
            return true;
        }
        if (cmd.equals("Script")) {
            this.script();
            return true;
        }
        if (cmd.equals("Print Console")) {
            this.printConsole();
            return true;
        }
        return false;
    }

    public boolean isConsoleMenuItem(JMenuItem item) {
        String cmd = item.getActionCommand();
        if (cmd == null) {
            return false;
        }
        for (int i = 0; i < CONSOLE_MENU_ACTIONS.length; ++i) {
            if (!cmd.equals(CONSOLE_MENU_ACTIONS[i])) continue;
            return true;
        }
        return false;
    }

    public void updateMenuBar(ProgramMenuBar mbar) {
        for (JMenuItem item : mbar) {
            if (this.isConsoleMenuItem(item)) {
                item.setEnabled(true);
                continue;
            }
            item.setEnabled(!mbar.isFocusedItem(item));
        }
    }

    @Override
    public void setBackground(Color color) {
        Component textPane = this.consoleModel.getTextPane();
        if (textPane != null) {
            textPane.setBackground(color);
        }
        super.setBackground(color);
    }

    @Override
    public void setForeground(Color color) {
        Component textPane = this.consoleModel.getTextPane();
        if (textPane != null) {
            textPane.setForeground(color);
        }
        super.setForeground(color);
    }

    @Override
    public void setFont(Font font) {
        font = JTFTools.getStandardFont(font);
        Component textPane = this.consoleModel.getTextPane();
        if (textPane != null) {
            textPane.setFont(font);
        }
        super.setFont(font);
    }

    @Override
    public void requestFocus() {
        this.consoleModel.requestFocus();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(50, 40);
    }

    protected ConsoleModel createConsoleModel() {
        return new StandardConsoleModel();
    }
}

