/*
 * Decompiled with CFR 0.152.
 */
package cpusim.util;

import cpusim.util.EditableListModel;
import cpusim.util.ListCellEditor;
import java.applet.Applet;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

public class EditableJList
extends JList
implements CellEditorListener {
    protected Component editorComp = null;
    protected int editingIndex = -1;
    protected ListCellEditor editor = null;
    private PropertyChangeListener editorRemover = null;

    public EditableJList(ListModel dataModel) {
        super(dataModel);
        this.init();
    }

    private void init() {
        this.getActionMap().put("startEditing", new StartEditingAction());
        this.getActionMap().put("cancel", new CancelEditingAction());
        this.addMouseListener(new MouseListener());
        this.getInputMap().put(KeyStroke.getKeyStroke(113, 0), "startEditing");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    public void setListCellEditor(ListCellEditor editor) {
        this.editor = editor;
    }

    public ListCellEditor getListCellEditor() {
        return this.editor;
    }

    public boolean isEditing() {
        return this.editorComp != null;
    }

    public Component getEditorComponent() {
        return this.editorComp;
    }

    public int getEditingIndex() {
        return this.editingIndex;
    }

    public Component prepareEditor(int index) {
        JComponent jComp;
        boolean isSelected;
        Object value = this.getModel().getElementAt(index);
        Component comp = this.editor.getListCellEditorComponent(this, value, isSelected = this.isSelectedIndex(index), index);
        if (comp instanceof JComponent && (jComp = (JComponent)comp).getNextFocusableComponent() == null) {
            jComp.setNextFocusableComponent(this);
        }
        return comp;
    }

    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        if (this.editor != null) {
            this.editor.removeCellEditorListener(this);
            if (this.editorComp != null) {
                this.remove(this.editorComp);
            }
            this.editorComp = null;
            if (this.editingIndex != -1) {
                Rectangle cellRect = this.getCellBounds(this.editingIndex, this.editingIndex);
                this.editingIndex = -1;
                this.repaint(cellRect);
            }
        }
    }

    public boolean editCellAt(int index, EventObject e) {
        if (this.editor != null && !this.editor.stopCellEditing()) {
            return false;
        }
        if (index < 0 || index >= this.getModel().getSize()) {
            return false;
        }
        if (!this.isCellEditable(index)) {
            return false;
        }
        if (this.editorRemover == null) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.editorRemover = new CellEditorRemover(fm);
            fm.addPropertyChangeListener("permanentFocusOwner", this.editorRemover);
        }
        if (this.editor != null && this.editor.isCellEditable(e)) {
            this.editorComp = this.prepareEditor(index);
            if (this.editorComp == null) {
                this.removeEditor();
                return false;
            }
            this.editorComp.setBounds(this.getCellBounds(index, index));
            this.add(this.editorComp);
            this.editorComp.validate();
            this.editingIndex = index;
            this.editor.addCellEditorListener(this);
            return true;
        }
        return false;
    }

    @Override
    public void removeNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        super.removeNotify();
    }

    public boolean isCellEditable(int index) {
        if (this.getModel() instanceof EditableListModel) {
            return ((EditableListModel)this.getModel()).isCellEditable(index);
        }
        return false;
    }

    public void setValueAt(Object value, int index) {
        ((EditableListModel)this.getModel()).setValueAt(value, index);
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        if (this.editor != null) {
            Object value = this.editor.getCellEditorValue();
            this.setValueAt(value, this.editingIndex);
            this.removeEditor();
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.removeEditor();
    }

    private class MouseListener
    extends MouseAdapter {
        private Component dispatchComponent;
        private boolean selectedOnPress;

        private MouseListener() {
        }

        private void setDispatchComponent(MouseEvent e) {
            Component editorComponent = EditableJList.this.getEditorComponent();
            Point p = e.getPoint();
            Point p2 = SwingUtilities.convertPoint(EditableJList.this, p, editorComponent);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
        }

        private boolean repostEvent(MouseEvent e) {
            if (this.dispatchComponent == null || !EditableJList.this.isEditing()) {
                return false;
            }
            MouseEvent e2 = SwingUtilities.convertMouseEvent(EditableJList.this, e, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(e2);
            return true;
        }

        private boolean shouldIgnore(MouseEvent e) {
            return e.isConsumed() || !SwingUtilities.isLeftMouseButton(e) || !EditableJList.this.isEnabled();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isConsumed()) {
                this.selectedOnPress = false;
                return;
            }
            this.selectedOnPress = true;
            this.adjustFocusAndSelection(e);
        }

        void adjustFocusAndSelection(MouseEvent e) {
            if (this.shouldIgnore(e)) {
                return;
            }
            Point p = e.getPoint();
            int index = EditableJList.this.locationToIndex(p);
            if (index == -1) {
                return;
            }
            if (EditableJList.this.editCellAt(index, e)) {
                this.setDispatchComponent(e);
                this.repostEvent(e);
            } else if (EditableJList.this.isRequestFocusEnabled()) {
                EditableJList.this.requestFocus();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.selectedOnPress) {
                if (this.shouldIgnore(e)) {
                    return;
                }
                this.repostEvent(e);
                this.dispatchComponent = null;
                EditableJList.this.setValueIsAdjusting(false);
            } else {
                this.adjustFocusAndSelection(e);
            }
        }
    }

    private class CancelEditingAction
    extends AbstractAction {
        private CancelEditingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditableJList list = (EditableJList)e.getSource();
            list.removeEditor();
        }

        @Override
        public boolean isEnabled() {
            return EditableJList.this.isEditing();
        }
    }

    private static class StartEditingAction
    extends AbstractAction {
        private StartEditingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditableJList list = (EditableJList)e.getSource();
            if (!list.hasFocus()) {
                ListCellEditor cellEditor = list.getListCellEditor();
                if (cellEditor != null && !cellEditor.stopCellEditing()) {
                    return;
                }
                list.requestFocus();
                return;
            }
            ListSelectionModel rsm = list.getSelectionModel();
            int anchorRow = rsm.getAnchorSelectionIndex();
            list.editCellAt(anchorRow, null);
            Component editorComp = list.getEditorComponent();
            if (editorComp != null) {
                editorComp.requestFocus();
            }
        }
    }

    class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover(KeyboardFocusManager fm) {
            this.focusManager = fm;
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (!EditableJList.this.isEditing() || EditableJList.this.getClientProperty("terminateEditOnFocusLost") != Boolean.TRUE) {
                return;
            }
            for (Component c = this.focusManager.getPermanentFocusOwner(); c != null; c = c.getParent()) {
                if (c == EditableJList.this) {
                    return;
                }
                if (!(c instanceof Window) && (!(c instanceof Applet) || c.getParent() != null)) continue;
                if (c != SwingUtilities.getRoot(EditableJList.this) || EditableJList.this.getListCellEditor().stopCellEditing()) break;
                EditableJList.this.getListCellEditor().cancelCellEditing();
                break;
            }
        }
    }
}

