/*
 * Decompiled with CFR 0.152.
 */
package cpusim.util;

import cpusim.module.RegisterArray;
import cpusim.module.RegisterArrayFactory;
import cpusim.util.ExtendedJTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class ArrayLengthTableCellEditor
extends DefaultCellEditor {
    private Object value;
    private RegisterArrayFactory factory;

    public ArrayLengthTableCellEditor(RegisterArrayFactory arrayFactory) {
        super(new JTextField());
        ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        this.factory = arrayFactory;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public boolean stopCellEditing() {
        int cellValue;
        ExtendedJTable table = (ExtendedJTable)this.getComponent().getParent();
        String s = (String)super.getCellEditorValue();
        try {
            cellValue = Integer.parseInt(s);
            if (cellValue <= 0) {
                throw new Exception();
            }
            this.value = new Integer(cellValue);
        }
        catch (Exception e) {
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(table.getTopLevelAncestor(), "Array lengths must be positive integers.", "Error", 0);
            return false;
        }
        RegisterArray array = (RegisterArray)table.getOOModel().getObject(table.getSelectedRow());
        String message = this.factory.newArrayLengthIsOkay(array, cellValue);
        if (message != null) {
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(table.getTopLevelAncestor(), message, "Error", 0);
            return false;
        }
        return super.stopCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }
}

